/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Set;
import oracle.security.pki.internal.asn1.ASN1SetInputStream;
import oracle.security.pki.internal.asn1.ASN1String;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.cert.AttributeTypeAndValue;
import oracle.security.pki.internal.cert.OIDRegistrar;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.util.InvalidFormatException;
import oracle.security.pki.util.OIDManager;
import oracle.security.pki.util.Utils;

public class X500RDN
implements Externalizable,
ASN1Object {
    private LinkedHashMap<ASN1ObjectID, AttributeTypeAndValue> a = new LinkedHashMap();
    private ASN1Set b = null;

    public X500RDN() {
    }

    public X500RDN(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.a.put(aSN1ObjectID, new AttributeTypeAndValue(aSN1ObjectID, aSN1Object));
    }

    public X500RDN(ASN1ObjectID aSN1ObjectID, String string) {
        this.a(aSN1ObjectID, string);
    }

    public X500RDN(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    X500RDN(String string) {
        this.d(string);
    }

    public void a(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.b = null;
        this.a.put(aSN1ObjectID, new AttributeTypeAndValue(aSN1ObjectID, aSN1Object));
    }

    public void a(ASN1ObjectID aSN1ObjectID, String string) {
        int n = aSN1ObjectID.equals(PKIX.i) || aSN1ObjectID.equals(PKIX.u) ? 22 : 19;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] <= '\u007f' && (n != 19 || X500RDN.b(cArray[i]))) continue;
            n = 12;
            break;
        }
        this.a(aSN1ObjectID, new ASN1String(string, n));
    }

    public Map<ASN1ObjectID, AttributeTypeAndValue> a() {
        return this.a;
    }

    public ASN1Object a(ASN1ObjectID aSN1ObjectID) {
        AttributeTypeAndValue attributeTypeAndValue = this.a.get(aSN1ObjectID);
        return attributeTypeAndValue != null ? attributeTypeAndValue.b() : null;
    }

    public int hashCode() {
        return Utils.hashBytes(this.c());
    }

    private static String c(String string) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2.charAt(0));
        int n = string2.length();
        for (int i = 1; i < n; ++i) {
            char c = string2.charAt(i);
            if (Character.isWhitespace(c)) {
                if (Character.isWhitespace(string2.charAt(i - 1))) continue;
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        X500RDN x500RDN = (X500RDN)object;
        if (this.a.size() != x500RDN.a.size()) {
            return false;
        }
        Iterator<AttributeTypeAndValue> iterator = this.a.values().iterator();
        Iterator<AttributeTypeAndValue> iterator2 = x500RDN.a.values().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            AttributeTypeAndValue attributeTypeAndValue = iterator.next();
            AttributeTypeAndValue attributeTypeAndValue2 = iterator2.next();
            if (!attributeTypeAndValue.a().equals(attributeTypeAndValue2.a())) {
                return false;
            }
            if (attributeTypeAndValue.b().getClass() != attributeTypeAndValue2.b().getClass()) {
                return false;
            }
            if (attributeTypeAndValue.b() instanceof ASN1String) {
                ASN1String aSN1String = (ASN1String)attributeTypeAndValue.b();
                ASN1String aSN1String2 = (ASN1String)attributeTypeAndValue2.b();
                if (!(aSN1String.c() == 19 && aSN1String2.c() == 19 ? !X500RDN.c(aSN1String.b()).equalsIgnoreCase(X500RDN.c(aSN1String2.b())) : !aSN1String.b().equals(aSN1String2.b()))) continue;
                return false;
            }
            if (Utils.areEqual(Utils.toBytes(attributeTypeAndValue.b()), Utils.toBytes(attributeTypeAndValue2.b()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.a(false);
    }

    private String a(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (AttributeTypeAndValue attributeTypeAndValue : this.a.values()) {
            String string = X500RDN.b(attributeTypeAndValue.a());
            stringBuffer.append(string != null ? string : attributeTypeAndValue.a().d());
            stringBuffer.append('=');
            ASN1Object aSN1Object = attributeTypeAndValue.b();
            if (aSN1Object instanceof ASN1String) {
                stringBuffer.append(X500RDN.a(((ASN1String)aSN1Object).b(), bl));
            } else {
                stringBuffer.append('#');
                stringBuffer.append(Utils.toHexString(Utils.toBytes(aSN1Object)));
            }
            stringBuffer.append('+');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String b() {
        return this.a(true);
    }

    static String a(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence;
            char c = string.charAt(i);
            if (bl && c >= '\u0080') {
                charSequence = new StringBuffer();
                while (true) {
                    ((StringBuffer)charSequence).append(c);
                    if (i == string.length() || string.charAt(i + 1) < '\u0080') break;
                    c = string.charAt(++i);
                }
                String string2 = Utils.toHexString(Utils.toUTF8(((StringBuffer)charSequence).toString()));
                int n2 = string2.length();
                for (int j = 0; j < n2; j += 2) {
                    stringBuffer.append('\\');
                    stringBuffer.append(string2.charAt(j));
                    stringBuffer.append(string2.charAt(j + 1));
                }
                continue;
            }
            if (c < ' ' || c == '\u007f' || i == 0 && c == ' ' || i == string.length() - 1 && c == ' ') {
                charSequence = Integer.toString(c, 16);
                stringBuffer.append('\\');
                if (c < '\u0010') {
                    stringBuffer.append('0');
                }
                stringBuffer.append((String)charSequence);
                continue;
            }
            if (X500RDN.f(c) || c == '\\' || c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String a(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '\\' && i < string.length() - 1) {
                stringBuffer.append(string.charAt(++i));
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    static ASN1ObjectID b(String string) {
        return OIDManager.getOIDManager().getAttributeType(string);
    }

    private static String b(ASN1ObjectID aSN1ObjectID) {
        return OIDManager.getOIDManager().getAttributeName(aSN1ObjectID);
    }

    private static boolean c(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean d(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean e(char c) {
        return X500RDN.d(c) || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean f(char c) {
        return c == ',' || c == '+' || c == '=' || c == '<' || c == '>' || c == ';' || c == '#';
    }

    static boolean a(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    static boolean b(char c) {
        return X500RDN.c(c) || X500RDN.d(c) || c == ' ' || c == '\'' || c == '(' || c == ')' || c == '+' || c == ',' || c == '-' || c == '.' || c == '/' || c == ':' || c == '=' || c == '?';
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.b = null;
        this.a = new LinkedHashMap();
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        while (aSN1SetInputStream.a()) {
            AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(aSN1SetInputStream);
            if (attributeTypeAndValue == null) continue;
            this.a.put(attributeTypeAndValue.a(), attributeTypeAndValue);
        }
        aSN1SetInputStream.b();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.c().output(outputStream);
    }

    @Override
    public int length() {
        return this.c().length();
    }

    private ASN1Set c() {
        if (this.b == null) {
            ASN1Set aSN1Set = new ASN1Set();
            Iterator<AttributeTypeAndValue> iterator = this.a.values().iterator();
            while (iterator.hasNext()) {
                aSN1Set.a(iterator.next());
            }
            this.b = aSN1Set;
        }
        return this.b;
    }

    private void d(String string) {
        this.b = null;
        this.a = new LinkedHashMap();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '+' && !bl && n > 0 && string.charAt(n - 1) != '\\') {
                bl2 = true;
            } else if (c == '\"') {
                bl = !bl;
                stringBuffer.append(c);
            } else {
                stringBuffer.append(c);
            }
            if (!bl2 && ++n != string.length()) continue;
            this.e(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            bl = false;
            bl2 = false;
        }
    }

    private void e(String string) {
        String string2;
        int n;
        int n2 = 0;
        n2 = string.indexOf("=");
        if (n2 == -1) {
            throw new InvalidFormatException("Improperly specified DN,'=' missing in attribute");
        }
        for (n = 0; n < n2 && X500RDN.a(string.charAt(n)); ++n) {
        }
        if (n == n2) {
            throw new InvalidFormatException("Attribute type missing");
        }
        int n3 = n2 - 1;
        while (n3 >= 0 & X500RDN.a(string.charAt(n3))) {
            --n3;
        }
        String string3 = string.substring(n, n3 + 1);
        ASN1ObjectID aSN1ObjectID = X500RDN.d(string3.charAt(0)) ? new ASN1ObjectID(string3) : (string3.toUpperCase().startsWith("OID.") ? new ASN1ObjectID(string3.substring(4)) : X500RDN.b(string3));
        if (aSN1ObjectID == null) {
            throw new InvalidFormatException("Malformed attribute type");
        }
        String string4 = string.substring(0, n2);
        int n4 = string.length() - 1;
        if ((n3 = n2++) == n4) {
            throw new InvalidFormatException("Improperly specified DN, attribute value is missing for attribute type : " + string4);
        }
        while (n2 < string.length() && X500RDN.a(string.charAt(n2))) {
            ++n2;
        }
        int n5 = string.length() - 1;
        while (X500RDN.a(string.charAt(n5))) {
            --n5;
        }
        String string5 = string2 = n5 >= n2 ? string.substring(n2, n5 + 1) : "";
        if (string2.startsWith("#") && string2.length() > 1) {
            try {
                this.a(aSN1ObjectID, ASN1Utils.a(Utils.fromHexString(string2.substring(1))));
                return;
            }
            catch (IOException iOException) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
        }
        boolean bl = false;
        if (string2.startsWith("\"")) {
            if (string2.length() == 1 || !string2.endsWith("\"")) {
                throw new InvalidFormatException("Missing final '\"'");
            }
            string2 = string2.substring(1, string2.length() - 1);
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        int n6 = string2.length();
        for (n2 = 0; n2 < n6; ++n2) {
            char c = string2.charAt(n2);
            if (c == '\\') {
                try {
                    if (X500RDN.e(string2.charAt(n2 + 1))) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        while (true) {
                            byteArrayOutputStream.write(Integer.parseInt(string2.substring(n2 + 1, n2 + 3), 16));
                            if ((n2 += 2) >= string2.length() - 1 || string2.charAt(n2 + 1) != '\\' || !X500RDN.e(string2.charAt(n2 + 2))) break;
                            ++n2;
                        }
                        stringBuffer.append(Utils.fromUTF8(byteArrayOutputStream.toByteArray()));
                        continue;
                    }
                    if (X500RDN.f(c = string2.charAt(++n2)) || c == '\\' || c == '\"') {
                        stringBuffer.append(c);
                        continue;
                    }
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
            }
            if (!bl && (X500RDN.f(c) || c == '\\' || c == '\"')) {
                throw new IllegalArgumentException("Malformed attribute value string");
            }
            if (bl && (c == '\\' || c == '\"')) {
                throw new IllegalArgumentException("Malformed attribute value string");
            }
            stringBuffer.append(c);
        }
        this.a(aSN1ObjectID, stringBuffer.toString());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }

    static {
        OIDRegistrar.b();
    }
}

