/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AsyncTask<Params, Progress, Result> {
    private volatile Status mStatus = Status.PENDING;
    private AtomicBoolean mCancelled = new AtomicBoolean(false);
    private Result mResult;

    public final Status getStatus() {
        return this.mStatus;
    }

    protected abstract Result doInBackground(Params ... var1);

    protected void onPreExecute() {
    }

    protected void onPostExecute(Result result) {
    }

    protected void onProgressUpdate(Progress ... values) {
    }

    protected void onCancelled(Result result) {
        this.onCancelled();
    }

    protected void onCancelled() {
    }

    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.mCancelled.set(true);
        return true;
    }

    public Result get() {
        return this.mResult;
    }

    public void execute() {
        this.onPreExecute();
        this.mResult = this.doInBackground(null);
        this.onProgressUpdate(null);
        this.onPostExecute(this.mResult);
    }

    public Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return null;
    }

    public static void execute(Runnable runnable) {
    }

    protected final void publishProgress(Progress ... values) {
    }

    private void finish(Result result) {
        if (this.isCancelled()) {
            this.onCancelled(result);
        } else {
            this.onPostExecute(result);
        }
        this.mStatus = Status.FINISHED;
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }
}

