/*
 * Decompiled with CFR 0.152.
 */
package com.jwetherell.openmap.common;

import com.jwetherell.openmap.common.GreatCircle;
import com.jwetherell.openmap.common.MoreMath;
import com.jwetherell.openmap.common.ProjMath;

public class LatLonPoint {
    public static final double NORTH_POLE = 90.0;
    public static final double SOUTH_POLE = -90.0;
    public static final double DATELINE = 180.0;
    public static final double LON_RANGE = 360.0;
    public static final double EQUIVALENT_TOLERANCE = 1.0E-5;
    protected double lat;
    protected double lon;
    protected transient double radLat;
    protected transient double radLon;

    public LatLonPoint() {
    }

    public LatLonPoint(double lat, double lon) {
        this.setLatLon(lat, lon, false);
    }

    public LatLonPoint(double lat, double lon, boolean isRadian) {
        this.setLatLon(lat, lon, isRadian);
    }

    public LatLonPoint(LatLonPoint llp) {
        this.setLatLon(llp.getY(), llp.getX(), false);
    }

    public void setLocation(double x, double y) {
        this.setLatLon(y, x, false);
    }

    public void setLatLon(double lat, double lon) {
        this.setLatLon(lat, lon, false);
    }

    public void setLatLon(double lat, double lon, boolean isRadians) {
        if (isRadians) {
            this.radLat = lat;
            this.radLon = lon;
            this.lat = ProjMath.radToDeg(lat);
            this.lon = ProjMath.radToDeg(lon);
        } else {
            this.lat = LatLonPoint.normalizeLatitude(lat);
            this.lon = LatLonPoint.wrapLongitude(lon);
            this.radLat = ProjMath.degToRad(lat);
            this.radLon = ProjMath.degToRad(lon);
        }
    }

    public double getX() {
        return this.lon;
    }

    public double getY() {
        return this.lat;
    }

    public float getLatitude() {
        return (float)this.lat;
    }

    public float getLongitude() {
        return (float)this.lon;
    }

    public double getRadLon() {
        return this.radLon;
    }

    public double getRadLat() {
        return this.radLat;
    }

    public void setLatitude(double lat) {
        this.lat = LatLonPoint.normalizeLatitude(lat);
        this.radLat = ProjMath.degToRad(lat);
    }

    public void setLongitude(double lon) {
        this.lon = LatLonPoint.wrapLongitude(lon);
        this.radLon = ProjMath.degToRad(lon);
    }

    public void setLatLon(LatLonPoint llp) {
        this.setLatLon(llp.getY(), llp.getX(), false);
    }

    public static final float normalizeLatitude(float lat) {
        return (float)LatLonPoint.normalizeLatitude((double)lat);
    }

    public static final double normalizeLatitude(double lat) {
        if (lat > 90.0) {
            lat = 90.0;
        }
        if (lat < -90.0) {
            lat = -90.0;
        }
        return lat;
    }

    public static final float wrapLongitude(float lon) {
        return (float)LatLonPoint.wrapLongitude((double)lon);
    }

    public static final double wrapLongitude(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            lon += 180.0;
            lon = (lon %= 360.0) < 0.0 ? 180.0 + lon : -180.0 + lon;
        }
        return lon;
    }

    public static boolean isInvalidLatitude(double lat) {
        return lat > 90.0 || lat < -90.0;
    }

    public static boolean isInvalidLongitude(double lon) {
        return lon < -180.0 || lon > 180.0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LatLonPoint pt = (LatLonPoint)obj;
        return MoreMath.approximately_equal(this.getY(), pt.getY(), 1.0E-5) && MoreMath.approximately_equal(this.getX(), pt.getX(), 1.0E-5);
    }

    public double distance(LatLonPoint toPoint) {
        return GreatCircle.sphericalDistance(this.getRadLat(), this.getRadLon(), toPoint.getRadLat(), toPoint.getRadLon());
    }

    public double azimuth(LatLonPoint toPoint) {
        return GreatCircle.sphericalAzimuth(this.getRadLat(), this.getRadLon(), toPoint.getRadLat(), toPoint.getRadLon());
    }

    public LatLonPoint getPoint(double distance, double azimuth) {
        return GreatCircle.sphericalBetween(this.getRadLat(), this.getRadLon(), distance, azimuth);
    }

    public String toString() {
        return "Lat=" + this.lat + ", Lon=" + this.lon;
    }
}

