/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import java.nio.charset.StandardCharsets;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.MacSignatureVerifierContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;

public class ClientMacSignatureVerifierContext
extends MacSignatureVerifierContext {
    public ClientMacSignatureVerifierContext(KeycloakSession session, ClientModel client, String algorithm) throws VerificationException {
        super(ClientMacSignatureVerifierContext.getKey(session, client, algorithm));
    }

    private static KeyWrapper getKey(KeycloakSession session, ClientModel client, String algorithm) throws VerificationException {
        if (algorithm == null) {
            algorithm = "HS256";
        }
        String clientSecretString = client.getSecret();
        SecretKeySpec clientSecret = new SecretKeySpec(clientSecretString.getBytes(StandardCharsets.UTF_8), JavaAlgorithm.getJavaAlgorithm((String)algorithm));
        KeyWrapper key = new KeyWrapper();
        key.setSecretKey((SecretKey)clientSecret);
        key.setUse(KeyUse.SIG);
        key.setType("OCT");
        key.setAlgorithm(algorithm);
        return key;
    }
}

