/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.attribute;

import io.github.dmlloyd.classfile.constantpool.ModuleEntry;
import io.github.dmlloyd.classfile.constantpool.PackageEntry;
import io.github.dmlloyd.classfile.extras.constant.ModuleDesc;
import io.github.dmlloyd.classfile.extras.constant.PackageDesc;
import io.github.dmlloyd.classfile.extras.reflect.AccessFlag;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import io.github.dmlloyd.classfile.impl.UnboundAttribute;
import io.github.dmlloyd.classfile.impl.Util;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleOpenInfo {
    public PackageEntry openedPackage();

    public int opensFlagsMask();

    default public Set<AccessFlag> opensFlags() {
        return AccessFlag.maskToAccessFlags(this.opensFlagsMask(), AccessFlag.Location.MODULE_OPENS);
    }

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.MODULE_OPENS, this.opensFlagsMask(), flag);
    }

    public List<ModuleEntry> opensTo();

    public static ModuleOpenInfo of(PackageEntry opens, int opensFlags, List<ModuleEntry> opensTo) {
        return new UnboundAttribute.UnboundModuleOpenInfo(opens, opensFlags, opensTo);
    }

    public static ModuleOpenInfo of(PackageEntry opens, Collection<AccessFlag> opensFlags, List<ModuleEntry> opensTo) {
        return ModuleOpenInfo.of(opens, Util.flagsToBits(AccessFlag.Location.MODULE_OPENS, opensFlags), opensTo);
    }

    public static ModuleOpenInfo of(PackageEntry opens, int opensFlags, ModuleEntry ... opensTo) {
        return ModuleOpenInfo.of(opens, opensFlags, List.of(opensTo));
    }

    public static ModuleOpenInfo of(PackageEntry opens, Collection<AccessFlag> opensFlags, ModuleEntry ... opensTo) {
        return ModuleOpenInfo.of(opens, Util.flagsToBits(AccessFlag.Location.MODULE_OPENS, opensFlags), opensTo);
    }

    public static ModuleOpenInfo of(PackageDesc opens, int opensFlags, List<ModuleDesc> opensTo) {
        return ModuleOpenInfo.of(TemporaryConstantPool.INSTANCE.packageEntry(TemporaryConstantPool.INSTANCE.utf8Entry(opens.internalName())), opensFlags, Util.moduleEntryList(opensTo));
    }

    public static ModuleOpenInfo of(PackageDesc opens, Collection<AccessFlag> opensFlags, List<ModuleDesc> opensTo) {
        return ModuleOpenInfo.of(opens, Util.flagsToBits(AccessFlag.Location.MODULE_OPENS, opensFlags), opensTo);
    }

    public static ModuleOpenInfo of(PackageDesc opens, int opensFlags, ModuleDesc ... opensTo) {
        return ModuleOpenInfo.of(opens, opensFlags, List.of(opensTo));
    }

    public static ModuleOpenInfo of(PackageDesc opens, Collection<AccessFlag> opensFlags, ModuleDesc ... opensTo) {
        return ModuleOpenInfo.of(opens, Util.flagsToBits(AccessFlag.Location.MODULE_OPENS, opensFlags), opensTo);
    }
}

