/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;

public final class SortedSetRandomFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, List<ScoredValue<V>>> {
    public static final AdvancedExternalizer<SortedSetRandomFunction> EXTERNALIZER = new Externalizer();
    private final int count;

    public SortedSetRandomFunction(int count) {
        this.count = count;
    }

    public List<ScoredValue<V>> apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (this.count == 0 || existing.isEmpty()) {
            return Collections.emptyList();
        }
        return ((SortedSetBucket)existing.get()).randomMembers(this.count);
    }

    private static class Externalizer
    implements AdvancedExternalizer<SortedSetRandomFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SortedSetRandomFunction>> getTypeClasses() {
            return Collections.singleton(SortedSetRandomFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SORTED_SET_RANDOM_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SortedSetRandomFunction object) throws IOException {
            output.writeInt(object.count);
        }

        public SortedSetRandomFunction readObject(ObjectInput input) throws IOException {
            return new SortedSetRandomFunction(input.readInt());
        }
    }
}

