/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractUserRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.utils.RoleResolveUtil;

public class UserClientRoleMappingMapper
extends AbstractUserRoleMappingMapper {
    public static final String PROVIDER_ID = "oidc-usermodel-client-role-mapper";
    private static final String TOKEN_CLAIM_NAME_TOOLTIP = "usermodel.clientRoleMapping.tokenClaimName.tooltip";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Client Role";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a user client role to a token claim.";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCtx) {
        String clientId = (String)mappingModel.getConfig().get("usermodel.clientRoleMapping.clientId");
        String rolePrefix = (String)mappingModel.getConfig().get("usermodel.clientRoleMapping.rolePrefix");
        if (clientId != null && !clientId.isEmpty()) {
            AccessToken.Access access = RoleResolveUtil.getResolvedClientRoles(session, clientSessionCtx, clientId, false);
            if (access == null) {
                return;
            }
            AbstractUserRoleMappingMapper.setClaim(token, mappingModel, access.getRoles(), clientId, rolePrefix);
        } else {
            Map<String, AccessToken.Access> allAccess = RoleResolveUtil.getAllResolvedClientRoles(session, clientSessionCtx);
            for (Map.Entry<String, AccessToken.Access> entry : allAccess.entrySet()) {
                String currClientId = entry.getKey();
                AccessToken.Access access = entry.getValue();
                if (access == null) continue;
                AbstractUserRoleMappingMapper.setClaim(token, mappingModel, access.getRoles(), currClientId, rolePrefix);
            }
        }
    }

    public static ProtocolMapperModel create(String clientId, String clientRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken, boolean introspectionEndpoint) {
        return UserClientRoleMappingMapper.create(clientId, clientRolePrefix, name, tokenClaimName, accessToken, idToken, introspectionEndpoint, false);
    }

    public static ProtocolMapperModel create(String clientId, String clientRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken, boolean introspectionEndpoint, boolean multiValued) {
        ProtocolMapperModel mapper = OIDCAttributeMapperHelper.createClaimMapper(name, "foo", tokenClaimName, "String", accessToken, idToken, false, introspectionEndpoint, PROVIDER_ID);
        mapper.getConfig().put("multivalued", String.valueOf(multiValued));
        mapper.getConfig().put("usermodel.clientRoleMapping.clientId", clientId);
        mapper.getConfig().put("usermodel.clientRoleMapping.rolePrefix", clientRolePrefix);
        return mapper;
    }

    static {
        ProviderConfigProperty clientId = new ProviderConfigProperty();
        clientId.setName("usermodel.clientRoleMapping.clientId");
        clientId.setLabel("usermodel.clientRoleMapping.clientId.label");
        clientId.setHelpText("usermodel.clientRoleMapping.clientId.tooltip");
        clientId.setType("ClientList");
        CONFIG_PROPERTIES.add(clientId);
        ProviderConfigProperty clientRolePrefix = new ProviderConfigProperty();
        clientRolePrefix.setName("usermodel.clientRoleMapping.rolePrefix");
        clientRolePrefix.setLabel("usermodel.clientRoleMapping.rolePrefix.label");
        clientRolePrefix.setHelpText("usermodel.clientRoleMapping.rolePrefix.tooltip");
        clientRolePrefix.setType("String");
        CONFIG_PROPERTIES.add(clientRolePrefix);
        ProviderConfigProperty multiValued = new ProviderConfigProperty();
        multiValued.setName("multivalued");
        multiValued.setLabel("multivalued.label");
        multiValued.setHelpText("multivalued.tooltip");
        multiValued.setType("boolean");
        multiValued.setDefaultValue((Object)"true");
        CONFIG_PROPERTIES.add(multiValued);
        OIDCAttributeMapperHelper.addAttributeConfig(CONFIG_PROPERTIES, UserClientRoleMappingMapper.class);
        for (ProviderConfigProperty prop : CONFIG_PROPERTIES) {
            if (!"claim.name".equals(prop.getName())) continue;
            prop.setHelpText(TOKEN_CLAIM_NAME_TOOLTIP);
        }
    }
}

