/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.actions.IPrimitiveAction;
import org.openstreetmap.josm.data.osm.IPrimitive;

public class PopupMenuHandler {
    private final Set<IPrimitiveAction> primitiveActions = new HashSet<IPrimitiveAction>();
    private final JPopupMenu menu;

    public PopupMenuHandler(JPopupMenu menu) {
        this.menu = menu;
    }

    public void addSeparator() {
        this.menu.addSeparator();
    }

    public JMenuItem addAction(Action a) {
        if (a != null) {
            if (a instanceof IPrimitiveAction) {
                this.primitiveActions.add((IPrimitiveAction)a);
            }
            return this.menu.add(a);
        }
        return null;
    }

    public void removeAction(Action a) {
        if (a != null) {
            if (a instanceof IPrimitiveAction) {
                this.primitiveActions.remove(a);
            }
            MenuElement[] elements = this.menu.getSubElements();
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof JMenuItem) || ((JMenuItem)elements[i]).getAction() != a) continue;
                this.menu.remove(i);
                return;
            }
        }
    }

    public void addListener(PopupMenuListener l) {
        this.menu.addPopupMenuListener(l);
    }

    public void removeListener(PopupMenuListener l) {
        this.menu.removePopupMenuListener(l);
    }

    public Collection<IPrimitiveAction> getPrimitiveActions() {
        return Collections.unmodifiableCollection(this.primitiveActions);
    }

    public void setPrimitives(Collection<? extends IPrimitive> primitives) {
        for (IPrimitiveAction action : this.primitiveActions) {
            action.setPrimitives(primitives);
        }
    }
}

