/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.reporting.dependencies.HtmlDependencyReportTask;
import org.gradle.api.tasks.diagnostics.ConventionReportTask;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.api.tasks.diagnostics.PropertyReportTask;
import org.gradle.api.tasks.diagnostics.TaskReportTask;
import org.gradle.util.internal.WrapUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class ProjectReportsPlugin
implements Plugin<Project> {
    public static final String TASK_REPORT = "taskReport";
    public static final String PROPERTY_REPORT = "propertyReport";
    public static final String DEPENDENCY_REPORT = "dependencyReport";
    public static final String HTML_DEPENDENCY_REPORT = "htmlDependencyReport";
    public static final String PROJECT_REPORT = "projectReport";

    public void apply(Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        project.getTasks().register(TASK_REPORT, TaskReportTask.class, taskReportTask -> ProjectReportsPlugin.configureReportTask(project, (ConventionReportTask)taskReportTask, "tasks.txt", "tasks"));
        project.getTasks().register(PROPERTY_REPORT, PropertyReportTask.class, propertyReportTask -> ProjectReportsPlugin.configureReportTask(project, (ConventionReportTask)propertyReportTask, "properties.txt", "properties"));
        project.getTasks().register(DEPENDENCY_REPORT, DependencyReportTask.class, dependencyReportTask -> ProjectReportsPlugin.configureReportTask(project, (ConventionReportTask)dependencyReportTask, "dependencies.txt", "library dependencies"));
        project.getTasks().register(HTML_DEPENDENCY_REPORT, HtmlDependencyReportTask.class, htmlDependencyReportTask -> {
            htmlDependencyReportTask.getProjectReportDirectory().convention(ProjectReportsPlugin.getProjectFile(project));
            htmlDependencyReportTask.setDescription("Generates an HTML report about your library dependencies.");
            htmlDependencyReportTask.getReports().getHtml().getOutputLocation().convention(htmlDependencyReportTask.getProjectReportDirectory().dir("dependencies"));
            htmlDependencyReportTask.conventionMapping("projects", () -> WrapUtil.toSet((Object[])new Project[]{project}));
        });
        project.getTasks().register(PROJECT_REPORT, projectReportTask -> {
            projectReportTask.dependsOn(new Object[]{TASK_REPORT, PROPERTY_REPORT, DEPENDENCY_REPORT, HTML_DEPENDENCY_REPORT});
            projectReportTask.setDescription("Generates a report about your project.");
            projectReportTask.setGroup("reporting");
        });
    }

    private static Provider<Directory> getProjectFile(Project project) {
        return ((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory().dir("project");
    }

    private static void configureReportTask(Project project, ConventionReportTask reportTask, String outputFileName, String description) {
        reportTask.getProjectReportDirectory().convention(ProjectReportsPlugin.getProjectFile(project));
        reportTask.setDescription("Generates a report about your " + description + " project.");
        reportTask.conventionMapping("outputFile", () -> ((RegularFile)reportTask.getProjectReportDirectory().file(outputFileName).get()).getAsFile());
        reportTask.conventionMapping("projects", () -> WrapUtil.toSet((Object[])new Project[]{project}));
    }
}

