/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.problems;

import com.google.common.collect.Comparators;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.cc.impl.problems.ConfigurationCacheProblemsSummaryKt;
import org.gradle.internal.cc.impl.problems.ProblemCause;
import org.gradle.internal.cc.impl.problems.ProblemSeverity;
import org.gradle.internal.configuration.problems.DocumentationSection;
import org.gradle.internal.extensions.stdlib.CharSequenceExtensionsKt;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#H\u0002J \u0010$\u001a\u00020%*\u00060&j\u0002`'2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020!H\u0002J\u0018\u0010+\u001a\n ,*\u0004\u0018\u00010\u001e0\u001e2\u0006\u0010-\u001a\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015\u00a8\u0006."}, d2={"Lorg/gradle/internal/cc/impl/problems/Summary;", "", "totalProblemCount", "", "deferredProblemCount", "suppressedSilentlyProblemCount", "reportableProblemCauses", "", "Lorg/gradle/internal/cc/impl/problems/ProblemCause;", "Lorg/gradle/internal/cc/impl/problems/ProblemSeverity;", "originalProblemExceptions", "", "", "overflowed", "", "maxCollectedProblems", "incompatibleTasksCount", "incompatibleFeatureCount", "<init>", "(IIILjava/util/Map;Ljava/util/List;ZIII)V", "getTotalProblemCount", "()I", "getDeferredProblemCount", "getOriginalProblemExceptions", "()Ljava/util/List;", "reportableProblemCount", "getReportableProblemCount", "reportableProblemCauseCount", "getReportableProblemCauseCount", "textForConsole", "", "cacheActionText", "htmlReportFile", "Ljava/io/File;", "topProblemsForConsole", "Lkotlin/sequences/Sequence;", "appendSummaryHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "cacheAction", "buildSummaryReportLink", "reportFile", "clickableUrlFor", "kotlin.jvm.PlatformType", "file", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheProblemsSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/internal/cc/impl/problems/Summary\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,350:1\n1321#2,2:351\n*S KotlinDebug\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/internal/cc/impl/problems/Summary\n*L\n229#1:351,2\n*E\n"})
public final class Summary {
    private final int totalProblemCount;
    private final int deferredProblemCount;
    private final int suppressedSilentlyProblemCount;
    @NotNull
    private final Map<ProblemCause, ProblemSeverity> reportableProblemCauses;
    @NotNull
    private final List<Throwable> originalProblemExceptions;
    private final boolean overflowed;
    private final int maxCollectedProblems;
    private final int incompatibleTasksCount;
    private final int incompatibleFeatureCount;

    public Summary(int totalProblemCount, int deferredProblemCount, int suppressedSilentlyProblemCount, @NotNull Map<ProblemCause, ? extends ProblemSeverity> reportableProblemCauses, @NotNull List<? extends Throwable> originalProblemExceptions, boolean overflowed, int maxCollectedProblems, int incompatibleTasksCount, int incompatibleFeatureCount) {
        Intrinsics.checkNotNullParameter(reportableProblemCauses, (String)"reportableProblemCauses");
        Intrinsics.checkNotNullParameter(originalProblemExceptions, (String)"originalProblemExceptions");
        this.totalProblemCount = totalProblemCount;
        this.deferredProblemCount = deferredProblemCount;
        this.suppressedSilentlyProblemCount = suppressedSilentlyProblemCount;
        this.reportableProblemCauses = reportableProblemCauses;
        this.originalProblemExceptions = originalProblemExceptions;
        this.overflowed = overflowed;
        this.maxCollectedProblems = maxCollectedProblems;
        this.incompatibleTasksCount = incompatibleTasksCount;
        this.incompatibleFeatureCount = incompatibleFeatureCount;
    }

    public final int getTotalProblemCount() {
        return this.totalProblemCount;
    }

    public final int getDeferredProblemCount() {
        return this.deferredProblemCount;
    }

    @NotNull
    public final List<Throwable> getOriginalProblemExceptions() {
        return this.originalProblemExceptions;
    }

    public final int getReportableProblemCount() {
        return this.totalProblemCount - this.suppressedSilentlyProblemCount;
    }

    public final int getReportableProblemCauseCount() {
        return this.reportableProblemCauses.size();
    }

    @NotNull
    public final String textForConsole(@NotNull String cacheActionText, @Nullable File htmlReportFile) {
        boolean hasReportableProblems;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)cacheActionText, (String)"cacheActionText");
        DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        StringBuilder $this$textForConsole_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = hasReportableProblems = this.getReportableProblemCount() > 0;
        if (hasReportableProblems) {
            $this$textForConsole_u24lambda_u240.append('\n');
            this.appendSummaryHeader($this$textForConsole_u24lambda_u240, cacheActionText, this.getReportableProblemCount());
            $this$textForConsole_u24lambda_u240.append('\n');
            Sequence<ProblemCause> $this$forEach$iv = this.topProblemsForConsole();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DocumentationSection it;
                ProblemCause problem = (ProblemCause)element$iv;
                boolean bl3 = false;
                $this$textForConsole_u24lambda_u240.append("- ");
                $this$textForConsole_u24lambda_u240.append(CharSequenceExtensionsKt.capitalized((CharSequence)problem.getUserCodeLocation()));
                $this$textForConsole_u24lambda_u240.append(": ");
                $this$textForConsole_u24lambda_u240.append(problem.getMessage()).append('\n');
                if (problem.getDocumentationSection() == null) continue;
                boolean bl4 = false;
                $this$textForConsole_u24lambda_u240.append("  See " + documentationRegistry.getDocumentationFor(it.getPage(), it.getAnchor())).append('\n');
            }
            if (this.getReportableProblemCauseCount() > 15) {
                $this$textForConsole_u24lambda_u240.append("plus " + (this.getReportableProblemCauseCount() - 15) + " more problems. Please see the report for details.").append('\n');
            }
        }
        boolean hasIncompatibleTasks = this.incompatibleTasksCount > 0;
        boolean hasIncompatibleFeatures = this.incompatibleFeatureCount > 0;
        File file = htmlReportFile;
        if (file != null) {
            File it = file;
            boolean bl5 = false;
            $this$textForConsole_u24lambda_u240.append('\n');
            if ((hasIncompatibleTasks || hasIncompatibleFeatures) && !hasReportableProblems) {
                $this$textForConsole_u24lambda_u240.append("Some tasks or features in this build are not compatible with the configuration cache.");
                $this$textForConsole_u24lambda_u240.append('\n');
            }
            $this$textForConsole_u24lambda_u240.append(this.buildSummaryReportLink(it));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String textForConsole$default(Summary summary, String string, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return summary.textForConsole(string, file);
    }

    private final Sequence<ProblemCause> topProblemsForConsole() {
        Object r = this.reportableProblemCauses.entrySet().stream().collect(Comparators.least((int)15, (Comparator)ConfigurationCacheProblemsSummaryKt.access$consoleComparatorForProblemCauseWithSeverity()));
        Intrinsics.checkNotNullExpressionValue(r, (String)"collect(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)r)), Summary::topProblemsForConsole$lambda$0);
    }

    private final void appendSummaryHeader(StringBuilder $this$appendSummaryHeader, String cacheAction, int reportableProblemCount) {
        $this$appendSummaryHeader.append(reportableProblemCount);
        $this$appendSummaryHeader.append(reportableProblemCount == 1 ? " problem was found " : " problems were found ");
        $this$appendSummaryHeader.append(cacheAction);
        $this$appendSummaryHeader.append(" the configuration cache");
        if (this.overflowed) {
            $this$appendSummaryHeader.append(", only the first ");
            $this$appendSummaryHeader.append(this.maxCollectedProblems);
            $this$appendSummaryHeader.append(" were considered");
        }
        if (reportableProblemCount != this.getReportableProblemCauseCount()) {
            $this$appendSummaryHeader.append(", ");
            $this$appendSummaryHeader.append(this.getReportableProblemCauseCount());
            $this$appendSummaryHeader.append(" of which ");
            $this$appendSummaryHeader.append(this.getReportableProblemCauseCount() == 1 ? "seems unique" : "seem unique");
        }
        $this$appendSummaryHeader.append(".");
    }

    private final String buildSummaryReportLink(File reportFile) {
        return "See the complete report at " + this.clickableUrlFor(reportFile);
    }

    private final String clickableUrlFor(File file) {
        return new ConsoleRenderer().asClickableFileUrl(file);
    }

    private static final ProblemCause topProblemsForConsole$lambda$0(Map.Entry it) {
        return (ProblemCause)it.getKey();
    }
}

