/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingWorker;
import org.freeplane.plugin.ai.chat.AIModelCatalog;
import org.freeplane.plugin.ai.chat.AIModelDescriptor;
import org.freeplane.plugin.ai.chat.AIModelSelection;
import org.freeplane.plugin.ai.chat.AIProviderConfiguration;

class AIModelSelectionController {
    private final AIProviderConfiguration configuration;
    private final AIModelCatalog modelCatalog;
    private final JComboBox<AIModelDescriptor> modelSelectionComboBox;
    private boolean isModelSelectionUpdateInProgress;
    private boolean isModelListLoadInProgress;
    private Consumer<AIModelDescriptor> modelSelectionChangeListener;

    AIModelSelectionController(AIProviderConfiguration configuration, AIModelCatalog modelCatalog) {
        this.configuration = configuration;
        this.modelCatalog = modelCatalog;
        this.modelSelectionComboBox = new JComboBox();
        this.modelSelectionComboBox.setRenderer(new ModelSelectionRenderer());
        this.modelSelectionComboBox.addActionListener(event -> this.onModelSelectionChanged());
    }

    JComboBox<AIModelDescriptor> getModelSelectionComboBox() {
        return this.modelSelectionComboBox;
    }

    void setModelSelectionChangeListener(Consumer<AIModelDescriptor> modelSelectionChangeListener) {
        this.modelSelectionChangeListener = modelSelectionChangeListener;
    }

    void loadInitialModelSelectionList() {
        this.updateModelSelectionList(true);
    }

    private void onModelSelectionChanged() {
        if (this.isModelSelectionUpdateInProgress) {
            return;
        }
        Object selectedValue = this.modelSelectionComboBox.getSelectedItem();
        if (!(selectedValue instanceof AIModelDescriptor)) {
            this.configuration.setSelectedModelValue("");
            this.notifyModelSelectionChange(null);
            return;
        }
        AIModelDescriptor selectedModel = (AIModelDescriptor)selectedValue;
        this.configuration.setSelectedModelValue(selectedModel.getSelectionValue());
        this.notifyModelSelectionChange(selectedModel);
    }

    private void updateModelSelectionList(final boolean allowsRefresh) {
        if (this.isModelListLoadInProgress) {
            return;
        }
        this.isModelListLoadInProgress = true;
        this.modelSelectionComboBox.setEnabled(false);
        new SwingWorker<List<AIModelDescriptor>, Void>(){

            @Override
            protected List<AIModelDescriptor> doInBackground() {
                return AIModelSelectionController.this.modelCatalog.getAvailableModels(allowsRefresh);
            }

            @Override
            protected void done() {
                List<AIModelDescriptor> modelDescriptors;
                try {
                    modelDescriptors = (List<AIModelDescriptor>)this.get();
                }
                catch (Exception exception) {
                    modelDescriptors = Collections.emptyList();
                }
                AIModelSelectionController.this.applyModelSelectionList(modelDescriptors);
                AIModelSelectionController.this.isModelListLoadInProgress = false;
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyModelSelectionList(List<AIModelDescriptor> modelDescriptors) {
        this.isModelSelectionUpdateInProgress = true;
        try {
            ArrayList<AIModelDescriptor> sortedModelDescriptors = new ArrayList<AIModelDescriptor>(modelDescriptors);
            sortedModelDescriptors.sort(Comparator.comparing(AIModelDescriptor::getDisplayName, String.CASE_INSENSITIVE_ORDER));
            DefaultComboBoxModel<AIModelDescriptor> comboBoxModel = new DefaultComboBoxModel<AIModelDescriptor>(sortedModelDescriptors.toArray(new AIModelDescriptor[0]));
            this.modelSelectionComboBox.setModel(comboBoxModel);
            this.modelSelectionComboBox.setSelectedIndex(-1);
            this.applySelectionFromConfiguration(sortedModelDescriptors);
            this.modelSelectionComboBox.setEnabled(this.hasAnyProviderEnabled());
        }
        finally {
            this.isModelSelectionUpdateInProgress = false;
        }
    }

    private void applySelectionFromConfiguration(List<AIModelDescriptor> modelDescriptors) {
        String storedSelectionValue = this.configuration.getStoredSelectedModelValue();
        String selectionValue = this.configuration.getSelectedModelValue();
        AIModelSelection selection = AIModelSelection.fromSelectionValue(selectionValue);
        if (selection == null) {
            return;
        }
        for (AIModelDescriptor modelDescriptor : modelDescriptors) {
            if (!selection.getProviderName().equalsIgnoreCase(modelDescriptor.getProviderName()) || !selection.getModelName().equals(modelDescriptor.getModelName())) continue;
            this.modelSelectionComboBox.setSelectedItem(modelDescriptor);
            if (storedSelectionValue == null || storedSelectionValue.isEmpty()) {
                this.configuration.setSelectedModelValue(modelDescriptor.getSelectionValue());
            }
            this.notifyModelSelectionChange(modelDescriptor);
            return;
        }
        this.configuration.setSelectedModelValue("");
        this.modelSelectionComboBox.setSelectedIndex(-1);
        this.notifyModelSelectionChange(null);
    }

    private boolean hasAnyProviderEnabled() {
        boolean hasOpenrouterKey = this.configuration.getOpenRouterKey() != null && !this.configuration.getOpenRouterKey().isEmpty();
        boolean hasGeminiKey = this.configuration.getGeminiKey() != null && !this.configuration.getGeminiKey().isEmpty();
        return hasOpenrouterKey || hasGeminiKey || this.configuration.hasOllamaServiceAddress();
    }

    private void notifyModelSelectionChange(AIModelDescriptor modelDescriptor) {
        if (this.modelSelectionChangeListener != null) {
            this.modelSelectionChangeListener.accept(modelDescriptor);
        }
    }

    private static class ModelSelectionRenderer
    extends DefaultListCellRenderer {
        private String preferredSizeText;
        private boolean measuringPreferredSize;

        private ModelSelectionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.preferredSizeText = null;
            if (value instanceof AIModelDescriptor) {
                AIModelDescriptor modelDescriptor = (AIModelDescriptor)value;
                this.preferredSizeText = index < 0 ? modelDescriptor.getDisplayName() : null;
                String renderedText = index < 0 ? this.renderSelectedModelName(modelDescriptor.getModelName()) : modelDescriptor.getDisplayName();
                this.setText(renderedText);
            }
            return component;
        }

        @Override
        public Dimension getPreferredSize() {
            boolean previousMeasuringState = this.measuringPreferredSize;
            this.measuringPreferredSize = true;
            try {
                Dimension dimension = super.getPreferredSize();
                return dimension;
            }
            finally {
                this.measuringPreferredSize = previousMeasuringState;
            }
        }

        @Override
        public String getText() {
            if (this.measuringPreferredSize && this.preferredSizeText != null) {
                return this.preferredSizeText;
            }
            return super.getText();
        }

        private String renderSelectedModelName(String modelName) {
            int separatorIndex = modelName.indexOf(47);
            if (separatorIndex >= 0 && separatorIndex < modelName.length() - 1) {
                return modelName.substring(separatorIndex + 1);
            }
            return modelName;
        }
    }
}

