/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.PatternMatcher;

public final class MatcherHelper {
    private MatcherHelper() {
    }

    public static boolean matches(PatternMatcher m, String expression, String input) {
        return m.getMatcher(expression).matches(input);
    }

    public static boolean matches(PatternMatcher m, ModuleId exp, ModuleId mid) {
        return MatcherHelper.matches(m, exp.getOrganisation(), mid.getOrganisation()) && MatcherHelper.matches(m, exp.getName(), mid.getName());
    }

    public static boolean matches(PatternMatcher m, ModuleRevisionId exp, ModuleRevisionId mrid) {
        return MatcherHelper.matches(m, exp.getOrganisation(), mrid.getOrganisation()) && MatcherHelper.matches(m, exp.getName(), mrid.getName()) && MatcherHelper.matches(m, exp.getRevision(), mrid.getRevision());
    }

    public static boolean matches(PatternMatcher m, ArtifactId exp, ArtifactId aid) {
        return MatcherHelper.matches(m, exp.getModuleId(), aid.getModuleId()) && MatcherHelper.matches(m, exp.getName(), aid.getName()) && MatcherHelper.matches(m, exp.getExt(), aid.getExt()) && MatcherHelper.matches(m, exp.getType(), aid.getType());
    }

    public static boolean isExact(PatternMatcher m, ModuleRevisionId exp) {
        return MatcherHelper.isExact(m, exp.getOrganisation()) && MatcherHelper.isExact(m, exp.getName()) && MatcherHelper.isExact(m, exp.getRevision());
    }

    public static boolean isExact(PatternMatcher m, ModuleId exp) {
        return MatcherHelper.isExact(m, exp.getOrganisation()) && MatcherHelper.isExact(m, exp.getName());
    }

    public static boolean isExact(PatternMatcher m, String exp) {
        return m.getMatcher(exp).isExact();
    }
}

