/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml.rules;

import com.tngtech.archunit.library.plantuml.rules.Alias;
import com.tngtech.archunit.library.plantuml.rules.ComponentIdentifier;
import com.tngtech.archunit.library.plantuml.rules.ComponentName;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlComponentDependency;
import com.tngtech.archunit.library.plantuml.rules.Stereotype;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class PlantUmlComponent {
    private final ComponentName componentName;
    private final Set<Stereotype> stereotypes;
    private final Optional<Alias> alias;
    private List<PlantUmlComponentDependency> dependencies = Collections.emptyList();

    private PlantUmlComponent(Builder builder) {
        this.componentName = Preconditions.checkNotNull(builder.componentName);
        this.stereotypes = Preconditions.checkNotNull(builder.stereotypes);
        this.alias = Preconditions.checkNotNull(builder.alias);
    }

    List<PlantUmlComponent> getDependencies() {
        return this.dependencies.stream().map(PlantUmlComponentDependency::getTarget).collect(Collectors.toList());
    }

    ComponentName getComponentName() {
        return this.componentName;
    }

    Collection<Stereotype> getStereotypes() {
        return this.stereotypes;
    }

    Optional<Alias> getAlias() {
        return this.alias;
    }

    void finish(List<PlantUmlComponentDependency> dependencies) {
        this.dependencies = ImmutableList.copyOf(dependencies);
    }

    ComponentIdentifier getIdentifier() {
        return this.alias.map(it -> new ComponentIdentifier(this.componentName, (Alias)it)).orElseGet(() -> new ComponentIdentifier(this.componentName));
    }

    public int hashCode() {
        return Objects.hash(this.componentName, this.stereotypes, this.alias);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PlantUmlComponent other = (PlantUmlComponent)obj;
        return Objects.equals(this.componentName, other.componentName) && Objects.equals(this.stereotypes, other.stereotypes) && Objects.equals(this.alias, other.alias);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{componentName=" + this.componentName + ", stereotypes=" + this.stereotypes + ", alias=" + this.alias + ", dependencies=" + this.dependencies + '}';
    }

    static class Builder {
        private ComponentName componentName;
        private Set<Stereotype> stereotypes;
        private Optional<Alias> alias;

        Builder() {
        }

        Builder withComponentName(ComponentName componentName) {
            this.componentName = componentName;
            return this;
        }

        Builder withStereotypes(Set<Stereotype> stereotypes) {
            this.stereotypes = stereotypes;
            return this;
        }

        Builder withAlias(Optional<Alias> alias) {
            this.alias = alias;
            return this;
        }

        PlantUmlComponent build() {
            return new PlantUmlComponent(this);
        }
    }

    static class Functions {
        static final Function<PlantUmlComponent, Alias> TO_EXISTING_ALIAS = input -> {
            Preconditions.checkState(input.getAlias().isPresent(), "Alias does not exist");
            return input.getAlias().get();
        };

        Functions() {
        }
    }
}

