/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDependencyGroup;
import org.jkiss.dbeaver.ext.oracle.model.OraclePrivTable;
import org.jkiss.dbeaver.ext.oracle.model.OraclePrivTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableIndex;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableNotPartitionPropertyValidator;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableTrigger;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleStatefulObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObjectWithLazyDescription;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstrainable;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintInfo;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class OracleTableBase
extends JDBCTable<OracleDataSource, OracleSchema>
implements DBPNamedObject2,
DBPRefreshableObject,
OracleStatefulObject,
DBPObjectWithLazyDescription,
DBSEntityConstrainable {
    private static final Log log = Log.getLog(OracleTableBase.class);
    private final TablePrivCache tablePrivCache = new TablePrivCache();
    protected boolean valid;
    private Date created;
    private Date lastDDLTime;
    private String comment;

    public abstract TableAdditionalInfo getAdditionalInfo();

    protected abstract String getTableTypeName();

    protected OracleTableBase(OracleSchema schema, String name, boolean persisted) {
        super((DBSObject)schema, name, persisted);
    }

    protected OracleTableBase(OracleSchema oracleSchema, ResultSet dbResult) {
        super((DBSObject)oracleSchema, true);
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME"));
        this.valid = "VALID".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
        this.created = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.lastDDLTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_DDL_TIME");
    }

    protected OracleTableBase(@NotNull OracleSchema oracleSchema, @NotNull String name) {
        super((DBSObject)oracleSchema, true);
        this.setName(name);
        this.valid = true;
    }

    public JDBCStructCache<OracleSchema, ? extends JDBCTable, ? extends JDBCTableColumn> getCache() {
        return ((OracleSchema)this.getContainer()).tableCache;
    }

    @Override
    @NotNull
    public OracleSchema getSchema() {
        return (OracleSchema)super.getContainer();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Nullable
    public String getDescription() {
        return this.getComment();
    }

    @Property(viewable=true, order=13, visibleIf=OracleTableNotPartitionPropertyValidator.class)
    public Date getCreated() {
        return this.created;
    }

    @Property(viewable=true, order=14, visibleIf=OracleTableNotPartitionPropertyValidator.class)
    public Date getLastDDLTime() {
        return this.lastDDLTime;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100, visibleIf=OracleTableNotPartitionPropertyValidator.class)
    @LazyProperty(cacheValidator=CommentsValidator.class)
    public String getComment(DBRProgressMonitor monitor) {
        if (this.comment == null) {
            this.comment = "";
            if (this.isPersisted() && !DBWorkbench.getPlatform().isUnitTestMode()) {
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table comments");){
                    this.comment = this.queryTableComment(session);
                    if (this.comment == null) {
                        this.comment = "";
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Can't fetch table '" + this.getName() + "' comment"), (Throwable)e);
                }
            }
        }
        return this.comment;
    }

    @Nullable
    public String getDescription(@NotNull DBRProgressMonitor monitor) {
        return this.getComment(monitor);
    }

    @Association
    public Collection<OracleDependencyGroup> getDependencies(DBRProgressMonitor monitor) {
        return OracleDependencyGroup.of(this);
    }

    @Association
    public List<? extends OracleTableColumn> getCachedAttributes() {
        DBSObjectCache childrenCache = ((OracleSchema)this.getContainer()).getTableCache().getChildrenCache(this);
        if (childrenCache != null) {
            return childrenCache.getCachedObjects();
        }
        return Collections.emptyList();
    }

    protected String queryTableComment(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((Connection)session, (String)("SELECT COMMENTS FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), (OracleDataSource)session.getDataSource(), "TAB_COMMENTS") + " WHERE OWNER=? AND TABLE_NAME=? AND TABLE_TYPE=?"), (Object[])new Object[]{this.getSchema().getName(), this.getName(), this.getTableTypeName()});
    }

    void loadColumnComments(DBRProgressMonitor monitor) {
        try {
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table column comments");
                 JDBCPreparedStatement stat = session.prepareStatement("SELECT COLUMN_NAME,COMMENTS FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), (OracleDataSource)session.getDataSource(), "COL_COMMENTS") + " cc WHERE CC.OWNER=? AND cc.TABLE_NAME=?");){
                stat.setString(1, this.getSchema().getName());
                stat.setString(2, this.getName());
                try (JDBCResultSet resultSet = stat.executeQuery();){
                    while (resultSet.next()) {
                        String colName = resultSet.getString(1);
                        String colComment = resultSet.getString(2);
                        OracleTableColumn col = this.getAttribute(monitor, colName);
                        if (col == null) {
                            log.warn((Object)("Column '" + colName + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
                            continue;
                        }
                        col.setComment(CommonUtils.notEmpty((String)colComment));
                    }
                }
            }
            for (OracleTableColumn col : CommonUtils.safeCollection(this.getAttributes(monitor))) {
                col.cacheComment();
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error fetching table '" + this.getName() + "' column comments"), (Throwable)e);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<OracleTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).tableCache.getChildren(monitor, (OracleSchema)this.getContainer(), this);
    }

    public OracleTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (OracleTableColumn)((OracleSchema)this.getContainer()).tableCache.getChild(monitor, (OracleSchema)this.getContainer(), this, attributeName);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).constraintCache.clearObjectCache(this);
        ((OracleSchema)this.getContainer()).tableTriggerCache.clearObjectCache(this);
        return ((OracleSchema)this.getContainer()).tableCache.refreshObject(monitor, (OracleSchema)this.getContainer(), this);
    }

    @Nullable
    @Association
    public List<OracleTableTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchema().tableTriggerCache.getObjects(monitor, this.getSchema(), this);
    }

    public Collection<? extends DBSTableIndex> getIndexes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @NotNull
    public List<DBSEntityConstraintInfo> getSupportedConstraints() {
        return List.of(DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.PRIMARY_KEY, OracleTableConstraint.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.UNIQUE_KEY, OracleTableConstraint.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.INDEX, OracleTableIndex.class), DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.CHECK, OracleTableConstraint.class));
    }

    @Nullable
    @Association
    public Collection<OracleTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).constraintCache.getObjects(monitor, (OracleSchema)this.getContainer(), this);
    }

    public OracleTableConstraint getConstraint(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (OracleTableConstraint)((OracleSchema)this.getContainer()).constraintCache.getObject(monitor, (OracleSchema)this.getContainer(), this, ukName);
    }

    public DBSTableForeignKey getForeignKey(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DBSTableForeignKey)DBUtils.findObject(this.getAssociations(monitor), (String)ukName);
    }

    public Collection<OracleTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<OracleTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String getDDL(DBRProgressMonitor monitor, OracleDDLFormat ddlFormat, Map<String, Object> options) throws DBException {
        return OracleUtils.getDDL(monitor, this.getTableTypeName(), this, ddlFormat, options);
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }

    public static OracleTableBase findTable(DBRProgressMonitor monitor, OracleDataSource dataSource, String ownerName, String tableName) throws DBException {
        OracleSchema refSchema = dataSource.getSchema(monitor, ownerName);
        if (refSchema == null) {
            log.warn((Object)("Referenced schema '" + ownerName + "' not found"));
            return null;
        }
        OracleTableBase refTable = (OracleTableBase)refSchema.tableCache.getObject(monitor, refSchema, tableName);
        if (refTable == null) {
            log.warn((Object)("Referenced table '" + tableName + "' not found in schema '" + ownerName + "'"));
        }
        return refTable;
    }

    @Association
    public Collection<OraclePrivTable> getTablePrivs(DBRProgressMonitor monitor) throws DBException {
        return this.tablePrivCache.getAllObjects(monitor, this);
    }

    static class TablePrivCache
    extends JDBCObjectCache<OracleTableBase, OraclePrivTable> {
        TablePrivCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleTableBase tableBase) throws SQLException {
            boolean hasDBA = ((OracleDataSource)tableBase.getDataSource()).isViewAvailable(session.getProgressMonitor(), "SYS", "DBA_TAB_PRIVS");
            String ownerColTab = hasDBA ? "OWNER" : "TABLE_SCHEMA";
            String commonTabExpr = hasDBA ? "p.COMMON" : "CAST(NULL AS VARCHAR2(3))";
            String typeTabExpr = hasDBA ? "p.TYPE" : "CAST('TABLE' AS VARCHAR2(10))";
            String commonColExpr = hasDBA ? "p.COMMON" : "CAST(NULL AS VARCHAR2(3))";
            String typeColExpr = "CAST('COLUMN' AS VARCHAR2(10))";
            String tabView = hasDBA ? "DBA_TAB_PRIVS" : "ALL_TAB_PRIVS";
            String colView = hasDBA ? "DBA_COL_PRIVS" : "ALL_COL_PRIVS";
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT\n    p.GRANTEE,\n    p.%s,\n    p.TABLE_NAME,\n    NULL AS COLUMN_NAME,\n    p.GRANTOR,\n    p.PRIVILEGE,\n    p.GRANTABLE,\n    p.HIERARCHY,\n    %s AS COMMON,\n    %s AS TYPE\nFROM %s p\nWHERE p.%s = ? AND p.TABLE_NAME = ?\nUNION ALL\nSELECT\n    p.GRANTEE,\n    p.%s,\n    p.TABLE_NAME,\n    p.COLUMN_NAME,\n    p.GRANTOR,\n    p.PRIVILEGE,\n    p.GRANTABLE,\n    NULL AS HIERARCHY,\n    %s AS COMMON,\n    %s AS TYPE\nFROM %s p\nWHERE p.%s = ? AND p.TABLE_NAME = ?\n".formatted(ownerColTab, commonTabExpr, typeTabExpr, tabView, ownerColTab, ownerColTab, commonColExpr, "CAST('COLUMN' AS VARCHAR2(10))", colView, ownerColTab));
            dbStat.setString(1, tableBase.getSchema().getName());
            dbStat.setString(2, tableBase.getName());
            dbStat.setString(3, tableBase.getSchema().getName());
            dbStat.setString(4, tableBase.getName());
            return dbStat;
        }

        protected OraclePrivTable fetchObject(@NotNull JDBCSession session, @NotNull OracleTableBase tableBase, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String type = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"TYPE");
            if ("COLUMN".equals(type)) {
                return new OraclePrivTableColumn(tableBase, (ResultSet)resultSet);
            }
            return new OraclePrivTable(tableBase, (ResultSet)resultSet);
        }
    }

    public static class CommentsValidator
    implements IPropertyCacheValidator<OracleTableBase> {
        public boolean isPropertyCached(@NotNull OracleTableBase object, @NotNull Object propertyId) {
            return object.comment != null;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<OracleTableBase> {
        public boolean isPropertyCached(@NotNull OracleTableBase object, @NotNull Object propertyId) {
            return object.getAdditionalInfo().isLoaded() || ((OracleDataSource)object.getDataSource()).dataTypeCache.isFullyCached();
        }
    }

    public static class TableAdditionalInfo {
        volatile boolean loaded = false;

        boolean isLoaded() {
            return this.loaded;
        }
    }
}

