/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLDataTypeConverter;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLStateType;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class JDBCSQLDialect
extends BasicSQLDialect
implements SQLDataTypeConverter {
    private static final Log log = Log.getLog(JDBCSQLDialect.class);
    private static final String[] LONG_TEXT_TYPES = new String[]{"longtext", "clob", "text", "string", "nclob"};
    private final String name;
    private final String id;
    private String[][] identifierQuoteString = new String[][]{{"\"", "\""}};
    private SQLStateType sqlStateType;
    private String searchStringEscape;
    private String catalogSeparator = String.valueOf('.');
    private boolean isCatalogAtStart;
    private int catalogUsage = Integer.MAX_VALUE;
    protected int schemaUsage = Integer.MAX_VALUE;
    protected String validCharacters = "";
    private boolean supportsUnquotedMixedCase;
    private boolean supportsQuotedMixedCase;
    @NotNull
    private DBPIdentifierCase unquotedIdentCase = this.getDefaultIdentifiersCase();
    @NotNull
    private DBPIdentifierCase quotedIdentCase = this.getDefaultIdentifiersCase();
    private boolean supportsSubqueries = false;
    private transient boolean typesLoaded = false;

    public JDBCSQLDialect(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        String singleQuoteStr;
        try {
            singleQuoteStr = metaData.getIdentifierQuoteString();
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting identifierQuoteString: " + e.getMessage()));
            singleQuoteStr = "\"";
        }
        if (singleQuoteStr != null && (singleQuoteStr = singleQuoteStr.trim()).isEmpty()) {
            singleQuoteStr = null;
        }
        this.identifierQuoteString = singleQuoteStr == null ? new String[0][] : new String[][]{{singleQuoteStr, singleQuoteStr}};
        try {
            switch (metaData.getSQLStateType()) {
                case 1: {
                    this.sqlStateType = SQLStateType.XOPEN;
                    break;
                }
                case 2: {
                    this.sqlStateType = SQLStateType.SQL99;
                    break;
                }
                default: {
                    this.sqlStateType = SQLStateType.UNKNOWN;
                    break;
                }
            }
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting sqlStateType: " + e.getMessage()));
            this.sqlStateType = SQLStateType.UNKNOWN;
        }
        try {
            this.supportsSubqueries = metaData.supportsCorrelatedSubqueries() || metaData.supportsSubqueriesInComparisons() || metaData.supportsSubqueriesInExists() || metaData.supportsSubqueriesInIns() || metaData.supportsSubqueriesInQuantifieds();
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting supportsSubqueries: " + e.getMessage()));
        }
        try {
            this.supportsUnquotedMixedCase = metaData.supportsMixedCaseIdentifiers();
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting supportsUnquotedMixedCase:" + e.getMessage()));
            this.supportsUnquotedMixedCase = false;
        }
        try {
            this.supportsQuotedMixedCase = metaData.supportsMixedCaseQuotedIdentifiers();
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting supportsQuotedMixedCase: " + e.getMessage()));
            this.supportsQuotedMixedCase = false;
        }
        try {
            this.unquotedIdentCase = metaData.storesUpperCaseIdentifiers() ? DBPIdentifierCase.UPPER : (metaData.storesLowerCaseIdentifiers() ? DBPIdentifierCase.LOWER : DBPIdentifierCase.MIXED);
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting unquotedIdentCase:" + e.getMessage()));
            this.unquotedIdentCase = DBPIdentifierCase.MIXED;
        }
        try {
            this.quotedIdentCase = metaData.storesUpperCaseQuotedIdentifiers() ? DBPIdentifierCase.UPPER : (metaData.storesLowerCaseQuotedIdentifiers() ? DBPIdentifierCase.LOWER : DBPIdentifierCase.MIXED);
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting quotedIdentCase:" + e.getMessage()));
            this.quotedIdentCase = DBPIdentifierCase.MIXED;
        }
        try {
            this.searchStringEscape = metaData.getSearchStringEscape();
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting searchStringEscape:" + e.getMessage()));
        }
        if (this.searchStringEscape == null) {
            this.searchStringEscape = "";
        }
        try {
            this.catalogSeparator = metaData.getCatalogSeparator();
            if (CommonUtils.isEmpty((String)this.catalogSeparator)) {
                this.catalogSeparator = String.valueOf('.');
            }
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting catalogSeparator:" + e.getMessage()));
            this.catalogSeparator = String.valueOf('.');
        }
        try {
            this.catalogUsage = (metaData.supportsCatalogsInDataManipulation() ? 1 : 0) | (metaData.supportsCatalogsInTableDefinitions() ? 2 : 0) | (metaData.supportsCatalogsInProcedureCalls() ? 4 : 0) | (metaData.supportsCatalogsInIndexDefinitions() ? 8 : 0) | (metaData.supportsCatalogsInPrivilegeDefinitions() ? 8 : 0);
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting catalogUsage:" + e.getMessage()));
            this.catalogUsage = 0;
        }
        try {
            this.schemaUsage = (metaData.supportsSchemasInDataManipulation() ? 1 : 0) | (metaData.supportsSchemasInTableDefinitions() ? 2 : 0) | (metaData.supportsSchemasInProcedureCalls() ? 4 : 0) | (metaData.supportsSchemasInIndexDefinitions() ? 8 : 0) | (metaData.supportsSchemasInPrivilegeDefinitions() ? 8 : 0);
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting schemaUsage:" + e.getMessage()));
            this.schemaUsage = 3;
        }
        try {
            this.validCharacters = metaData.getExtraNameCharacters();
            this.validCharacters = this.validCharacters == null ? "" : this.validCharacters.trim();
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting validCharacters:" + e.getMessage()));
            this.validCharacters = "";
        }
        try {
            this.isCatalogAtStart = metaData.isCatalogAtStart();
        }
        catch (Throwable e) {
            log.debug((Object)("Error getting isCatalogAtStart:" + e.getMessage()));
            this.isCatalogAtStart = true;
        }
        this.loadDriverKeywords(session, dataSource, metaData);
    }

    @NotNull
    protected DBPIdentifierCase getDefaultIdentifiersCase() {
        return DBPIdentifierCase.MIXED;
    }

    @NotNull
    public String getDialectName() {
        return this.name;
    }

    @NotNull
    public String getDialectId() {
        return this.id;
    }

    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return this.identifierQuoteString;
    }

    protected void setIdentifierQuoteString(String[][] identifierQuoteString) {
        this.identifierQuoteString = identifierQuoteString;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return new String[0];
    }

    @NotNull
    public String getSearchStringEscape() {
        return this.searchStringEscape;
    }

    public int getCatalogUsage() {
        return this.catalogUsage;
    }

    public int getSchemaUsage() {
        return this.schemaUsage;
    }

    @NotNull
    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    public char getStructSeparator() {
        return '.';
    }

    public boolean isCatalogAtStart() {
        return this.isCatalogAtStart;
    }

    @NotNull
    public SQLStateType getSQLStateType() {
        return this.sqlStateType;
    }

    public boolean validIdentifierPart(char c, boolean quoted) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_' || quoted && this.validCharacters.indexOf(c) != -1;
    }

    public boolean supportsUnquotedMixedCase() {
        return this.supportsUnquotedMixedCase;
    }

    public void setSupportsUnquotedMixedCase(boolean supportsUnquotedMixedCase) {
        this.supportsUnquotedMixedCase = supportsUnquotedMixedCase;
    }

    public boolean supportsQuotedMixedCase() {
        return this.supportsQuotedMixedCase;
    }

    protected void setSupportsQuotedMixedCase(boolean supportsQuotedMixedCase) {
        this.supportsQuotedMixedCase = supportsQuotedMixedCase;
    }

    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return this.unquotedIdentCase;
    }

    protected void setUnquotedIdentCase(@NotNull DBPIdentifierCase unquotedIdentCase) {
        this.unquotedIdentCase = unquotedIdentCase;
    }

    @NotNull
    public DBPIdentifierCase storesQuotedCase() {
        return this.quotedIdentCase;
    }

    public boolean supportsSubqueries() {
        return this.supportsSubqueries;
    }

    public void setSupportsSubqueries(boolean supportsSubqueries) {
        this.supportsSubqueries = supportsSubqueries;
    }

    public boolean supportsUpsertStatement() {
        return false;
    }

    @NotNull
    public Collection<String> getDataTypes(@Nullable DBPDataSource dataSource) {
        if (!this.typesLoaded && dataSource instanceof JDBCDataSource) {
            this.loadDataTypesFromDatabase((JDBCDataSource)dataSource);
            this.typesLoaded = true;
        }
        return super.getDataTypes(dataSource);
    }

    protected void loadDataTypesFromDatabase(JDBCDataSource dataSource) {
        this.clearDataTypes();
        Collection supportedDataTypes = dataSource.getLocalDataTypes();
        ArrayList<String> dataTypes = new ArrayList<String>();
        if (supportedDataTypes != null) {
            for (DBSDataType dataType : supportedDataTypes) {
                if (dataType.getDataKind().isComplex()) continue;
                dataTypes.add(dataType.getName().toUpperCase(Locale.ENGLISH));
            }
        }
        if (dataTypes.isEmpty() && this.needsDefaultDataTypes()) {
            Collections.addAll(dataTypes, SQLConstants.DEFAULT_TYPES);
        }
        this.addDataTypes(dataTypes);
    }

    private void loadDriverKeywords(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        try {
            List<String> sqlKeywords = JDBCSQLDialect.makeStringList(metaData.getSQLKeywords());
            if (!CommonUtils.isEmpty(sqlKeywords)) {
                for (String keyword : sqlKeywords) {
                    this.addSQLKeyword(keyword.toUpperCase());
                }
            }
        }
        catch (SQLException e) {
            log.debug((Object)("Error reading SQL keywords: " + e.getMessage()));
        }
        try {
            HashSet<String> allFunctions = new HashSet<String>();
            this.loadFunctions(session, metaData, allFunctions);
            allFunctions.removeIf(s -> this.getKeywordType((String)s) == DBPKeywordType.KEYWORD);
            this.addFunctions(allFunctions);
        }
        catch (Throwable e) {
            log.debug((Object)("Error reading SQL functions: " + e.getMessage()));
        }
    }

    protected void loadFunctions(JDBCSession session, JDBCDatabaseMetaData metaData, Set<String> allFunctions) throws DBException, SQLException {
        allFunctions.addAll(JDBCSQLDialect.makeStringList(metaData.getNumericFunctions()));
        allFunctions.addAll(JDBCSQLDialect.makeStringList(metaData.getStringFunctions()));
        allFunctions.addAll(JDBCSQLDialect.makeStringList(metaData.getSystemFunctions()));
        allFunctions.addAll(JDBCSQLDialect.makeStringList(metaData.getTimeDateFunctions()));
    }

    private static List<String> makeStringList(String source) {
        ArrayList<String> result = new ArrayList<String>();
        if (source != null && source.length() > 0) {
            StringTokenizer st = new StringTokenizer(source, ";,");
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    public String convertExternalDataType(@NotNull SQLDialect sourceDialect, @NotNull DBSTypedObject sourceTypedObject, @Nullable DBPDataTypeProvider targetTypeProvider) {
        long maxLength;
        String externalTypeName;
        String typeName;
        if (targetTypeProvider != null && CommonUtils.isNotEmpty((String)(typeName = sourceTypedObject.getTypeName())) && "varchar".equals(externalTypeName = typeName.toLowerCase(Locale.ENGLISH)) && (maxLength = sourceTypedObject.getMaxLength()) <= 0L) {
            for (String textType : LONG_TEXT_TYPES) {
                DBSDataType textDataType = targetTypeProvider.getLocalDataType(textType);
                if (textDataType == null) continue;
                return textDataType.getName();
            }
        }
        return null;
    }
}

