﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/acm-pca/ACMPCA_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ACMPCA {
namespace Model {
class GetCertificateAuthorityCertificateResult {
 public:
  AWS_ACMPCA_API GetCertificateAuthorityCertificateResult() = default;
  AWS_ACMPCA_API GetCertificateAuthorityCertificateResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ACMPCA_API GetCertificateAuthorityCertificateResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Base64-encoded certificate authority (CA) certificate.</p>
   */
  inline const Aws::String& GetCertificate() const { return m_certificate; }
  template <typename CertificateT = Aws::String>
  void SetCertificate(CertificateT&& value) {
    m_certificateHasBeenSet = true;
    m_certificate = std::forward<CertificateT>(value);
  }
  template <typename CertificateT = Aws::String>
  GetCertificateAuthorityCertificateResult& WithCertificate(CertificateT&& value) {
    SetCertificate(std::forward<CertificateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Base64-encoded certificate chain that includes any intermediate certificates
   * and chains up to root certificate that you used to sign your private CA
   * certificate. The chain does not include your private CA certificate. If this is
   * a root CA, the value will be null.</p>
   */
  inline const Aws::String& GetCertificateChain() const { return m_certificateChain; }
  template <typename CertificateChainT = Aws::String>
  void SetCertificateChain(CertificateChainT&& value) {
    m_certificateChainHasBeenSet = true;
    m_certificateChain = std::forward<CertificateChainT>(value);
  }
  template <typename CertificateChainT = Aws::String>
  GetCertificateAuthorityCertificateResult& WithCertificateChain(CertificateChainT&& value) {
    SetCertificateChain(std::forward<CertificateChainT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetCertificateAuthorityCertificateResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_certificate;

  Aws::String m_certificateChain;

  Aws::String m_requestId;
  bool m_certificateHasBeenSet = false;
  bool m_certificateChainHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ACMPCA
}  // namespace Aws
