﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appfabric/AppFabric_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppFabric {
namespace Model {

/**
 * <p>Contains a summary of an ingestion destination.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/IngestionDestinationSummary">AWS
 * API Reference</a></p>
 */
class IngestionDestinationSummary {
 public:
  AWS_APPFABRIC_API IngestionDestinationSummary() = default;
  AWS_APPFABRIC_API IngestionDestinationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFABRIC_API IngestionDestinationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPFABRIC_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the ingestion destination.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  IngestionDestinationSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppFabric
}  // namespace Aws
