/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.type;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;

public class OpenSearchTextType
extends OpenSearchDataType {
    private static final OpenSearchTextType instance = new OpenSearchTextType();
    Map<String, OpenSearchDataType> fields = ImmutableMap.of();

    private OpenSearchTextType() {
        super(OpenSearchDataType.MappingType.Text);
        this.exprCoreType = ExprCoreType.UNKNOWN;
    }

    public static OpenSearchTextType of(Map<String, OpenSearchDataType> fields) {
        OpenSearchTextType res = new OpenSearchTextType();
        res.fields = fields;
        return res;
    }

    public static OpenSearchTextType of() {
        return instance;
    }

    public List<ExprType> getParent() {
        return List.of(ExprCoreType.STRING);
    }

    public boolean shouldCast(ExprType other) {
        return false;
    }

    public Map<String, OpenSearchDataType> getFields() {
        return this.fields;
    }

    @Override
    protected OpenSearchDataType cloneEmpty() {
        return OpenSearchTextType.of(Map.copyOf(this.fields));
    }

    @Deprecated
    public static String convertTextToKeyword(String fieldName, ExprType fieldType) {
        if (fieldType instanceof OpenSearchTextType && ((OpenSearchTextType)fieldType).getFields().size() > 0) {
            return fieldName + ".keyword";
        }
        return fieldName;
    }

    public static String toKeywordSubField(String fieldName, ExprType exprType) {
        ExprType exprType2;
        if (exprType != null && (exprType2 = exprType.getOriginalExprType()) instanceof OpenSearchTextType) {
            OpenSearchTextType textType = (OpenSearchTextType)exprType2;
            String path = exprType.getOriginalPath().orElse(fieldName);
            return textType.getFields().entrySet().stream().filter(e -> ((OpenSearchDataType)e.getValue()).getMappingType() == OpenSearchDataType.MappingType.Keyword).findFirst().map(e -> path + "." + (String)e.getKey()).orElse(null);
        }
        return fieldName;
    }
}

