/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.AbstractAuthenticatableSAMLEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.security.messaging.impl.BaseClientCertAuthSecurityHandler;
import org.slf4j.Logger;

public class SAMLMDClientCertAuthSecurityHandler
extends BaseClientCertAuthSecurityHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SAMLMDClientCertAuthSecurityHandler.class);
    @Nonnull
    private Class<? extends AbstractAuthenticatableSAMLEntityContext> entityContextClass = SAMLPeerEntityContext.class;

    @Nonnull
    public Class<? extends AbstractAuthenticatableSAMLEntityContext> getEntityContextClass() {
        return this.entityContextClass;
    }

    public void setEntityContextClass(@Nonnull Class<? extends AbstractAuthenticatableSAMLEntityContext> clazz) {
        this.checkSetterPreconditions();
        this.entityContextClass = Constraint.isNotNull(clazz, "The SAML entity context class may not be null");
    }

    @Override
    @Nonnull
    protected CriteriaSet buildCriteriaSet(@Nullable String entityID, @Nonnull MessageContext messageContext) throws MessageHandlerException {
        CriteriaSet criteriaSet = super.buildCriteriaSet(entityID, messageContext);
        if (criteriaSet == null) {
            criteriaSet = new CriteriaSet();
        }
        try {
            this.log.trace("Attempting to build criteria based on contents of entity contxt class of type: {}", (Object)this.entityContextClass.getName());
            AbstractAuthenticatableSAMLEntityContext entityContext = messageContext.ensureSubcontext(this.entityContextClass);
            criteriaSet.add(new EntityRoleCriterion(Constraint.isNotNull(entityContext.getRole(), "SAML entity role was null")));
            SAMLProtocolContext protocolContext = messageContext.ensureSubcontext(SAMLProtocolContext.class);
            criteriaSet.add(new ProtocolCriterion(Constraint.isNotNull(protocolContext.getProtocol(), "SAML protocol was null")));
        }
        catch (ConstraintViolationException e) {
            throw new MessageHandlerException(e);
        }
        return criteriaSet;
    }

    @Override
    @Nullable
    protected String getCertificatePresenterEntityID(@Nonnull MessageContext messageContext) {
        AbstractAuthenticatableSAMLEntityContext entityContext = messageContext.getSubcontext(this.entityContextClass);
        if (entityContext != null) {
            this.log.trace("Found authenticatable entityID '{}' from context: {}", (Object)entityContext.getEntityId(), (Object)entityContext.getClass().getName());
            return entityContext.getEntityId();
        }
        this.log.trace("Authenticatable entityID context was not present: {}", (Object)this.entityContextClass.getName());
        return null;
    }

    @Override
    protected void setAuthenticatedCertificatePresenterEntityID(@Nonnull MessageContext messageContext, @Nullable String entityID) {
        this.log.trace("Storing authenticatable entityID '{}' in context: {}", (Object)entityID, this.entityContextClass);
        messageContext.ensureSubcontext(this.entityContextClass).setEntityId(entityID);
    }

    @Override
    protected void setAuthenticatedState(@Nonnull MessageContext messageContext, boolean authenticated) {
        this.log.trace("Storing authenticated entity state '{}' in context: {}", (Object)authenticated, this.entityContextClass);
        messageContext.ensureSubcontext(this.entityContextClass).setAuthenticated(authenticated);
    }
}

