/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.ffmpeg.FFmpegResult;
import com.github.kokorin.jaffree.process.Stopper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FFmpegResultFuture {
    private final CompletableFuture<FFmpegResult> resultFuture;
    private final Stopper stopper;

    public FFmpegResultFuture(CompletableFuture<FFmpegResult> resultFuture, Stopper stopper) {
        this.resultFuture = resultFuture;
        this.stopper = stopper;
    }

    public void forceStop() {
        this.resultFuture.cancel(true);
    }

    public void graceStop() {
        this.stopper.graceStop();
    }

    public void stop(boolean forcefully) {
        if (forcefully) {
            this.forceStop();
        }
        this.graceStop();
    }

    @Deprecated
    public boolean cancel(boolean forceStop) {
        this.stop(forceStop);
        return true;
    }

    public FFmpegResult get() throws InterruptedException, ExecutionException {
        return this.resultFuture.get();
    }

    public FFmpegResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.resultFuture.get(timeout, unit);
    }

    public boolean isCancelled() {
        return this.resultFuture.isCancelled();
    }

    public boolean isDone() {
        return this.resultFuture.isDone();
    }

    public CompletableFuture<FFmpegResult> toCompletableFuture() {
        return this.resultFuture;
    }
}

