/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.filter;

import com.jidesoft.swing.RangeSlider;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import mediathek.tool.FilterConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FilmLengthSlider
extends RangeSlider {
    private static final Logger logger = LogManager.getLogger();
    private static final int MAX_FILM_LENGTH = 240;
    private static final int TICK_SPACING = 30;
    public static final int UNLIMITED_VALUE = 240;

    public FilmLengthSlider() {
        super(0, 240);
        this.setPaintLabels(true);
        this.setPaintTicks(true);
        this.setPaintTrack(true);
        this.setMajorTickSpacing(30);
        this.setLabelTable(new FilmlengthLabelTable());
    }

    public void restoreFilterConfig(@NotNull FilterConfiguration filterConfig) {
        try {
            this.setValueIsAdjusting(true);
            this.setLowValue((int)filterConfig.getFilmLengthMin());
            this.setHighValue((int)filterConfig.getFilmLengthMax());
            this.setValueIsAdjusting(false);
        }
        catch (Exception exception) {
            logger.error("Failed to restore filmlength config", (Throwable)exception);
        }
    }

    public String getHighValueText() {
        int highValue = this.getHighValue();
        String res = highValue == 240 ? "\u221e" : String.valueOf(highValue);
        return res;
    }

    private static class FilmlengthLabelTable
    extends Hashtable<Integer, JComponent> {
        public FilmlengthLabelTable() {
            for (int i = 0; i < 240; i += 30) {
                this.put(i, new JLabel(String.valueOf(i)));
            }
            this.put(240, new JLabel("\u221e"));
        }
    }
}

