/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\rJ\u0006\u0010\b\u001a\u00020\rJ\u0006\u0010\t\u001a\u00020\rJ\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0006\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lmediathek/tool/http/ByteCounter;", "", "<init>", "()V", "socketFactory", "Ljavax/net/SocketFactory;", "bytesWritten", "Ljava/util/concurrent/atomic/AtomicLong;", "bytesRead", "totalBytesRead", "totalBytesWritten", "resetCounters", "", "", "length", "", "CountSocketFactory", "CountingSocket", "CountingOutputStream", "CountingInputStream", "MediathekView"})
public final class ByteCounter {
    @NotNull
    private final SocketFactory socketFactory = new CountSocketFactory();
    @NotNull
    private final AtomicLong bytesWritten = new AtomicLong();
    @NotNull
    private final AtomicLong bytesRead = new AtomicLong();
    @NotNull
    private final AtomicLong totalBytesRead = new AtomicLong();
    @NotNull
    private final AtomicLong totalBytesWritten = new AtomicLong();

    public final void resetCounters() {
        this.bytesWritten.set(0L);
        this.bytesRead.set(0L);
    }

    @NotNull
    public final SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public final long bytesWritten() {
        return this.bytesWritten.get();
    }

    public final long bytesRead() {
        return this.bytesRead.get();
    }

    public final long totalBytesRead() {
        return this.totalBytesRead.get();
    }

    public final long totalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    public final void bytesRead(int length) {
        this.bytesRead.getAndAdd(length);
        this.totalBytesRead.getAndAdd(length);
    }

    public final void bytesWritten(int length) {
        this.bytesWritten.getAndAdd(length);
        this.totalBytesWritten.getAndAdd(length);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\u000e"}, d2={"Lmediathek/tool/http/ByteCounter$CountSocketFactory;", "Ljavax/net/SocketFactory;", "<init>", "(Lmediathek/tool/http/ByteCounter;)V", "createSocket", "Ljava/net/Socket;", "s", "", "i", "", "inetAddress", "Ljava/net/InetAddress;", "i1", "inetAddress1", "MediathekView"})
    public final class CountSocketFactory
    extends SocketFactory {
        @Override
        @NotNull
        public Socket createSocket() {
            return new CountingSocket();
        }

        @Override
        @NotNull
        public Socket createSocket(@NotNull String s, int i) throws IOException {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return new CountingSocket(s, i);
        }

        @Override
        @NotNull
        public Socket createSocket(@NotNull String s, int i, @NotNull InetAddress inetAddress, int i1) throws IOException {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
            return new CountingSocket(s, i, inetAddress, i1);
        }

        @Override
        @NotNull
        public Socket createSocket(@NotNull InetAddress inetAddress, int i) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
            return new CountingSocket(inetAddress, i);
        }

        @Override
        @NotNull
        public Socket createSocket(@NotNull InetAddress inetAddress, int i, @NotNull InetAddress inetAddress1, int i1) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inetAddress, (String)"inetAddress");
            Intrinsics.checkNotNullParameter((Object)inetAddress1, (String)"inetAddress1");
            return new CountingSocket(inetAddress, i, inetAddress1, i1);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmediathek/tool/http/ByteCounter$CountingInputStream;", "Ljava/io/InputStream;", "delegate", "byteCounter", "Lmediathek/tool/http/ByteCounter;", "<init>", "(Ljava/io/InputStream;Lmediathek/tool/http/ByteCounter;)V", "read", "", "b", "", "off", "len", "skip", "", "n", "available", "close", "", "mark", "readlimit", "reset", "markSupported", "", "MediathekView"})
    public static final class CountingInputStream
    extends InputStream {
        @NotNull
        private final InputStream delegate;
        @NotNull
        private final ByteCounter byteCounter;

        public CountingInputStream(@NotNull InputStream delegate, @NotNull ByteCounter byteCounter) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)byteCounter, (String)"byteCounter");
            this.delegate = delegate;
            this.byteCounter = byteCounter;
        }

        @Override
        public int read() throws IOException {
            int read = this.delegate.read();
            if (read > 0) {
                this.byteCounter.bytesRead(1);
            }
            return read;
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int read = this.delegate.read(b);
            if (read > 0) {
                this.byteCounter.bytesRead(read);
            }
            return read;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int read = this.delegate.read(b, off, len);
            if (read > 0) {
                this.byteCounter.bytesRead(read);
            }
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmediathek/tool/http/ByteCounter$CountingOutputStream;", "Ljava/io/OutputStream;", "delegate", "byteCounter", "Lmediathek/tool/http/ByteCounter;", "<init>", "(Ljava/io/OutputStream;Lmediathek/tool/http/ByteCounter;)V", "write", "", "b", "", "", "off", "len", "flush", "close", "MediathekView"})
    public static final class CountingOutputStream
    extends OutputStream {
        @NotNull
        private final OutputStream delegate;
        @NotNull
        private final ByteCounter byteCounter;

        public CountingOutputStream(@NotNull OutputStream delegate, @NotNull ByteCounter byteCounter) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)byteCounter, (String)"byteCounter");
            this.delegate = delegate;
            this.byteCounter = byteCounter;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
            this.byteCounter.bytesWritten(1);
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.delegate.write(b);
            this.byteCounter.bytesWritten(b.length);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.delegate.write(b, off, len);
            this.byteCounter.bytesWritten(len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001b\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\bB\u001b\b\u0016\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\u000bB-\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\u000eB-\b\u0016\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\u000fJ\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmediathek/tool/http/ByteCounter$CountingSocket;", "Ljava/net/Socket;", "<init>", "(Lmediathek/tool/http/ByteCounter;)V", "host", "", "port", "", "(Lmediathek/tool/http/ByteCounter;Ljava/lang/String;I)V", "address", "Ljava/net/InetAddress;", "(Lmediathek/tool/http/ByteCounter;Ljava/net/InetAddress;I)V", "localAddr", "localPort", "(Lmediathek/tool/http/ByteCounter;Ljava/lang/String;ILjava/net/InetAddress;I)V", "(Lmediathek/tool/http/ByteCounter;Ljava/net/InetAddress;ILjava/net/InetAddress;I)V", "lock", "", "outputStream", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "getInputStream", "getOutputStream", "MediathekView"})
    public final class CountingSocket
    extends Socket {
        @NotNull
        private final Object lock;
        @Nullable
        private OutputStream outputStream;
        @Nullable
        private InputStream inputStream;

        public CountingSocket() {
            this.lock = new Object();
        }

        public CountingSocket(String host, int port) {
            super(host, port);
            this.lock = new Object();
        }

        public CountingSocket(InetAddress address, int port) {
            super(address, port);
            this.lock = new Object();
        }

        public CountingSocket(String host, @Nullable int port, InetAddress localAddr, int localPort) {
            super(host, port, localAddr, localPort);
            this.lock = new Object();
        }

        public CountingSocket(InetAddress address, @Nullable int port, InetAddress localAddr, int localPort) {
            super(address, port, localAddr, localPort);
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            Object object = this.lock;
            ByteCounter byteCounter = ByteCounter.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                if (this.inputStream == null) {
                    InputStream inputStream = super.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    this.inputStream = new CountingInputStream(inputStream, byteCounter);
                }
                Unit unit = Unit.INSTANCE;
            }
            InputStream inputStream = this.inputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            return inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public OutputStream getOutputStream() throws IOException {
            Object object = this.lock;
            ByteCounter byteCounter = ByteCounter.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                if (this.outputStream == null) {
                    OutputStream outputStream = super.getOutputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
                    this.outputStream = new CountingOutputStream(outputStream, byteCounter);
                }
                Unit unit = Unit.INSTANCE;
            }
            OutputStream outputStream = this.outputStream;
            Intrinsics.checkNotNull((Object)outputStream);
            return outputStream;
        }
    }
}

