/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Transforms the image so that any pixel that is not a regional maxima
is set to the minimum value for the pixel type. Pixels that are
regional maxima retain their value.


Regional maxima are flat zones surrounded by pixels of lower value. A
completely flat image will be marked as a regional maxima by this
filter.

This code was contributed in the Insight Journal paper: "Finding
regional extrema - methods and performance" by Beare R., Lehmann G. https://doi.org/10.54294/hva3gz


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.

See:
 ValuedRegionalMinimaImageFilter

 ValuedRegionalExtremaImageFilter

 HMinimaImageFilter

 itk::simple::ValuedRegionalMaxima for the procedural interface

 itk::ValuedRegionalMaximaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkValuedRegionalMaximaImageFilter.h
*/
public class ValuedRegionalMaximaImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ValuedRegionalMaximaImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ValuedRegionalMaximaImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ValuedRegionalMaximaImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ValuedRegionalMaximaImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ValuedRegionalMaximaImageFilter::~ValuedRegionalMaximaImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ValuedRegionalMaximaImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ValuedRegionalMaximaImageFilter::ValuedRegionalMaximaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ValuedRegionalMaximaImageFilter() {
    this(SimpleITKJNI.new_ValuedRegionalMaximaImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ValuedRegionalMaximaImageFilter::SetFullyConnected(bool FullyConnected)
*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.ValuedRegionalMaximaImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::ValuedRegionalMaximaImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.ValuedRegionalMaximaImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ValuedRegionalMaximaImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.ValuedRegionalMaximaImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::ValuedRegionalMaximaImageFilter::GetFullyConnected() const
*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.ValuedRegionalMaximaImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
bool itk::simple::ValuedRegionalMaximaImageFilter::GetFlat() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  boolean getFlat() {
    return SimpleITKJNI.ValuedRegionalMaximaImageFilter_getFlat(swigCPtr, this);
  }

  /**
std::string itk::simple::ValuedRegionalMaximaImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ValuedRegionalMaximaImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ValuedRegionalMaximaImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ValuedRegionalMaximaImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ValuedRegionalMaximaImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ValuedRegionalMaximaImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
