"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtensionSignatureVerificationError = exports.verify = exports.sign = void 0;
const commander = __importStar(require("commander"));
const commands_1 = require("./utils/commands");
Object.defineProperty(exports, "verify", { enumerable: true, get: function () { return commands_1.verify; } });
Object.defineProperty(exports, "sign", { enumerable: true, get: function () { return commands_1.sign; } });
const errors_1 = require("./utils/errors");
Object.defineProperty(exports, "ExtensionSignatureVerificationError", { enumerable: true, get: function () { return errors_1.ExtensionSignatureVerificationError; } });
function default_1(argv) {
    const program = new commander.Command();
    program.usage("<command> [options]");
    const verifyCmd = program.command("verify");
    verifyCmd
        .description("Verify an extension package")
        .arguments("<extension-package> <signature-archive>")
        .option("-p, --public-key <public-key>", "The path to the public key to use for verification")
        .option("-m, --verify-signature-manifest", "Verify the signature manifest in the signature archive (will be the default in a future release)")
        .option("-v, --verbose", "Capture verbose detail in the event of an error")
        .action(async (vsixFilePath, signatureArchiveFilePath, { publicKey, verifySignatureManifest, verbose }) => {
        try {
            await (0, commands_1.verify)(vsixFilePath, signatureArchiveFilePath, verbose, {
                publicKey,
                verifySignatureManifest,
            });
        }
        catch (e) {
            console.error(e.message);
            process.exit(1);
        }
    });
    const signCmd = program.command("sign");
    signCmd
        .description("Sign an extension package")
        .arguments("<extension-package> <private-key>")
        .option("-o, --output <output>", "The path to the output signature archive")
        .action(commands_1.sign);
    const keyPairCmd = program.command("key-pair");
    keyPairCmd
        .description("Generate a ed25519 key pair")
        .option("-o, --output-dir <output-dir>", "The directory to the output key pair")
        .option("-f, --overwrite", "Overwrite existing key pair if it already exists")
        .action(async ({ outputDir, overwrite }) => {
        try {
            await (0, commands_1.keyPair)({ outputDir, overwrite });
        }
        catch (e) {
            console.error(e.message);
            process.exit(1);
        }
    });
    program.parse(argv);
    if (process.argv.length <= 2) {
        program.help();
    }
}
exports.default = default_1;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/072586267e68ece9a47aa43f8c108e0dcbf44622/node_modules/node-ovsx-sign/lib/index.js.map