/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.slf4j.Logger;

public class ScriptedPredicate<T>
extends AbstractScriptEvaluator
implements Predicate<T> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedPredicate.class);
    @Nullable
    private Class<T> inputTypeClass;

    protected ScriptedPredicate(@Nonnull @NotEmpty EvaluableScript theScript, @Nullable @NotEmpty String extraInfo) {
        super(theScript);
        this.setOutputType(Boolean.class);
        this.setReturnOnError(false);
        this.setLogPrefix("Scripted Predicate from " + extraInfo + ":");
    }

    protected ScriptedPredicate(@Nonnull @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setLogPrefix("Anonymous Scripted Predicate:");
        this.setOutputType(Boolean.class);
        this.setReturnOnError(false);
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputTypeClass;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputTypeClass = type;
    }

    public void setReturnOnError(boolean flag) {
        this.setReturnOnError((Object)flag);
    }

    @Override
    public boolean test(@Nullable T input) {
        Class<T> itype = this.getInputType();
        if (null != itype && null != input && !itype.isInstance(input)) {
            this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), input.getClass(), this.getInputType()});
            return this.returnError();
        }
        Object result = this.evaluate(input);
        return (Boolean)(result != null ? result : Boolean.valueOf(this.returnError()));
    }

    private boolean returnError() throws ClassCastException {
        Object ret = this.getReturnOnError();
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        throw new ClassCastException("Unable to cast return value to a boolean");
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input", input != null ? input[0] : null, 100);
    }

    @Nonnull
    public static <T> ScriptedPredicate<T> resourceScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initialize();
            ScriptedPredicate<T> scriptedPredicate = new ScriptedPredicate<T>(script, resource.getDescription());
            return scriptedPredicate;
        }
    }

    @Nonnull
    public static <T> ScriptedPredicate<T> resourceScript(@Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedPredicate.resourceScript("JavaScript", resource);
    }

    @Nonnull
    public static <T> ScriptedPredicate<T> inlineScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedPredicate<T>(script, "Inline");
    }

    @Nonnull
    public static <T> ScriptedPredicate<T> inlineScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName("JavaScript");
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedPredicate<T>(script, "Inline");
    }
}

