/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.value.IValueMap;

public final class WicketNamespaceHandler
extends AbstractMarkupFilter {
    private static final String WICKET_URI = "http://wicket.apache.org";
    private static final String XMLNS = "xmlns:";

    public WicketNamespaceHandler(MarkupResourceStream markup) {
        super(markup);
    }

    @Override
    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        String namespace;
        if (tag.isOpen() && "html".equals(tag.getName().toLowerCase(Locale.ROOT)) && (namespace = this.determineWicketNamespace(tag)) != null) {
            this.getMarkupResourceStream().setWicketNamespace(namespace);
        }
        return tag;
    }

    private String determineWicketNamespace(ComponentTag tag) {
        IValueMap attributes = tag.getAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            String xmlnsUrl;
            String attributeName = (String)entry.getKey();
            if (!attributeName.startsWith(XMLNS) || (xmlnsUrl = (String)entry.getValue()) != null && xmlnsUrl.trim().length() != 0 && !xmlnsUrl.startsWith(WICKET_URI)) continue;
            String namespace = attributeName.substring(XMLNS.length());
            if (Application.get().getMarkupSettings().getStripWicketTags()) {
                attributes.remove(attributeName);
                tag.setModified(true);
            }
            return namespace;
        }
        return null;
    }
}

