/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.bean.validation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.bean.validation.BeanValidationContext;
import org.apache.wicket.bean.validation.DefaultPropertyResolver;
import org.apache.wicket.bean.validation.DefaultValidatorProvider;
import org.apache.wicket.bean.validation.DefaultViolationTranslator;
import org.apache.wicket.bean.validation.IPropertyResolver;
import org.apache.wicket.bean.validation.ITagModifier;
import org.apache.wicket.bean.validation.IViolationTranslator;
import org.apache.wicket.bean.validation.Property;
import org.apache.wicket.bean.validation.SizeTagModifier;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.lang.Args;

public class BeanValidationConfiguration
implements BeanValidationContext {
    private static final MetaDataKey<BeanValidationConfiguration> KEY = new MetaDataKey<BeanValidationConfiguration>(){};
    static final List<Class<? extends Annotation>> REQUIRED_ANNOTATIONS;
    private Supplier<Validator> validatorProvider = new DefaultValidatorProvider();
    private IViolationTranslator violationTranslator = new DefaultViolationTranslator();
    private List<IPropertyResolver> propertyResolvers = new CopyOnWriteArrayList<IPropertyResolver>();
    private Map<Class<?>, ITagModifier<? extends Annotation>> tagModifiers = new ConcurrentHashMap();

    public BeanValidationConfiguration() {
        this.add(new DefaultPropertyResolver());
        this.register(Size.class, new SizeTagModifier());
    }

    public <T extends Annotation> BeanValidationConfiguration register(Class<T> annotationType, ITagModifier<T> modifier) {
        Args.notNull(annotationType, (String)"annotationType");
        Args.notNull(modifier, (String)"modifier");
        this.tagModifiers.put(annotationType, modifier);
        return this;
    }

    @Override
    public <T extends Annotation> ITagModifier<T> getTagModifier(Class<T> annotationType) {
        Args.notNull(annotationType, (String)"annotationType");
        return this.tagModifiers.get(annotationType);
    }

    public BeanValidationConfiguration add(IPropertyResolver resolver) {
        Args.notNull((Object)resolver, (String)"resolver");
        this.propertyResolvers.add(0, resolver);
        return this;
    }

    @Override
    public Validator getValidator() {
        return this.validatorProvider.get();
    }

    public void setValidatorProvider(Supplier<Validator> validatorProvider) {
        Args.notNull(validatorProvider, (String)"validatorProvider");
        this.validatorProvider = validatorProvider;
    }

    public void configure(Application application) {
        application.setMetaData(KEY, (Object)this);
    }

    @Override
    public IViolationTranslator getViolationTranslator() {
        return this.violationTranslator;
    }

    public void setViolationTranslator(IViolationTranslator violationTranslator) {
        Args.notNull((Object)violationTranslator, (String)"violationTranslator");
        this.violationTranslator = violationTranslator;
    }

    public static BeanValidationContext get() {
        BeanValidationConfiguration config = (BeanValidationConfiguration)Application.get().getMetaData(KEY);
        if (config == null) {
            throw new IllegalStateException("Application instance has not yet been configured for bean validation. See BeanValidationConfiguration#configure(Application)");
        }
        return config;
    }

    @Override
    public Property resolveProperty(FormComponent<?> component) {
        for (IPropertyResolver resolver : this.propertyResolvers) {
            Property property = resolver.resolveProperty(component);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    @Override
    public boolean isRequiredConstraint(ConstraintDescriptor<?> constraint) {
        return REQUIRED_ANNOTATIONS.contains(constraint.getAnnotation().annotationType());
    }

    static {
        ArrayList<Class<Annotation>> tmp = new ArrayList<Class<Annotation>>();
        tmp.add(NotNull.class);
        try {
            tmp.add(Class.forName("javax.validation.constraints.NotBlank").asSubclass(Annotation.class));
            tmp.add(Class.forName("javax.validation.constraints.NotEmpty").asSubclass(Annotation.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        REQUIRED_ANNOTATIONS = Collections.unmodifiableList(tmp);
    }
}

