/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.valueextraction;

import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.metadata.ValidateUnwrappedValue;
import jakarta.validation.valueextraction.UnwrapByDefault;
import jakarta.validation.valueextraction.ValueExtractor;
import jakarta.validation.valueextraction.ValueExtractorDeclarationException;
import jakarta.validation.valueextraction.ValueExtractorDefinitionException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.bval.util.reflection.TypeUtils;

public class ValueExtractors {
    public static final ValueExtractors EMPTY = new ValueExtractors(null, OnDuplicateContainerElementKey.EXCEPTION, Collections.emptyMap());
    public static final ValueExtractors DEFAULT;
    private final ValueExtractors parent;
    private final Map<ContainerElementKey, ValueExtractor<?>> valueExtractors = new ConcurrentHashMap();
    private final Map<ContainerElementKey, ValueExtractor<?>> searchCache = new ConcurrentHashMap();
    private final OnDuplicateContainerElementKey onDuplicateContainerElementKey;

    public static Class<?> getExtractedType(ValueExtractor<?> extractor, Type target) {
        ContainerElementKey key = ContainerElementKey.forValueExtractor(extractor);
        Type result = key.getAnnotatedType().getType();
        if (result instanceof WildcardType && key.getTypeArgumentIndex() != null) {
            result = TypeUtils.getTypeArguments(target, key.getContainerClass()).get(key.getContainerClass().getTypeParameters()[key.getTypeArgumentIndex()]);
        }
        Exceptions.raiseUnless(result instanceof Class, ValueExtractorDefinitionException::new, "%s did not resolve to a %s relative to %s", f -> f.args(key, Class.class.getName(), target));
        return (Class)result;
    }

    public static boolean isUnwrapByDefault(ValueExtractor<?> valueExtractor) {
        if (valueExtractor != null) {
            for (Class<?> t : Reflection.hierarchy(valueExtractor.getClass(), Reflection.Interfaces.INCLUDE)) {
                if (!t.isAnnotationPresent(UnwrapByDefault.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static Stream<String> split(String s) {
        return Stream.of(StringUtils.split(s, Character.valueOf(',')));
    }

    private static <T> T newInstance(Class<T> t) {
        try {
            return t.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }

    private static Stream<ValueExtractor<?>> loadValueExtractors(String containerClassName) {
        Class<?> containerClass;
        try {
            Class<BooleanSupplier> activation = Reflection.toClass(containerClassName + "$Activation").asSubclass(BooleanSupplier.class);
            if (!ValueExtractors.newInstance(activation).getAsBoolean()) {
                return Stream.empty();
            }
        }
        catch (ClassNotFoundException activation) {
            // empty catch block
        }
        try {
            containerClass = Reflection.toClass(containerClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return Stream.of(containerClass.getClasses()).filter(ValueExtractor.class::isAssignableFrom).map(c -> {
            Class<ValueExtractor> result = c.asSubclass(ValueExtractor.class);
            return result;
        }).map(ValueExtractors::newInstance);
    }

    private static <T> Optional<T> maximallySpecific(Collection<T> candidates, Function<? super T, Class<?>> toType) {
        Collection<T> result;
        if (candidates.size() > 1) {
            result = new HashSet<T>();
            for (T candidate : candidates) {
                Class<?> candidateType = toType.apply(candidate);
                if (!candidates.stream().filter(Predicate.isEqual(candidate).negate()).map(toType).allMatch(t -> t.isAssignableFrom(candidateType))) continue;
                result.add(candidate);
            }
        } else {
            result = candidates;
        }
        return result.size() == 1 ? Optional.of(result.iterator().next()) : Optional.empty();
    }

    public ValueExtractors() {
        this(OnDuplicateContainerElementKey.EXCEPTION);
    }

    public ValueExtractors(OnDuplicateContainerElementKey onDuplicateContainerElementKey) {
        this(DEFAULT, Validate.notNull(onDuplicateContainerElementKey));
    }

    private ValueExtractors(ValueExtractors parent, OnDuplicateContainerElementKey onDuplicateContainerElementKey) {
        this.parent = parent;
        this.onDuplicateContainerElementKey = onDuplicateContainerElementKey;
    }

    private ValueExtractors(ValueExtractors parent, OnDuplicateContainerElementKey onDuplicateContainerElementKey, Map<ContainerElementKey, ValueExtractor<?>> backingMap) {
        this(parent, onDuplicateContainerElementKey);
        this.valueExtractors.clear();
        this.valueExtractors.putAll(backingMap);
    }

    public ValueExtractors createChild() {
        return this.createChild(OnDuplicateContainerElementKey.EXCEPTION);
    }

    public ValueExtractors createChild(OnDuplicateContainerElementKey onDuplicateContainerElementKey) {
        return new ValueExtractors(this, onDuplicateContainerElementKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ValueExtractor<?> extractor) {
        ContainerElementKey key = ContainerElementKey.forValueExtractor(extractor);
        if (key == null) {
            Exceptions.raise(IllegalStateException::new, "Computed null %s for %s", ContainerElementKey.class.getSimpleName(), extractor);
        }
        Map<ContainerElementKey, ValueExtractor<?>> m = this.valueExtractors;
        if (this.onDuplicateContainerElementKey == OnDuplicateContainerElementKey.EXCEPTION) {
            ValueExtractors valueExtractors = this;
            synchronized (valueExtractors) {
                if (m.containsKey(key)) {
                    Exceptions.raise(ValueExtractorDeclarationException::new, "Multiple context-level %ss specified for %s", ValueExtractor.class.getSimpleName(), key);
                }
                m.put(key, extractor);
            }
        } else {
            m.put(key, extractor);
        }
        this.searchCache.clear();
    }

    public Map<ContainerElementKey, ValueExtractor<?>> getValueExtractors() {
        HashMap result = new HashMap();
        this.populate(result);
        return result;
    }

    public ValueExtractor<?> find(ContainerElementKey key) {
        ValueExtractor<?> cacheHit = this.searchCache.get(key);
        if (cacheHit != null) {
            return cacheHit;
        }
        Map<ContainerElementKey, ValueExtractor<?>> allValueExtractors = this.getValueExtractors();
        if (allValueExtractors.containsKey(key)) {
            return allValueExtractors.get(key);
        }
        Map candidates = Stream.concat(Stream.of(key), key.getAssignableKeys().stream()).filter(allValueExtractors::containsKey).collect(Collectors.toMap(allValueExtractors::get, Function.identity(), (quid, quo) -> quo, LinkedHashMap::new));
        Optional<ValueExtractor> result = ValueExtractors.maximallySpecific(candidates.keySet(), ve -> ((ContainerElementKey)candidates.get(ve)).getContainerClass());
        if (result.isPresent()) {
            this.searchCache.put(key, result.get());
            return result.get();
        }
        throw Exceptions.create(ConstraintDeclarationException::new, "Could not determine %s for %s", ValueExtractor.class.getSimpleName(), key);
    }

    public Optional<UnwrappingInfo> findUnwrappingInfo(Class<?> containerClass, ValidateUnwrappedValue valueUnwrapping) {
        if (valueUnwrapping == ValidateUnwrappedValue.SKIP) {
            return Optional.empty();
        }
        Map<ContainerElementKey, ValueExtractor<?>> allValueExtractors = this.getValueExtractors();
        Set unwrapping = allValueExtractors.entrySet().stream().filter(e -> ((ContainerElementKey)e.getKey()).getContainerClass().isAssignableFrom(containerClass)).filter(e -> valueUnwrapping == ValidateUnwrappedValue.UNWRAP || ValueExtractors.isUnwrapByDefault((ValueExtractor)e.getValue())).map(e -> new UnwrappingInfo((ContainerElementKey)e.getKey(), (ValueExtractor)e.getValue())).collect(Collectors.toSet());
        Optional<UnwrappingInfo> result = ValueExtractors.maximallySpecific(unwrapping, u -> u.containerElementKey.getContainerClass()).map(u -> u.inTermsOf(containerClass));
        if (!result.isPresent() && valueUnwrapping == ValidateUnwrappedValue.UNWRAP) {
            Exceptions.raise(ConstraintDeclarationException::new, "Could not determine %s for %s", ValueExtractor.class.getSimpleName(), containerClass);
        }
        return result;
    }

    private void populate(Map<ContainerElementKey, ValueExtractor<?>> target) {
        if (this.parent != null) {
            this.parent.populate(target);
        }
        target.putAll(this.valueExtractors);
    }

    static {
        Properties defaultExtractors = new Properties();
        try {
            defaultExtractors.load(ValueExtractors.class.getResourceAsStream("DefaultExtractors.properties"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        TreeMap m = new TreeMap();
        Consumer<ValueExtractor> put = ve -> m.put(ContainerElementKey.forValueExtractor(ve), ve);
        ValueExtractors.split(defaultExtractors.getProperty(ValueExtractor.class.getName())).map(cn -> {
            try {
                Class<ValueExtractor> result = Reflection.toClass(cn).asSubclass(ValueExtractor.class);
                return result;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }).map(ValueExtractors::newInstance).forEach(put);
        ValueExtractors.split(defaultExtractors.getProperty(ValueExtractor.class.getName() + ".container")).flatMap(ValueExtractors::loadValueExtractors).forEach(put);
        DEFAULT = new ValueExtractors(null, OnDuplicateContainerElementKey.EXCEPTION, Collections.unmodifiableMap(m));
    }

    public static class UnwrappingInfo {
        public final ContainerElementKey containerElementKey;
        public final ValueExtractor<?> valueExtractor;

        private UnwrappingInfo(ContainerElementKey containerElementKey, ValueExtractor<?> valueExtractor) {
            this.containerElementKey = containerElementKey;
            this.valueExtractor = valueExtractor;
        }

        UnwrappingInfo inTermsOf(Class<?> containerClass) {
            ContainerElementKey key;
            Class<?> keyContainer = this.containerElementKey.getContainerClass();
            if (keyContainer.equals(containerClass)) {
                return this;
            }
            Validate.validState(keyContainer.isAssignableFrom(containerClass), "Cannot render %s in terms of %s", this.containerElementKey, containerClass);
            if (this.containerElementKey.getTypeArgumentIndex() == null) {
                key = new ContainerElementKey(containerClass, null);
            } else {
                Integer typeArgumentIndex = null;
                Map<TypeVariable<?>, Type> typeArguments = TypeUtils.getTypeArguments(containerClass, keyContainer);
                Type t = typeArguments.get(keyContainer.getTypeParameters()[this.containerElementKey.getTypeArgumentIndex()]);
                while (t instanceof TypeVariable) {
                    TypeVariable var = (TypeVariable)t;
                    if (containerClass.equals(var.getGenericDeclaration())) {
                        typeArgumentIndex = ObjectUtils.indexOf(containerClass.getTypeParameters(), var);
                        break;
                    }
                    t = typeArguments.get(t);
                }
                key = new ContainerElementKey(containerClass, typeArgumentIndex);
            }
            return new UnwrappingInfo(key, this.valueExtractor);
        }

        public String toString() {
            return String.format("%s:%s", this.containerElementKey, this.valueExtractor);
        }
    }

    public static enum OnDuplicateContainerElementKey {
        EXCEPTION,
        OVERWRITE;

    }
}

