/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import jakarta.batch.api.chunk.listener.SkipProcessListener;
import jakarta.batch.api.chunk.listener.SkipReadListener;
import jakarta.batch.api.chunk.listener.SkipWriteListener;
import java.util.List;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.controller.chunk.ExceptionConfig;
import org.apache.batchee.jaxb.Chunk;
import org.apache.batchee.jaxb.ExceptionClassFilter;

public class SkipHandler {
    private List<SkipProcessListener> _skipProcessListener = null;
    private List<SkipReadListener> _skipReadListener = null;
    private List<SkipWriteListener> _skipWriteListener = null;
    private final ExceptionConfig config = new ExceptionConfig();
    private int _skipLimit = Integer.MIN_VALUE;
    private long _skipCount = 0L;

    public SkipHandler(Chunk chunk) {
        try {
            if (chunk.getSkipLimit() != null) {
                this._skipLimit = Integer.parseInt(chunk.getSkipLimit());
                if (this._skipLimit < 0) {
                    throw new IllegalArgumentException("The skip-limit attribute on a chunk cannot be a negative value");
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("NumberFormatException reading skip-limit", nfe);
        }
        if (chunk.getSkippableExceptionClasses() != null && chunk.getSkippableExceptionClasses().getIncludeList() != null) {
            List<ExceptionClassFilter.Include> includes = chunk.getSkippableExceptionClasses().getIncludeList();
            for (ExceptionClassFilter.Include include : includes) {
                this.config.getIncludes().add(include.getClazz().trim());
            }
        }
        if (chunk.getSkippableExceptionClasses() != null && chunk.getSkippableExceptionClasses().getExcludeList() != null) {
            List<ExceptionClassFilter.Exclude> excludes = chunk.getSkippableExceptionClasses().getExcludeList();
            for (ExceptionClassFilter.Exclude exclude : excludes) {
                this.config.getExcludes().add(exclude.getClazz().trim());
            }
        }
    }

    public void addSkipReadListener(List<SkipReadListener> skipReadListener) {
        this._skipReadListener = skipReadListener;
    }

    public void addSkipWriteListener(List<SkipWriteListener> skipWriteListener) {
        this._skipWriteListener = skipWriteListener;
    }

    public void addSkipProcessListener(List<SkipProcessListener> skipProcessListener) {
        this._skipProcessListener = skipProcessListener;
    }

    public void handleExceptionRead(Exception e) {
        if (this.isSkipLimitReached() || !this.isSkippable(e)) {
            throw new BatchContainerRuntimeException(e);
        }
        ++this._skipCount;
        if (this._skipReadListener != null) {
            for (SkipReadListener skipReadListenerProxy : this._skipReadListener) {
                try {
                    skipReadListenerProxy.onSkipReadItem(e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
        }
    }

    public void handleExceptionWithRecordProcess(Exception e, Object w) {
        if (this.isSkipLimitReached() || !this.isSkippable(e)) {
            throw new BatchContainerRuntimeException(e);
        }
        ++this._skipCount;
        if (this._skipProcessListener != null) {
            for (SkipProcessListener skipProcessListenerProxy : this._skipProcessListener) {
                try {
                    skipProcessListenerProxy.onSkipProcessItem(w, e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
        }
    }

    public void handleExceptionWithRecordListWrite(Exception e, List<Object> items) {
        if (this.isSkipLimitReached() || !this.isSkippable(e)) {
            throw new BatchContainerRuntimeException(e);
        }
        ++this._skipCount;
        if (this._skipWriteListener != null) {
            for (SkipWriteListener skipWriteListenerProxy : this._skipWriteListener) {
                try {
                    skipWriteListenerProxy.onSkipWriteItem(items, e);
                }
                catch (Exception e1) {
                    ExceptionConfig.wrapBatchException(e1);
                }
            }
        }
    }

    private boolean isSkippable(Exception e) {
        return this.config.accept(e);
    }

    private boolean isSkipLimitReached() {
        return this._skipLimit != Integer.MIN_VALUE && this._skipCount >= (long)this._skipLimit;
    }

    public String toString() {
        return "SkipHandler{" + super.toString() + "}count:limit=" + this._skipCount + ":" + this._skipLimit;
    }
}

