/*
* Licensed to the Apache Software Foundation (ASF) under one
* or more contributor license agreements.  See the NOTICE file
* distributed with this work for additional information
* regarding copyright ownership.  The ASF licenses this file
* to you under the Apache License, Version 2.0 (the
* "License"); you may not use this file except in compliance
* with the License.  You may obtain a copy of the License at
* 
* http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing,
* software distributed under the License is distributed on an
* "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
* KIND, either express or implied.  See the License for the
* specific language governing permissions and limitations
* under the License.
*/



//********************************************************************************
//* Do NOT edit this file directly - generated by build/generate.groovy
//********************************************************************************


const uuid = require('uuid');
const graphTraversalModule = require('../../lib/process/graph-traversal');
const traversalModule = require('../../lib/process/traversal');
const { TraversalStrategies, VertexProgramStrategy, OptionsStrategy, PartitionStrategy, 
        ReadOnlyStrategy, GraphFilterStrategy, SeedStrategy, SubgraphStrategy, ProductiveByStrategy, 
        LambdaRestrictionStrategy, StandardVerificationStrategy, VertexProgramRestrictionStrategy, 
        ComputerVerificationStrategy, MessagePassingReductionStrategy, ProfileStrategy, InlineFilterStrategy, 
        ComputerFinalizationStrategy, ReferenceElementStrategy, ElementIdStrategy, MatchAlgorithmStrategy, 
        EdgeLabelVerificationStrategy, CountStrategy, ConnectiveStrategy, ByModulatorOptimizationStrategy, 
        AdjacentToIncidentStrategy, ReservedKeysVerificationStrategy, RepeatUnrollStrategy, 
        PathRetractionStrategy, PathProcessorStrategy, OrderLimitStrategy, MatchPredicateStrategy, 
        LazyBarrierStrategy, EarlyLimitStrategy, IncidentToAdjacentStrategy, IdentityRemovalStrategy, 
        HaltedTraverserStrategy, FilterRankingStrategy } = require('../../lib/process/traversal-strategy');
const __ = graphTraversalModule.statics;
const Barrier = traversalModule.barrier
const Cardinality = traversalModule.cardinality
const CardinalityValue = graphTraversalModule.CardinalityValue;
const Column = traversalModule.column
const Direction = {
    BOTH: traversalModule.direction.both,
    IN: traversalModule.direction.in,
    OUT: traversalModule.direction.out,
    from_: traversalModule.direction.out,
    to: traversalModule.direction.in
};
const IO = traversalModule.IO;
const DT = traversalModule.dt;
const GType = traversalModule.gType;
const Merge = traversalModule.merge;
const P = traversalModule.P;
const Pick = traversalModule.pick
const Pop = traversalModule.pop
const Order = traversalModule.order
const Operator = traversalModule.operator
const Scope = traversalModule.scope
const T = traversalModule.t
const TextP = traversalModule.TextP
const WithOptions = traversalModule.withOptions

const gremlins = {
    g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX: [function({g, xx1, xx2}) { return g.V().branch(__.label().is("person").count()).option(xx1, __.values("age")).option(xx2, __.values("lang")).option(xx2, __.values("name")) }], 
    g_V_branchXlabel_isXpersonX_countX_optionX1__ageX_optionX0__langX_optionX0__nameX_optionXany__labelX: [function({g, xx1, xx2}) { return g.V().branch(__.label().is("person").count()).option(xx1, __.values("age")).option(xx2, __.values("lang")).option(xx2, __.values("name")).option(Pick.any, __.label()) }], 
    g_V_branchXageX_optionXltX30X__youngX_optionXgtX30X__oldX_optionXnone__on_the_edgeX: [function({g}) { return g.V().hasLabel("person").branch(__.values("age")).option(P.lt(30), __.constant("young")).option(P.gt(30), __.constant("old")).option(Pick.none, __.constant("on the edge")) }], 
    g_V_branchXidentityX_optionXhasLabelXsoftwareX__inXcreatedX_name_order_foldX_optionXhasXname_vadasX__ageX_optionXneqX123X__bothE_countX: [function({g}) { return g.V().branch(__.identity()).option(__.hasLabel("software"), __.in_("created").values("name").order().fold()).option(__.has("name", "vadas"), __.values("age")).option(P.neq(123), __.bothE().count()) }], 
    g_V_chooseXout_countX_optionX2L_nameX_optionX3L_ageX: [function({g, xx1, xx2}) { return g.V().choose(__.out().count()).option(xx1, __.values("name")).option(xx2, __.values("age")) }], 
    g_V_chooseXout_countX_optionX2L_nameX_optionX3L_ageX_optionXnone_discardX: [function({g, xx1, xx2}) { return g.V().choose(__.out().count()).option(xx1, __.values("name")).option(xx2, __.values("age")).option(Pick.none, __.discard()) }], 
    g_V_chooseXhasLabelXpersonX_and_outXcreatedX__outXknowsX_identityX_name: [function({g}) { return g.V().choose(__.hasLabel("person").and().out("created"), __.out("knows"), __.identity()).values("name") }], 
    g_V_chooseXhasLabelXpersonX_and_outXcreatedX_outXknowsX_name: [function({g}) { return g.V().choose(__.hasLabel("person").and().out("created"), __.out("knows")).values("name") }], 
    g_V_chooseXlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone__identityX_name: [function({g}) { return g.V().choose(__.label()).option("blah", __.out("knows")).option("bleep", __.out("created")).option(Pick.none, __.identity()).values("name") }], 
    g_V_chooseXTlabelX_optionXperson__outXknowsX_nameX_optionXbleep_constantXbleepXX: [function({g}) { return g.V().choose(T.label).option("person", __.out("knows").values("name")).option("bleep", __.constant("bleep")) }], 
    g_V_chooseXTlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone__identityX_name: [function({g}) { return g.V().choose(T.label).option("blah", __.out("knows")).option("bleep", __.out("created")).option(Pick.none, __.identity()).values("name") }], 
    g_V_chooseXTlabelX_optionXblah__outXknowsXX_optionXbleep__outXcreatedXX_optionXnone_discardX_name: [function({g}) { return g.V().choose(T.label).option("blah", __.out("knows")).option("bleep", __.out("created")).option(Pick.none, __.discard()).values("name") }], 
    g_V_chooseXoutXknowsX_count_isXgtX0XX__outXknowsXX_name: [function({g}) { return g.V().choose(__.out("knows").count().is(P.gt(0)), __.out("knows")).values("name") }], 
    g_V_hasLabelXpersonX_asXp1X_chooseXoutEXknowsX__outXknowsXX_asXp2X_selectXp1_p2X_byXnameX: [function({g}) { return g.V().hasLabel("person").as("p1").choose(__.outE("knows"), __.out("knows")).as("p2").select("p1", "p2").by("name") }], 
    g_V_hasLabelXpersonX_chooseXageX__optionX27L__constantXyoungXX_optionXnone__constantXoldXX_groupCount: [function({g, xx1}) { return g.V().hasLabel("person").choose(__.values("age")).option(xx1, __.constant("young")).option(Pick.none, __.constant("old")).groupCount() }], 
    g_injectX1X_chooseXisX1X__constantX10Xfold__foldX: [function({g, xx1}) { return g.inject(1).choose(__.is(xx1), __.constant(10).fold(), __.fold()) }], 
    g_injectX2X_chooseXisX1X__constantX10Xfold__foldX: [function({g, xx1}) { return g.inject(2).choose(__.is(xx1), __.constant(10).fold(), __.fold()) }], 
    g_V_chooseXhasLabelXpersonX_chooseXageX_optionXbetweenX26_30X_constantXxXX_optionXbetweenX20_30X_constantXyXX_optionXnone_constantXzXX: [function({g}) { return g.V().hasLabel("person").choose(__.values("age")).option(P.between(26, 30), __.constant("x")).option(P.between(20, 30), __.constant("y")).option(Pick.none, __.constant("z")) }], 
    g_V_chooseXhasLabelXpersonX_chooseXageX_optionXbetweenX26_30X_orXgtX34XX_constantXxXX_optionXgtX34X_constantXyXX_optionXnone_constantXzXX: [function({g}) { return g.V().hasLabel("person").choose(__.values("age")).option(P.between(26, 30).or(P.gt(34)), __.constant("x")).option(P.gt(34), __.constant("y")).option(Pick.none, __.constant("z")) }], 
    g_V_hasLabelXpersonX_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX: [function({g}) { return g.V().hasLabel("person").choose(__.values("age")).option(P.between(26, 30), __.values("name")).option(Pick.none, __.values("name")) }], 
    g_V_chooseXhasLabelXpersonX_localXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX: [function({g}) { return g.V().hasLabel("person").local(__.choose(__.values("age")).option(P.between(26, 30), __.values("name").fold()).option(Pick.none, __.values("name").fold())) }], 
    g_V_chooseXhasLabelXpersonX_mapXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX: [function({g}) { return g.V().hasLabel("person").map(__.choose(__.values("age")).option(P.between(26, 30), __.values("name").fold()).option(Pick.none, __.values("name").fold())) }], 
    g_unionXV_VXhasLabelXpersonX_barrier_localXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX: [function({g}) { return g.union(__.V(), __.V()).hasLabel("person").barrier().local(__.choose(__.values("age")).option(P.between(26, 30), __.values("name").fold()).option(Pick.none, __.values("name").fold())) }], 
    g_unionXV_VXhasLabelXpersonX_barrier_mapXchooseXageX_optionXbetweenX26_30X_name_foldX_optionXnone_name_foldXX: [function({g}) { return g.union(__.V(), __.V()).hasLabel("person").barrier().map(__.choose(__.values("age")).option(P.between(26, 30), __.values("name").fold()).option(Pick.none, __.values("name").fold())) }], 
    g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX: [function({g}) { return g.V().choose(__.values("age")).option(P.between(26, 30), __.values("name")).option(Pick.none, __.values("name")) }], 
    g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX_optionXunproductive_labelX: [function({g}) { return g.V().choose(__.values("age")).option(P.between(26, 30), __.values("name")).option(Pick.none, __.values("name")).option(Pick.unproductive, __.label()) }], 
    g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_nameX_optionXnone_identityX_optionXnone_failX_optionXunproductive_identityX_optionXunproductive_labelX_optionXnone_failX: [function({g}) { return g.V().choose(__.values("age")).option(P.between(26, 30), __.values("name")).option(Pick.none, __.values("name")).option(Pick.none, __.identity()).option(Pick.none, __.fail()).option(Pick.unproductive, __.label()).option(Pick.unproductive, __.identity()).option(Pick.unproductive, __.fail()) }], 
    g_V_chooseXage_nameX: [function({g}) { return g.V().choose(__.values("age"), __.values("name")) }], 
    g_V_chooseXageX_optionXbetweenX26_30X_nameX_optionXnone_discardX: [function({g}) { return g.V().choose(__.values("age")).option(P.between(26, 30), __.values("name")).option(Pick.none, __.discard()) }], 
    g_V_chooseXnameX_optionXneqXyX_ageX_optionXnone_constantXxXX: [function({g}) { return g.V().choose(__.values("name")).option(P.neq("y"), __.values("age")).option(Pick.none, __.constant("x")) }], 
    g_V_hasLabelXpersonX_chooseXoutXcreatedX_count_isXeqX0XX__constantXdidnt_createX__constantXcreatedXX: [function({g}) { return g.V().hasLabel("person").choose(__.out("created").count().is(P.eq(0)), __.constant("didnt_create"), __.constant("created")) }], 
    g_V_hasLabelXpersonX_chooseXvaluesXageX_isXgtX30XX__valuesXageX__constantX30XX: [function({g}) { return g.V().hasLabel("person").choose(__.values("age").is(P.gt(30)), __.values("age"), __.constant(30)) }], 
    g_V_hasLabelXpersonX_chooseXvaluesXageX_isXgtX29XX_and_valuesXageX_isXltX35XX__valuesXnameX__constantXotherXX: [function({g}) { return g.V().hasLabel("person").choose(__.values("age").is(P.gt(29)).and().values("age").is(P.lt(35)), __.values("name"), __.constant("other")) }], 
    g_V_chooseXhasXname_vadasX__valuesXnameX__valuesXageXX: [function({g}) { return g.V().choose(__.has("name", "vadas"), __.values("name"), __.values("age")) }], 
    g_V_hasLabelXpersonX_chooseXoutXcreatedX_countX_optionX0__constantXnoneXX_optionX1__constantXoneXX_optionX2__constantXmanyXX: [function({g, xx1, xx0, xx2}) { return g.V().hasLabel("person").choose(__.out("created").count()).option(xx0, __.constant("none")).option(xx1, __.constant("one")).option(xx2, __.constant("many")) }], 
    g_V_hasLabelXpersonX_chooseXlocalXoutXknowsX_countX__optionX0__constantXnoFriendsXX__optionXnone__constantXhasFriendsXXX: [function({g, xx0}) { return g.V().hasLabel("person").choose(__.local(__.out("knows").count())).option(xx0, __.constant("noFriends")).option(Pick.none, __.constant("hasFriends")) }], 
    g_V_chooseXoutE_countX_optionX0__constantXnoneXX_optionXnone__constantXsomeXX: [function({g, xx0}) { return g.V().choose(__.outE().count()).option(xx0, __.constant("none")).option(Pick.none, __.constant("some")) }], 
    g_V_chooseXlabelX_optionXperson__chooseXageX_optionXP_lt_30__constantXyoungXX_optionXP_gte_30__constantXoldXXX_optionXsoftware__constantXprogramXX_optionXnone__constantXunknownXX: [function({g}) { return g.V().choose(__.label()).option("person", __.choose(__.values("age")).option(P.lt(30), __.constant("young")).option(P.gte(30), __.constant("old"))).option("software", __.constant("program")).option(Pick.none, __.constant("unknown")) }], 
    g_V_chooseXhasXname_vadasX__valuesXnameXX: [function({g}) { return g.V().choose(__.has("name", "vadas"), __.values("name")) }], 
    g_V_hasLabelXpersonX_age_chooseXP_eqX29X_constantXmatchedX_constantXotherXX: [function({g}) { return g.V().hasLabel("person").values("age").choose(P.eq(29), __.constant("matched"), __.constant("other")) }], 
    g_V_hasLabelXpersonX_age_chooseXP_eqX29X_constantXmatchedX: [function({g}) { return g.V().hasLabel("person").values("age").choose(P.eq(29), __.constant("matched")) }], 
    g_V_hasLabelXpersonX_chooseX_valuesXnameX_option1X_isXmarkoX_valuesXageXX_option2Xnone_valuesXnameXX: [function({g}) { return g.V().hasLabel("person").choose(__.values("name")).option(__.is("marko"), __.values("age")).option(Pick.none, __.values("name")) }], 
    g_V_hasLabelXpersonX_chooseX_valuesXnameX_option1X_PeqXmarkoX_valuesXageXX_option2Xnone_valuesXnameXX: [function({g}) { return g.V().hasLabel("person").choose(__.values("name")).option(P.eq("marko"), __.values("age")).option(Pick.none, __.values("name")) }], 
    g_V_localXpropertiesXlocationX_order_byXvalueX_limitX2XX_value: [function({g}) { return g.V().local(__.properties("location").order().by(T.value, Order.asc).range(0, 2)).value() }], 
    g_V_hasXlabel_personX_asXaX_localXoutXcreatedX_asXbXX_selectXa_bX_byXnameX_byXidX: [function({g}) { return g.V().has(T.label, "person").as("a").local(__.out("created").as("b")).select("a", "b").by("name").by(T.id) }], 
    g_V_localXoutE_countX: [function({g}) { return g.V().local(__.outE().count()) }], 
    g_VX1X_localXoutEXknowsX_limitX1XX_inV_name: [function({g, vid1}) { return g.V(vid1).local(__.outE("knows").limit(1)).inV().values("name") }], 
    g_V_localXbothEXcreatedX_limitX1XX_otherV_name: [function({g}) { return g.V().local(__.bothE("created").limit(1)).otherV().values("name") }], 
    g_VX4X_localXbothEX1_createdX_limitX1XX: [function({g, vid4}) { return g.V(vid4).local(__.bothE("created").limit(1)) }], 
    g_VX4X_localXbothEXknows_createdX_limitX1XX: [function({g, vid4}) { return g.V(vid4).local(__.bothE("knows", "created").limit(1)) }], 
    g_VX4X_localXbothE_limitX1XX_otherV_name: [function({g, vid4}) { return g.V(vid4).local(__.bothE().limit(1)).otherV().values("name") }], 
    g_VX4X_localXbothE_limitX2XX_otherV_name: [function({g, vid4}) { return g.V(vid4).local(__.bothE().limit(2)).otherV().values("name") }], 
    g_V_localXinEXknowsX_limitX2XX_outV_name: [function({g}) { return g.V().local(__.inE("knows").limit(2)).outV().values("name") }], 
    g_V_localXmatchXproject__created_person__person_name_nameX_selectXname_projectX_by_byXnameX: [function({g}) { return g.V().local(__.match(__.as("project").in_("created").as("person"), __.as("person").values("name").as("name"))).select("name", "project").by().by("name") }], 
    g_V_in_barrier_localXcountX: [function({g}) { return g.V().in_().barrier().local(__.count()) }], 
    g_V_localXout_in_simplePathX_path: [function({g}) { return g.V().local(__.out().in_().simplePath()).path() }], 
    g_withSackX0LX_V_in_barrier_localXsackXsumX_byXageXX_sack: [function({g}) { return g.withSack(0).V().in_().barrier().local(__.sack(Operator.sum).by("age")).sack() }], 
    g_V_localXout_localXcountXX: [function({g}) { return g.V().local(__.out().local(__.count())) }], 
    g_V_unionXoutE_count_localXinE_countXX: [function({g}) { return g.V().union(__.outE().count(), __.local(__.inE().count())) }], 
    g_VX2X_optionalXoutXknowsXX: [function({g, vid2}) { return g.V(vid2).optional(__.out("knows")) }], 
    g_VX2X_optionalXinXknowsXX: [function({g, vid2}) { return g.V(vid2).optional(__.in_("knows")) }], 
    g_V_hasLabelXpersonX_optionalXoutXknowsX_optionalXoutXcreatedXXX_path: [function({g}) { return g.V().hasLabel("person").optional(__.out("knows").optional(__.out("created"))).path() }], 
    g_V_optionalXout_optionalXoutXX_path: [function({g}) { return g.V().optional(__.out().optional(__.out())).path() }], 
    g_VX1X_optionalXaddVXdogXX_label: [function({g, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1}) { return g.V(vid1).optional(__.addV("dog")).label() }, function({g, vid1}) { return g.V() }], 
    g_V_repeatXoutX_timesX2X_emit_path: [function({g}) { return g.V().repeat(__.out()).times(2).emit().path() }], 
    g_V_repeatXoutX_timesX2X_repeatXinX_timesX2X_name: [function({g}) { return g.V().repeat(__.out()).times(2).repeat(__.in_()).times(2).values("name") }], 
    g_V_repeatXoutE_inVX_timesX2X_path_by_name_by_label: [function({g}) { return g.V().repeat(__.outE().inV()).times(2).path().by("name").by(T.label) }], 
    g_V_repeatXoutX_timesX2X: [function({g}) { return g.V().repeat(__.out()).times(2) }], 
    g_V_repeatXoutX_timesX2X_emit: [function({g}) { return g.V().repeat(__.out()).times(2).emit() }], 
    g_VX1X_timesX2X_repeatXoutX_name: [function({g, vid1}) { return g.V(vid1).times(2).repeat(__.out()).values("name") }], 
    g_V_emit_timesX2X_repeatXoutX_path: [function({g}) { return g.V().emit().times(2).repeat(__.out()).path() }], 
    g_V_emit_repeatXoutX_timesX2X_path: [function({g}) { return g.V().emit().repeat(__.out()).times(2).path() }], 
    g_VX1X_emitXhasXlabel_personXX_repeatXoutX_name: [function({g, vid1}) { return g.V(vid1).emit(__.has(T.label, "person")).repeat(__.out()).values("name") }], 
    g_V_repeatXgroupCountXmX_byXnameX_outX_timesX2X_capXmX: [function({g}) { return g.V().repeat(__.groupCount("m").by("name").out()).times(2).cap("m") }], 
    g_VX1X_repeatXgroupCountXmX_byXloopsX_outX_timesX3X_capXmX: [function({g, vid1}) { return g.V(vid1).repeat(__.groupCount("m").by(__.loops()).out()).times(3).cap("m") }], 
    g_V_repeatXbothX_timesX10X_asXaX_out_asXbX_selectXa_bX: [function({g}) { return g.V().repeat(__.both()).times(10).as("a").out().as("b").select("a", "b").count() }], 
    g_VX1X_repeatXoutX_untilXoutE_count_isX0XX_name: [function({g, vid1}) { return g.V(vid1).repeat(__.out()).until(__.outE().count().is(0)).values("name") }], 
    g_V_hasXname_markoX_repeatXoutE_inV_simplePathX_untilXhasXname_rippleXX_path_byXnameX_byXlabelX: [function({g}) { return g.V().has("name", "marko").repeat(__.outE().inV().simplePath()).until(__.has("name", "ripple")).path().by("name").by(T.label) }], 
    g_V_hasXloop_name_loopX_repeatXinX_timesX5X_path_by_name: [function({g}) { return g.V().has("loops", "name", "loop").repeat(__.in_()).times(5).path().by("name") }], 
    g_V_repeatXout_repeatXout_order_byXname_descXX_timesX1XX_timesX1X_limitX1X_path_byXnameX: [function({g}) { return g.V().repeat(__.out().repeat(__.out().order().by("name", Order.desc)).times(1)).times(1).limit(1).path().by("name") }], 
    g_V_repeatXoutXknowsXX_untilXrepeatXoutXcreatedXX_emitXhasXname_lopXXX_path_byXnameX: [function({g}) { return g.V().repeat(__.out("knows")).until(__.repeat(__.out("created")).emit(__.has("name", "lop"))).path().by("name") }], 
    g_V_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang: [function({g}) { return g.V().repeat(__.repeat(__.out("created")).until(__.has("name", "ripple"))).emit().values("lang") }], 
    g_V_untilXconstantXtrueXX_repeatXrepeatXout_createdXX_untilXhasXname_rippleXXXemit_lang: [function({g}) { return g.V().until(__.constant(true)).repeat(__.repeat(__.out("created")).until(__.has("name", "ripple"))).emit().values("lang") }], 
    g_V_emit_repeatXa_outXknows_filterXloops_isX0XX_lang: [function({g}) { return g.V().emit().repeat("a", __.out("knows").filter(__.loops("a").is(0))).values("lang") }], 
    g_VX3X_repeatXbothX_createdXX_untilXloops_is_40XXemit_repeatXin_knowsXX_emit_loopsXisX1Xdedup_values: [function({g, vid3}) { return g.V(vid3).repeat(__.both("created")).until(__.loops().is(40)).emit(__.repeat(__.in_("knows")).emit(__.loops().is(1))).dedup().values("name") }], 
    g_VX1X_repeatXrepeatXunionXout_uses_out_traversesXX_whereXloops_isX0X_timesX1X_timeX2X_name: [function({g, vid1}) { return g.V(vid1).repeat(__.repeat(__.union(__.out("uses"), __.out("traverses")).where(__.loops().is(0))).times(1)).times(2).values("name") }], 
    g_V_repeatXa_outXknows_repeatXb_outXcreatedX_filterXloops_isX0XX_emit_lang: [function({g}) { return g.V().repeat("a", __.out("knows").repeat("b", __.out("created").filter(__.loops("a").is(0))).emit()).emit().values("lang") }], 
    g_VX6X_repeatXa_bothXcreatedX_simplePathX_emitXrepeatXb_bothXknowsXX_untilXloopsXbX_asXb_whereXloopsXaX_asXbX_hasXname_vadasXX_dedup_name: [function({g, vid6}) { return g.V(vid6).repeat("a", __.both("created").simplePath()).emit(__.repeat("b", __.both("knows")).until(__.loops("b").as("b").where(__.loops("a").as("b"))).has("name", "vadas")).dedup().values("name") }], 
    g_V_emit: [function({g}) { return g.V().emit() }], 
    g_V_untilXidentityX: [function({g}) { return g.V().until(__.identity()) }], 
    g_V_timesX5X: [function({g}) { return g.V().times(5) }], 
    g_V_hasXperson_name_markoX_repeatXoutXcreatedXX_timesX1X_name: [function({g}) { return g.V().has("person", "name", "marko").repeat(__.out("created")).times(1).values("name") }], 
    g_V_hasXperson_name_markoX_repeatXoutXcreatedXX_timesX0X_name: [function({g}) { return g.V().has("person", "name", "marko").repeat(__.out("created")).times(0).values("name") }], 
    g_V_hasXperson_name_markoX_timesX1X_repeatXoutXcreatedXX_name: [function({g}) { return g.V().has("person", "name", "marko").times(1).repeat(__.out("created")).values("name") }], 
    g_V_hasXperson_name_markoX_timesX0X_repeatXoutXcreatedXX_name: [function({g}) { return g.V().has("person", "name", "marko").times(0).repeat(__.out("created")).values("name") }], 
    g_V_repeatXboth_hasXnot_productiveXX_timesX3X_constantX1X: [function({g}) { return g.V().repeat(__.both().has("not", "productive")).times(3).constant(1) }], 
    g_V_hasXnot_productiveX_repeatXbothX_timesX3X_constantX1X: [function({g}) { return g.V().has("not", "productive").repeat(__.both()).times(3).constant(1) }], 
    g_VX1_2_3X_repeatXboth_barrierX_emit_timesX2X_path: [function({g, vid3, vid2, vid1}) { return g.V(vid1, vid2, vid3).repeat(__.both().barrier()).emit().times(2).path() }], 
    g_V_order_byXname_descX_repeatXboth_simplePath_order_byXname_descXX_timesX2X_path: [function({g}) { return g.V().order().by("name", Order.desc).repeat(__.both().simplePath().order().by("name", Order.desc)).times(2).path() }], 
    g_V_repeatXboth_repeatXorder_byXnameXX_timesX1XX_timesX1X: [function({g}) { return g.V().repeat(__.both().repeat(__.order().by("name")).times(1)).times(1) }], 
    g_V_order_byXname_descX_repeatXlocalXout_order_byXnameXXX_timesX1X: [function({g}) { return g.V().order().by("name", Order.desc).repeat(__.local(__.out().order().by("name"))).times(1) }], 
    g_V_order_byXnameX_repeatXlocalXboth_simplePath_order_byXnameXXX_timesX2X_path: [function({g}) { return g.V().order().by("name").repeat(__.local(__.both().simplePath().order().by("name"))).times(2).path() }], 
    g_V_repeatXunionXoutXknowsX_order_byXnameX_inXcreatedX_order_byXnameXXX_timesX1X: [function({g}) { return g.V().repeat(__.union(__.out("knows").order().by("name"), __.in_("created").order().by("name"))).times(1) }], 
    g_V_repeatXaddV_propertyXgenerated_trueXX_timesX2X: [function({g}) { return g.addV().property("notGenerated", "true").addV().property("notGenerated", "true") }, function({g}) { return g.V().repeat(__.addV().property("generated", "true")).times(2) }, function({g}) { return g.V().has("notGenerated") }, function({g}) { return g.V().has("generated") }], 
    g_V_repeatXdedup_bothX_timesX2X: [function({g}) { return g.V().repeat(__.dedup().both()).times(2) }], 
    g_V_repeatXaggregateXxXX_timesX2X_selectXxX_limitX1X_unfold: [function({g}) { return g.V().repeat(__.aggregate("x")).times(2).select("x").limit(1).unfold() }], 
    g_V_valuesXstrX_repeatXsplitXabcX_conjoinX_timesX2X: [function({g}) { return g.addV().property("str", "ababcczababcc").addV().property("str", "abcyabc") }, function({g}) { return g.V().values("str").repeat(__.split("abc").conjoin("")).times(2) }], 
    g_withSackX0X_V_repeatXsackXsumX_byXageX_whereXsack_isXltX59XXXX_timesX2X: [function({g}) { return g.withSack(0).V().repeat(__.sack(Operator.sum).by("age").where(__.sack().is(P.lt(59)))).times(2) }], 
    g_V_repeatXinjectXyXX_timesX2X: [function({g}) { return g.V().repeat(__.inject("y")).times(2) }], 
    g_V_repeatXunionXconstantXyX_limitX1X_identityXX_timesX3X: [function({g}) { return g.V().repeat(__.union(__.constant("y").limit(1), __.identity())).times(2) }], 
    g_VX3X_repeatXout_order_byXperformancesX_tailX2XX_timesX1X_valuesXnameX: [function({g, vid3}) { return g.V(vid3).repeat(__.out().order().by("performances").tail(2)).times(1).values("name") }], 
    g_VX3X_repeatXout_order_byXperformancesX_tailX2XX_timesX2X_valuesXnameX: [function({g, vid3}) { return g.V(vid3).repeat(__.out().order().by("performances").tail(2)).times(2).values("name") }], 
    g_VX2X_repeatXout_localXorder_byXperformancesX_tailX1XXX_timesX1X_valuesXnameX: [function({g, vid2}) { return g.V(vid2).repeat(__.out().local(__.order().by("performances").tail(1))).times(1).values("name") }], 
    g_VX250X_repeatXout_localXorder_byXperformancesX_tailX1XXX_timesX2X_valuesXnameX: [function({g, vid250}) { return g.V(vid250).repeat(__.out().local(__.order().by("performances").tail(1))).times(2).values("name") }], 
    g_VX3X_repeatXout_order_byXperformancesX_tailX3X_limitX1XX_timesX2X_valuesXnameX: [function({g, vid3}) { return g.V(vid3).repeat(__.out().order().by("performances").tail(3).limit(1)).times(2).values("name") }], 
    g_VX3X_repeatXout_order_byXperformances_descX_limitX5X_tailX1XX_timesX2X_valuesXnameX: [function({g, vid3}) { return g.V(vid3).repeat(__.out().order().by("performances", Order.desc).limit(5).tail(1)).times(2).values("name") }], 
    g_VX3X_repeatXoutE_order_byXweightX_tailX2X_inVX_timesX2X_valuesXnameX: [function({g, vid3}) { return g.V(vid3).repeat(__.outE().order().by("weight").tail(2).inV()).times(2).values("name") }], 
    g_VX3X_repeatXoutE_order_byXweight_descX_limitX2X_inVX_timesX2X_valuesXnameX: [function({g, vid3}) { return g.V(vid3).repeat(__.outE().order().by("weight", Order.desc).limit(2).inV()).times(2).values("name") }], 
    g_unionXX: [function({g}) { return g.union() }], 
    g_unionXV_name: [function({g}) { return g.union(__.V().values("name")) }], 
    g_unionXVXv1X_VX4XX_name: [function({g, vid4, vid1}) { return g.union(__.V(vid1), __.V(vid4)).values("name") }], 
    g_unionXV_hasLabelXsoftwareX_V_hasLabelXpersonXX_name: [function({g}) { return g.union(__.V().hasLabel("software"), __.V().hasLabel("person")).values("name") }], 
    g_unionXV_out_out_V_hasLabelXsoftwareXX_path: [function({g}) { return g.union(__.V().out().out(), __.V().hasLabel("software")).path() }], 
    g_unionXV_out_out_V_hasLabelXsoftwareXX_path_byXnameX: [function({g}) { return g.union(__.V().out().out(), __.V().hasLabel("software")).path().by("name") }], 
    g_unionXunionXV_out_outX_V_hasLabelXsoftwareXX_path_byXnameX: [function({g}) { return g.union(__.union(__.V().out().out()), __.V().hasLabel("software")).path().by("name") }], 
    g_unionXinjectX1X_injectX2X: [function({g}) { return g.union(__.inject(1), __.inject(2)) }], 
    g_V_unionXconstantX1X_constantX2X_constantX3XX: [function({g, vid2}) { return g.V(vid2).union(__.constant(1), __.constant(2), __.constant(3)) }], 
    g_V_unionXout__inX_name: [function({g}) { return g.V().union(__.out(), __.in_()).values("name") }], 
    g_VX1X_unionXrepeatXoutX_timesX2X__outX_name: [function({g, vid1}) { return g.V(vid1).union(__.repeat(__.out()).times(2), __.out()).values("name") }], 
    g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX: [function({g}) { return g.V().choose(__.label().is("person"), __.union(__.out().values("lang"), __.out().values("name")), __.in_().label()) }], 
    g_V_chooseXlabel_is_person__unionX__out_lang__out_nameX__in_labelX_groupCount: [function({g}) { return g.V().choose(__.label().is("person"), __.union(__.out().values("lang"), __.out().values("name")), __.in_().label()).groupCount() }], 
    g_V_unionXrepeatXunionXoutXcreatedX__inXcreatedXX_timesX2X__repeatXunionXinXcreatedX__outXcreatedXX_timesX2XX_label_groupCount: [function({g}) { return g.V().union(__.repeat(__.union(__.out("created"), __.in_("created"))).times(2), __.repeat(__.union(__.in_("created"), __.out("created"))).times(2)).label().groupCount() }], 
    g_VX1_2X_unionXoutE_count__inE_count__outE_weight_sumX: [function({g, vid2, vid1}) { return g.V(vid1, vid2).union(__.outE().count(), __.inE().count(), __.outE().values("weight").sum()) }], 
    g_VX1_2X_localXunionXoutE_count__inE_count__outE_weight_sumXX: [function({g, vid2, vid1}) { return g.V(vid1, vid2).local(__.union(__.outE().count(), __.inE().count(), __.outE().values("weight").sum())) }], 
    g_VX1_2X_localXunionXcountXX: [function({g, vid2, vid1}) { return g.V(vid1, vid2).local(__.union(__.count())) }], 
    g_unionXaddVXpersonX_propertyXname_aliceX_addVXpersonX_propertyXname_bobX_addVXpersonX_propertyXname_chrisX_name: [function({g}) { return g.union(__.addV("person").property("name", "alice"), __.addV("person").property("name", "bob"), __.addV("person").property("name", "chris")).values("name") }], 
    g_VX_hasLabelXpersonX_unionX_whereX_out_count_isXgtX2XXX_valuesXageX_notX_whereX_bothE_count_isXgt2XXX_valusXnameXX: [function({g}) { return g.V().hasLabel("person").union(__.where(__.outE().count().is(P.gt(2))).values("age"), __.not(__.where(__.outE().count().is(P.gt(2)))).values("name")) }], 
    g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX: [function({g}) { return g.addV("data").property("int", 123) }, function({g}) { return g.V().values("int").asNumber(GType.bigDecimal).is(P.typeOf(GType.bigDecimal)) }], 
    g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_mathXaddX0_5XX: [function({g}) { return g.addV("data").property("int", 10) }, function({g}) { return g.V().values("int").asNumber(GType.bigDecimal).is(P.typeOf(GType.bigDecimal)).math("_ + 0.5") }], 
    g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_isXgtX0XX: [function({g}) { return g.addV("data").property("int", 5) }, function({g}) { return g.V().values("int").asNumber(GType.bigDecimal).is(P.typeOf(GType.bigDecimal)).is(P.gt(0)) }], 
    g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_sumX: [function({g}) { return g.addV("data").property("int", 2).addV("data").property("int", 3).addV("data").property("int", 4) }, function({g}) { return g.V().values("int").asNumber(GType.bigDecimal).is(P.typeOf(GType.bigDecimal)).sum() }], 
    g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_minX: [function({g}) { return g.addV("data").property("int", 1).addV("data").property("int", 5).addV("data").property("int", 10) }, function({g}) { return g.V().values("int").asNumber(GType.bigDecimal).is(P.typeOf(GType.bigDecimal)).min() }], 
    g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_maxX: [function({g}) { return g.addV("data").property("int", 7).addV("data").property("int", 14).addV("data").property("int", 21) }, function({g}) { return g.V().values("int").asNumber(GType.bigDecimal).is(P.typeOf(GType.bigDecimal)).max() }], 
    g_V_valuesXintX_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_project_byXidentityX_byXmathXmulX10XXX: [function({g}) { return g.addV("data").property("int", 6) }, function({g}) { return g.V().values("int").asNumber(GType.bigDecimal).is(P.typeOf(GType.bigDecimal)).project("original", "multiplied").by(__.identity()).by(__.math("_ * 10")) }], 
    g_injectX99X_asNumberXGType_BIGDECIMALX_isXtypeOfXGType_BIGDECIMALXX_groupCount: [function({g}) { return g.inject(99).asNumber(GType.bigDecimal).is(P.typeOf(GType.bigDecimal)).groupCount() }], 
    g_V_valuesXageX_isXtypeOfXGType_BIGDECIMALXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.bigDecimal)) }], 
    g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX: [function({g}) { return g.addV("data").property("int", 456) }, function({g}) { return g.V().values("int").asNumber(GType.bigInt).is(P.typeOf(GType.bigInt)) }], 
    g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_mathXmulX1000XX: [function({g}) { return g.addV("data").property("int", 100) }, function({g}) { return g.V().values("int").asNumber(GType.bigInt).is(P.typeOf(GType.bigInt)).math("_ * 1000") }], 
    g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_isXeqX42XX: [function({g}) { return g.addV("data").property("int", 42) }, function({g}) { return g.V().values("int").asNumber(GType.bigInt).is(P.typeOf(GType.bigInt)).is(P.eq(42)) }], 
    g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_sumX: [function({g}) { return g.addV("data").property("int", 10).addV("data").property("int", 20).addV("data").property("int", 30) }, function({g}) { return g.V().values("int").asNumber(GType.bigInt).is(P.typeOf(GType.bigInt)).sum() }], 
    g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_minX: [function({g}) { return g.addV("data").property("int", 5).addV("data").property("int", 15).addV("data").property("int", 25) }, function({g}) { return g.V().values("int").asNumber(GType.bigInt).is(P.typeOf(GType.bigInt)).min() }], 
    g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_maxX: [function({g}) { return g.addV("data").property("int", 100).addV("data").property("int", 200).addV("data").property("int", 300) }, function({g}) { return g.V().values("int").asNumber(GType.bigInt).is(P.typeOf(GType.bigInt)).max() }], 
    g_V_valuesXintX_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_project_byXidentityX_byXmathXaddX999XXX: [function({g}) { return g.addV("data").property("int", 50) }, function({g}) { return g.V().values("int").asNumber(GType.bigInt).is(P.typeOf(GType.bigInt)).project("original", "added").by(__.identity()).by(__.math("_ + 999")) }], 
    g_injectX777X_asNumberXGType_BIGINTX_isXtypeOfXGType_BIGINTXX_groupCount: [function({g}) { return g.inject(777).asNumber(GType.bigInt).is(P.typeOf(GType.bigInt)).groupCount() }], 
    g_V_valuesXageX_isXtypeOfXGType_BIGINTXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.bigInt)) }], 
    g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX: [function({g}) { return g.addV("data").property("int", 5) }, function({g}) { return g.V().values("int").asNumber(GType.byte).is(P.typeOf(GType.byte)) }], 
    g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_mathXaddX20XX: [function({g}) { return g.addV("data").property("int", 10) }, function({g}) { return g.V().values("int").asNumber(GType.byte).is(P.typeOf(GType.byte)).math("_ + 20") }], 
    g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_isXltX10XX: [function({g}) { return g.addV("data").property("int", 7) }, function({g}) { return g.V().values("int").asNumber(GType.byte).is(P.typeOf(GType.byte)).is(P.lt(10)) }], 
    g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_sumX: [function({g}) { return g.addV("data").property("int", 1).addV("data").property("int", 2).addV("data").property("int", 3) }, function({g}) { return g.V().values("int").asNumber(GType.byte).is(P.typeOf(GType.byte)).sum() }], 
    g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_project_byXidentityX_byXmathXmulX2XXX: [function({g}) { return g.addV("data").property("int", 8) }, function({g}) { return g.V().values("int").asNumber(GType.byte).is(P.typeOf(GType.byte)).project("original", "doubled").by(__.identity()).by(__.math("_ * 2")) }], 
    g_V_valuesXintX_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_chooseXisXeqX12XX_constantXtwelveX_constantXotherXX: [function({g}) { return g.addV("data").property("int", 12) }, function({g}) { return g.V().values("int").asNumber(GType.byte).is(P.typeOf(GType.byte)).choose(__.is(P.eq(12)), __.constant("twelve"), __.constant("other")) }], 
    g_injectX15X_asNumberXGType_BYTEX_isXtypeOfXGType_BYTEXX_groupCount: [function({g}) { return g.inject(15).asNumber(GType.byte).is(P.typeOf(GType.byte)).groupCount() }], 
    g_V_valuesXageX_isXtypeOfXGType_BYTEXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.byte)) }], 
    g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX: [function({g}) { return g.addV("event").property("datetime", new Date('2023-08-08T00:00Z')) }, function({g}) { return g.V().values("datetime").is(P.typeOf(GType.datetime)) }], 
    g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_project_byXidentityX_byXdateAddXDT_dayX1XX: [function({g}) { return g.addV("event").property("datetime", new Date('2023-08-08T00:00Z')) }, function({g}) { return g.V().values("datetime").is(P.typeOf(GType.datetime)).project("original", "nextDay").by(__.identity()).by(__.dateAdd(DT.day, 1)) }], 
    g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_dateDiffXdatetimeX2023_08_10XX: [function({g}) { return g.addV("event").property("datetime", new Date('2023-08-08T00:00Z')) }, function({g}) { return g.V().values("datetime").is(P.typeOf(GType.datetime)).dateDiff(new Date('2023-08-08T00:00:30Z')) }], 
    g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_whereXisXgtXdatetimeX2020_01_01XXXX: [function({g}) { return g.addV("event").property("datetime", new Date('2023-08-08T00:00Z')) }, function({g}) { return g.V().values("datetime").is(P.typeOf(GType.datetime)).where(__.is(P.gt(new Date('2020-01-01T00:00Z')))) }], 
    g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_chooseXisXeqXdatetimeX2023_08_08XXXX_constantXmatchX_constantXnoMatchXX: [function({g}) { return g.addV("event").property("datetime", new Date('2023-08-08T00:00Z')) }, function({g}) { return g.V().values("datetime").is(P.typeOf(GType.datetime)).choose(__.is(P.eq(new Date('2023-08-08T00:00Z'))), __.constant("match"), __.constant("noMatch")) }], 
    g_V_valuesXdatetimeX_isXtypeOfXGType_DATETIMEXX_localXaggregateXaX_capXaX: [function({g}) { return g.addV("event").property("datetime", new Date('2023-08-08T00:00Z')) }, function({g}) { return g.V().values("datetime").is(P.typeOf(GType.datetime)).local(__.aggregate("a")).cap("a") }], 
    g_injectXdatetimeX_isXtypeOfXGType_DATETIMEXX_aggregateXaX_capXaX: [function({g}) { return g.inject(new Date('2023-08-08T00:00Z')).is(P.typeOf(GType.datetime)).aggregate("a").cap("a") }], 
    g_injectXdatetimeX_isXtypeOfXGType_DATETIMEXX_groupCount: [function({g}) { return g.inject(new Date('2023-08-08T00:00Z')).is(P.typeOf(GType.datetime)).groupCount() }], 
    g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX: [function({g}) { return g.addV("data").property("double", 1.5) }, function({g}) { return g.V().values("double").is(P.typeOf(GType.double)) }], 
    g_E_valuesXweightX_isXtypeOfXGType_DOUBLEXX: [function({g}) { return g.E().values("weight").is(P.typeOf(GType.double)) }], 
    g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_mathXceilX: [function({g}) { return g.addV("data").property("double", 2.7) }, function({g}) { return g.V().values("double").is(P.typeOf(GType.double)).math("ceil _") }], 
    g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_isXgtX1_0XX: [function({g}) { return g.addV("data").property("double", 0.8).addV("data").property("double", 1.2) }, function({g}) { return g.V().values("double").is(P.typeOf(GType.double)).is(P.gt(1.0)) }], 
    g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_sumX: [function({g}) { return g.addV("data").property("double", 1.5).addV("data").property("double", 2.5).addV("data").property("double", 3.5) }, function({g}) { return g.V().values("double").is(P.typeOf(GType.double)).sum() }], 
    g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_minX: [function({g}) { return g.addV("data").property("double", 0.1).addV("data").property("double", 0.5).addV("data").property("double", 0.9) }, function({g}) { return g.V().values("double").is(P.typeOf(GType.double)).min() }], 
    g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_maxX: [function({g}) { return g.addV("data").property("double", 2.1).addV("data").property("double", 3.7).addV("data").property("double", 1.9) }, function({g}) { return g.V().values("double").is(P.typeOf(GType.double)).max() }], 
    g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_meanX: [function({g}) { return g.addV("data").property("double", 2.1).addV("data").property("double", 4.1).addV("data").property("double", 6.1) }, function({g}) { return g.V().values("double").is(P.typeOf(GType.double)).mean() }], 
    g_V_valuesXdoubleX_isXtypeOfXGType_DOUBLEXX_order_byXascX: [function({g}) { return g.addV("data").property("double", 3.2).addV("data").property("double", 1.8).addV("data").property("double", 2.5) }, function({g}) { return g.V().values("double").is(P.typeOf(GType.double)).order().by(Order.asc) }], 
    g_injectX5_5dX_isXtypeOfXGType_DOUBLEXX_groupCount: [function({g}) { return g.inject(5.5).is(P.typeOf(GType.double)).groupCount() }], 
    g_V_valuesXageX_isXtypeOfXGType_DOUBLEXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.double)) }], 
    g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX: [function({g}) { return g.addV("data").property("float", 2.5) }, function({g}) { return g.V().values("float").asNumber(GType.float).is(P.typeOf(GType.float)) }], 
    g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_mathXmulX2XX: [function({g}) { return g.addV("data").property("float", 3.0) }, function({g}) { return g.V().values("float").asNumber(GType.float).is(P.typeOf(GType.float)).math("_ * 2") }], 
    g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_isXeqX1_5XX: [function({g}) { return g.addV("data").property("float", 1.5) }, function({g}) { return g.V().values("float").asNumber(GType.float).is(P.typeOf(GType.float)).is(P.eq(1.5)) }], 
    g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_sumX: [function({g}) { return g.addV("data").property("float", 1.5).addV("data").property("float", 2.5).addV("data").property("float", 3.0) }, function({g}) { return g.V().values("float").asNumber(GType.float).is(P.typeOf(GType.float)).sum() }], 
    g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_project_byXidentityX_byXmathXmulX10XXX: [function({g}) { return g.addV("data").property("float", 4.5) }, function({g}) { return g.V().values("float").asNumber(GType.float).is(P.typeOf(GType.float)).project("original", "multiplied").by(__.identity()).by(__.math("_ * 10")) }], 
    g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_whereXisXgtX1_0XXX: [function({g}) { return g.addV("data").property("float", 0.5).addV("data").property("float", 1.5) }, function({g}) { return g.V().values("float").asNumber(GType.float).is(P.typeOf(GType.float)).where(__.is(P.gt(1.0))) }], 
    g_V_valuesXfloatX_isXtypeOfXGType_FLOATXX_chooseXisXeqX3_0XX_constantXthreeX_constantXotherXX: [function({g}) { return g.addV("data").property("float", 3.0) }, function({g}) { return g.V().values("float").asNumber(GType.float).is(P.typeOf(GType.float)).choose(__.is(P.eq(3.0)), __.constant("three"), __.constant("other")) }], 
    g_injectX2_0fX_isXtypeOfXGType_FLOATXX_groupCount: [function({g}) { return g.inject(2.0).asNumber(GType.float).is(P.typeOf(GType.float)).groupCount() }], 
    g_V_valuesXageX_isXtypeOfXGType_FLOATXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.float)) }], 
    g_V_valuesXageX_isXtypeOfXGType_INTXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.int)) }], 
    g_V_hasXage_typeOfXGType_INTXX_valuesXnameX: [function({g}) { return g.V().has("age", P.typeOf(GType.int)).values("name") }], 
    g_V_whereXvaluesXageX_isXtypeOfXGType_INTXXX_valuesXnameX: [function({g}) { return g.V().where(__.values("age").is(P.typeOf(GType.int))).values("name") }], 
    g_V_valuesXageX_isXtypeOfXGType_INTXX_mathXincX: [function({g}) { return g.V().values("name", "age").is(P.typeOf(GType.int)).math("_ + 1") }], 
    g_V_valuesXageX_isXtypeOfXGType_INTXX_sumX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.int)).sum() }], 
    g_V_valuesXageX_isXtypeOfXGType_INTXX_minX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.int)).min() }], 
    g_V_valuesXageX_isXtypeOfXGType_INTXX_maxX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.int)).max() }], 
    g_V_valuesXageX_isXtypeOfXGType_INTXX_meanX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.int)).mean() }], 
    g_V_valuesXageX_isXtypeOfXGType_INTXX_order_byXdescX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.int)).order().by(Order.desc) }], 
    g_V_valuesXageX_isXtypeOfXGType_INTXX_groupCount: [function({g}) { return g.V().values("age").is(P.typeOf(GType.int)).groupCount() }], 
    g_V_valuesXnameX_fold_isXtypeOfXGType_LISTXX_count: [function({g}) { return g.V().values("name").fold().is(P.typeOf(GType.list)).count() }], 
    g_V_valuesXageX_isXtypeOfXGType_LISTXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.list)) }], 
    g_V_valuesXlistX_isXtypeOfXGType_LISTXX: [function({g}) { return g.addV("data").property("list", ["a", "b", "c"]) }, function({g}) { return g.V().values("list").is(P.typeOf(GType.list)) }], 
    g_V_hasXlist_typeOfXGType_LISTXX_valuesXnameX: [function({g}) { return g.addV("data").property("name", "test").property("list", [1, 2, 3]) }, function({g}) { return g.V().has("list", P.typeOf(GType.list)).values("name") }], 
    g_V_valuesXlistX_isXtypeOfXGType_LISTXX_unfold: [function({g}) { return g.addV("data").property("list", ["x", "y", "z"]) }, function({g}) { return g.V().values("list").is(P.typeOf(GType.list)).unfold() }], 
    g_V_valuesXlistX_isXtypeOfXGType_LISTXX_countXlocalX: [function({g}) { return g.addV("data").property("list", [1, 2, 3, 4, 5]) }, function({g}) { return g.V().values("list").is(P.typeOf(GType.list)).count(Scope.local) }], 
    g_V_valuesXlistX_isXtypeOfXGType_LISTXX_unfold_rangeX1_3X: [function({g}) { return g.addV("data").property("list", ["first", "second", "third", "fourth"]) }, function({g}) { return g.V().values("list").is(P.typeOf(GType.list)).unfold().range(1, 3) }], 
    g_V_valuesXlistX_isXtypeOfXGType_LISTXX_project_byXidentityX_byXcountXlocalX: [function({g}) { return g.addV("data").property("list", ["apple", "banana"]) }, function({g}) { return g.V().values("list").is(P.typeOf(GType.list)).project("original", "size").by(__.identity()).by(__.count(Scope.local)) }], 
    g_V_valuesXlistX_isXtypeOfXGType_LISTXX_whereXcountXlocalX_isXgtX2XXX: [function({g}) { return g.addV("data").property("list", [1]).addV("data").property("list", [1, 2, 3]) }, function({g}) { return g.V().values("list").is(P.typeOf(GType.list)).where(__.count(Scope.local).is(P.gt(2))) }], 
    g_injectXlistX_isXtypeOfXGType_LISTXX_groupCount: [function({g}) { return g.inject(["test"]).is(P.typeOf(GType.list)).groupCount() }], 
    g_V_valuesXlongX_isXtypeOfXGType_LONGXX: [function({g}) { return g.addV("data").property("long", 1) }, function({g}) { return g.V().values("long").is(P.typeOf(GType.long)) }], 
    g_V_hasXlong_typeOfXGType_LONGXX_valuesXnameX: [function({g}) { return g.addV("data").property("name", "test").property("long", 1) }, function({g}) { return g.V().has("long", P.typeOf(GType.long)).values("name") }], 
    g_V_valuesXlongX_isXtypeOfXGType_LONGXX_mathXmulX2XX: [function({g}) { return g.addV("data").property("long", 5) }, function({g}) { return g.V().values("long").is(P.typeOf(GType.long)).math("_ * 2") }], 
    g_V_valuesXlongX_isXtypeOfXGType_LONGXX_isXgtX5XX: [function({g}) { return g.addV("data").property("long", 10) }, function({g}) { return g.V().values("long").is(P.typeOf(GType.long)).is(P.gt(5)) }], 
    g_V_valuesXlongX_isXtypeOfXGType_LONGXX_sumX: [function({g}) { return g.addV("data").property("long", 1).addV("data").property("long", 2).addV("data").property("long", 3) }, function({g}) { return g.V().values("long").is(P.typeOf(GType.long)).sum() }], 
    g_V_valuesXlongX_isXtypeOfXGType_LONGXX_localXaggregateXaXX_capXaX: [function({g}) { return g.addV("data").property("long", 100) }, function({g}) { return g.V().values("long").is(P.typeOf(GType.long)).local(__.aggregate("a")).cap("a") }], 
    g_V_hasLabelXpersonX_valueMap_isXtypeOfXGType_MAPXX_count: [function({g}) { return g.V().hasLabel("person").valueMap().is(P.typeOf(GType.map)).count() }], 
    g_V_groupCount_byXlabelX_isXtypeOfXGType_MAPX: [function({g}) { return g.V().groupCount().by(T.label).is(P.typeOf(GType.map)) }], 
    g_V_valuesXageX_isXtypeOfXGType_MAPXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.map)) }], 
    g_V_valuesXmapX_isXtypeOfXGType_MAPXX: [function({g}) { return g.addV("data").property("map", new Map([["key1", "1"], ["key2", "2"]])) }, function({g}) { return g.V().values("map").is(P.typeOf(GType.map)) }], 
    g_V_hasXmap_typeOfXGType_MAPXX_valuesXnameX: [function({g}) { return g.addV("data").property("name", "test").property("map", new Map([["a", 1], ["b", 2]])) }, function({g}) { return g.V().has("map", P.typeOf(GType.map)).values("name") }], 
    g_V_valuesXmapX_isXtypeOfXGType_MAPXX_countXlocalX: [function({g}) { return g.addV("data").property("map", new Map([["a", 1], ["b", 2], ["c", 3]])) }, function({g}) { return g.V().values("map").is(P.typeOf(GType.map)).count(Scope.local) }], 
    g_V_valuesXmapX_isXtypeOfXGType_MAPXX_selectXvaluesX: [function({g}) { return g.addV("data").property("map", new Map([["city", "NYC"], ["country", "USA"]])) }, function({g}) { return g.V().values("map").is(P.typeOf(GType.map)).select(Column.values) }], 
    g_V_valuesXmapX_isXtypeOfXGType_MAPXX_whereX_countXlocalX_isXgtX1XXX: [function({g}) { return g.addV("data").property("map", new Map([["single", "value"]])).addV("data").property("map", new Map([["key1", "1"], ["key2", "2"]])) }, function({g}) { return g.V().values("map").is(P.typeOf(GType.map)).where(__.count(Scope.local).is(P.gt(1))) }], 
    g_V_valuesXmapX_isXtypeOfXGType_MAPXX_foldX: [function({g}) { return g.addV("data").property("map", new Map([["a", 1]])).addV("data").property("map", new Map([["b", 2], ["c", 3]])) }, function({g}) { return g.V().values("map").is(P.typeOf(GType.map)).fold() }], 
    g_V_valueXnameX_aggregateXxX_capXxX_isXtypeOfXGType_SETX: [function({g}) { return g.V().values("name").aggregate("x").cap("x").is(P.typeOf(GType.set)) }], 
    g_V_valuesXageX_isXtypeOfXGType_SETXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.set)) }], 
    g_V_valueMap_selectXkeysX_dedup_isXtypeOfXGType_SETXX: [function({g}) { return g.V().valueMap().select(Column.keys).dedup().is(P.typeOf(GType.set)) }], 
    g_V_valuesXsetX_isXtypeOfXGType_SETXX: [function({g}) { return g.addV("data").property("set", new Set(["a", "b", "c"])) }, function({g}) { return g.V().values("set").is(P.typeOf(GType.set)) }], 
    g_V_hasXset_typeOfXGType_SETXX_valuesXnameX: [function({g}) { return g.addV("data").property("name", "test").property("set", new Set([1, 2, 3])) }, function({g}) { return g.V().has("set", P.typeOf(GType.set)).values("name") }], 
    g_V_valuesXsetX_isXtypeOfXGType_SETXX_unfold: [function({g}) { return g.addV("data").property("set", new Set(["x", "y", "z"])) }, function({g}) { return g.V().values("set").is(P.typeOf(GType.set)).unfold() }], 
    g_V_valuesXsetX_isXtypeOfXGType_SETXX_countXlocalX: [function({g}) { return g.addV("data").property("set", new Set([1, 2, 3, 4, 5])) }, function({g}) { return g.V().values("set").is(P.typeOf(GType.set)).count(Scope.local) }], 
    g_V_valuesXsetX_isXtypeOfXGType_SETXX_whereXcountXlocalX_isXeqX3XXX: [function({g}) { return g.addV("data").property("set", new Set([1, 2])).addV("data").property("set", new Set([1, 2, 3])) }, function({g}) { return g.V().values("set").is(P.typeOf(GType.set)).where(__.count(Scope.local).is(P.eq(3))) }], 
    g_V_valuesXsetX_isXtypeOfXGType_SETXX_unfold_limitX2X: [function({g}) { return g.addV("data").property("set", new Set(["first", "second", "third", "fourth"])) }, function({g}) { return g.V().values("set").is(P.typeOf(GType.set)).unfold().limit(2) }], 
    g_injectXsetX_isXtypeOfXGType_SETXX_groupCount: [function({g}) { return g.inject(new Set(["test"])).is(P.typeOf(GType.set)).groupCount() }], 
    g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX: [function({g}) { return g.addV("data").property("int", 100) }, function({g}) { return g.V().values("int").asNumber(GType.short).is(P.typeOf(GType.short)) }], 
    g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_mathXmulX10XX: [function({g}) { return g.addV("data").property("int", 50) }, function({g}) { return g.V().values("int").asNumber(GType.short).is(P.typeOf(GType.short)).math("_ * 10") }], 
    g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_isXbetweenX20_30XX: [function({g}) { return g.addV("data").property("int", 25) }, function({g}) { return g.V().values("int").asNumber(GType.short).is(P.typeOf(GType.short)).is(P.between(20, 30)) }], 
    g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_minX: [function({g}) { return g.addV("data").property("int", 10).addV("data").property("int", 20).addV("data").property("int", 30) }, function({g}) { return g.V().values("int").asNumber(GType.short).is(P.typeOf(GType.short)).min() }], 
    g_V_valuesXintX_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_maxX: [function({g}) { return g.addV("data").property("int", 15).addV("data").property("int", 25).addV("data").property("int", 35) }, function({g}) { return g.V().values("int").asNumber(GType.short).is(P.typeOf(GType.short)).max() }], 
    g_injectX42X_asNumberXGType_SHORTX_isXtypeOfXGType_SHORTXX_storeXaX_capXaX: [function({g}) { return g.inject(42).asNumber(GType.short).is(P.typeOf(GType.short)) }], 
    g_V_valuesXageX_isXtypeOfXGType_SHORTXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.short)) }], 
    g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX: [function({g}) { return g.addV("data").property("uuid", "f47af10b-58cc-4372-a567-0f02b2f3d479") }, function({g}) { return g.V().values("uuid").is(P.typeOf(GType.uuid)) }], 
    g_V_hasXuuid_typeOfXGType_UUIDXX_valuesXnameX: [function({g}) { return g.addV("data").property("name", "test").property("uuid", "f47af10b-58cc-4372-a567-0f02b2f3d479") }, function({g}) { return g.V().has("uuid", P.typeOf(GType.uuid)).values("name") }], 
    g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_project_byXidentityX_byXconstantXuuidXX: [function({g}) { return g.addV("data").property("uuid", "f47af10b-58cc-4372-a567-0f02b2f3d479") }, function({g}) { return g.V().values("uuid").is(P.typeOf(GType.uuid)).project("original", "type").by(__.identity()).by(__.constant("uuid")) }], 
    g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_whereXisXeqXuuidXX: [function({g}) { return g.addV("data").property("uuid", "f47af10b-58cc-4372-a567-0f02b2f3d479") }, function({g}) { return g.V().values("uuid").is(P.typeOf(GType.uuid)).where(__.is(P.eq("f47af10b-58cc-4372-a567-0f02b2f3d479"))) }], 
    g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_chooseXisXeqXuuidXX_constantXmatchX_constantXnoMatchXX: [function({g}) { return g.addV("data").property("uuid", "f47af10b-58cc-4372-a567-0f02b2f3d479") }, function({g}) { return g.V().values("uuid").is(P.typeOf(GType.uuid)).choose(__.is(P.eq("f47af10b-58cc-4372-a567-0f02b2f3d479")), __.constant("match"), __.constant("noMatch")) }], 
    g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_localXaggregateXaXX_capXaX: [function({g}) { return g.addV("data").property("uuid", "f47af10b-58cc-4372-a567-0f02b2f3d479") }, function({g}) { return g.V().values("uuid").is(P.typeOf(GType.uuid)).local(__.aggregate("a")).cap("a") }], 
    g_V_valuesXuuidX_isXtypeOfXGType_UUIDXX_aggregateXaX_capXaX: [function({g}) { return g.addV("data").property("uuid", "f47af10b-58cc-4372-a567-0f02b2f3d479") }, function({g}) { return g.V().values("uuid").is(P.typeOf(GType.uuid)).aggregate("a").cap("a") }], 
    g_injectXuuidX_isXtypeOfXGType_UUIDXX_groupCount: [function({g}) { return g.inject("f47af10b-58cc-4372-a567-0f02b2f3d479").is(P.typeOf(GType.uuid)).groupCount() }], 
    g_injectXUUIDX47af10b_58cc_4372_a567_0f02b2f3d479XX: [function({g}) { return g.inject("f47af10b-58cc-4372-a567-0f02b2f3d479") }], 
    g_injectXUUIDXXX: [function({g}) { return g.inject(uuid.v4()) }], 
    g_V_aggregateXxX_byXnameX_byXageX_capXxX: [function({g}) { return g.V().aggregate("x").by("name").by("age").cap("x") }], 
    g_V_localXaggregateXxX_byXnameXX_byXageX_capXxX: [function({g}) { return g.V().local(__.aggregate("x").by("name").by("age")).cap("x") }], 
    g_V_valuesXageX_allXgtX32XX: [function({g}) { return g.V().values("age").all(P.gt(32)) }], 
    g_V_valuesXageX_whereXisXP_gtX33XXX_fold_allXgtX33XX: [function({g}) { return g.V().values("age").where(__.is(P.gt(33))).fold().all(P.gt(33)) }], 
    g_V_valuesXageX_order_byXdescX_fold_allXgtX10XX: [function({g}) { return g.V().values("age").order().by(Order.desc).fold().all(P.gt(10)) }], 
    g_V_valuesXageX_order_byXdescX_fold_allXgtX30XX: [function({g}) { return g.V().values("age").order().by(Order.desc).fold().all(P.gt(30)) }], 
    g_injectXabc_bcdX_allXeqXbcdXX: [function({g}) { return g.inject(["abc", "bcd"]).all(P.eq("bcd")) }], 
    g_injectXbcd_bcdX_allXeqXbcdXX: [function({g}) { return g.inject(["bcd", "bcd"]).all(P.eq("bcd")) }], 
    g_injectXnull_abcX_allXTextP_startingWithXaXX: [function({g}) { return g.inject([null, "abc"]).all(TextP.startingWith("a")) }], 
    g_injectX5_8_10_10_7X_allXgteX7XX: [function({g}) { return g.inject([5, 8, 10], [10, 7]).all(P.gte(7)) }], 
    g_injectXnullX_allXeqXnullXX: [function({g}) { return g.inject(null).all(P.eq(null)) }], 
    g_injectX7X_allXeqX7XX: [function({g}) { return g.inject(7).all(P.eq(7)) }], 
    g_injectXnull_nullX_allXeqXnullXX: [function({g}) { return g.inject([null, null]).all(P.eq(null)) }], 
    g_injectX3_threeX_allXeqX3XX: [function({g}) { return g.inject([3, "three"]).all(P.eq(3)) }], 
    g_V_andXhasXage_gt_27X__outE_count_gte_2X_name: [function({g}) { return g.V().and(__.has("age", P.gt(27)), __.outE().count().is(P.gte(2))).values("name") }], 
    g_V_andXoutE__hasXlabel_personX_and_hasXage_gte_32XX_name: [function({g}) { return g.V().and(__.outE(), __.has(T.label, "person").and().has("age", P.gte(32))).values("name") }], 
    g_V_asXaX_outXknowsX_and_outXcreatedX_inXcreatedX_asXaX_name: [function({g}) { return g.V().as("a").out("knows").and().out("created").in_("created").as("a").values("name") }], 
    g_V_asXaX_andXselectXaX_selectXaXX: [function({g}) { return g.V().as("a").and(__.select("a"), __.select("a")) }], 
    g_V_hasXname_markoX_and_hasXname_markoX_and_hasXname_markoX: [function({g}) { return g.V().has("name", "marko").and().has("name", "marko").and().has("name", "marko") }], 
    g_V_valuesXageX_anyXgtX32XX: [function({g}) { return g.V().values("age").any(P.gt(32)) }], 
    g_V_valuesXageX_order_byXdescX_fold_anyXeqX29XX: [function({g}) { return g.V().values("age").order().by(Order.desc).fold().any(P.eq(29)) }], 
    g_V_valuesXageX_order_byXdescX_fold_anyXgtX10XX: [function({g}) { return g.V().values("age").order().by(Order.desc).fold().any(P.gt(10)) }], 
    g_V_valuesXageX_order_byXdescX_fold_anyXgtX42XX: [function({g}) { return g.V().values("age").order().by(Order.desc).fold().any(P.gt(42)) }], 
    g_injectXabc_cdeX_anyXeqXbcdXX: [function({g}) { return g.inject(["abc", "cde"]).any(P.eq("bcd")) }], 
    g_injectXabc_bcdX_anyXeqXbcdXX: [function({g}) { return g.inject(["abc", "bcd"]).any(P.eq("bcd")) }], 
    g_injectXnull_abcX_anyXTextP_startingWithXaXX: [function({g}) { return g.inject([null, "abc"]).any(TextP.startingWith("a")) }], 
    g_injectX5_8_10_10_7X_anyXeqX7XX: [function({g}) { return g.inject([5, 8, 10], [10, 7]).any(P.eq(7)) }], 
    g_injectXnullX_anyXeqXnullXX: [function({g}) { return g.inject(null).any(P.eq(null)) }], 
    g_injectX7X_anyXeqX7XX: [function({g}) { return g.inject(7).any(P.eq(7)) }], 
    g_injectXnull_nullX_anyXeqXnullXX: [function({g}) { return g.inject([null, null]).any(P.eq(null)) }], 
    g_injectX3_threeX_anyXeqX3XX: [function({g}) { return g.inject([3, "three"]).any(P.eq(3)) }], 
    g_V_coinX1X: [function({g}) { return g.V().coin(1.0) }], 
    g_V_coinX0X: [function({g}) { return g.V().coin(0.0) }], 
    g_withStrategiesXSeedStrategyX_V_order_byXnameX_coinX50X: [function({g}) { return g.withStrategies(new SeedStrategy({seed: 999999})).V().order().by("name").coin(0.5) }], 
    g_VX1X_outXcreatedX_inXcreatedX_cyclicPath: [function({g, vid1}) { return g.V(vid1).out("created").in_("created").cyclicPath() }], 
    g_VX1X_both_both_cyclicPath_byXageX: [function({g, vid1}) { return g.V(vid1).both().both().cyclicPath().by("age") }], 
    g_VX1X_outXcreatedX_inXcreatedX_cyclicPath_path: [function({g, vid1}) { return g.V(vid1).out("created").in_("created").cyclicPath().path() }], 
    g_VX1X_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_cyclicPath_fromXaX_toXbX_path: [function({g, vid1}) { return g.V(vid1).as("a").out("created").as("b").in_("created").as("c").cyclicPath().from_("a").to("b").path() }], 
    g_injectX0X_V_both_coalesceXhasXname_markoX_both_constantX0XX_cyclicPath_path: [function({g}) { return g.inject(0).V().both().coalesce(__.has("name", "marko").both(), __.constant(0)).cyclicPath().path() }], 
    g_V_out_in_valuesXnameX_fold_dedupXlocalX_unfold: [function({g}) { return g.V().out().in_().values("name").fold().dedup(Scope.local).unfold() }], 
    g_V_out_in_valuesXnameX_fold_dedupXlocalX: [function({g}) { return g.V().out().map(__.in_().values("name").fold().dedup(Scope.local)) }], 
    g_V_out_asXxX_in_asXyX_selectXx_yX_byXnameX_fold_dedupXlocal_x_yX_unfold: [function({g}) { return g.V().out().as("x").in_().as("y").select("x", "y").by("name").fold().dedup(Scope.local, "x", "y").unfold() }], 
    g_V_both_dedup_name: [function({g}) { return g.V().both().dedup().values("name") }], 
    g_V_both_hasXlabel_softwareX_dedup_byXlangX_name: [function({g}) { return g.V().both().has(T.label, "software").dedup().by("lang").values("name") }], 
    g_V_both_both_name_dedup: [function({g}) { return g.V().both().both().values("name").dedup() }], 
    g_V_both_both_dedup: [function({g}) { return g.V().both().both().dedup() }], 
    g_V_both_both_dedup_byXlabelX: [function({g}) { return g.V().both().both().dedup().by(T.label) }], 
    g_V_group_byXlabelX_byXbothE_weight_dedup_foldX: [function({g}) { return g.V().group().by(T.label).by(__.bothE().values("weight").dedup().order().by(Order.asc).fold()) }], 
    g_V_asXaX_both_asXbX_dedupXa_bX_byXlabelX_selectXa_bX: [function({g}) { return g.V().as("a").both().as("b").dedup("a", "b").by(T.label).select("a", "b") }], 
    g_V_asXaX_out_asXbX_in_asXcX_dedupXa_bX_path_byXnameX: [function({g}) { return g.addV("person").property("name", "alice").as("a").addV("person").property("name", "bob").as("b").addV("person").property("name", "carol").as("c").addE("knows").from_("a").to("b").addE("likes").from_("a").to("b").addE("likes").from_("a").to("c") }, function({g}) { return g.V().as("a").out().as("b").in_().as("c").dedup("a", "b").path().by("name") }], 
    g_V_outE_asXeX_inV_asXvX_selectXeX_order_byXweight_ascX_selectXvX_valuesXnameX_dedup: [function({g}) { return g.V().outE().as("e").inV().as("v").select("e").order().by("weight", Order.asc).select("v").values("name").dedup() }], 
    g_V_both_both_dedup_byXoutE_countX_name: [function({g}) { return g.V().both().both().dedup().by(__.outE().count()).values("name") }], 
    g_V_groupCount_selectXvaluesX_unfold_dedup: [function({g}) { return g.V().groupCount().select(Column.values).unfold().dedup() }], 
    g_V_asXaX_repeatXbothX_timesX3X_emit_name_asXbX_group_byXselectXaXX_byXselectXbX_dedup_order_foldX_selectXvaluesX_unfold_dedup: [function({g}) { return g.V().as("a").repeat(__.both()).times(3).emit().values("name").as("b").group().by(__.select("a")).by(__.select("b").dedup().order().fold()).select(Column.values).unfold().dedup() }], 
    g_V_repeatXdedupX_timesX2X_count: [function({g}) { return g.V().repeat(__.dedup()).times(2).count() }], 
    g_V_both_group_by_byXout_dedup_foldX_unfold_selectXvaluesX_unfold_out_order_byXnameX_limitX1X_valuesXnameX: [function({g}) { return g.V().both().group().by().by(__.out().dedup().fold()).unfold().select(Column.values).unfold().out().order().by("name").limit(1).values("name") }], 
    g_V_bothE_properties_dedup_count: [function({g}) { return g.V().bothE().properties().dedup().count() }], 
    g_V_both_properties_dedup_count: [function({g}) { return g.V().both().properties().dedup().count() }], 
    g_V_both_properties_properties_dedup_count: [function({g}) { return g.V().both().properties().properties().dedup().count() }], 
    g_V_order_byXname_descX_barrier_dedup_age_name: [function({g}) { return g.V().order().by("name", Order.desc).barrier().dedup().by("age").values("name") }], 
    g_withStrategiesXProductiveByStrategyX_V_order_byXname_descX_barrier_dedup_age_name: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().order().by("name", Order.desc).barrier().dedup().by("age").values("name") }], 
    g_V_both_dedup_age_name: [function({g}) { return g.V().both().dedup().by("age").values("name") }], 
    g_VX1X_asXaX_both_asXbX_both_asXcX_dedupXa_bX_age_selectXa_b_cX_name: [function({g, vid1}) { return g.V(vid1).as("a").both().as("b").both().as("c").dedup("a", "b").by("age").select("a", "b", "c").by("name") }], 
    g_VX1X_valuesXageX_dedupXlocalX_unfold: [function({g, vid1}) { return g.V(vid1).values("age").dedup(Scope.local).unfold() }], 
    g_V_properties_dedup_count: [function({g}) { return g.addV("person").property("name", "josh").addV("person").property("name", "josh").addV("person").property("name", "josh") }, function({g}) { return g.V().properties("name").dedup().count() }], 
    g_V_properties_dedup_byXvalueX_count: [function({g}) { return g.addV("person").property("name", "josh").addV("person").property("name", "josh").addV("person").property("name", "josh") }, function({g}) { return g.V().properties("name").dedup().by(T.value).count() }], 
    g_V_both_hasXlabel_softwareX_dedup_byXlangX_byXnameX_name: [function({g}) { return g.V().both().has(T.label, "software").dedup().by("lang").by("name").values("name") }], 
    g_V_count_discard: [function({g}) { return g.V().count().discard() }], 
    g_V_hasLabelXpersonX_discard: [function({g}) { return g.V().hasLabel("person").discard() }], 
    g_VX1X_outXcreatedX_discard: [function({g, vid1}) { return g.V(vid1).out("created").discard() }], 
    g_V_discard: [function({g}) { return g.V().discard() }], 
    g_V_discard_discard: [function({g}) { return g.V().discard().discard() }], 
    g_V_discard_fold: [function({g}) { return g.V().discard().fold() }], 
    g_V_discard_fold_discard: [function({g}) { return g.V().discard().fold().discard() }], 
    g_V_discard_fold_constantX1X: [function({g}) { return g.V().discard().fold().constant(1) }], 
    g_V_projectXxX_byXcoalesceXage_isXgtX29XX_discardXX_selectXxX: [function({g}) { return g.V().project("x").by(__.coalesce(__.values("age").is(P.gt(29)), __.discard())).select("x") }], 
    g_V_drop: [function({g}) { return g.addV().as("a").addV().as("b").addE("knows").to("a") }, function({g}) { return g.V().drop() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_V_outE_drop: [function({g}) { return g.addV().as("a").addV().as("b").addE("knows").to("a") }, function({g}) { return g.V().outE().drop() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_V_properties_drop: [function({g}) { return g.addV().property("name", "bob").addV().property("name", "alice") }, function({g}) { return g.V().properties().drop() }, function({g}) { return g.V() }, function({g}) { return g.V().properties() }], 
    g_E_propertiesXweightX_drop: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.E().properties("weight").drop() }, function({g}) { return g.E().properties() }], 
    g_V_properties_propertiesXstartTimeX_drop: [function({g}) { return g.addV().property("name", "bob").property(Cardinality.list, "location", "ny", "startTime", 2014, "endTime", 2016).property(Cardinality.list, "location", "va", "startTime", 2016).addV().property("name", "alice").property(Cardinality.list, "location", "va", "startTime", 2014, "endTime", 2016).property(Cardinality.list, "location", "ny", "startTime", 2016) }, function({g}) { return g.V().properties().properties("startTime").drop() }, function({g}) { return g.V().properties().properties() }, function({g}) { return g.V().properties().properties("startTime") }], 
    g_V_filterXisX0XX: [function({g}) { return g.V().filter(__.is(0)) }], 
    g_V_filterXconstantX0XX: [function({g}) { return g.V().filter(__.constant(0)) }], 
    g_V_filterXhasXlang_javaXX: [function({g}) { return g.V().filter(__.has("lang", "java")) }], 
    g_VX1X_filterXhasXage_gtX30XXX: [function({g, vid1}) { return g.V(vid1).filter(__.has("age", P.gt(30))) }], 
    g_VX2X_filterXhasXage_gtX30XXX: [function({g, vid2}) { return g.V(vid2).filter(__.has("age", P.gt(30))) }], 
    g_VX1X_out_filterXhasXage_gtX30XXX: [function({g, vid1}) { return g.V(vid1).out().filter(__.has("age", P.gt(30))) }], 
    g_V_filterXhasXname_startingWithXm_or_pXX: [function({g}) { return g.V().filter(__.has("name", TextP.startingWith("m").or(TextP.startingWith("p")))) }], 
    g_E_filterXisX0XX: [function({g}) { return g.E().filter(__.is(0)) }], 
    g_E_filterXconstantX0XX: [function({g}) { return g.E().filter(__.constant(0)) }], 
    g_VX1X_hasXnameX: [function({g, vid1}) { return g.V(vid1).has("name") }], 
    g_VX1X_hasXcircumferenceX: [function({g, vid1}) { return g.V(vid1).has("circumference") }], 
    g_VX1X_hasXname_markoX: [function({g, vid1}) { return g.V(vid1).has("name", "marko") }], 
    g_VX1X_hasXname_markovarX: [function({g, xx1, vid1}) { return g.V(vid1).has("name", xx1) }], 
    g_VX2X_hasXname_markoX: [function({g, vid1}) { return g.V(vid1).has("name", "marko") }], 
    g_V_hasXname_markoX: [function({g}) { return g.V().has("name", "marko") }], 
    g_V_hasXname_blahX: [function({g}) { return g.V().has("name", "blah") }], 
    g_V_hasXage_gt_30X: [function({g}) { return g.V().has("age", P.gt(30)) }], 
    g_VX1X_hasXage_gt_30X: [function({g, vid1}) { return g.V(vid1).has("age", P.gt(30)) }], 
    g_V_hasXpersonvar_age_gt_30X: [function({g, xx1}) { return g.V().has(xx1, "age", P.gt(30)) }], 
    g_VX4X_hasXage_gt_30X: [function({g, vid4}) { return g.V(vid4).has("age", P.gt(30)) }], 
    g_VXv1X_hasXage_gt_30X: [function({g, vid1}) { return g.V(vid1).has("age", P.gt(30)) }], 
    g_VXv4X_hasXage_gt_30X: [function({g, vid4}) { return g.V(vid4).has("age", P.gt(30)) }], 
    g_VX1X_out_hasXid_2X: [function({g, vid2}) { return g.V(vid2).has("age", P.gt(30)) }], 
    g_V_hasXblahX: [function({g}) { return g.V().has("blah") }], 
    g_V_hasXperson_name_markoX_age: [function({g}) { return g.V().has("person", "name", "marko").values("age") }], 
    g_V_hasXperson_name_markovarX_age: [function({g, xx1}) { return g.V().has("person", "name", xx1).values("age") }], 
    g_V_hasXpersonvar_name_markoX_age: [function({g, xx1}) { return g.V().has(xx1, "name", "marko").values("age") }], 
    g_VX1X_outE_hasXweight_inside_0_06X_inV: [function({g, vid1}) { return g.V(vid1).outE().has("weight", P.inside(0.0, 0.6)).inV() }], 
    g_EX11X_outV_outE_hasXid_10X: [function({g, eid11, eid10}) { return g.E(eid11).outV().outE().has(T.id, eid10) }], 
    g_EX11X_outV_outE_hasXid_10AsStringX: [function({g, eid11, eid10}) { return g.E(eid11).outV().outE().has(T.id, eid10) }], 
    g_V_hasXlocationX: [function({g}) { return g.V().has("location") }], 
    g_V_hasXage_withinX27X_count: [function({g}) { return g.V().has("age", P.within(27)).count() }], 
    g_V_hasXage_withinX27_nullX_count: [function({g}) { return g.V().has("age", P.within(27, null)).count() }], 
    g_V_hasXage_withinX27_29X_count: [function({g}) { return g.V().has("age", P.within(27, 29)).count() }], 
    g_V_hasXage_withoutX27X_count: [function({g}) { return g.V().has("age", P.without(27)).count() }], 
    g_V_hasXage_withoutX27_29X_count: [function({g}) { return g.V().has("age", P.without(27, 29)).count() }], 
    g_V_hasXperson_age_withinX: [function({g}) { return g.V().has("person", "age", P.within()) }], 
    g_V_hasXperson_age_withoutX: [function({g}) { return g.V().has("person", "age", P.without()) }], 
    g_V_hasXname_containingXarkXX: [function({g}) { return g.V().has("name", TextP.containing("ark")) }], 
    g_V_hasXname_startingWithXmarXX: [function({g}) { return g.V().has("name", TextP.startingWith("mar")) }], 
    g_V_hasXname_endingWithXasXX: [function({g}) { return g.V().has("name", TextP.endingWith("as")) }], 
    g_V_hasXperson_name_containingXoX_andXltXmXXX: [function({g}) { return g.V().has("person", "name", TextP.containing("o").and(P.lt("m"))) }], 
    g_V_hasXname_gtXmX_andXcontainingXoXXX: [function({g}) { return g.V().has("name", P.gt("m").and(TextP.containing("o"))) }], 
    g_V_hasXname_not_containingXarkXX: [function({g}) { return g.V().has("name", TextP.notContaining("ark")) }], 
    g_V_hasXname_not_startingWithXmarXX: [function({g}) { return g.V().has("name", TextP.notStartingWith("mar")) }], 
    g_V_hasXname_not_endingWithXasXX: [function({g}) { return g.V().has("name", TextP.notEndingWith("as")) }], 
    g_V_hasXname_regexXrMarXX: [function({g}) { return g.V().has("name", TextP.regex("^mar")) }], 
    g_V_hasXname_notRegexXrMarXX: [function({g}) { return g.V().has("name", TextP.notRegex("^mar")) }], 
    g_V_hasXname_regexXTinkerXX: [function({g}) { return g.addV("software").property("name", "Apache TinkerPop©") }, function({g}) { return g.V().has("name", TextP.regex("Tinker")).values("name") }], 
    g_V_hasXname_regexXTinkerUnicodeXX: [function({g}) { return g.addV("software").property("name", "Apache TinkerPop©") }, function({g}) { return g.V().has("name", TextP.regex("Tinker.*\u00A9")).values("name") }], 
    g_V_hasXp_neqXvXX: [function({g}) { return g.V().has("p", P.neq("v")) }], 
    g_V_hasXage_gtX18X_andXltX30XXorXgtx35XXX: [function({g}) { return g.V().has("age", P.gt(18).and(P.lt(30)).or(P.gt(35))) }], 
    g_V_hasXage_gtX18X_andXltX30XXorXltx35XXX: [function({g}) { return g.V().has("age", P.gt(18).and(P.lt(30)).and(P.lt(35))) }], 
    g_V_hasXk_withinXcXX_valuesXkX: [function({g}) { return g.addV().property("k", "轉注").addV().property("k", "✦").addV().property("k", "♠").addV().property("k", "A") }, function({g}) { return g.V().has("k", P.within("轉注", "✦", "♠")).values("k") }], 
    g_V_hasXnullX: [function({g}) { return g.V().has(null) }], 
    g_V_hasXnull_testnullkeyX: [function({g}) { return g.V().has(null, "test-null-key") }], 
    g_E_hasXnullX: [function({g}) { return g.E().has(null) }], 
    g_V_hasXlabel_personX: [function({g}) { return g.V().has(T.label, "person") }], 
    g_V_hasXlabel_eqXpersonXX: [function({g}) { return g.V().has(T.label, P.eq("person")) }], 
    g_V_hasXname_nullX: [function({g}) { return g.V().has("name", null) }], 
    g_V_hasIdXemptyX_count: [function({g, xx1}) { return g.V().hasId(xx1).count() }], 
    g_V_hasIdXwithinXemptyXX_count: [function({g}) { return g.V().hasId(P.within([])).count() }], 
    g_V_hasIdXwithoutXemptyXX_count: [function({g}) { return g.V().hasId(P.without([])).count() }], 
    g_V_notXhasIdXwithinXemptyXXX_count: [function({g}) { return g.V().not(__.hasId(P.within([]))).count() }], 
    g_V_hasIdXnullX: [function({g}) { return g.V().hasId(null) }], 
    g_V_hasIdXeqXnullXX: [function({g}) { return g.V().hasId(P.eq(null)) }], 
    g_V_hasIdX2_nullX: [function({g, vid2}) { return g.V().hasId(vid2, null) }], 
    g_V_hasIdXmarkovar_vadasvarX: [function({g, vid2, vid1}) { return g.V().hasId(vid1, vid2) }], 
    g_V_hasIdX2AsString_nullX: [function({g, vid2}) { return g.V().hasId(vid2, null) }], 
    g_V_hasIdX1AsString_2AsString_nullX: [function({g, vid2, vid1}) { return g.V().hasId(vid1, vid2, null) }], 
    g_V_hasIdXnull_2X: [function({g, vid2}) { return g.V().hasId(null, vid2) }], 
    g_V_hasIdX1X_hasIdX2X: [function({g, vid2, vid1}) { return g.V().hasId(vid1).hasId(vid2) }], 
    g_V_in_hasIdXneqX1XX: [function({g, xx1}) { return g.V().in_().hasId(P.neq(xx1)) }], 
    g_VX1X_out_hasIdX2X: [function({g, vid2, vid1}) { return g.V(vid1).out().hasId(vid2) }], 
    g_VX1X_out_hasXid_2_3X: [function({g, vid3, vid2, vid1}) { return g.V(vid1).out().hasId(vid2, vid3) }], 
    g_VX1X_out_hasXid_2AsString_3AsStringX: [function({g, vid3, vid2, vid1}) { return g.V(vid1).out().hasId(vid2, vid3) }], 
    g_VX1AsStringX_out_hasXid_2AsStringX: [function({g, vid2, vid1}) { return g.V(vid1).out().hasId(vid2) }], 
    g_VX1X_out_hasXid_2_3X_inList: [function({g, xx1, vid1}) { return g.V(vid1).out().hasId(xx1) }], 
    g_V_hasXid_1_2X: [function({g, vid2, vid1}) { return g.V().hasId(vid1, vid2) }], 
    g_V_hasXid_1_2X_inList: [function({g, xx1}) { return g.V().hasId(xx1) }], 
    g_V_both_dedup_properties_hasKeyXageX_value: [function({g}) { return g.V().both().properties().dedup().hasKey("age").value() }], 
    g_V_both_properties_dedup_hasKeyXageX_hasValueXgtX30XX_value: [function({g}) { return g.V().both().properties().dedup().hasKey("age").hasValue(P.gt(30)).value() }, function({g}) { return g.V().both().properties().dedup().hasKey("age").hasValue(P.gt(30)).value() }], 
    g_V_bothE_properties_dedup_hasKeyXweightX_value: [function({g}) { return g.V().bothE().properties().dedup().hasKey("weight").value() }], 
    g_V_bothE_properties_dedup_hasKeyXweightX_hasValueXltX0d3XX_value: [function({g}) { return g.V().bothE().properties().dedup().hasKey("weight").hasValue(P.lt(0.3)).value() }, function({g}) { return g.V().bothE().properties().dedup().hasKey("weight").hasValue(P.lt(0.3)).value() }], 
    g_V_properties_hasKeyXnullX: [function({g}) { return g.V().properties().hasKey(null) }], 
    g_V_properties_hasKeyXnull_nullX: [function({g}) { return g.V().properties().hasKey(null, null) }], 
    g_V_properties_hasKeyXnull_ageX_value: [function({g}) { return g.V().properties().hasKey(null, "age").value() }], 
    g_E_properties_hasKeyXnullX: [function({g}) { return g.E().properties().hasKey(null) }], 
    g_E_properties_hasKeyXnull_nullX: [function({g}) { return g.E().properties().hasKey(null, null) }], 
    g_E_properties_hasKeyXnull_weightX_value: [function({g}) { return g.E().properties().hasKey(null, "weight").value() }], 
    g_EX7X_hasLabelXknowsX: [function({g, eid7}) { return g.E(eid7).hasLabel("knows") }], 
    g_E_hasLabelXknowsX: [function({g}) { return g.E().hasLabel("knows") }], 
    g_E_hasLabelXuses_traversesX: [function({g}) { return g.E().hasLabel("uses", "traverses") }], 
    g_V_hasLabelXperson_software_blahX: [function({g}) { return g.V().hasLabel("person", "software", "blah") }], 
    g_V_hasLabelXperson_softwarevarX: [function({g, xx1}) { return g.V().hasLabel("person", xx1) }], 
    g_V_hasLabelXpersonX_hasLabelXsoftwareX: [function({g}) { return g.V().hasLabel("person").hasLabel("software") }], 
    g_V_hasLabelXpersonvarX_hasLabelXsoftwareX: [function({g, xx1}) { return g.V().hasLabel(xx1).hasLabel("software") }], 
    g_V_hasLabelXpersonvar_softwarevarX: [function({g, xx1, xx2}) { return g.V().hasLabel(xx1, xx2) }], 
    g_V_hasLabelXpersonX_hasXage_notXlteX10X_andXnotXbetweenX11_20XXXX_andXltX29X_orXeqX35XXXX_name: [function({g}) { return g.V().hasLabel("person").has("age", P.not(P.lte(10).and(P.not(P.between(11, 20)))).and(P.lt(29).or(P.eq(35)))).values("name") }], 
    g_V_hasLabelXnullX: [function({g}) { return g.V().hasLabel(null) }], 
    g_V_hasXlabel_nullX: [function({g}) { return g.V().has(T.label, null) }], 
    g_V_hasLabelXnull_nullX: [function({g}) { return g.V().hasLabel(null, null) }], 
    g_V_hasLabelXnull_personX: [function({g}) { return g.V().hasLabel(null, "person") }], 
    g_E_hasLabelXnullX: [function({g}) { return g.E().hasLabel(null) }], 
    g_E_hasXlabel_nullX: [function({g}) { return g.E().has(T.label, null) }], 
    g_V_properties_hasLabelXnullX: [function({g}) { return g.V().properties().hasLabel(null) }], 
    g_V_hasNotXageX_name: [function({g}) { return g.V().hasNot("age").values("name") }], 
    g_V_properties_hasValueXnullX: [function({g}) { return g.V().properties().hasValue(null) }], 
    g_V_properties_hasValueXnull_nullX: [function({g}) { return g.V().properties().hasValue(null, null) }], 
    g_V_properties_hasValueXnull_joshX_value: [function({g}) { return g.V().properties().hasValue(null, "josh").value() }], 
    g_V_valuesXageX_isX32X: [function({g}) { return g.V().values("age").is(32) }], 
    g_V_valuesXageX_isX32varX: [function({g, xx1}) { return g.V().values("age").is(xx1) }], 
    g_V_valuesXageX_isXlte_30X: [function({g}) { return g.V().values("age").is(P.lte(30)) }], 
    g_V_valuesXageX_isXlte_30varX: [function({g, xx1}) { return g.V().values("age").is(P.lte(xx1)) }], 
    g_V_valuesXageX_isXgte_29X_isXlt_34X: [function({g}) { return g.V().values("age").is(P.gte(29)).is(P.lt(34)) }], 
    g_V_valuesXageX_isXgte_29vaarX_isXlt_34varX: [function({g, xx1, xx2}) { return g.V().values("age").is(P.gte(xx1)).is(P.lt(xx2)) }], 
    g_V_whereXinXcreatedX_count_isX1XX_valuesXnameX: [function({g}) { return g.V().where(__.in_("created").count().is(1)).values("name") }], 
    g_V_whereXinXcreatedX_count_isXgte_2XX_valuesXnameX: [function({g}) { return g.V().where(__.in_("created").count().is(P.gte(2))).values("name") }], 
    g_V_valuesXageX_noneXgtX32XX: [function({g}) { return g.V().values("age").none(P.gt(32)) }], 
    g_V_valuesXageX_whereXisXP_gtX33XXX_fold_noneXlteX33XX: [function({g}) { return g.V().values("age").where(__.is(P.gt(33))).fold().none(P.lte(33)) }], 
    g_V_valuesXageX_order_byXdescX_fold_noneXltX10XX: [function({g}) { return g.V().values("age").order().by(Order.desc).fold().none(P.lt(10)) }], 
    g_V_valuesXageX_order_byXdescX_fold_noneXgtX30XX: [function({g}) { return g.V().values("age").order().by(Order.desc).fold().none(P.gt(30)) }], 
    g_injectXabc_bcdX_noneXeqXbcdXX: [function({g}) { return g.inject(["abc", "bcd"]).none(P.eq("bcd")) }], 
    g_injectXbcd_bcdX_noneXeqXabcXX: [function({g}) { return g.inject(["bcd", "bcd"]).none(P.eq("abc")) }], 
    g_injectXnull_bcdX_noneXP_eqXabcXX: [function({g}) { return g.inject([null, "bcd"]).none(P.eq("abc")) }], 
    g_injectX5_8_10_10_7X_noneXltX7XX: [function({g}) { return g.inject([5, 8, 10], [10, 7]).none(P.lt(7)) }], 
    g_injectXnullX_noneXeqXnullXX: [function({g}) { return g.inject(null).none(P.eq(null)) }], 
    g_injectX7X_noneXeqX7XX: [function({g}) { return g.inject(7).none(P.eq(7)) }], 
    g_injectXnull_1_emptyX_noneXeqXnullXX: [function({g}) { return g.inject([null, 1], []).none(P.eq(null)) }], 
    g_injectXnull_nullX_noneXnotXnullXX: [function({g}) { return g.inject([null, null]).none(P.neq(null)) }], 
    g_injectX3_threeX_noneXeqX3XX: [function({g}) { return g.inject([3, "three"]).none(P.eq(3)) }], 
    g_V_notXhasXage_gt_27XX_name: [function({g}) { return g.V().not(__.has("age", P.gt(27))).values("name") }], 
    g_V_notXnotXhasXage_gt_27XXX_name: [function({g}) { return g.V().not(__.not(__.has("age", P.gt(27)))).values("name") }], 
    g_V_notXhasXname_gt_27XX_name: [function({g}) { return g.V().not(__.has("name", P.gt(27))).values("name") }], 
    g_V_orXhasXage_gt_27X__outE_count_gte_2X_name: [function({g}) { return g.V().or(__.has("age", P.gt(27)), __.outE().count().is(P.gte(2))).values("name") }], 
    g_V_orXoutEXknowsX__hasXlabel_softwareX_or_hasXage_gte_35XX_name: [function({g}) { return g.V().or(__.outE("knows"), __.has(T.label, "software").or().has("age", P.gte(35))).values("name") }], 
    g_V_asXaX_orXselectXaX_selectXaXX: [function({g}) { return g.V().as("a").or(__.select("a"), __.select("a")) }], 
    g_VX1X_out_limitX2X: [function({g, vid1}) { return g.V(vid1).out().limit(2) }], 
    g_VX1X_out_limitX2varX: [function({g, xx1, vid1}) { return g.V(vid1).out().limit(xx1) }], 
    g_V_localXoutE_limitX1X_inVX_limitX3X: [function({g}) { return g.V().local(__.outE().limit(1)).inV().limit(3) }], 
    g_VX1X_outXknowsX_outEXcreatedX_rangeX0_1X_inV: [function({g, vid1}) { return g.V(vid1).out("knows").outE("created").range(0, 1).inV() }], 
    g_VX1X_outXknowsX_outXcreatedX_rangeX0_1X: [function({g, vid1}) { return g.V(vid1).out("knows").out("created").range(0, 1) }], 
    g_VX1X_outXcreatedX_inXcreatedX_rangeX1_3X: [function({g, vid1}) { return g.V(vid1).out("created").in_("created").range(1, 3) }], 
    g_VX1X_outXcreatedX_inXcreatedX_rangeX1var_3varX: [function({g, xx1, xx2, vid1}) { return g.V(vid1).out("created").in_("created").range(xx1, xx2) }], 
    g_VX1X_outXcreatedX_inEXcreatedX_rangeX1_3X_outV: [function({g, vid1}) { return g.V(vid1).out("created").inE("created").range(1, 3).outV() }], 
    g_V_repeatXbothX_timesX3X_rangeX5_11X: [function({g}) { return g.V().repeat(__.both()).times(3).range(5, 11) }], 
    g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_2X: [function({g}) { return g.V().as("a").in_().as("b").in_().as("c").select("a", "b", "c").by("name").limit(Scope.local, 2) }], 
    g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_2varX: [function({g, xx1}) { return g.V().as("a").in_().as("b").in_().as("c").select("a", "b", "c").by("name").limit(Scope.local, xx1) }], 
    g_V_asXaX_in_asXbX_in_asXcX_selectXa_b_cX_byXnameX_limitXlocal_1X: [function({g}) { return g.V().as("a").in_().as("b").in_().as("c").select("a", "b", "c").by("name").limit(Scope.local, 1) }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_3X: [function({g}) { return g.V().as("a").out().as("b").out().as("c").select("a", "b", "c").by("name").range(Scope.local, 1, 3) }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1var_3varX: [function({g, xx1, xx2}) { return g.V().as("a").out().as("b").out().as("c").select("a", "b", "c").by("name").range(Scope.local, xx1, xx2) }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_rangeXlocal_1_2X: [function({g}) { return g.V().as("a").out().as("b").out().as("c").select("a", "b", "c").by("name").range(Scope.local, 1, 2) }], 
    g_V_hasLabelXpersonX_order_byXageX_skipX1X_valuesXnameX: [function({g}) { return g.V().hasLabel("person").order().by("age").skip(1).values("name") }], 
    g_V_hasLabelXpersonX_order_byXageX_skipX1varX_valuesXnameX: [function({g, xx1}) { return g.V().hasLabel("person").order().by("age").skip(xx1).values("name") }], 
    g_V_foldX_rangeXlocal_6_7X: [function({g}) { return g.V().fold().range(Scope.local, 6, 7) }], 
    g_V_outE_valuesXweightX_fold_orderXlocalX_skipXlocal_2X: [function({g}) { return g.V().outE().values("weight").fold().order(Scope.local).skip(Scope.local, 2) }], 
    g_V_outE_valuesXweightX_fold_orderXlocalX_skipXlocal_2varX: [function({g, xx1}) { return g.V().outE().values("weight").fold().order(Scope.local).skip(Scope.local, xx1) }], 
    g_V_hasLabelXpersonX_order_byXageX_valuesXnameX_skipX1X: [function({g}) { return g.V().hasLabel("person").order().by("age").values("name").skip(1) }], 
    g_VX1X_valuesXageX_rangeXlocal_20_30X: [function({g, vid1}) { return g.V(vid1).values("age").range(Scope.local, 20, 30) }], 
    g_V_mapXin_hasIdX1XX_limitX2X_valuesXnameX: [function({g, vid1}) { return g.V().map(__.in_().hasId(vid1)).limit(2).values("name") }], 
    g_V_rangeX2_1X: [function({g}) { return g.V().range(2, 1) }], 
    g_V_rangeX3_2X: [function({g}) { return g.V().range(3, 2) }], 
    g_injectXlistX1_2_3XX_rangeXlocal_1_2X: [function({g}) { return g.inject([1, 2, 3]).range(Scope.local, 1, 2) }], 
    g_injectXlistX1_2_3XX_limitXlocal_1X: [function({g}) { return g.inject([1, 2, 3]).limit(Scope.local, 1) }], 
    g_injectXlistX1_2_3X_limitXlocal_1X_unfold: [function({g}) { return g.inject([1, 2, 3]).limit(Scope.local, 1).unfold() }], 
    g_injectX1_2_3_4_5X_limitXlocal_1X: [function({g}) { return g.inject([1, 2], [3, 4, 5]).limit(Scope.local, 1) }], 
    g_injectX1_2_3_4_5_6X_rangeXlocal_1_2X: [function({g}) { return g.inject([1, 2, 3], [4, 5, 6]).range(Scope.local, 1, 2) }], 
    g_VX5X_repeatXlimitX1X_inX_timesX2X_valuesXnameX: [function({g, vid5}) { return g.V(vid5).repeat(__.limit(1).in_()).times(2).values("name") }], 
    g_VX5X_repeatXlimitX1X_inX_untilXloopsXisX2XXX_valuesXnameX: [function({g, vid5}) { return g.V(vid5).repeat(__.limit(1).in_()).until(__.loops().is(2)).values("name") }], 
    g_VX5X_limitX1X_in_limitX1X_in_valuesXnameX: [function({g, vid5}) { return g.V(vid5).limit(1).in_().limit(1).in_().values("name") }], 
    g_VX5X_repeatXlimitX1X_inX_timesX1X_repeatXlimitX1X_inX_timesX1X_valuesXnameX: [function({g, vid5}) { return g.V(vid5).repeat(__.limit(1).in_()).times(1).repeat(__.limit(1).in_()).times(1).values("name") }], 
    g_VX5X_repeatXlimitX1X_in_aggregateXxXX_timesX2X_capXxX: [function({g, vid5}) { return g.V(vid5).repeat(__.limit(1).in_().aggregate("x")).times(2).cap("x") }], 
    g_VX5X_repeatXrangeX0_1X_inX_timesX2X_valuesXnameX: [function({g, vid5}) { return g.V(vid5).repeat(__.range(0, 1).in_()).times(2).values("name") }], 
    g_VX5X_repeatXrangeX0_1X_inX_untilXloopsXisX2XXX_valuesXnameX: [function({g, vid5}) { return g.V(vid5).repeat(__.range(0, 1).in_()).until(__.loops().is(2)).values("name") }], 
    g_VX5X_rangeX0_1X_in_rangeX0_1X_in_valuesXnameX: [function({g, vid5}) { return g.V(vid5).range(0, 1).in_().range(0, 1).in_().values("name") }], 
    g_VX5X_repeatXrangeX0_1X_in_repeatXrangeX0_1X_inX_timesX1XX_timesX1X_valuesXnameX: [function({g, vid5}) { return g.V(vid5).repeat(__.range(0, 1).in_().repeat(__.range(0, 1).in_()).times(1)).times(1).values("name") }], 
    g_VX5X_repeatXrangeX0_1X_in_aggregateXxXX_timesX2X_capXxX: [function({g, vid5}) { return g.V(vid5).repeat(__.range(0, 1).in_().aggregate("x")).times(2).cap("x") }], 
    g_withoutStrategiesXEarlyLimitStrategyX_VX5X_repeatXlimitX1X_in_limitX1X_limitX1XX_timesX2X: [function({g, vid5}) { return g.withoutStrategies(EarlyLimitStrategy).V(vid5).repeat(__.limit(1).in_().limit(1).limit(1)).times(2) }], 
    g_V_repeatXout_whereXhasXnameX_order_byXnameX_limitX1XXX_timesX2X: [function({g}) { return g.V().repeat(__.out().where(__.has("name").order().by("name").limit(1))).times(2) }], 
    g_V_out_whereXhasXnameX_order_byXnameX_limitX1XX_out_whereXhasXnameX_order_byXnameX_limitX1XX: [function({g}) { return g.V().out().where(__.has("name").order().by("name").limit(1)).out().where(__.has("name").order().by("name").limit(1)) }], 
    g_V_hasXnameXJAMXX_repeatXoutXfollowedByX_order_byXnameX_limitX2XX_timesX2X: [function({g}) { return g.V().has("name", "JAM").repeat(__.out("followedBy").order().by("name").limit(2)).times(2) }], 
    g_V_hasXnameXJAMXX_outXfollowedByX_order_byXnameX_limitX2X_outXfollowedByX_order_byXnameX_limitX2X: [function({g}) { return g.V().has("name", "JAM").out("followedBy").order().by("name").limit(2).out("followedBy").order().by("name").limit(2) }], 
    g_V_hasXnameXDRUMSXX_repeatXinXfollowedByX_order_byXnameX_rangeX1_4XX_timesX2X: [function({g}) { return g.V().has("name", "DRUMS").repeat(__.in_("followedBy").order().by("name").range(1, 4)).times(2) }], 
    g_V_hasXnameXDRUMSXX_inXfollowedByX_order_byXnameX_rangeX1_4X_inXfollowedByX_order_byXnameX_rangeX1_4X: [function({g}) { return g.V().has("name", "DRUMS").in_("followedBy").order().by("name").range(1, 4).in_("followedBy").order().by("name").range(1, 4) }], 
    g_V_chooseXvaluesXageX_isXlteX30XX_out_order_byXnameX_limitX1X_out_order_byXnameX_limitX2XX: [function({g}) { return g.V().choose(__.values("age").is(P.lte(30)), __.out().order().by("name").limit(1), __.out().order().by("name").limit(2)) }], 
    g_V_chooseXvaluesXageX_isXlteX30XX_localXout_order_byXnameX_limitX1XX_localXout_order_byXnameX_limitX2XXX: [function({g}) { return g.V().choose(__.values("age").is(P.lte(30)), __.local(__.out().order().by("name").limit(1)), __.local(__.out().order().by("name").limit(2))) }], 
    g_V_hasXnameXHEY_BO_DIDDLEYXX_unionXoutXfollowedByX_order_byXnameX_limitX2X_outXsungByX_order_byXnameX_byXnameX_limitX1XX_unionXoutXfollowedByX_order_limitX2X_outXsungByX_order_byXnameX_limitX1XX: [function({g}) { return g.V().has("name", "HEY BO DIDDLEY").union(__.out("followedBy").order().by("name").limit(2), __.out("sungBy").order().by("name").limit(1)).union(__.out("followedBy").order().by("name").limit(2), __.out("sungBy").order().by("name").limit(1)) }], 
    g_V_hasXnameXHEY_BO_DIDDLEYXX_repeatXunionXoutXfollowedByX_order_byXnameX_limitX2X_outXsungByX_order_byXnameX_limitX1XXX_timesX2X: [function({g}) { return g.V().has("name", "HEY BO DIDDLEY").repeat(__.union(__.out("followedBy").order().by("name").limit(2), __.out("sungBy").order().by("name").limit(1))).times(2) }], 
    g_V_sampleX1X_byXageX_byXT_idX: [function({g}) { return g.V().sample(1).by("age").by(T.id) }], 
    g_E_sampleX1X: [function({g}) { return g.E().sample(1) }], 
    g_E_sampleX2X_byXweightX: [function({g}) { return g.E().sample(2).by("weight") }], 
    g_V_localXoutE_sampleX1X_byXweightXX: [function({g}) { return g.V().local(__.outE().sample(1).by("weight")) }], 
    g_withStrategiesXSeedStrategyX_V_group_byXlabelX_byXbothE_weight_order_sampleX2X_foldXunfold: [function({g}) { return g.withStrategies(new SeedStrategy({seed: 999999})).V().group().by(T.label).by(__.bothE().values("weight").order().sample(2).fold()).unfold() }], 
    g_withStrategiesXSeedStrategyX_V_group_byXlabelX_byXbothE_weight_order_fold_sampleXlocal_5XXunfold: [function({g}) { return g.withStrategies(new SeedStrategy({seed: 999999})).V().group().by(T.label).by(__.bothE().values("weight").order().fold().sample(Scope.local, 5)).unfold() }], 
    g_withStrategiesXSeedStrategyX_V_order_byXlabel_descX_sampleX1X_byXageX: [function({g}) { return g.withStrategies(new SeedStrategy({seed: 999999})).V().order().by(T.label, Order.desc).sample(1).by("age") }], 
    g_VX1X_valuesXageX_sampleXlocal_5X: [function({g, vid1}) { return g.V(vid1).values("age").sample(Scope.local, 5) }], 
    g_V_repeatXsampleX2XX_timesX2X: [function({g}) { return g.V().repeat(__.sample(2)).times(2) }], 
    g_V_sampleX2X_sampleX2X: [function({g}) { return g.V().sample(2).sample(2) }], 
    g_V3_repeatXout_order_byXperformancesX_sampleX2X_aggregateXxXX_untilXloops_isX2XX_capXxX_unfold: [function({g, vid3}) { return g.V(vid3).repeat(__.out().order().by("performances").sample(2).aggregate("x")).until(__.loops().is(2)).cap("x").unfold() }], 
    g_V3_out_order_byXperformancesX_sampleX2X_aggregateXxX_out_order_byXperformancesX_sampleX2X_aggregateXxX_capXxX_unfold: [function({g, vid3}) { return g.V(vid3).out().order().by("performances").sample(2).aggregate("x").out().order().by("performances").sample(2).aggregate("x").cap("x").unfold() }], 
    g_VX1X_outXcreatedX_inXcreatedX_simplePath: [function({g, vid1}) { return g.V(vid1).out("created").in_("created").simplePath() }], 
    g_V_repeatXboth_simplePathX_timesX3X_path: [function({g}) { return g.V().repeat(__.both().simplePath()).times(3).path() }], 
    g_V_asXaX_out_asXbX_out_asXcX_simplePath_byXlabelX_fromXbX_toXcX_path_byXnameX: [function({g}) { return g.V().as("a").out().as("b").out().as("c").simplePath().by(T.label).from_("b").to("c").path().by("name") }], 
    g_injectX0X_V_both_coalesceXhasXname_markoX_both_constantX0XX_simplePath_path: [function({g}) { return g.inject(0).V().both().coalesce(__.has("name", "marko").both(), __.constant(0)).simplePath().path() }], 
    g_V_both_asXaX_both_asXbX_simplePath_path_byXageX__fromXaX_toXbX: [function({g}) { return g.V().both().as("a").both().as("b").simplePath().path().by("age").from_("a").to("b") }], 
    g_V_valuesXnameX_order_tailXglobal_2X: [function({g}) { return g.V().values("name").order().tail(Scope.global, 2) }], 
    g_V_valuesXnameX_order_tailX2X: [function({g}) { return g.V().values("name").order().tail(2) }], 
    g_V_valuesXnameX_order_tailX2varX: [function({g, xx1}) { return g.V().values("name").order().tail(xx1) }], 
    g_V_valuesXnameX_order_tail: [function({g}) { return g.V().values("name").order().tail() }], 
    g_V_valuesXnameX_order_tailX7X: [function({g}) { return g.V().values("name").order().tail(7) }], 
    g_V_repeatXbothX_timesX3X_tailX7X: [function({g}) { return g.V().repeat(__.both()).times(3).tail(7) }], 
    g_V_repeatXin_outX_timesX3X_tailX7X_count: [function({g}) { return g.V().repeat(__.in_().out()).times(3).tail(7).count() }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocal_1X_unfold: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select("a").by(__.unfold().values("name").fold()).tail(Scope.local, 1).unfold() }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXaX_byXunfold_valuesXnameX_foldX_tailXlocalX_unfold: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select("a").by(__.unfold().values("name").fold()).tail(Scope.local).unfold() }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_2X: [function({g}) { return g.V().as("a").out().as("b").out().as("c").select("a", "b", "c").by("name").tail(Scope.local, 2) }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_2varX: [function({g, xx1}) { return g.V().as("a").out().as("b").out().as("c").select("a", "b", "c").by("name").tail(Scope.local, xx1) }], 
    g_V_asXaX_out_asXbX_out_asXcX_selectXa_b_cX_byXnameX_tailXlocal_1X: [function({g}) { return g.V().as("a").out().as("b").out().as("c").select("a", "b", "c").by("name").tail(Scope.local, 1) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_1X_unfold: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed, "a").by(__.unfold().values("name").fold()).tail(Scope.local, 1).unfold() }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocalX_unfold: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed, "a").by(__.unfold().values("name").fold()).tail(Scope.local).unfold() }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXlimitXlocal_0XX_tailXlocal_1X: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed, "a").by(__.limit(Scope.local, 0)).tail(Scope.local, 1) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX_tailXlocal_2X: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed, "a").by(__.unfold().values("name").fold()).tail(Scope.local, 2) }], 
    g_VX1X_valuesXageX_tailXlocal_5X: [function({g, vid1}) { return g.V(vid1).values("age").tail(Scope.local, 50) }], 
    g_injectXlistX1_2_3XX_tailXlocal_1X: [function({g}) { return g.inject([1, 2, 3]).tail(Scope.local, 1) }], 
    g_VX1X_valueMapXnameX_tailXlocal_1X: [function({g, vid1}) { return g.V(vid1).valueMap("name").tail(Scope.local, 1) }], 
    g_injectX1_2_3X_tailXlocal_1X_unfold: [function({g}) { return g.inject([1, 2, 3]).tail(Scope.local, 1).unfold() }], 
    g_injectX1_2_3_4_5_6X_tailXlocal_1X: [function({g}) { return g.inject([1, 2, 3], [4, 5, 6]).tail(Scope.local, 1) }], 
    g_injectX1_2_3_4_5X_tailXlocal_2X: [function({g}) { return g.inject([1, 2, 3, 4, 5]).tail(Scope.local, 2) }], 
    g_V_valuesXnameX_isXtypeOfXGType_STRINGXX: [function({g}) { return g.V().values("name").is(P.typeOf(GType.string)) }], 
    g_V_valuesXnameX_isXtypeOfXjava_lang_StringXX: [function({g}) { return g.V().values("name").is(P.typeOf("String")) }], 
    g_V_hasXname_typeOfXGType_STRINGXX_valuesXnameX: [function({g}) { return g.V().has("name", P.typeOf(GType.string)).values("name") }], 
    g_V_orXhasXname_typeOfXGType_STRINGXX__hasXage_typeOfXGType_INTXXX_valuesXnameX: [function({g}) { return g.V().or(__.has("name", P.typeOf(GType.string)), __.has("age", P.typeOf(GType.int))).values("name") }], 
    g_V_andXhasXname_typeOfXGType_STRINGXX__hasXage_typeOfXGType_INTXXX_valuesXnameX: [function({g}) { return g.V().and(__.has("name", P.typeOf(GType.string)), __.has("age", P.typeOf(GType.int))).values("name") }], 
    g_V_notXhasXage_typeOfXGType_STRINGXXX_valuesXnameX: [function({g}) { return g.V().not(__.has("age", P.typeOf(GType.string))).values("name") }], 
    g_V_valuesXageX_isXnotXtypeOfXGType_STRINGXXX: [function({g}) { return g.V().values("age").is(P.not(P.typeOf(GType.string))) }], 
    g_V_valuesXnameX_isXtypeOfXstringStringXX: [function({g}) { return g.V().values("name").is(P.typeOf("String")) }], 
    g_V_orXvaluesXageX_isXtypeOfXGType_INTXX__valuesXnameX_isXtypeOfXGType_STRINGXXX_count: [function({g}) { return g.V().or(__.values("age").is(P.typeOf(GType.int)), __.values("name").is(P.typeOf(GType.string))).count() }], 
    g_V_whereXvaluesXnameX_isXtypeOfXGType_STRINGXXX_valuesXnameX: [function({g}) { return g.V().where(__.values("name").is(P.typeOf(GType.string))).values("name") }], 
    g_V_whereXvaluesXageX_isXtypeOfXGType_STRINGXXX_count: [function({g}) { return g.V().where(__.values("age").is(P.typeOf(GType.string))).count() }], 
    g_V_whereXnotXvaluesXageX_isXtypeOfXGType_STRINGXXXX_valuesXnameX: [function({g}) { return g.V().where(__.not(__.values("age").is(P.typeOf(GType.string)))).values("name") }], 
    g_V_valuesXageX_isXtypeOfXGType_NULLXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.null)) }], 
    g_V_valuesXageX_isXtypeOfXGType_BOOLEANXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.boolean)) }], 
    g_V_valuesXageX_isXtypeOfXGType_CHARXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.char)) }], 
    g_V_valuesXageX_isXtypeOfXGType_BINARYXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.binary)) }], 
    g_V_valuesXageX_isXtypeOfXGType_UUIDXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.uuid)) }], 
    g_V_valuesXageX_isXtypeOfXGType_DATETIMEXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.datetime)) }], 
    g_V_valuesXageX_isXtypeOfXGType_DURATIONXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.duration)) }], 
    g_V_valuesXageX_isXtypeOfXnon_registered_NameXX: [function({g}) { return g.V().values("age").is(P.typeOf("non-registered-Name")) }], 
    g_injectXtrueX_isXtypeOfXGType_BOOLEANX: [function({g}) { return g.inject(true).is(P.typeOf(GType.boolean)) }], 
    g_V_path_isXtypeOfXGType_PATHXX: [function({g}) { return g.V().hasLabel("person").values("name").path().is(P.typeOf(GType.path)) }], 
    g_V_out_path_isXtypeOfXGType_PATHXX_count: [function({g}) { return g.V().out().path().is(P.typeOf(GType.path)).count() }], 
    g_V_hasXname_markoX_out_out_path_isXtypeOfXGType_PATHXX: [function({g}) { return g.V().has("name", "marko").out().out().path().is(P.typeOf(GType.path)) }], 
    g_V_out_tree_isXtypeOfXGType_TREEXX_count: [function({g}) { return g.V().has("name", "marko").out().tree().is(P.typeOf(GType.tree)).count() }], 
    g_V_whereXtree_isXtypeOfXGType_TREEXXX_values_name: [function({g}) { return g.V().where(__.tree().is(P.typeOf(GType.tree))).values("name") }], 
    g_VX1X_outEXknowsX_subgraphXsgX_name_capXsgX_isXtypeOfXGType_GRAPHXX_count: [function({g}) { return g.V().outE("knows").subgraph("sg").cap("sg").is(P.typeOf(GType.graph)).count() }], 
    g_VX1X_outEXknowsX_subgraphXsgX_name_capXsgX_isX_notXtypeOfXGType_GRAPHXXX_count: [function({g}) { return g.V().outE("knows").subgraph("sg").cap("sg").is(P.not(P.typeOf(GType.graph))).count() }], 
    g_V_valuesXageX_isXtypeOfXGType_PATHXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.path)) }], 
    g_V_valuesXageX_isXtypeOfXGType_TREEXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.tree)) }], 
    g_V_valuesXageX_isXtypeOfXGType_GRAPHXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.graph)) }], 
    g_V_valuesXageX_isXtypeOfXGType_VPROPERTYXX: [function({g}) { return g.V().values("age").is(P.typeOf(GType.vproperty)) }], 
    g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_eqXbXX: [function({g}) { return g.V().has("age").as("a").out().in_().has("age").as("b").select("a", "b").where("a", P.eq("b")) }], 
    g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_neqXbXX: [function({g}) { return g.V().has("age").as("a").out().in_().has("age").as("b").select("a", "b").where("a", P.neq("b")) }], 
    g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXb_hasXname_markoXX: [function({g}) { return g.V().has("age").as("a").out().in_().has("age").as("b").select("a", "b").where(__.as("b").has("name", "marko")) }], 
    g_V_hasXageX_asXaX_out_in_hasXageX_asXbX_selectXa_bX_whereXa_outXknowsX_bX: [function({g}) { return g.V().has("age").as("a").out().in_().has("age").as("b").select("a", "b").where(__.as("a").out("knows").as("b")) }], 
    g_V_asXaX_outXcreatedX_whereXasXaX_name_isXjoshXX_inXcreatedX_name: [function({g}) { return g.V().as("a").out("created").where(__.as("a").values("name").is("josh")).in_("created").values("name") }], 
    g_withSideEffectXa_josh_peterX_VX1X_outXcreatedX_inXcreatedX_name_whereXwithinXaXX: [function({g, vid1}) { return g.withSideEffect("a", ["josh", "peter"]).V(vid1).out("created").in_("created").values("name").where(P.within("a")) }], 
    g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_neqXbXX_name: [function({g, vid1}) { return g.V(vid1).as("a").out("created").in_("created").as("b").where("a", P.neq("b")).values("name") }], 
    g_VX1X_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXasXbX_outXcreatedX_hasXname_rippleXX_valuesXage_nameX: [function({g, vid1}) { return g.V(vid1).as("a").out("created").in_("created").as("b").where(__.as("b").out("created").has("name", "ripple")).values("age", "name") }], 
    g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXeqXaXX_name: [function({g, vid1}) { return g.V(vid1).as("a").out("created").in_("created").where(P.eq("a")).values("name") }], 
    g_VX1X_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_name: [function({g, vid1}) { return g.V(vid1).as("a").out("created").in_("created").where(P.neq("a")).values("name") }], 
    g_VX1X_out_aggregateXxX_out_whereXnotXwithinXaXXX: [function({g, vid1}) { return g.V(vid1).out().aggregate("x").out().where(P.not(P.within("x"))) }], 
    g_withSideEffectXa_g_VX2XX_VX1X_out_whereXneqXaXX: [function({g, vid1}) { return g.V(vid1).out().where(__.id().where(P.neq("a"))) }], 
    g_VX1X_repeatXbothEXcreatedX_whereXwithoutXeXX_aggregateXeX_otherVX_emit_path: [function({g, vid1}) { return g.V(vid1).repeat(__.bothE("created").where(P.without("e")).aggregate("e").otherV()).emit().path() }], 
    g_V_whereXnotXoutXcreatedXXX_name: [function({g}) { return g.V().where(__.not(__.out("created"))).values("name") }], 
    g_V_asXaX_out_asXbX_whereXandXasXaX_outXknowsX_asXbX__orXasXbX_outXcreatedX_hasXname_rippleX__asXbX_inXknowsX_count_isXnotXeqX0XXXXX_selectXa_bX: [function({g}) { return g.V().as("a").out().as("b").where(__.and(__.as("a").out("knows").as("b"), __.or(__.as("b").out("created").has("name", "ripple"), __.as("b").in_("knows").count().is(P.not(P.eq(0)))))).select("a", "b") }], 
    g_V_whereXoutXcreatedX_and_outXknowsX_or_inXknowsXX_valuesXnameX: [function({g}) { return g.V().where(__.out("created").and().out("knows").or().in_("knows")).values("name") }], 
    g_V_asXaX_outXcreatedX_asXbX_whereXandXasXbX_in__notXasXaX_outXcreatedX_hasXname_rippleXXX_selectXa_bX: [function({g}) { return g.V().as("a").out("created").as("b").where(__.and(__.as("b").in_(), __.not(__.as("a").out("created").has("name", "ripple")))).select("a", "b") }], 
    g_V_asXaX_outXcreatedX_asXbX_inXcreatedX_asXcX_bothXknowsX_bothXknowsX_asXdX_whereXc__notXeqXaX_orXeqXdXXXX_selectXa_b_c_dX: [function({g}) { return g.V().as("a").out("created").as("b").in_("created").as("c").both("knows").both("knows").as("d").where("c", P.not(P.eq("a").or(P.eq("d")))).select("a", "b", "c", "d") }], 
    g_V_asXaX_out_asXbX_whereXin_count_isXeqX3XX_or_whereXoutXcreatedX_and_hasXlabel_personXXX_selectXa_bX: [function({g}) { return g.V().as("a").out().as("b").where(__.as("b").in_().count().is(P.eq(3)).or().where(__.as("b").out("created").and().as("b").has(T.label, "person"))).select("a", "b") }], 
    g_V_asXaX_outXcreatedX_inXcreatedX_asXbX_whereXa_gtXbXX_byXageX_selectXa_bX_byXnameX: [function({g}) { return g.V().as("a").out("created").in_("created").as("b").where("a", P.gt("b")).by("age").select("a", "b").by("name") }], 
    g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_whereXa_gtXbX_orXeqXbXXX_byXageX_byXweightX_byXweightX_selectXa_cX_byXnameX: [function({g}) { return g.V().as("a").outE("created").as("b").inV().as("c").where("a", P.gt("b").or(P.eq("b"))).by("age").by("weight").by("weight").select("a", "c").by("name") }], 
    g_V_asXaX_outEXcreatedX_asXbX_inV_asXcX_inXcreatedX_asXdX_whereXa_ltXbX_orXgtXcXX_andXneqXdXXX_byXageX_byXweightX_byXinXcreatedX_valuesXageX_minX_selectXa_c_dX: [function({g}) { return g.V().as("a").outE("created").as("b").inV().as("c").in_("created").as("d").where("a", P.lt("b").or(P.gt("c")).and(P.neq("d"))).by("age").by("weight").by(__.in_("created").values("age").min()).select("a", "c", "d").by("name") }], 
    g_VX1X_asXaX_out_hasXageX_whereXgtXaXX_byXageX_name: [function({g, vid1}) { return g.V(vid1).as("a").out().has("age").where(P.gt("a")).by("age").values("name") }], 
    g_VX3X_asXaX_in_out_asXbX_whereXa_eqXbXX_byXageX_name: [function({g, vid3}) { return g.V(vid3).as("a").in_().out().as("b").where("a", P.eq("b")).by("age").values("name") }], 
    g_withStrategiesXProductiveByStrategyX_VX3X_asXaX_in_out_asXbX_whereXa_eqXbXX_byXageX_name: [function({g, vid3}) { return g.withStrategies(new ProductiveByStrategy()).V(vid3).as("a").in_().out().as("b").where("a", P.eq("b")).by("age").values("name") }], 
    g_V_asXnX_whereXorXhasLabelXsoftwareX_hasLabelXpersonXXX_selectXnX_byXnameX: [function({g}) { return g.V().as("n").where(__.or(__.hasLabel("software"), __.hasLabel("person"))).select("n").by("name") }], 
    g_V_asXnX_whereXorXselectXnX_hasLabelXsoftwareX_selectXnX_hasLabelXpersonXXX_selectXnX_byXnameX: [function({g}) { return g.V().as("n").where(__.or(__.select("n").hasLabel("software"), __.select("n").hasLabel("person"))).select("n").by("name") }], 
    g_V_hasLabelXpersonX_asXxX_whereXinEXknowsX_count_isXgteX1XXX_selectXxX: [function({g}) { return g.V().hasLabel("person").as("x").where(__.inE("knows").count().is(P.gte(1))).select("x") }], 
    get_g_V_whereXage_isXgt_30XX: [function({g}) { return g.V().where(__.values("age").is(P.gt(30))) }], 
    g_V_whereXlabel_isXsoftwareXX: [function({g}) { return g.V().where(__.label().is("software")) }], 
    g_V_whereXlabel_isXpersonXX: [function({g}) { return g.V().where(__.label().is("person")) }], 
    g_withStrategiesXAdjacentToIncidentStrategyX_V: [function({g}) { return g.withStrategies(new AdjacentToIncidentStrategy()).V() }], 
    g_withoutStrategiesXAdjacentToIncidentStrategyX_V: [function({g}) { return g.withoutStrategies(AdjacentToIncidentStrategy).V() }], 
    g_withStrategiesXAdjacentToIncidentStrategyX_V_out_count: [function({g}) { return g.withStrategies(new AdjacentToIncidentStrategy()).V().out().count() }], 
    g_withStrategiesXAdjacentToIncidentStrategyX_V_whereXoutX: [function({g}) { return g.withStrategies(new AdjacentToIncidentStrategy()).V().where(__.out()) }], 
    g_withStrategiesXByModulatorOptimizationStrategyX_V_order_byXvaluesXnameXX: [function({g}) { return g.withStrategies(new ByModulatorOptimizationStrategy()).V().order().by(__.values("name")) }], 
    g_withoutStrategiesXByModulatorOptimizationStrategyX_V_order_byXvaluesXnameXX: [function({g}) { return g.withoutStrategies(ByModulatorOptimizationStrategy).V().order().by(__.values("name")) }], 
    g_withStrategiesXComputerFinalizationStrategyX_V: [function({g}) { return g.withStrategies(new ComputerFinalizationStrategy()).V() }], 
    g_withoutStrategiesXByModulatorOptimizationStrategyX_V: [function({g}) { return g.withoutStrategies(ComputerFinalizationStrategy).V() }], 
    g_withStrategiesXComputerVerificationStrategyX_V: [function({g}) { return g.withStrategies(new ComputerVerificationStrategy()).V() }], 
    g_withoutStrategiesXComputerVerificationStrategyX_V: [function({g}) { return g.withoutStrategies(ComputerVerificationStrategy).V() }], 
    g_withStrategiesXConnectiveStrategyStrategyX_V_hasXname_markoX_or_whereXinXknowsX_hasXname_markoXX: [function({g}) { return g.withStrategies(new ConnectiveStrategy()).V().has("name", "marko").or().where(__.in_("knows").has("name", "marko")) }], 
    g_withoutStrategiesXConnectiveStrategyX_V_hasXname_markoX_or_whereXinXknowsX_hasXname_markoXX: [function({g}) { return g.withoutStrategies(ConnectiveStrategy).V().has("name", "marko").or().where(__.in_("knows").has("name", "marko")) }], 
    g_withStrategiesXCountStrategyX_V_whereXoutE_count_isX0XX: [function({g}) { return g.withStrategies(new CountStrategy()).V().where(__.outE().count().is(0)) }], 
    g_withoutStrategiesXCountStrategyX_V_whereXoutE_count_isX0XX: [function({g}) { return g.withoutStrategies(CountStrategy).V().where(__.outE().count().is(0)) }], 
    g_withStrategiesXEarlyLimitStrategyX_V_out_order_byXnameX_valueMap_limitX3X_selectXnameX: [function({g}) { return g.withStrategies(new EarlyLimitStrategy()).V().out().order().by("name").valueMap().limit(3).select("name") }], 
    g_withoutStrategiesXEarlyLimitStrategyX_V_out_order_byXnameX_valueMap_limitX3X_selectXnameX: [function({g}) { return g.withoutStrategies(EarlyLimitStrategy).V().out().order().by("name").valueMap().limit(3).select("name") }], 
    g_withStrategiesXEdgeLabelVerificationStrategyXthrowException_true_logWarning_falseXX_V: [function({g}) { return g.withStrategies(new EdgeLabelVerificationStrategy({throwException: true, logWarning: false})).V().out() }], 
    g_withStrategiesXEdgeLabelVerificationStrategyXthrowException_false_logWarning_falseXX_V: [function({g}) { return g.withStrategies(new EdgeLabelVerificationStrategy({throwException: false, logWarning: false})).V().out() }], 
    g_withoutStrategiesXEdgeLabelVerificationStrategyX_V: [function({g}) { return g.withoutStrategies(EdgeLabelVerificationStrategy).V().out() }], 
    g_withStrategiesXElementIdStrategyX_V: [function({g}) { return g.withStrategies(new ElementIdStrategy()).V() }], 
    g_withoutStrategiesXElementIdStrategyX_V: [function({g}) { return g.withoutStrategies(ElementIdStrategy).V() }], 
    g_withStrategiesXFilterRankingStrategyX_V_out_order_dedup: [function({g}) { return g.withStrategies(new FilterRankingStrategy()).V().out().order().dedup() }], 
    g_withoutStrategiesXFilterRankingStrategyX_V_out_order_dedup: [function({g}) { return g.withoutStrategies(FilterRankingStrategy).V().out().order().dedup() }], 
    g_withStrategiesXGraphFilterStrategyX_V: [function({g}) { return g.withStrategies(new GraphFilterStrategy()).V() }], 
    g_withoutStrategiesXGraphFilterStrategyX_V: [function({g}) { return g.withoutStrategies(GraphFilterStrategy).V() }], 
    g_withStrategiesXHaltedTraverserStrategyXDetachedFactoryXX_V: [function({g}) { return g.withStrategies(new HaltedTraverserStrategy({haltedTraverserFactory: "org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory"})).V() }], 
    g_withStrategiesXHaltedTraverserStrategyXReferenceFactoryXX_V: [function({g}) { return g.withStrategies(new HaltedTraverserStrategy({haltedTraverserFactory: "org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory"})).V() }], 
    g_withoutStrategiesXHaltedTraverserStrategyX_V: [function({g}) { return g.withoutStrategies(HaltedTraverserStrategy).V() }], 
    g_withStrategiesXIdentityRemovalStrategyX_V_identity_out: [function({g}) { return g.withStrategies(new IdentityRemovalStrategy()).V().identity().out() }], 
    g_withoutStrategiesXIdentityRemovalStrategyX_V_identity_out: [function({g}) { return g.withoutStrategies(IdentityRemovalStrategy).V().identity().out() }], 
    g_withStrategiesXIncidentToAdjacentStrategyX_V_outE_inV: [function({g}) { return g.withStrategies(new IncidentToAdjacentStrategy()).V().outE().inV() }], 
    g_withoutStrategiesXIncidentToAdjacentStrategyX_V_outE_inV: [function({g}) { return g.withoutStrategies(IncidentToAdjacentStrategy).V().outE().inV() }], 
    g_withStrategiesXInlineFilterStrategyX_V_filterXhasXname_markoXX: [function({g}) { return g.withStrategies(new InlineFilterStrategy()).V().filter(__.has("name", "marko")) }], 
    g_withoutStrategiesXInlineFilterStrategyX_V_filterXhasXname_markoXX: [function({g}) { return g.withoutStrategies(InlineFilterStrategy).V().filter(__.has("name", "marko")) }], 
    g_withStrategiesXLambdaRestrictionStrategyX_V: [function({g}) { return g.withStrategies(new LambdaRestrictionStrategy()).V() }], 
    g_withoutStrategiesXLambdaRestrictionStrategyX_V: [function({g}) { return g.withoutStrategies(LambdaRestrictionStrategy).V() }], 
    g_withStrategiesXLazyBarrierStrategyX_V_out_bothE_count: [function({g}) { return g.withStrategies(new LazyBarrierStrategy()).V().out().bothE().count() }], 
    g_withoutStrategiesXLazyBarrierStrategyX_V_out_bothE_count: [function({g}) { return g.withoutStrategies(LazyBarrierStrategy).V().out().bothE().count() }], 
    g_withStrategiesXMatchAlgorithmStrategyXmatchAlgorithm_CountMatchAlgorithmXX_V_matchXa_knows_b__a_created_cX: [function({g}) { return g.withStrategies(new MatchAlgorithmStrategy({matchAlgorithm: "org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep$CountMatchAlgorithm"})).V().match(__.as("a").out("knows").as("b"), __.as("a").out("created").as("c")) }], 
    g_withStrategiesXMatchAlgorithmStrategyXmatchAlgorithm_GreedyMatchAlgorithmXX_V_matchXa_knows_b__a_created_cX: [function({g}) { return g.withStrategies(new MatchAlgorithmStrategy({matchAlgorithm: "org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep$GreedyMatchAlgorithm"})).V().match(__.as("a").out("knows").as("b"), __.as("a").out("created").as("c")) }], 
    g_withoutStrategiesXMatchAlgorithmStrategyX_V_matchXa_knows_b__a_created_cX: [function({g}) { return g.withoutStrategies(MatchAlgorithmStrategy).V().match(__.as("a").out("knows").as("b"), __.as("a").out("created").as("c")) }], 
    g_withStrategiesXMatchPredicateStrategyX_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX: [function({g}) { return g.withStrategies(new MatchPredicateStrategy()).V().match(__.as("a").out("created").has("name", "lop").as("b"), __.as("b").in_("created").has("age", 29).as("c")).where(__.as("c").repeat(__.out()).times(2)).select("a", "b", "c") }], 
    g_withoutStrategiesXMatchPredicateStrategyX_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX: [function({g}) { return g.withoutStrategies(MatchPredicateStrategy).V().match(__.as("a").out("created").has("name", "lop").as("b"), __.as("b").in_("created").has("age", 29).as("c")).where(__.as("c").repeat(__.out()).times(2)).select("a", "b", "c") }], 
    g_withStrategiesXMessagePassingReductionStrategyX_V: [function({g}) { return g.withStrategies(new MessagePassingReductionStrategy()).V() }], 
    g_withoutStrategiesXMessagePassingReductionStrategyX_V: [function({g}) { return g.withoutStrategies(MessagePassingReductionStrategy).V() }], 
    g_V_coworker: [function({g}) { return g.V().hasLabel("person").filter(__.outE("created")).aggregate("p").as("p1").values("name").as("p1n").select("p").unfold().where(P.neq("p1")).as("p2").values("name").as("p2n").select("p2").out("created").choose(__.in_("created").where(P.eq("p1")), __.values("name"), __.constant([])).group().by(__.select("p1n")).by(__.group().by(__.select("p2n")).by(__.unfold().fold().project("numCoCreated", "coCreated").by(__.count(Scope.local)).by())).unfold() }], 
    g_V_coworker_with_midV: [function({g}) { return g.V().hasLabel("person").filter(__.outE("created")).as("p1").V().hasLabel("person").where(P.neq("p1")).filter(__.outE("created")).as("p2").map(__.out("created").where(__.in_("created").as("p1")).values("name").fold()).group().by(__.select("p1").by("name")).by(__.group().by(__.select("p2").by("name")).by(__.project("numCoCreated", "coCreated").by(__.count(Scope.local)).by())).unfold() }], 
    g_withStrategiesXOptionsStrategyX_V: [function({g}) { return g.withStrategies(new OptionsStrategy()).V() }], 
    g_withStrategiesXOptionsStrategyXmyVar_myValueXX_V: [function({g}) { return g.withStrategies(new OptionsStrategy({myVar: "myValue"})).V() }], 
    g_withoutStrategiesXOptionsStrategyX_V: [function({g}) { return g.withoutStrategies(OptionsStrategy).V() }], 
    g_withStrategiesXOrderLimitStrategyX_V: [function({g}) { return g.withStrategies(new OrderLimitStrategy()).V() }], 
    g_withoutStrategiesXOrderLimitStrategyX_V: [function({g}) { return g.withoutStrategies(OrderLimitStrategy).V() }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").addV("person").property("_partition", "b").property("name", "bob") }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).V().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").addV("person").property("_partition", "b").property("name", "bob") }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a", "b"]})).V().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").addV("person").property("_partition", "b").property("name", "bob") }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["c"]})).V().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_bothE_weight: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).V().bothE().values("weight") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_bothE_weight: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["b"]})).V().bothE().values("weight") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_bothE_dedup_weight: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a", "b"]})).V().bothE().dedup().values("weight") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_bothE_weight: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["c"]})).V().bothE().values("weight") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_both_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).V().both().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_both_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["b"]})).V().both().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_both_dedup_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a", "b"]})).V().both().dedup().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_both_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["c"]})).V().both().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_V_out_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).V().out().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_bXX_V_in_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["b"]})).V().in_().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_a_bXX_V_out_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a", "b"]})).V().out().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_cXX_V_out_name: [function({g}) { return g.addV("person").property("_partition", "a").property("name", "alice").as("a").addV("person").property("_partition", "b").property("name", "bob").as("b").addE("knows").from_("a").to("b").property("_partition", "a").property("weight", 1.0).addE("knows").from_("b").to("a").property("_partition", "b").property("weight", 2.0) }, function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["c"]})).V().out().values("name") }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_addVXpersonX_propertyXname_aliceX_addXselfX: [function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).addV("person").property("name", "alice").addE("self") }, function({g}) { return g.V().has("person", "name", "alice").has("_partition", "a") }, function({g}) { return g.V() }, function({g}) { return g.E().has("_partition", "a") }, function({g}) { return g.E() }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectXzeroX_addVXpersonX_propertyXname_aliceX_addXselfX: [function({g}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).inject(0).addV("person").property("name", "alice").addE("self") }, function({g}) { return g.V().has("person", "name", "alice").has("_partition", "a") }, function({g}) { return g.V() }, function({g}) { return g.E().has("_partition", "a") }, function({g}) { return g.E() }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeV: [function({g, xx1}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).mergeV(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "alice").has("_partition", "a") }, function({g, xx1}) { return g.V() }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0X_mergeV: [function({g, xx1}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).inject(0).mergeV(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "alice").has("_partition", "a") }, function({g, xx1}) { return g.V() }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeE: [function({g, xx1}) { return g.addV("person").property("_partition", "a").property("name", "alice").addV("person").property("_partition", "a").property("name", "bob") }, function({g, xx1}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).mergeE(xx1) }, function({g, xx1}) { return g.E().has("knows", "_partition", "a") }, function({g, xx1}) { return g.E() }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0XmergeE: [function({g, xx1}) { return g.addV("person").property("_partition", "a").property("name", "alice").addV("person").property("_partition", "a").property("name", "bob") }, function({g, xx1}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).inject(0).mergeE(xx1) }, function({g, xx1}) { return g.E().has("knows", "_partition", "a") }, function({g, xx1}) { return g.E() }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeVXlabel_person_name_aliceX_optionXonMatch_name_bobX: [function({g, xx1, xx2}) { return g.addV("person").property("_partition", "a").property("name", "alice").addV("person").property("_partition", "b").property("name", "alice") }, function({g, xx1, xx2}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).mergeV(xx1).option(Merge.onMatch, xx2) }, function({g, xx1, xx2}) { return g.V().has("person", "name", "bob").has("_partition", "a") }, function({g, xx1, xx2}) { return g.V() }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_mergeV_optionXonCreateX: [function({g, xx1, xx2}) { return g.addV("person").property("_partition", "b").property("name", "alice") }, function({g, xx1, xx2}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).mergeV(xx1).option(Merge.onCreate, xx2) }, function({g, xx1, xx2}) { return g.V().has("name", "alice").has("age", 35).has("_partition", "a") }, function({g, xx1, xx2}) { return g.V() }], 
    g_withStrategiesXPartitionStrategyXwrite_a_read_aXX_injectX0X__mergeV_optionXonCreateX: [function({g, xx1, xx2}) { return g.addV("person").property("_partition", "b").property("name", "alice") }, function({g, xx1, xx2}) { return g.withStrategies(new PartitionStrategy({partitionKey: "_partition", writePartition: "a", readPartitions: ["a"]})).inject(0).mergeV(xx1).option(Merge.onCreate, xx2) }, function({g, xx1, xx2}) { return g.V().has("name", "alice").has("age", 35).has("_partition", "a") }, function({g, xx1, xx2}) { return g.V() }], 
    g_withStrategiesXPathProcessorStrategyX_V_asXaX_selectXaX_byXvaluesXnameXX: [function({g}) { return g.withStrategies(new PathProcessorStrategy()).V().as("a").select("a").by(__.values("name")) }], 
    g_withoutStrategiesXPathProcessorStrategyX_V_asXaX_selectXaX_byXvaluesXnameXX: [function({g}) { return g.withoutStrategies(PathProcessorStrategy).V().as("a").select("a").by(__.values("name")) }], 
    g_withStrategiesXPathRetractionStrategyX_V: [function({g}) { return g.withStrategies(new PathRetractionStrategy()).V() }], 
    g_withoutStrategiesXPathRetractionStrategyX_V: [function({g}) { return g.withoutStrategies(PathRetractionStrategy).V() }], 
    g_V_shortestpath: [function({g}) { return g.V().as("v").both().as("v").project("src", "tgt", "p").by(__.select(Pop.first, "v")).by(__.select(Pop.last, "v")).by(__.select(Pop.all, "v")).as("triple").group("x").by(__.select("src", "tgt")).by(__.select("p").fold()).select("tgt").barrier().repeat(__.both().as("v").project("src", "tgt", "p").by(__.select(Pop.first, "v")).by(__.select(Pop.last, "v")).by(__.select(Pop.all, "v")).as("t").filter(__.select(Pop.all, "p").count(Scope.local).as("l").select(Pop.last, "t").select(Pop.all, "p").dedup(Scope.local).count(Scope.local).where(P.eq("l"))).where("src", P.neq("tgt")).select(Pop.last, "t").not(__.select(Pop.all, "p").as("p").count(Scope.local).as("l").select(Pop.all, "x").unfold().filter(__.select(Column.keys).where(P.eq("t")).by(__.select("src", "tgt"))).filter(__.select(Column.values).unfold().or(__.count(Scope.local).where(P.lt("l")), __.where(P.eq("p"))))).barrier().group("x").by(__.select("src", "tgt")).by(__.select(Pop.all, "p").fold()).select("tgt").barrier()).cap("x").select(Column.values).unfold().unfold().map(__.unfold().values("name").fold()) }], 
    g_V_playlist_paths: [function({g}) { return g.withStrategies(new SeedStrategy({seed: 99999})).V().has("name", "Bob_Dylan").in_("sungBy").as("a").repeat(__.out().order().by(Order.shuffle).simplePath().from_("a")).until(__.out("writtenBy").has("name", "Johnny_Cash")).limit(1).as("b").repeat(__.out().order().by(Order.shuffle).as("c").simplePath().from_("b").to("c")).until(__.out("sungBy").has("name", "Grateful_Dead")).limit(1).path().from_("a").unfold().project("song", "artists").by("name").by(__.coalesce(__.out("sungBy", "writtenBy").dedup().values("name"), __.constant("Unknown")).fold()) }], 
    g_withStrategiesXProductiveByStrategyX_V_group_byXageX_byXnameX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().group().by("age").by("name") }], 
    g_withoutStrategiesXProductiveByStrategyX_V_group_byXageX_byXnameX: [function({g}) { return g.withoutStrategies(ProductiveByStrategy).V().group().by("age").by("name") }], 
    g_withStrategiesXProfileStrategyX_V: [function({g}) { return g.withStrategies(new ProfileStrategy()).V() }], 
    g_withoutStrategiesXProfileStrategyX_V: [function({g}) { return g.withoutStrategies(ProfileStrategy).V() }], 
    g_withStrategiesXReadOnlyStrategyX_V: [function({g}) { return g.withStrategies(new ReadOnlyStrategy()).V() }], 
    g_withStrategiesXReadOnlyStrategyX_V_outXknowsX_name: [function({g}) { return g.withStrategies(new ReadOnlyStrategy()).V().out("knows").values("name") }], 
    g_withStrategiesXReadOnlyStrategyX_addVXpersonX: [function({g}) { return g.withStrategies(new ReadOnlyStrategy()).addV("person") }], 
    g_withStrategiesXReadOnlyStrategyX_addVXpersonX_fromXVX1XX_toXVX2XX: [function({g, vid2, vid1}) { return g.withStrategies(new ReadOnlyStrategy()).addE("link").from_(__.V(vid1)).to(__.V(vid2)) }], 
    g_withStrategiesXReadOnlyStrategyX_V_addVXpersonX_fromXVX1XX: [function({g, vid1}) { return g.withStrategies(new ReadOnlyStrategy()).V().addE("link").from_(__.V(vid1)) }], 
    g_withStrategiesXReadOnlyStrategyX_V_propertyXname_joshX: [function({g}) { return g.withStrategies(new ReadOnlyStrategy()).V().property("name", "josh") }], 
    g_withStrategiesXReadOnlyStrategyX_E_propertyXweight_0X: [function({g}) { return g.withStrategies(new ReadOnlyStrategy()).E().property("weight", 0) }], 
    g_V_classic_recommendation: [function({g}) { return g.V().has("name", "DARK STAR").as("a").out("followedBy").aggregate("stash").in_("followedBy").where(P.neq("a").and(P.not(P.within("stash")))).groupCount().unfold().project("x", "y", "z").by(__.select(Column.keys).values("name")).by(__.select(Column.keys).values("performances")).by(__.select(Column.values)).order().by(__.select("z"), Order.desc).by(__.select("y"), Order.asc).limit(5).local(__.aggregate("m")).select("x") }], 
    g_V_classic_recommendation_ranked: [function({g}) { return g.V().has("name", "DARK STAR").as("a").out("followedBy").aggregate("stash").in_("followedBy").where(P.neq("a").and(P.not(P.within("stash")))).groupCount().unfold().project("x", "y", "z").by(__.select(Column.keys).values("name")).by(__.select(Column.keys).values("performances")).by(__.select(Column.values)).order().by(__.select("z"), Order.desc).by(__.select("y"), Order.asc).limit(5).local(__.aggregate("m")) }], 
    g_withStrategiesXReferenceElementStrategyX_V: [function({g}) { return g.withStrategies(new ReferenceElementStrategy()).V() }], 
    g_withoutStrategiesXReferenceElementStrategyX_V: [function({g}) { return g.withoutStrategies(ReferenceElementStrategy).V() }], 
    g_withStrategiesXRepeatUnrollStrategyX_V_repeatXoutX_timesX2X: [function({g}) { return g.withStrategies(new RepeatUnrollStrategy()).V().repeat(__.out()).times(2) }], 
    g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXoutX_timesX2X: [function({g}) { return g.withoutStrategies(RepeatUnrollStrategy).V().repeat(__.out()).times(2) }], 
    g_withStrategiesXRepeatUnrollStrategyX_V_repeatXinX_timesX2X: [function({g}) { return g.withStrategies(new RepeatUnrollStrategy()).V().repeat(__.in_()).times(2) }], 
    g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXinX_timesX2X: [function({g}) { return g.withoutStrategies(RepeatUnrollStrategy).V().repeat(__.in_()).times(2) }], 
    g_withStrategiesXRepeatUnrollStrategyX_V_repeatXout_hasXname_notStartingWithXzXXX_timesX2X: [function({g}) { return g.withStrategies(new RepeatUnrollStrategy()).V().repeat(__.out().has("name", TextP.notStartingWith("z"))).times(2) }], 
    g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXout_hasXname_notStartingWithXzXXX_timesX2X: [function({g}) { return g.withoutStrategies(RepeatUnrollStrategy).V().repeat(__.out().has("name", TextP.notStartingWith("z"))).times(2) }], 
    g_withStrategiesXRepeatUnrollStrategyX_V_repeatXin_hasXage_gtX20XXX_timesX2X: [function({g}) { return g.withStrategies(new RepeatUnrollStrategy()).V().repeat(__.in_().has("age", P.gt(20))).times(2) }], 
    g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXin_hasXage_gtX20XXX_timesX2X: [function({g}) { return g.withoutStrategies(RepeatUnrollStrategy).V().repeat(__.in_().has("age", P.gt(20))).times(2) }], 
    g_withStrategiesXRepeatUnrollStrategyX_V_repeatXboth_hasXage_ltX30XXX_timesX2X: [function({g}) { return g.withStrategies(new RepeatUnrollStrategy()).V().repeat(__.both().has("age", P.lt(30))).times(2) }], 
    g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXboth_hasXage_ltX30XXX_timesX2X: [function({g}) { return g.withoutStrategies(RepeatUnrollStrategy).V().repeat(__.both().has("age", P.lt(30))).times(2) }], 
    g_withStrategiesXRepeatUnrollStrategyX_V_repeatXbothE_otherV_hasXage_ltX30XXX_timesX2X: [function({g}) { return g.withStrategies(new RepeatUnrollStrategy()).V().repeat(__.bothE().otherV().has("age", P.lt(30))).times(2) }], 
    g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXbothE_otherV_hasXage_ltX30XXX_timesX2X: [function({g}) { return g.withoutStrategies(RepeatUnrollStrategy).V().repeat(__.bothE().otherV().has("age", P.lt(30))).times(2) }], 
    g_withStrategiesXRepeatUnrollStrategyX_V_repeatXboth_limitX1XX_timesX2X: [function({g}) { return g.withStrategies(new RepeatUnrollStrategy()).V().repeat(__.both().limit(1)).times(2) }], 
    g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXboth_limitX1XX_timesX2X: [function({g}) { return g.withoutStrategies(RepeatUnrollStrategy).V().repeat(__.both().limit(1)).times(2) }], 
    g_withStrategiesXRepeatUnrollStrategyX_V_order_byXnameX_repeatXboth_order_byXnameX_aggregateXxXX_timesX2X_limitX10X: [function({g}) { return g.withStrategies(new RepeatUnrollStrategy()).V().order().by("name").repeat(__.both().order().by("name").aggregate("x")).times(2).limit(10) }], 
    g_withoutStrategiesXRepeatUnrollStrategyX_V_order_byXnameX_repeatXboth_order_byXnameX_aggregateXxXX_timesX2X_limitX10X: [function({g}) { return g.withoutStrategies(RepeatUnrollStrategy).V().order().by("name").repeat(__.both().order().by("name").aggregate("x")).times(2).limit(10) }], 
    g_withStrategiesXRepeatUnrollStrategyX_V_repeatXboth_sampleX1XX_timesX2X: [function({g}) { return g.withStrategies(new RepeatUnrollStrategy()).V().repeat(__.both().sample(1)).times(2) }], 
    g_withoutStrategiesXRepeatUnrollStrategyX_V_repeatXboth_sampleX1XX_timesX2X: [function({g}) { return g.withoutStrategies(RepeatUnrollStrategy).V().repeat(__.both().sample(1)).times(2) }], 
    g_withStrategiesXReservedKeysVerificationStrategyXthrowException_trueXX_addVXpersonX_propertyXid_123X_propertyXname_markoX: [function({g}) { return g.withStrategies(new ReservedKeysVerificationStrategy({throwException: true})).addV("person").property("id", 123).property("name", "marko") }], 
    g_withStrategiesXReservedKeysVerificationStrategyXthrowException_trueXX_addVXpersonX_propertyXage_29X_propertyXname_markoX: [function({g}) { return g.withStrategies(new ReservedKeysVerificationStrategy({throwException: true, keys: new Set(["age"])})).addV("person").property("age", 29).property("name", "marko") }], 
    g_withoutStrategiesXReservedKeysVerificationStrategyX_addVXpersonX_propertyXid_123X_propertyXname_markoX: [function({g}) { return g.withoutStrategies(ReservedKeysVerificationStrategy).addV("person").property("id", 123).property("name", "marko").values() }], 
    g_withoutStrategiesXSeedStrategyX_V: [function({g}) { return g.withoutStrategies(SeedStrategy).V() }], 
    g_withStrategiesXStandardVerificationStrategyX_V: [function({g}) { return g.withStrategies(new StandardVerificationStrategy()).V() }], 
    g_withoutStrategiesXStandardVerificationStrategyX_V: [function({g}) { return g.withoutStrategies(StandardVerificationStrategy).V() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_V: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).V() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_E: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).E() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_outE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).V(vid4).outE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_inE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).V(vid4).inE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_out: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).V(vid4).out() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_in: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).V(vid4).in_() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_both: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).V(vid4).both() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_bothE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).V(vid4).bothE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_VX4X_localXbothE_limitX1XX: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).V(vid4).local(__.bothE().limit(1)) }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_EX11X_bothV: [function({g, eid11}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).E(eid11).bothV() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphAXX_EX12X_bothV: [function({g, eid12}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple"))})).E(eid12).bothV() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_V: [function({g}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).V() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_E: [function({g}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).E() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_outE: [function({g, vid1}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).V(vid1).outE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_out: [function({g, vid1}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).V(vid1).out() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX1X_outXcreatedX: [function({g, vid1}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).V(vid1).out("knows") }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outXcreatedX: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).out("created") }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).outE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_out: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).out() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_bothE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).bothE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_both: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).both() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphBXX_VX4X_outV_outE: [function({g, eid8}) { return g.withStrategies(new SubgraphStrategy({edges: __.or(__.has("weight", 1.0).hasLabel("knows"), __.has("weight", 0.4).hasLabel("created").outV().has("name", "marko"), __.has("weight", 1.0).hasLabel("created"))})).E(eid8).outV().outE() }], 
    g_withStrategiesXSubgraphStrategyXvertices_inXknowsX_hasXname_markoXXX_V_name: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.in_("knows").has("name", "marko")})).V().values("name") }], 
    g_withStrategiesXSubgraphStrategyXvertices_in_hasXname_markoXXX_V_name: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.in_().has("name", "marko")})).V().values("name") }], 
    g_withStrategiesXSubgraphStrategyXvertices_inXknowsX_whereXoutXcreatedX_hasXname_lopXXXX_V_name: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.in_("knows").where(__.out("created").has("name", "lop"))})).V().values("name") }], 
    g_withStrategiesXSubgraphStrategyXvertices_in_hasXname_markoX_outXcreatedX_hasXname_lopXXXX_V_name: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.in_().where(__.has("name", "marko").out("created").has("name", "lop"))})).V().values("name") }], 
    g_withStrategiesXSubgraphStrategyXvertices_orXboth_hasXname_markoX_hasXname_markoXXXX_V_name: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.or(__.both().has("name", "marko"), __.has("name", "marko"))})).V().where(__.bothE().count().is(P.neq(0))).values("name") }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_V: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_E: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_outE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).outE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_inE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).inE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_out: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).out() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_in: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).in_() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_both: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).both() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_bothE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).bothE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_VX4X_localXbothE_limitX1XX: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).local(__.bothE().limit(1)) }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX11X_bothV: [function({g, eid11}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E(eid11).bothV() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX12X_bothV: [function({g, eid12}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E(eid12).bothV() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphCXX_EX9X_bothV: [function({g, eid9}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E(eid9).bothV() }], 
    g_withStrategiesXSubgraphStrategyXvertices_hasXname_withinXripple_josh_markoXXX_V_asXaX_out_in_asXbX_dedupXa_bX_name: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertices: __.has("name", P.within("ripple", "josh", "marko"))})).V().as("a").out().in_().as("b").dedup("a", "b").values("name") }], 
    g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_propertiesXlocationX_value: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertexProperties: __.has("startTime", P.gt(2005))})).V().properties("location").value() }], 
    g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_valuesXlocationX: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertexProperties: __.has("startTime", P.gt(2005))})).V().values("location") }], 
    g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_asXaX_propertiesXlocationX_asXbX_selectXaX_outE_properties_selectXbX_value_dedup: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertexProperties: __.has("startTime", P.gt(2005))})).V().as("a").properties("location").as("b").select("a").outE().properties().select("b").value().dedup() }], 
    g_withStrategiesXSubgraphStrategyXvertexProperties_hasXstartTime_gtX2005XXXX_V_asXaX_valuesXlocationX_asXbX_selectXaX_outE_properties_selectXbX_dedup: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertexProperties: __.has("startTime", P.gt(2005))})).V().as("a").values("location").as("b").select("a").outE().properties().select("b").dedup() }], 
    g_withStrategiesXSubgraphStrategyXvertices_hasXname_neqXstephenXX_vertexProperties_hasXstartTime_gtX2005XXXX_V_propertiesXlocationX_value: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertexProperties: __.has("startTime", P.gt(2005)), vertices: __.has("name", P.neq("stephen"))})).V().properties("location").value() }], 
    g_withStrategiesXSubgraphStrategyXvertices_hasXname_neqXstephenXX_vertexProperties_hasXstartTime_gtX2005XXXX_V_valuesXlocationX: [function({g}) { return g.withStrategies(new SubgraphStrategy({vertexProperties: __.has("startTime", P.gt(2005)), vertices: __.has("name", P.neq("stephen"))})).V().values("location") }], 
    g_withStrategiesXSubgraphStrategyXedges_hasLabelXusesX_hasXskill_5XXX_V_outE_valueMap_selectXvaluesX_unfold: [function({g}) { return g.withStrategies(new SubgraphStrategy({edges: __.hasLabel("uses").has("skill", 5)})).V().outE().valueMap().select(Column.values).unfold() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_V: [function({g}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_E: [function({g}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E() }], 
    g_withStrategiesXSubgraphStrategyXcheckAdjacentVertices_subgraphDXX_E: [function({g}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: true, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_outE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).outE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_inE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).inE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_out: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).out() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_in: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).in_() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_both: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).both() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_bothE: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).bothE() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_VX4X_localXbothE_limitX1XX: [function({g, vid4}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).V(vid4).local(__.bothE().limit(1)) }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX11X_bothV: [function({g, eid11}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E(eid11).bothV() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX12X_bothV: [function({g, eid12}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E(eid12).bothV() }], 
    g_withStrategiesXSubgraphStrategyXsubgraphDXX_EX9X_bothV: [function({g, eid9}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: false, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E(eid9).bothV() }], 
    g_withStrategiesXSubgraphStrategyXcheckAdjacentVertices_subgraphDXX_EX9X_bothV: [function({g, eid9}) { return g.withStrategies(new SubgraphStrategy({checkAdjacentVertices: true, vertices: __.has("name", P.within("josh", "lop", "ripple")), edges: __.or(__.has("weight", 0.4).hasLabel("created"), __.has("weight", 1.0).hasLabel("created"))})).E(eid9).bothV() }], 
    g_withStrategiesXVertexProgramRestrictionStrategyX_withoutStrategiesXVertexProgramStrategyX_V: [function({g}) { return g.withStrategies(new VertexProgramRestrictionStrategy()).withoutStrategies(VertexProgramStrategy).V() }], 
    g_withStrategiesXVertexProgramRestrictionStrategy_VertexProgramStrategyX_V: [function({g}) { return g.withStrategies(new VertexProgramRestrictionStrategy(), new VertexProgramStrategy()).V() }], 
    g_withoutStrategiesXVertexProgramRestrictionStrategyX_V: [function({g}) { return g.withoutStrategies(VertexProgramRestrictionStrategy).withStrategies(new VertexProgramStrategy()).V() }], 
    g_withStrategiesXVertexProgramStrategyX_V: [function({g}) { return g.withStrategies(new VertexProgramStrategy()).V() }], 
    g_withoutStrategiesXVertexProgramStrategyX_V: [function({g}) { return g.withoutStrategies(VertexProgramStrategy).V() }], 
    g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX: [function({g, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1}) { return g.V(vid1).as("a").out("created").addE("createdBy").to("a") }, function({g, vid1}) { return g.E() }, function({g, vid1}) { return g.V(vid1).inE() }], 
    g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX_propertyXweight_2X: [function({g, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1}) { return g.V(vid1).as("a").out("created").addE("createdBy").to("a").property("weight", 2.0) }, function({g, vid1}) { return g.E() }, function({g, vid1}) { return g.V(vid1).bothE() }, function({g, vid1}) { return g.V(vid1).inE().has("weight", 2.0) }], 
    g_V_outE_propertyXweight_nullX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().outE().property("weight", null) }, function({g}) { return g.E().properties("weight") }], 
    g_V_aggregateXxX_asXaX_selectXxX_unfold_addEXexistsWithX_toXaX_propertyXtime_nowX: [function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V().aggregate("x").as("a").select("x").unfold().addE("existsWith").to("a").property("time", "now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.E() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).bothE("existsWith").has("time", "now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).bothE("existsWith").has("time", "now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).bothE("existsWith").has("time", "now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).bothE("existsWith").has("time", "now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).bothE("existsWith").has("time", "now") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).inE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).outE("existsWith") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).bothE("existsWith").has("time", "now") }], 
    g_V_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_asXbX_addEXcodeveloperX_fromXaX_toXbX_propertyXyear_2009X: [function({g, vid1, vid2, vid4, vid6}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1, vid2, vid4, vid6}) { return g.V().as("a").out("created").in_("created").where(P.neq("a")).as("b").addE("codeveloper").from_("a").to("b").property("year", 2009) }, function({g, vid1, vid2, vid4, vid6}) { return g.E() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid1).bothE() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid1).inE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid1).outE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid1).bothE("codeveloper").has("year", 2009) }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid2).bothE() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid4).bothE() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid4).inE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid4).outE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid4).bothE("codeveloper").has("year", 2009) }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid6).bothE() }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid6).inE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid6).outE("codeveloper") }, function({g, vid1, vid2, vid4, vid6}) { return g.V(vid6).bothE("codeveloper").has("year", 2009) }], 
    g_V_asXaX_inXcreatedX_addEXcreatedByX_fromXaX_propertyXyear_2009X_propertyXacl_publicX: [function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V().as("a").in_("created").addE("createdBy").from_("a").property("year", 2009).property("acl", "public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.E() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).bothE("createdBy").has("year", 2009).has("acl", "public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).bothE("createdBy").has("year", 2009).has("acl", "public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).bothE("createdBy").has("year", 2009).has("acl", "public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).bothE("createdBy").has("year", 2009).has("acl", "public") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).bothE() }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).inE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).outE("createdBy") }, function({g, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).bothE("createdBy").has("year", 2009).has("acl", "public") }], 
    g_withSideEffectXb_bX_VXaX_addEXknowsX_toXbX_propertyXweight_0_5X: [function({g, vid1, vid6}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1, vid6}) { return g.V(vid1).addE("knows").to("b").property("weight", 0.5) }, function({g, vid1, vid6}) { return g.E() }, function({g, vid1, vid6}) { return g.V(vid1).bothE() }, function({g, vid1, vid6}) { return g.V(vid1).inE("knows") }, function({g, vid1, vid6}) { return g.V(vid1).outE("knows") }, function({g, vid1, vid6}) { return g.V(vid1).bothE("knows").has("weight", 0.5) }, function({g, vid1, vid6}) { return g.V(vid6).bothE() }, function({g, vid1, vid6}) { return g.V(vid6).inE("knows") }, function({g, vid1, vid6}) { return g.V(vid6).outE("knows") }, function({g, vid1, vid6}) { return g.V(vid6).bothE("knows").has("weight", 0.5) }], 
    g_addV_asXfirstX_repeatXaddEXnextX_toXaddVX_inVX_timesX5X_addEXnextX_toXselectXfirstXX: [function({g}) { return g.addV().as("first").repeat(__.addE("next").to(__.addV()).inV()).times(5).addE("next").to(__.select("first")) }, function({g}) { return g.V() }, function({g}) { return g.E() }, function({g}) { return g.E().hasLabel("next") }, function({g}) { return g.V().limit(1).bothE() }, function({g}) { return g.V().limit(1).inE() }, function({g}) { return g.V().limit(1).outE() }], 
    g_V_hasXname_markoX_asXaX_outEXcreatedX_asXbX_inV_addEXselectXbX_labelX_toXaX: [function({g, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1}) { return g.V().has("name", "marko").as("a").outE("created").as("b").inV().addE(__.select("b").label()).to("a") }, function({g, vid1}) { return g.E() }, function({g, vid1}) { return g.V(vid1).bothE() }, function({g, vid1}) { return g.V(vid1).inE("created") }, function({g, vid1}) { return g.V(vid1).in_("created").has("name", "lop") }, function({g, vid1}) { return g.V(vid1).outE("created") }], 
    g_addEXV_outE_label_groupCount_orderXlocalX_byXvalues_descX_selectXkeysX_unfold_limitX1XX_fromXV_hasXname_vadasXX_toXV_hasXname_lopXX: [function({g, vid2}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid2}) { return g.addE(__.V().outE().label().groupCount().order(Scope.local).by(Column.values, Order.desc).select(Column.keys).unfold().limit(1)).from_(__.V().has("name", "vadas")).to(__.V().has("name", "lop")) }, function({g, vid2}) { return g.E() }, function({g, vid2}) { return g.V(vid2).bothE() }, function({g, vid2}) { return g.V(vid2).inE("knows") }, function({g, vid2}) { return g.V(vid2).outE("created") }, function({g, vid2}) { return g.V(vid2).out("created").has("name", "lop") }], 
    g_addEXknowsX_fromXVXvid1XX_toXVXvid6XX_propertyXweight_0_1X: [function({g, xx1, vid6, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, xx1, vid6, vid1}) { return g.addE("knows").from_(__.V(vid1)).to(__.V(vid6)).property("weight", xx1) }, function({g, xx1, vid6, vid1}) { return g.E() }, function({g, xx1, vid6, vid1}) { return g.V(vid1).outE("knows") }, function({g, xx1, vid6, vid1}) { return g.V(vid1).out("knows").has("name", "peter") }], 
    g_addEXknowsvarX_fromXVXvid1XX_toXVXvid6XX_propertyXweight_0_1X: [function({g, xx1, vid6, xx2, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, xx1, vid6, xx2, vid1}) { return g.addE(xx1).from_(__.V(vid1)).to(__.V(vid6)).property("weight", xx2) }, function({g, xx1, vid6, xx2, vid1}) { return g.E() }, function({g, xx1, vid6, xx2, vid1}) { return g.V(vid1).outE("knows") }, function({g, xx1, vid6, xx2, vid1}) { return g.V(vid1).out("knows").has("name", "peter") }], 
    g_VXaX_addEXknowsX_toXbX_propertyXweight_0_1X: [function({g, xx1, vid6, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, xx1, vid6, vid1}) { return g.V(vid1).addE("knows").to(__.V(vid6)).property("weight", xx1) }, function({g, xx1, vid6, vid1}) { return g.E() }, function({g, xx1, vid6, vid1}) { return g.V(vid1).outE("knows") }, function({g, xx1, vid6, vid1}) { return g.V(vid1).out("knows").has("name", "peter") }], 
    g_addEXknowsXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).addV("person").property("name", "vadas").property("age", 27) }, function({g}) { return g.addE("knows").property("weight", null).from_(__.V().has("name", "marko")).to(__.V().has("name", "vadas")) }, function({g}) { return g.E().has("knows", "weight", null) }], 
    g_addEXknowsvarXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29).addV("person").property("name", "vadas").property("age", 27) }, function({g, xx1}) { return g.addE(xx1).property("weight", null).from_(__.V().has("name", "marko")).to(__.V().has("name", "vadas")) }, function({g, xx1}) { return g.E().has("knows", "weight", null) }], 
    g_unionXaddEXknowsvarXpropertyXweight_nullXfromXV_hasXname_markoXX_toXV_hasXname_vadasXXX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29).addV("person").property("name", "vadas").property("age", 27) }, function({g, xx1}) { return g.union(__.addE(xx1).property("weight", 1).from_(__.V().has("name", "marko")).to(__.V().has("name", "vadas"))) }, function({g, xx1}) { return g.E().has("knows", "weight", 1) }], 
    g_addEXedgeX_fromXV_hasXname_markoXX_toXV_hasXname_vadasXX_propertyXweight_0_5X_withXkey_valueX_valuesXweight_keyX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).addV("person").property("name", "vadas").property("age", 27) }, function({g}) { return g.addE("edge").from_(__.V().has("name", "marko")).to(__.V().has("name", "vadas")).property("weight", 0.5).with_("key", "value").values("weight", "key") }], 
    g_VX1X_addVXanimalX_propertyXage_selectXaX_byXageXX_propertyXname_puppyX: [function({g, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1}) { return g.V(vid1).as("a").addV("animal").property("age", __.select("a").by("age")).property("name", "puppy") }, function({g, vid1}) { return g.V().has("animal", "age", 29) }], 
    g_V_addVXanimalX_propertyXage_0X: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().addV("animal").property("age", 0) }, function({g}) { return g.V().has("animal", "age", 0) }], 
    g_V_addVXanimalvarX_propertyXage_0varX: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, xx1, xx2}) { return g.V().addV(xx1).property("age", xx2) }, function({g, xx1, xx2}) { return g.V().has("animal", "age", 0) }], 
    g_addVXpersonX_propertyXname_stephenX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.addV("person").property("name", "stephen") }, function({g}) { return g.V().has("person", "name", "stephen") }], 
    g_addVXpersonvarX_propertyXname_stephenvarX: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, xx1, xx2}) { return g.addV(xx1).property("name", xx2) }, function({g, xx1, xx2}) { return g.V().has("person", "name", "stephen") }], 
    g_V_hasLabelXpersonX_propertyXname_nullX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().hasLabel("person").property(Cardinality.single, "name", null) }, function({g}) { return g.V().properties("name") }], 
    g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenmX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.addV("person").property(Cardinality.single, "name", "stephen").property(Cardinality.single, "name", "stephenm") }, function({g}) { return g.V().has("person", "name", "stephen") }, function({g}) { return g.V().has("person", "name", "stephenm") }], 
    get_g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.addV("person").property(Cardinality.single, "name", "stephen").property(Cardinality.single, "name", "stephenm", "since", 2010) }, function({g}) { return g.V().has("person", "name", "stephen") }, function({g}) { return g.V().has("person", "name", "stephenm") }, function({g}) { return g.V().has("person", "name", "stephenm").properties("name").has("since", 2010) }], 
    g_V_hasXname_markoX_propertyXfriendWeight_outEXknowsX_weight_sum__acl_privateX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().has("name", "marko").property("friendWeight", __.outE("knows").values("weight").sum(), "acl", "private") }, function({g}) { return g.V().has("person", "name", "marko").has("friendWeight", 1.5) }, function({g}) { return g.V().has("person", "name", "marko").properties("friendWeight").has("acl", "private") }, function({g}) { return g.V().has("person", "name", "marko").properties("friendWeight").count() }], 
    g_addVXanimalX_propertyXname_mateoX_propertyXname_gateoX_propertyXname_cateoX_propertyXage_5X: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.addV("animal").property("name", "mateo").property("name", "gateo").property("name", "cateo").property("age", 5) }, function({g}) { return g.V().hasLabel("animal").has("name", "mateo").has("name", "gateo").has("name", "cateo").has("age", 5) }], 
    g_withSideEffectXa_markoX_addV_propertyXname_selectXaXX_name: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.withSideEffect("a", "marko").addV().property("name", __.select("a")).values("name") }, function({g}) { return g.V().has("name", "marko") }], 
    g_addVXpersonX_propertyXsingle_name_stephenX_propertyXsingle_name_stephenm_since_2010X: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.addV("person").property(Cardinality.single, "name", "stephen").property(Cardinality.single, "name", "stephenm", "since", 2010) }, function({g}) { return g.V().has("name", "stephen") }, function({g}) { return g.V().has("name", "stephenm") }, function({g}) { return g.V().has("name", "stephenm").properties("name").has("since", 2010) }], 
    g_V_addVXanimalX_propertyXname_valuesXnameXX_propertyXname_an_animalX_propertyXvaluesXnameX_labelX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().addV("animal").property("name", __.values("name")).property("name", "an animal").property(__.values("name"), __.label()) }, function({g}) { return g.V().hasLabel("animal").has("name", "marko").has("name", "an animal").has("marko", "person") }, function({g}) { return g.V().hasLabel("animal").has("name", "vadas").has("name", "an animal").has("vadas", "person") }, function({g}) { return g.V().hasLabel("animal").has("name", "lop").has("name", "an animal").has("lop", "software") }, function({g}) { return g.V().hasLabel("animal").has("name", "josh").has("name", "an animal").has("josh", "person") }, function({g}) { return g.V().hasLabel("animal").has("name", "ripple").has("name", "an animal").has("ripple", "software") }, function({g}) { return g.V().hasLabel("animal").has("name", "peter").has("name", "an animal").has("peter", "person") }], 
    g_withSideEffectXa_testX_V_hasLabelXsoftwareX_propertyXtemp_selectXaXX_valueMapXname_tempX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.withSideEffect("a", "test").V().hasLabel("software").property("temp", __.select("a")).valueMap("name", "temp") }], 
    g_withSideEffectXa_nameX_addV_propertyXselectXaX_markoX_name: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.withSideEffect("a", "name").addV().property(__.select("a"), "marko").values("name") }, function({g}) { return g.V().has("name", "marko") }], 
    g_V_asXaX_hasXname_markoX_outXcreatedX_asXbX_addVXselectXaX_labelX_propertyXtest_selectXbX_labelX_valueMap_withXtokensX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().as("a").has("name", "marko").out("created").as("b").addV(__.select("a").label()).property("test", __.select("b").label()).valueMap().with_(WithOptions.tokens) }, function({g}) { return g.V().has("person", "test", "software") }], 
    g_addVXV_hasXname_markoX_propertiesXnameX_keyX_label: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.addV(__.V().has("name", "marko").properties("name").key()).label() }], 
    g_addV_propertyXlabel_personX: [function({g}) { return g.addV().property(T.label, "person") }, function({g}) { return g.V().hasLabel("person") }], 
    g_addV_propertyXlabel_personvarX: [function({g, xx1}) { return g.addV().property(T.label, xx1) }, function({g, xx1}) { return g.V().hasLabel("person") }], 
    g_addV_propertyXid_1X: [function({g}) { return g.addV().property(T.id, 1) }, function({g}) { return g.V().hasId("1") }], 
    g_addV_propertyXidvar_1varX: [function({g, xx1}) { return g.addV().property(T.id, xx1) }, function({g, xx1}) { return g.V().hasId("1") }], 
    g_addV_propertyXmapX: [function({g}) { return g.addV().property(new Map([["name", "foo"], ["age", 42]])) }, function({g}) { return g.V().has("name", "foo") }], 
    g_addV_propertyXsingle_mapX: [function({g}) { return g.addV().property(Cardinality.single, new Map([["name", "foo"], ["age", 42]])) }, function({g}) { return g.V().has("name", "foo") }], 
    g_V_hasXname_fooX_propertyXname_setXbarX_age_43X: [function({g}) { return g.addV().property(Cardinality.single, "name", "foo").property("age", 42) }, function({g}) { return g.V().has("name", "foo").property(new Map([["name", CardinalityValue.set("bar")], ["age", 43]])) }, function({g}) { return g.V().has("name", "foo") }, function({g}) { return g.V().has("name", "bar") }, function({g}) { return g.V().has("age", 43) }, function({g}) { return g.V().has("age", 42) }], 
    g_V_hasXname_fooX_propertyXset_name_bar_age_singleX43XX: [function({g}) { return g.addV().property(Cardinality.single, "name", "foo").property("age", 42) }, function({g}) { return g.V().has("name", "foo").property(Cardinality.set, new Map([["name", "bar"], ["age", CardinalityValue.single(43)]])) }, function({g}) { return g.V().has("name", "foo") }, function({g}) { return g.V().has("name", "bar") }, function({g}) { return g.V().has("age", 43) }, function({g}) { return g.V().has("age", 42) }], 
    g_addV_propertyXnullX: [function({g}) { return g.addV("person").property(null) }, function({g}) { return g.V().hasLabel("person").values() }], 
    g_addV_propertyXemptyX: [function({g}) { return g.addV("person").property(new Map([])) }, function({g}) { return g.V().hasLabel("person").values() }], 
    g_addV_propertyXset_nullX: [function({g}) { return g.addV("foo").property(Cardinality.set, null) }, function({g}) { return g.V().hasLabel("foo").values() }], 
    g_addV_propertyXset_emptyX: [function({g}) { return g.addV("foo").property(Cardinality.set, new Map([])) }, function({g}) { return g.V().hasLabel("person").values() }], 
    g_addVXpersonX_propertyXname_joshX_propertyXage_nullX: [function({g}) { return g.addV("person").property("name", "josh").property("age", null) }, function({g}) { return g.V().has("person", "age", null) }], 
    g_addVXpersonX_propertyXname_markoX_propertyXfriendWeight_null_acl_nullX: [function({g}) { return g.addV("person").property("name", "marko").property("friendWeight", null, "acl", null) }, function({g}) { return g.V().has("person", "name", "marko").has("friendWeight", null) }, function({g}) { return g.V().has("person", "name", "marko").properties("friendWeight").has("acl", null) }, function({g}) { return g.V().has("person", "name", "marko").properties("friendWeight").count() }], 
    g_V_hasXperson_name_aliceX_propertyXsingle_age_unionXage_constantX1XX_sumX: [function({g}) { return g.addV("person").property("name", "alice").property(Cardinality.single, "age", 50) }, function({g}) { return g.V().has("person", "name", "alice").property("age", __.union(__.values("age"), __.constant(1)).sum()) }, function({g}) { return g.V().has("person", "age", 50) }, function({g}) { return g.V().has("person", "age", 51) }], 
    g_V_limitX3X_addVXsoftwareX_aggregateXa1X_byXlabelX_aggregateXa2X_byXlabelX_capXa1_a2X_selectXa_bX_byXunfoldX_foldX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().limit(3).addV("software").aggregate("a1").by(T.label).aggregate("a2").by(T.label).cap("a1", "a2").select("a1", "a2").by(__.unfold().fold()) }], 
    g_addV_propertyXname_markoX_withXkey_valueX_valuesXname_keyX: [function({g}) { return g.addV().property("name", "marko").with_("key", "value").values("name", "key") }], 
    g_addV_propertyXname_marko_since_2010X_withXkey_valueX_propertiesXnameX_valuesXsince_keyX: [function({g}) { return g.addV().property("name", "marko", "since", 2010).with_("key", "value").properties("name").values("since", "key") }], 
    g_injectX1X_asBool: [function({g}) { return g.inject(1).asBool() }], 
    g_injectX3_14X_asBool: [function({g}) { return g.inject(3.14).asBool() }], 
    g_injectXneg_1X_asBool: [function({g}) { return g.inject(-1).asBool() }], 
    g_injectX0X_asBool: [function({g}) { return g.inject(0).asBool() }], 
    g_injectXneg_0X_asBool: [function({g}) { return g.inject(-0.0).asBool() }], 
    g_injectXNaNX_asBool: [function({g}) { return g.inject(Number.NaN).asBool() }], 
    g_injectXbool_trueX_asBool: [function({g}) { return g.inject(true).asBool() }], 
    g_injectXfalseX_asBool: [function({g}) { return g.inject(false).asBool() }], 
    g_injectXtrueX_asBool: [function({g}) { return g.inject("true").asBool() }], 
    g_injectXmixed_trueX_asBool: [function({g}) { return g.inject("tRUe").asBool() }], 
    g_injectXnullX_asBool: [function({g}) { return g.inject(null).asBool() }], 
    g_injectXhelloX_asBool: [function({g}) { return g.inject("hello").asBool() }], 
    g_injectX1_2X_asBool: [function({g}) { return g.inject([1, 2]).asBool() }], 
    g_VXX_localX_outE_countX_asBool: [function({g}) { return g.V().local(__.outE().count()).asBool() }], 
    g_V_sackXassignX_byX_hasLabelXpersonX_count_asBoolX_sackXandX_byX_outE_count_asBoolX_sack_path: [function({g}) { return g.V().sack(Operator.assign).by(__.hasLabel("person").count().asBool()).sack(Operator.and).by(__.outE().count().asBool()).sack().path() }], 
    g_injectXstrX_asDate: [function({g}) { return g.inject("2023-08-02T00:00:00Z").asDate() }], 
    g_injectXstr_offsetX_asDate: [function({g}) { return g.inject("2023-08-02T00:00:00-07:00").asDate() }], 
    g_injectX1694017707000X_asDate: [function({g}) { return g.inject(1694017707000).asDate() }], 
    g_injectX1694017708000LX_asDate: [function({g}) { return g.inject(1694017708000).asDate() }], 
    g_injectX1694017709000dX_asDate: [function({g}) { return g.inject(1694017709000.1).asDate() }], 
    g_injectX1_2X_asDate: [function({g}) { return g.inject([1, 2]).asDate() }], 
    g_injectXnullX_asDate: [function({g}) { return g.inject(null).asDate() }], 
    g_injectXinvalidstrX_asDate: [function({g}) { return g.inject("This String is not an ISO 8601 Date").asDate() }], 
    g_V_valuesXbirthdayX_asDate_asNumber_asDate: [function({g}) { return g.addV("person").property("name", "alice").property("birthday", "2020-08-02").addV("person").property("name", "john").property("birthday", "1988-12-10").addV("person").property("name", "charlie").property("birthday", "2002-02-01").addV("person").property("name", "suzy").property("birthday", "1965-10-31") }, function({g}) { return g.V().values("birthday").asDate().asNumber().asDate() }], 
    g_injectX5bX_asNumber: [function({g}) { return g.inject(5).asNumber() }], 
    g_injectX5sX_asNumber: [function({g}) { return g.inject(5).asNumber() }], 
    g_injectX5iX_asNumber: [function({g}) { return g.inject(5).asNumber() }], 
    g_injectX5lX_asNumber: [function({g}) { return g.inject(5).asNumber() }], 
    g_injectX5nX_asNumber: [function({g}) { return g.inject(5).asNumber() }], 
    g_injectX5_0X_asNumber: [function({g}) { return g.inject(5.0).asNumber() }], 
    g_injectX5_75fX_asNumber: [function({g}) { return g.inject(5.75).asNumber() }], 
    g_injectX5X_asNumber: [function({g}) { return g.inject("5").asNumber() }], 
    g_injectXtestX_asNumber: [function({g}) { return g.inject("test").asNumber() }], 
    g_injectX_1_2_3_4X_asNumber: [function({g}) { return g.inject([1, 2, 3, 4]).asNumber() }], 
    g_injectX1_2_3_4X_unfold_asNumber: [function({g}) { return g.inject([1, 2, 3, 4]).unfold().asNumber() }], 
    g_injectX_1__2__3__4_X_asNumberXX_foldXX: [function({g}) { return g.inject("1", 2, "3", 4).asNumber().fold() }], 
    g_injectX5_43X_asNumberXGType_INTX: [function({g}) { return g.inject(5.43).asNumber(GType.int) }], 
    g_injectX5_67X_asNumberXGType_INTX: [function({g}) { return g.inject(5.67).asNumber(GType.int) }], 
    g_injectX5X_asNumberXGType_LONGX: [function({g}) { return g.inject(5).asNumber(GType.long) }], 
    g_injectX12X_asNumberXGType_BYTEX: [function({g}) { return g.inject(12).asNumber(GType.byte) }], 
    g_injectX32768X_asNumberXGType_SHORTX: [function({g}) { return g.inject(32768).asNumber(GType.short) }], 
    g_injectX300X_asNumberXGType_BYTEX: [function({g}) { return g.inject(300).asNumber(GType.byte) }], 
    g_injectX32768X_asNumberXGType_VertexX: [function({g}) { return g.inject(32768).asNumber(GType.vertex) }], 
    g_injectX5X_asNumberXGType_BYTEX: [function({g}) { return g.inject("5").asNumber(GType.byte) }], 
    g_injectX1_000X_asNumberXGType_BIGINTX: [function({g}) { return g.inject("1,000").asNumber(GType.bigInt) }], 
    g_injectX1_2_3_4_0x5X_asNumber_sum_asNumberXGType_BYTEX: [function({g}) { return g.inject(1.0, 2, 3, "4", "0x5").asNumber().sum().asNumber(GType.byte) }], 
    g_injectXnullX_asNumberXGType_INTX: [function({g}) { return g.inject(null).asNumber(GType.int) }], 
    g_V_asXaX_outXknowsX_asXbX_mathXa_plus_bX_byXageX_asNumberXGType_INTX: [function({g}) { return g.V().as("a").out("knows").as("b").math("a + b").by("age").asNumber(GType.int) }], 
    g_withSideEffectXx_100X_V_age_mathX__plus_xX_asNumberXGType_LONGX: [function({g}) { return g.withSideEffect("x", 100).V().values("age").math("_ + x").asNumber(GType.long) }], 
    g_V_valuesXageX_asString_asNumberXGType_DOUBLEX: [function({g}) { return g.V().values("age").asString().asNumber(GType.double) }], 
    g_V_valuesXbirthdayX_asNumber_asDate_asNumber: [function({g}) { return g.addV("person").property("name", "alice").property("birthday", 1596326400000).addV("person").property("name", "john").property("birthday", 597715200000).addV("person").property("name", "charlie").property("birthday", 1012521600000).addV("person").property("name", "suzy").property("birthday", -131587200000) }, function({g}) { return g.V().values("birthday").asNumber().asDate().asNumber() }], 
    g_injectX1_2X_asString: [function({g}) { return g.inject(1, 2).asString() }], 
    g_injectX1_2X_asStringXlocalX: [function({g}) { return g.inject(1, 2).asString(Scope.local) }], 
    g_injectXlist_1_2X_asStringXlocalX: [function({g}) { return g.inject([1, 2]).asString(Scope.local) }], 
    g_injectX1_nullX_asString: [function({g}) { return g.inject(null, 1).asString() }], 
    g_injectX1_nullX_asStringXlocalX: [function({g}) { return g.inject([1, null]).asString(Scope.local) }], 
    g_V_valueMapXnameX_asString: [function({g}) { return g.V().valueMap("name").asString() }], 
    g_V_valueMapXnameX_order_fold_asStringXlocalX: [function({g}) { return g.V().valueMap("name").order().fold().asString(Scope.local) }], 
    g_V_asString: [function({g}) { return g.V().asString() }], 
    g_V_fold_asStringXlocalX_orderXlocalX: [function({g}) { return g.V().fold().asString(Scope.local).order(Scope.local) }], 
    g_E_asString: [function({g}) { return g.E().asString() }], 
    g_V_properties: [function({g}) { return g.V().properties().asString() }], 
    g_V_hasLabelXpersonX_valuesXageX_asString: [function({g}) { return g.V().hasLabel("person").values("age").asString() }], 
    g_V_hasLabelXpersonX_valuesXageX_order_fold_asStringXlocalX: [function({g}) { return g.V().hasLabel("person").values("age").order().fold().asString(Scope.local) }], 
    g_V_hasLabelXpersonX_valuesXageX_asString_concatX_years_oldX: [function({g}) { return g.V().hasLabel("person").values("age").asString().concat(" years old") }], 
    g_call: [function({g}) { return g.call() }], 
    g_callXlistX: [function({g}) { return g.call("--list") }], 
    g_callXlistX_withXstring_stringX: [function({g}) { return g.call("--list").with_("service", "tinker.search") }], 
    g_callXlistX_withXstring_traversalX: [function({g}) { return g.call("--list").with_("service", __.constant("tinker.search")) }], 
    g_callXlist_mapX: [function({g, xx1}) { return g.call("--list", xx1) }], 
    g_callXlist_traversalX: [function({g}) { return g.call("--list", __.project("service").by(__.constant("tinker.search"))) }], 
    g_callXlist_map_traversalX: [function({g, xx1}) { return g.call("--list", xx1, __.project("service").by(__.constant("tinker.search"))) }], 
    g_callXsearch_mapX: [function({g, xx1}) { return g.call("tinker.search", xx1).element() }], 
    g_callXsearch_traversalX: [function({g}) { return g.call("tinker.search", __.project("search").by(__.constant("vada"))).element() }], 
    g_callXsearchX_withXstring_stringX: [function({g}) { return g.call("tinker.search").with_("search", "vada").element() }], 
    g_callXsearchX_withXstring_traversalX: [function({g}) { return g.call("tinker.search").with_("search", __.constant("vada")).element() }], 
    g_callXsearch_mapX_withXstring_VertexX: [function({g, xx1}) { return g.call("tinker.search", xx1).with_("type", "Vertex").element() }], 
    g_callXsearch_mapX_withXstring_EdgeX: [function({g, xx1}) { return g.call("tinker.search", xx1).with_("type", "Edge").element() }], 
    g_callXsearch_mapX_withXstring_VertexPropertyX: [function({g, xx1}) { return g.call("tinker.search", xx1).with_("type", "VertexProperty").element() }], 
    g_V_callXdcX: [function({g}) { return g.V().as("v").call("tinker.degree.centrality").project("vertex", "degree").by(__.select("v")).by() }], 
    g_V_whereXcallXdcXX: [function({g}) { return g.V().where(__.call("tinker.degree.centrality").is(3)) }], 
    g_V_callXdcX_withXdirection_OUTX: [function({g}) { return g.V().as("v").call("tinker.degree.centrality").with_("direction", Direction.OUT).project("vertex", "degree").by(__.select("v")).by() }], 
    g_V_callXdc_mapX_withXdirection_OUTX: [function({g, xx1}) { return g.V().as("v").call("tinker.degree.centrality", xx1).with_("direction", Direction.OUT).project("vertex", "degree").by(__.select("v")).by() }], 
    g_V_callXdc_traversalX: [function({g}) { return g.V().as("v").call("tinker.degree.centrality", __.project("direction").by(__.constant(Direction.OUT))).project("vertex", "degree").by(__.select("v")).by() }], 
    g_V_callXdc_map_traversalX: [function({g, xx1}) { return g.V().as("v").call("tinker.degree.centrality", xx1, __.project("direction").by(__.constant(Direction.OUT))).project("vertex", "degree").by(__.select("v")).by() }], 
    g_V_coalesceXoutXfooX_outXbarXX: [function({g}) { return g.V().coalesce(__.out("foo"), __.out("bar")) }], 
    g_VX1X_coalesceXoutXknowsX_outXcreatedXX_valuesXnameX: [function({g, vid1}) { return g.V(vid1).coalesce(__.out("knows"), __.out("created")).values("name") }], 
    g_VX1X_coalesceXoutXcreatedX_outXknowsXX_valuesXnameX: [function({g, vid1}) { return g.V(vid1).coalesce(__.out("created"), __.out("knows")).values("name") }], 
    g_V_coalesceXoutXlikesX_outXknowsX_inXcreatedXX_groupCount_byXnameX: [function({g}) { return g.V().coalesce(__.out("likes"), __.out("knows"), __.out("created")).groupCount().by("name") }], 
    g_V_coalesceXoutEXknowsX_outEXcreatedXX_otherV_path_byXnameX_byXlabelX: [function({g}) { return g.V().coalesce(__.outE("knows"), __.outE("created")).otherV().path().by("name").by(T.label) }], 
    g_V_outXcreatedX_order_byXnameX_coalesceXname_constantXxXX: [function({g}) { return g.V().out("created").order().by("name").coalesce(__.values("name"), __.constant("x")) }], 
    g_injectXnullX_combineXinjectX1XX: [function({g}) { return g.inject(null).combine(__.inject(1)) }], 
    g_V_valuesXnameX_combineXV_foldX: [function({g}) { return g.V().values("name").combine(__.V().fold()) }], 
    g_V_fold_combineXconstantXnullXX: [function({g}) { return g.V().fold().combine(__.constant(null)) }], 
    g_V_fold_combineXVX: [function({g}) { return g.V().fold().combine(__.V()) }], 
    g_V_valuesXnameX_fold_combineX2X: [function({g}) { return g.V().values("name").fold().combine(2) }], 
    g_V_valuesXnameX_fold_combineXnullX: [function({g}) { return g.V().values("name").fold().combine(null) }], 
    g_V_valuesXnonexistantX_fold_combineXV_valuesXnameX_foldX_unfold: [function({g}) { return g.V().values("nonexistant").fold().combine(__.V().values("name").fold()).unfold() }], 
    g_V_valuesXnameX_fold_combineXV_valuesXnonexistantX_foldX_unfold: [function({g}) { return g.V().values("name").fold().combine(__.V().values("nonexistant").fold()).unfold() }], 
    g_V_valuesXageX_order_byXdescX_fold_combineXV_valuesXageX_order_byXdescX_foldX: [function({g}) { return g.V().values("age").order().by(Order.desc).fold().combine(__.V().values("age").order().by(Order.desc).fold()) }], 
    g_V_out_path_byXvaluesXnameX_toUpperX_combineXMARKOX: [function({g}) { return g.V().out().path().by(__.values("name").toUpper()).combine(["MARKO"]) }], 
    g_injectXxx1X_combineXV_valuesXnameX_foldX_unfold: [function({g}) { return g.inject(["marko"]).combine(__.V().values("name").fold()).unfold() }], 
    g_V_valueMapXlocationX_selectXvaluesX_unfold_combineXseattle_vancouverX_orderXlocalX: [function({g}) { return g.V().valueMap("location").select(Column.values).unfold().combine(["seattle", "vancouver"]).order(Scope.local) }], 
    g_V_out_out_path_byXnameX_combineXempty_listX: [function({g}) { return g.V().out().out().path().by("name").combine([]) }], 
    g_V_valuesXageX_order_fold_combineXconstantX27X_foldX: [function({g}) { return g.V().values("age").order().fold().combine(__.constant(27).fold()) }], 
    g_V_out_out_path_byXnameX_combineXdave_kelvinX: [function({g}) { return g.V().out().out().path().by("name").combine(["dave", "kelvin"]) }], 
    g_injectXa_null_bX_combineXa_cX: [function({g}) { return g.inject(["a", null, "b"]).combine(["a", "c"]) }], 
    g_injectXa_null_bX_combineXa_null_cX: [function({g}) { return g.inject(["a", null, "b"]).combine(["a", null, "c"]) }], 
    g_injectX3_threeX_combineXfive_three_7X: [function({g}) { return g.inject([3, "three"]).combine(["five", "three", 7]) }], 
    g_injectXa_bX_concat: [function({g}) { return g.inject("a", "b").concat() }], 
    g_injectXa_bX_concat_XcX: [function({g}) { return g.inject("a", "b").concat("c") }], 
    g_injectXa_bX_concat_Xc_dX: [function({g}) { return g.inject("a", "b").concat("c", "d") }], 
    g_injectXa_bX_concat_Xinject_c_dX: [function({g}) { return g.inject("a", "b").concat(__.inject("c")) }], 
    g_injectXaX_concat_Xinject_List_b_cX: [function({g}) { return g.inject("a").concat(__.inject(["b", "c"])) }], 
    g_injectXListXa_bXcX_concat_XdX: [function({g}) { return g.inject(["a", "b"], "c").concat("d") }], 
    g_injectXnullX_concat_XinjectX: [function({g}) { return g.inject(null).concat() }], 
    g_injectXnull_aX_concat_Xnull_bX: [function({g}) { return g.inject(null, "a").concat(null, "b") }], 
    g_injectXhello_hiX_concatXV_values_order_byXnameX_valuesXnameXX: [function({g}) { return g.inject("hello", "hi").concat(__.V().order().by("name").values("name")) }], 
    g_V_hasLabel_value_concat_X_X_concat_XpersonX: [function({g}) { return g.V().hasLabel("person").values("name").concat(" ").concat("person") }], 
    g_hasLabelXpersonX_valuesXnameX_asXaX_constantXMrX_concatXselectXaX: [function({g}) { return g.V().hasLabel("person").values("name").as("a").constant("Mr.").concat(__.select("a")) }], 
    g_hasLabelXsoftwareX_asXaX_valuesXnameX_concatXunsesX_concatXselectXaXvaluesXlangX: [function({g}) { return g.V().hasLabel("software").as("a").values("name").concat(" uses ").concat(__.select("a").values("lang")) }], 
    g_VX1X_outE_asXaX_VX1X_valuesXnamesX_concatXselectXaX_labelX_concatXselectXaX_inV_valuesXnameXX: [function({g, vid1}) { return g.V(vid1).outE().as("a").V(vid1).values("name").concat(__.select("a").label()).concat(__.select("a").inV().values("name")) }], 
    g_VX1X_outE_asXaX_VX1X_valuesXnamesX_concatXselectXaX_label_selectXaX_inV_valuesXnameXX: [function({g, vid1}) { return g.V(vid1).outE().as("a").V(vid1).values("name").concat(__.select("a").label(), __.select("a").inV().values("name")) }], 
    g_addVXconstantXprefix_X_concatXVX1X_labelX_label: [function({g, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid1}) { return g.addV(__.constant("prefix_").concat(__.V(vid1).label())).label() }], 
    g_injectXnullX_conjoinX1X: [function({g}) { return g.inject(null).conjoin("1") }], 
    g_V_valuesXnameX_conjoinX1X: [function({g}) { return g.V().values("name").conjoin("1") }], 
    g_V_valuesXnonexistantX_fold_conjoinX_X: [function({g}) { return g.V().values("nonexistant").fold().conjoin(";") }], 
    g_V_valuesXnameX_order_fold_conjoinX_X: [function({g}) { return g.V().values("name").order().fold().conjoin("_") }], 
    g_V_valuesXageX_order_fold_conjoinX_X: [function({g}) { return g.V().values("age").order().fold().conjoin(";") }], 
    g_V_out_path_byXvaluesXnameX_toUpperX_conjoinXMARKOX: [function({g}) { return g.V().out().path().by(__.values("name").toUpper()).conjoin("MARKO") }], 
    g_injectXmarkoX_conjoinX_X: [function({g}) { return g.inject(["marko"]).conjoin("-") }], 
    g_V_valueMapXlocationX_selectXvaluesX_unfold_orderXlocalX_conjoinX1X: [function({g}) { return g.V().valueMap("location").select(Column.values).unfold().order(Scope.local).conjoin("1") }], 
    g_V_out_out_path_byXnameX_conjoinXX: [function({g}) { return g.V().out().out().path().by("name").conjoin("") }], 
    g_injectXa_null_bX_conjoinXxyzX: [function({g}) { return g.inject(["a", null, "b"]).conjoin("xyz") }], 
    g_injectX3_threeX_conjoinX_X: [function({g}) { return g.inject([3, "three"]).conjoin(";") }], 
    g_V_connectedComponent_hasXcomponentX: [function({g}) { return g.V().connectedComponent().has("gremlin.connectedComponentVertexProgram.component") }], 
    g_V_dedup_connectedComponent_hasXcomponentX: [function({g}) { return g.V().dedup().connectedComponent().has("gremlin.connectedComponentVertexProgram.component") }], 
    g_V_hasLabelXsoftwareX_connectedComponent_project_byXnameX_byXcomponentX: [function({g}) { return g.V().hasLabel("software").connectedComponent().project("name", "component").by("name").by("gremlin.connectedComponentVertexProgram.component") }], 
    g_V_connectedComponent_withXEDGES_bothEXknowsXX_withXPROPERTY_NAME_clusterX_project_byXnameX_byXclusterX: [function({g}) { return g.V().hasLabel("person").connectedComponent().with_("~tinkerpop.connectedComponent.edges", __.bothE("knows")).with_("~tinkerpop.connectedComponent.propertyName", "cluster").project("name", "cluster").by("name").by("cluster") }], 
    g_V_constantX123X: [function({g}) { return g.V().constant(123) }], 
    g_V_constantXnullX: [function({g}) { return g.V().constant(null) }], 
    g_V_chooseXhasLabelXpersonX_valuesXnameX_constantXinhumanXX: [function({g}) { return g.V().choose(__.hasLabel("person"), __.values("name"), __.constant("inhuman")) }], 
    g_V_count: [function({g}) { return g.V().count() }], 
    g_V_out_count: [function({g}) { return g.V().out().count() }], 
    g_V_both_both_count: [function({g}) { return g.V().both().both().count() }], 
    g_V_fold_countXlocalX: [function({g}) { return g.V().fold().count(Scope.local) }], 
    g_V_hasXnoX_count: [function({g}) { return g.V().has("no").count() }], 
    g_V_whereXinXkknowsX_outXcreatedX_count_is_0XX_name: [function({g}) { return g.V().where(__.in_("knows").out("created").count().is(0)).values("name") }], 
    g_V_repeatXoutX_timesX8X_count: [function({g}) { return g.V().repeat(__.out()).times(8).count() }], 
    g_V_repeatXoutX_timesX5X_asXaX_outXwrittenByX_asXbX_selectXa_bX_count: [function({g}) { return g.V().repeat(__.out()).times(5).as("a").out("writtenBy").as("b").select("a", "b").count() }], 
    g_V_repeatXoutX_timesX3X_count: [function({g}) { return g.V().repeat(__.out()).times(3).count() }], 
    g_V_order_byXlangX_count: [function({g}) { return g.V().order().by("lang").count() }], 
    g_E_sampleX1X_count: [function({g}) { return g.E().sample(1).count() }], 
    g_V_sampleX1X_byXageX_count: [function({g}) { return g.V().sample(1).by("age").count() }], 
    g_V_order_byXnoX_count: [function({g}) { return g.V().order().by("no").count() }], 
    g_V_group_byXlabelX_count: [function({g}) { return g.V().group().by(T.label).count() }], 
    g_V_group_byXlabelX_countXlocalX: [function({g}) { return g.V().group().by(T.label).count(Scope.local) }], 
    g_injectXdatetimeXstrXX_dateAddXDT_hour_2X: [function({g}) { return g.inject(new Date('2023-08-02T00:00Z'), new Date('2023-08-02T00:00Z')).dateAdd(DT.hour, 2) }], 
    g_injectXdatetimeXstrXX_dateAddXhour_2X: [function({g}) { return g.inject(new Date('2023-08-02T00:00Z'), new Date('2023-08-02T00:00Z')).dateAdd(DT.hour, 2) }], 
    g_injectXdatetimeXstrXX_dateAddXhour_1X: [function({g}) { return g.inject(new Date('2023-08-02T00:00Z'), new Date('2023-08-02T00:00Z')).dateAdd(DT.hour, -1) }], 
    g_injectXdatetimeXstrXX_dateAddXminute_10X: [function({g}) { return g.inject(new Date('2023-08-02T00:00Z'), new Date('2023-08-02T00:00Z')).dateAdd(DT.minute, 10) }], 
    g_injectXdatetimeXstrXX_dateAddXsecond_20X: [function({g}) { return g.inject(new Date('2023-08-02T00:00Z'), new Date('2023-08-02T00:00Z')).dateAdd(DT.second, 20) }], 
    g_injectXdatetimeXstrXX_dateAddXday_11X: [function({g}) { return g.inject(new Date('2023-09-06T00:00Z'), new Date('2023-09-06T00:00Z')).dateAdd(DT.day, 11) }], 
    g_injectXdatetimeXstr1XX_dateDiffXdatetimeXstr2XX: [function({g}) { return g.inject(new Date('2023-08-02T00:00Z'), new Date('2023-08-02T00:00Z')).dateDiff(new Date('2023-08-09T00:00Z')) }], 
    g_injectXdatetimeXstr1XX_dateDiffXconstantXdatetimeXstr2XXX: [function({g}) { return g.inject(new Date('2023-08-08T00:00Z'), new Date('2023-08-08T00:00Z')).dateDiff(__.constant(new Date('2023-08-01T00:00Z'))) }], 
    g_injectXdatetimeXstr1XX_dateDiffXinjectXdatetimeXstr2XXX: [function({g}) { return g.inject(new Date('2023-08-08T00:00Z'), new Date('2023-08-08T00:00Z')).dateDiff(__.inject(new Date('2023-10-11T00:00Z'))) }], 
    g_V_valuesXbirthdayX_asDate_dateDiffXdatetimeX19700101T0000ZXX: [function({g}) { return g.addV("person").property("name", "alice").property("birthday", "1596326400000").addV("person").property("name", "john").property("birthday", "597715200000").addV("person").property("name", "charlie").property("birthday", "1012521600000").addV("person").property("name", "suzy").property("birthday", "-131587200000") }, function({g}) { return g.V().values("birthday").asNumber().asDate().dateDiff(new Date('1970-01-01T00:00Z')) }], 
    g_V_hasXname_aliceX_valuesXbirthdayX_asDate_dateDiffXconstantXnullXX: [function({g}) { return g.addV("person").property("name", "alice").property("birthday", 1596326400000) }, function({g}) { return g.V().has("name", "alice").values("birthday").asDate().dateDiff(__.constant(null)) }], 
    g_injectXnullX_differenceXinjectX1XX: [function({g}) { return g.inject(null).difference(__.inject(1)) }], 
    g_V_valuesXnameX_differenceXV_foldX: [function({g}) { return g.V().values("name").difference(__.V().fold()) }], 
    g_V_fold_differenceXconstantXnullXX: [function({g}) { return g.V().fold().difference(__.constant(null)) }], 
    g_V_fold_differenceXVX: [function({g}) { return g.V().fold().difference(__.V()) }], 
    g_V_valuesXnameX_fold_differenceX2X: [function({g}) { return g.V().values("name").fold().difference(2) }], 
    g_V_valuesXnameX_fold_differenceXnullX: [function({g}) { return g.V().values("name").fold().difference(null) }], 
    g_V_valuesXnonexistantX_fold_differenceXV_valuesXnameX_foldX: [function({g}) { return g.V().values("nonexistant").fold().difference(__.V().values("name").fold()) }], 
    g_V_valuesXnameX_fold_differenceXV_valuesXnonexistantX_foldX: [function({g}) { return g.V().values("name").fold().difference(__.V().values("nonexistant").fold()) }], 
    g_V_valuesXageX_fold_differenceXV_valuesXageX_foldX: [function({g}) { return g.V().values("age").fold().difference(__.V().values("age").fold()) }], 
    g_V_out_path_byXvaluesXnameX_toUpperX_differenceXMARKOX: [function({g}) { return g.V().out().path().by(__.values("name").toUpper()).difference(["MARKO"]) }], 
    g_injectXmarkoX_differenceXV_valuesXnameX_foldX: [function({g}) { return g.inject(["marko"]).difference(__.V().values("name").fold()) }], 
    g_V_valueMapXlocationX_selectXvaluesX_unfold_differenceXseattle_vancouverX: [function({g}) { return g.V().valueMap("location").select(Column.values).unfold().difference(["seattle", "vancouver"]) }], 
    g_V_out_out_path_byXnameX_differenceXrippleX: [function({g}) { return g.V().out().out().path().by("name").difference(["ripple"]) }], 
    g_V_out_out_path_byXnameX_differenceXempty_listX: [function({g}) { return g.V().out().out().path().by("name").difference([]) }], 
    g_V_valuesXageX_fold_differenceXconstantX27X_foldX: [function({g}) { return g.V().values("age").fold().difference(__.constant(27).fold()) }], 
    g_V_out_out_path_byXnameX_differenceXdave_kelvinX: [function({g}) { return g.V().out().out().path().by("name").difference(["dave", "kelvin"]) }], 
    g_injectXa_null_bX_differenceXa_cX: [function({g}) { return g.inject(["a", null, "b"]).difference(["a", "c"]) }], 
    g_injectXa_null_bX_differenceXa_null_cX: [function({g}) { return g.inject(["a", null, "b"]).difference(["a", null, "c"]) }], 
    g_injectX3_threeX_differenceXfive_three_7X: [function({g}) { return g.inject([3, "three"]).difference(["five", "three", 7]) }], 
    g_injectXnullX_disjunctXinjectX1XX: [function({g}) { return g.inject(null).disjunct(__.inject(1)) }], 
    g_V_valuesXnameX_disjunctXV_foldX: [function({g}) { return g.V().values("name").disjunct(__.V().fold()) }], 
    g_V_fold_disjunctXconstantXnullXX: [function({g}) { return g.V().fold().disjunct(__.constant(null)) }], 
    g_V_fold_disjunctXVX: [function({g}) { return g.V().fold().disjunct(__.V()) }], 
    g_V_valuesXnameX_fold_disjunctX2X: [function({g}) { return g.V().values("name").fold().disjunct(2) }], 
    g_V_valuesXnameX_fold_disjunctXnullX: [function({g}) { return g.V().values("name").fold().disjunct(null) }], 
    g_V_valuesXnonexistantX_fold_disjunctXV_valuesXnameX_foldX: [function({g}) { return g.V().values("nonexistant").fold().disjunct(__.V().values("name").fold()) }], 
    g_V_valuesXnameX_fold_disjunctXV_valuesXnonexistantX_foldX: [function({g}) { return g.V().values("name").fold().disjunct(__.V().values("nonexistant").fold()) }], 
    g_V_valuesXageX_fold_disjunctXV_valuesXageX_foldX: [function({g}) { return g.V().values("age").fold().disjunct(__.V().values("age").fold()) }], 
    g_V_out_path_byXvaluesXnameX_toUpperX_disjunctXMARKOX: [function({g}) { return g.V().out().path().by(__.values("name").toUpper()).disjunct(["MARKO"]) }], 
    g_V_valueMapXlocationX_selectXvaluesX_unfold_disjunctXseattle_vancouverX: [function({g}) { return g.V().valueMap("location").select(Column.values).unfold().disjunct(["seattle", "vancouver"]) }], 
    g_V_out_out_path_byXnameX_disjunctXmarkoX: [function({g}) { return g.V().out().out().path().by("name").disjunct(["marko"]) }], 
    g_V_out_out_path_byXnameX_disjunctXstephen_markoX: [function({g}) { return g.V().out().out().path().by("name").disjunct(["stephen", "marko"]) }], 
    g_V_out_out_path_byXnameX_disjunctXdave_kelvinX: [function({g}) { return g.V().out().out().path().by("name").disjunct(["dave", "kelvin"]) }], 
    g_injectXa_null_bX_disjunctXa_cX: [function({g}) { return g.inject(["a", null, "b"]).disjunct(["a", "c"]) }], 
    g_injectXa_null_bX_disjunctXa_null_cX: [function({g}) { return g.inject(["a", null, "b"]).disjunct(["a", null, "c"]) }], 
    g_injectX3_threeX_disjunctXfive_three_7X: [function({g}) { return g.inject([3, "three"]).disjunct(["five", "three", 7]) }], 
    g_E: [function({g}) { return g.E() }], 
    g_EX11X: [function({g, eid11}) { return g.E(eid11) }], 
    g_EX11AsStringX: [function({g, eid11}) { return g.E(eid11) }], 
    g_EXe11X: [function({g, e11}) { return g.E(e11) }], 
    g_EXe7_e11X: [function({g, e7, e11}) { return g.E(e7, e11) }], 
    g_EXlistXe7_e11XX: [function({g, xx1}) { return g.E(xx1) }], 
    g_EXnullX: [function({g}) { return g.E(null) }], 
    g_EXlistXnullXX: [function({g, xx1}) { return g.E(xx1) }], 
    g_EX11_nullX: [function({g, eid11}) { return g.E(eid11, null) }], 
    g_V_EX11X: [function({g, eid11}) { return g.V().E(eid11) }], 
    g_EX11X_E: [function({g, eid11}) { return g.E(eid11).E() }], 
    g_V_EXnullX: [function({g}) { return g.V().E(null) }], 
    g_V_EXlistXnullXX: [function({g, xx1}) { return g.V().E(xx1) }], 
    g_injectX1X_EX11_nullX: [function({g, eid11}) { return g.inject(1).E(eid11, null) }], 
    g_injectX1X_coalesceXEX_hasLabelXtestsX_addEXtestsX_from_V_hasXnameX_XjoshXX_toXV_hasXnameX_XvadasXXX: [function({g}) { return g.addV("person").property("name", "josh").addV("person").property("name", "vadas") }, function({g}) { return g.inject(1).coalesce(__.E().hasLabel("tests"), __.addE("tests").from_(__.V().has("name", "josh")).to(__.V().has("name", "vadas"))) }, function({g}) { return g.E().hasLabel("tests") }], 
    g_VX1X_outE_inV: [function({g, vid1}) { return g.V(vid1).outE().inV() }], 
    g_VX2X_inE_outV: [function({g, vid2}) { return g.V(vid2).inE().outV() }], 
    g_V_outE_hasXweight_1X_outV: [function({g}) { return g.V().outE().has("weight", 1.0).outV() }], 
    g_VX1X_outE_otherV: [function({g, vid1}) { return g.V(vid1).outE().otherV() }], 
    g_VX4X_bothE_otherV: [function({g, vid4}) { return g.V(vid4).bothE().otherV() }], 
    g_VX4X_bothE_hasXweight_lt_1X_otherV: [function({g, vid4}) { return g.V(vid4).bothE().has("weight", P.lt(1.0)).otherV() }], 
    get_g_VX1X_outE_otherV: [function({g, vid1}) { return g.V(vid1).outE().otherV() }], 
    g_VX1X_outEXknowsX_inV: [function({g, vid1}) { return g.V(vid1).outE("knows").inV() }], 
    g_VX1X_outEXknows_createdX_inV: [function({g, vid1}) { return g.V(vid1).outE("knows", "created").inV() }], 
    g_VX1X_outEXknowsX_bothV: [function({g, vid1}) { return g.V(vid1).outE("knows").bothV() }], 
    g_VX1X_outEXknowsX_bothV_name: [function({g, vid1}) { return g.V(vid1).outE("knows").bothV().values("name") }], 
    g_VX1X_properties_element: [function({g, vid2}) { return g.V(vid2).properties().element().limit(1) }], 
    g_V_properties_element: [function({g}) { return g.V().properties().element() }], 
    g_V_propertiesXageX_element: [function({g}) { return g.V().properties("age").element() }], 
    g_EX_properties_element: [function({g, eid11}) { return g.E(eid11).properties().element().limit(1) }], 
    g_E_properties_element: [function({g}) { return g.E().properties().element() }], 
    g_VXv7_properties_properties_element_element: [function({g, vid7}) { return g.V(vid7).properties().properties().element().element().limit(1) }], 
    g_V_properties_properties_element_element: [function({g, vid7}) { return g.V(vid7).properties().properties().element().element() }], 
    g_V_elementMap: [function({g}) { return g.V().elementMap() }], 
    g_V_elementMapXname_ageX: [function({g}) { return g.V().elementMap("name", "age") }], 
    g_EX11X_elementMap: [function({g, eid11}) { return g.E(eid11).elementMap() }], 
    g_V_elementMapXname_age_nullX: [function({g}) { return g.V().elementMap("name", "age", null) }], 
    g_V_asXaX_flatMapXselectXaXX: [function({g}) { return g.V().as("a").flatMap(__.select("a")) }], 
    g_V_valuesXnameX_flatMapXsplitXaX_unfoldX: [function({g}) { return g.V().values("name").flatMap(__.split("a").unfold()) }], 
    g_V_flatMapXout_outX_path: [function({g}) { return g.V().flatMap(__.out().out()).path() }], 
    g_V_fold: [function({g}) { return g.V().fold() }], 
    g_V_fold_unfold: [function({g}) { return g.V().fold().unfold() }], 
    g_V_age_foldX0_plusX: [function({g}) { return g.V().values("age").fold(0, Operator.sum) }], 
    g_injectXa1_b2X_foldXm_addAllX: [function({g}) { return g.inject(new Map([["a", 1]]), new Map([["b", 2]])).fold(new Map([]), Operator.addAll) }], 
    g_injectXa1_b2_b4X_foldXm_addAllX: [function({g}) { return g.inject(new Map([["a", 1]]), new Map([["b", 2]]), new Map([["b", 4]])).fold(new Map([]), Operator.addAll) }], 
    g_VX1X_formatXstrX: [function({g}) { return g.V().has("name", "marko").format("Hello world") }], 
    g_V_formatXstrX: [function({g}) { return g.V().format("%{name} is %{age} years old") }], 
    g_injectX1X_asXageX_V_formatXstrX: [function({g}) { return g.inject(1).as("age").V().format("%{name} is %{age} years old") }], 
    g_V_formatXstrX_byXvaluesXnameXX_byXvaluesXageXX: [function({g}) { return g.V().format("%{_} is %{_} years old").by(__.values("name")).by(__.values("age")) }], 
    g_V_hasLabelXpersonX_formatXstrX_byXconstantXhelloXX_byXvaluesXnameXX: [function({g}) { return g.V().hasLabel("person").format("%{_} %{_} %{_}").by(__.constant("hello")).by(__.values("name")) }], 
    g_VX1X_formatXstrX_byXconstantXhelloXX_byXvaluesXnameXX: [function({g, vid1}) { return g.V(vid1).format("%{_}").by(__.constant("hello")).by(__.values("name")) }], 
    g_V_formatXstrX_byXbothE_countX: [function({g}) { return g.V().format("%{name} has %{_} connections").by(__.bothE().count()) }], 
    g_V_projectXname_countX_byXvaluesXnameXX_byXbothE_countX_formatXstrX: [function({g}) { return g.V().project("name", "count").by(__.values("name")).by(__.bothE().count()).format("%{name} has %{count} connections") }], 
    g_V_elementMap_formatXstrX: [function({g}) { return g.V().elementMap().format("%{name} is %{age} years old") }], 
    g_V_hasLabelXpersonX_asXaX_valuesXnameX_asXp1X_selectXaX_inXknowsX_formatXstrX: [function({g}) { return g.V().hasLabel("person").as("a").values("name").as("p1").select("a").in_("knows").format("%{p1} knows %{name}") }], 
    g_V_asXsX_label_asXsubjectX_selectXsX_outE_asXpX_label_asXpredicateX_selectXpX_inV_label_asXobjectX_formatXstrX: [function({g}) { return g.V().as("s").label().as("subject").select("s").outE().as("p").label().as("predicate").select("p").inV().label().as("object").format("%{subject} %{predicate} %{object}") }], 
    g_V_hasLabelXsoftwareX_index_unfold: [function({g}) { return g.V().hasLabel("software").index().unfold() }], 
    g_V_hasLabelXsoftwareX_order_byXnameX_index_withXmapX: [function({g}) { return g.V().hasLabel("software").order().by("name").index().with_(WithOptions.indexer, WithOptions.map) }], 
    g_V_hasLabelXsoftwareX_name_fold_orderXlocalX_index_unfold_order_byXtailXlocal_1XX: [function({g}) { return g.V().hasLabel("software").values("name").fold().order(Scope.local).index().unfold().order().by(__.tail(Scope.local, 1)) }], 
    g_V_hasLabelXpersonX_name_fold_orderXlocalX_index_withXmapX: [function({g}) { return g.V().hasLabel("person").values("name").fold().order(Scope.local).index().with_(WithOptions.indexer, WithOptions.map) }], 
    g_VX1X_valuesXageX_index_unfold_unfold: [function({g, vid1}) { return g.V(vid1).values("age").index().unfold().unfold() }], 
    g_injectXnullX_intersectXinjectX1XX: [function({g}) { return g.inject(null).intersect(__.inject(1)) }], 
    g_V_valuesXnameX_intersectXV_foldX: [function({g}) { return g.V().values("name").intersect(__.V().fold()) }], 
    g_V_fold_intersectXconstantXnullXX: [function({g}) { return g.V().fold().intersect(__.constant(null)) }], 
    g_V_fold_intersectXVX: [function({g}) { return g.V().fold().intersect(__.V()) }], 
    g_V_valuesXnameX_fold_intersectX2X: [function({g}) { return g.V().values("name").fold().intersect(2) }], 
    g_V_valuesXnameX_fold_intersectXnullX: [function({g}) { return g.V().values("name").fold().intersect(null) }], 
    g_V_valuesXnonexistantX_fold_intersectXV_valuesXnameX_foldX: [function({g}) { return g.V().values("nonexistant").fold().intersect(__.V().values("name").fold()) }], 
    g_V_valuesXnameX_fold_intersectXV_valuesXnonexistantX_foldX: [function({g}) { return g.V().values("name").fold().intersect(__.V().values("nonexistant").fold()) }], 
    g_V_valuesXageX_fold_intersectXV_valuesXageX_foldX_order_local: [function({g}) { return g.V().values("age").fold().intersect(__.V().values("age").fold()).order(Scope.local) }], 
    g_V_out_path_byXvaluesXnameX_toUpperX_intersectXMARKOX: [function({g}) { return g.V().out().path().by(__.values("name").toUpper()).intersect(["MARKO"]) }], 
    g_injectXmarkoX_intersectX___V_valuesXnameX_foldX: [function({g}) { return g.inject(["marko"]).intersect(__.V().values("name").fold()) }], 
    g_V_valueMapXlocationX_selectXvaluesX_unfold_intersectXseattle_vancouverX: [function({g}) { return g.V().valueMap("location").select(Column.values).unfold().intersect(["seattle", "vancouver"]) }], 
    g_V_valuesXageX_fold_intersectX___constantX27X_foldX: [function({g}) { return g.V().values("age").fold().intersect(__.constant(27).fold()) }], 
    g_V_out_out_path_byXnameX_intersectXdave_kelvinX: [function({g}) { return g.V().out().out().path().by("name").intersect(["dave", "kelvin"]) }], 
    g_injectXa_null_bX_intersectXa_cX: [function({g}) { return g.inject(["a", null, "b"]).intersect(["a", "c"]) }], 
    g_injectXa_null_bX_intersectXa_null_cX: [function({g}) { return g.inject(["a", null, "b"]).intersect(["a", null, "c"]) }], 
    g_injectX3_threeX_intersectXfive_three_7X: [function({g}) { return g.inject([3, "three"]).intersect(["five", "three", 7]) }], 
    g_injectX__feature___test__nullX_lTrim: [function({g}) { return g.inject("  feature", " one test", null, "", " ", "　abc", "abc　", "　abc　", "　　").lTrim() }], 
    g_injectX__feature___test__nullX_lTrimXlocalX: [function({g}) { return g.inject(["  feature  ", " one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　"]).lTrim(Scope.local) }], 
    g_injectX__feature__X_lTrim: [function({g}) { return g.inject("  feature  ").lTrim() }], 
    g_injectXListXa_bXX_lTrim: [function({g}) { return g.inject(["a", "b"]).lTrim() }], 
    g_injectXListX1_2XX_lTrimXlocalX: [function({g}) { return g.inject([1, 2]).lTrim(Scope.local) }], 
    g_V_valuesXnameX_lTrim: [function({g}) { return g.addV("person").property("name", " marko ").property("age", 29).as("marko").addV("person").property("name", "  vadas  ").property("age", 27).as("vadas").addV("software").property("name", "  lop").property("lang", "java").as("lop").addV("person").property("name", "josh  ").property("age", 32).as("josh").addV("software").property("name", "   ripple   ").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().values("name").lTrim() }], 
    g_V_valuesXnameX_order_fold_lTrimXlocalX: [function({g}) { return g.addV("person").property("name", " marko ").property("age", 29).as("marko").addV("person").property("name", "  vadas  ").property("age", 27).as("vadas").addV("software").property("name", "  lop").property("lang", "java").as("lop").addV("person").property("name", "josh  ").property("age", 32).as("josh").addV("software").property("name", "   ripple   ").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().values("name").order().fold().lTrim(Scope.local) }], 
    g_injectXfeature_test_nullX_length: [function({g}) { return g.inject("feature", "test", null).length() }], 
    g_injectXfeature_test_nullX_lengthXlocalX: [function({g}) { return g.inject("feature", "test", null).length(Scope.local) }], 
    g_injectXListXa_bXX_length: [function({g}) { return g.inject(["a", "b"]).length() }], 
    g_V_valuesXnameX_length: [function({g}) { return g.V().values("name").length() }], 
    g_V_valuesXnameX_order_fold_lengthXlocalX: [function({g}) { return g.V().values("name").order().fold().length(Scope.local) }], 
    g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX3XX_hasXname_peterX_path_byXnameX: [function({g, vid1}) { return g.V(vid1).repeat(__.both().simplePath()).until(__.has("name", "peter").or().loops().is(3)).has("name", "peter").path().by("name") }], 
    g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_or_loops_isX2XX_hasXname_peterX_path_byXnameX: [function({g, vid1}) { return g.V(vid1).repeat(__.both().simplePath()).until(__.has("name", "peter").or().loops().is(2)).has("name", "peter").path().by("name") }], 
    g_VX1X_repeatXboth_simplePathX_untilXhasXname_peterX_and_loops_isX3XX_hasXname_peterX_path_byXnameX: [function({g, vid1}) { return g.V(vid1).repeat(__.both().simplePath()).until(__.has("name", "peter").and().loops().is(3)).has("name", "peter").path().by("name") }], 
    g_V_emitXhasXname_markoX_or_loops_isX2XX_repeatXoutX_valuesXnameX: [function({g}) { return g.V().emit(__.has("name", "marko").or().loops().is(2)).repeat(__.out()).values("name") }], 
    g_VX1X_mapXvaluesXnameXX: [function({g, vid1}) { return g.V(vid1).map(__.values("name")) }], 
    g_VX1X_outE_label_mapXlengthX: [function({g, vid1}) { return g.V(vid1).outE().label().map(__.length()) }], 
    g_VX1X_out_mapXvaluesXnameXX_mapXlengthX: [function({g, vid1}) { return g.V(vid1).out().map(__.values("name")).map(__.length()) }], 
    g_withPath_V_asXaX_out_mapXselectXaX_valuesXnameXX: [function({g}) { return g.withPath().V().as("a").out().map(__.select("a").values("name")) }], 
    g_withPath_V_asXaX_out_out_asXbX_mapXselectXaX_valuesXnameX_concatXselectXbX_valuesXnameXXX: [function({g}) { return g.withPath().V().as("a").out().out().as("b").map(__.select("a").values("name").concat(__.select("b").values("name"))) }], 
    g_V_mapXselectXaXX: [function({g}) { return g.V().as("a").map(__.select("a")) }], 
    g_V_mapXconstantXnullXX: [function({g}) { return g.V().map(__.constant(null)) }], 
    g_V_valueMap_matchXa_selectXnameX_bX: [function({g}) { return g.V().valueMap().match(__.as("a").select("name").as("b")) }], 
    g_V_matchXa_out_bX: [function({g}) { return g.V().match(__.as("a").out().as("b")) }], 
    g_V_matchXa_out_bX_selectXb_idX: [function({g}) { return g.V().match(__.as("a").out().as("b")).select("b").by(T.id) }], 
    g_V_matchXa_knows_b__b_created_cX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"), __.as("b").out("created").as("c")) }], 
    g_V_matchXb_created_c__a_knows_bX: [function({g}) { return g.V().match(__.as("b").out("created").as("c"), __.as("a").out("knows").as("b")) }], 
    g_V_matchXa_created_b__b_0created_cX_whereXa_neq_cX_selectXa_cX: [function({g}) { return g.V().match(__.as("a").out("created").as("b"), __.as("b").in_("created").as("c")).where("a", P.neq("c")).select("a", "c") }], 
    g_V_matchXd_0knows_a__d_hasXname_vadasX__a_knows_b__b_created_cX: [function({g}) { return g.V().match(__.as("d").in_("knows").as("a"), __.as("d").has("name", "vadas"), __.as("a").out("knows").as("b"), __.as("b").out("created").as("c")) }], 
    g_V_matchXa_created_lop_b__b_0created_29_c__c_whereXrepeatXoutX_timesX2XXX: [function({g}) { return g.V().match(__.as("a").out("created").has("name", "lop").as("b"), __.as("b").in_("created").has("age", 29).as("c"), __.as("c").where(__.repeat(__.out()).times(2))) }], 
    g_V_asXaX_out_asXbX_matchXa_out_count_c__b_in_count_cX: [function({g}) { return g.V().as("a").out().as("b").match(__.as("a").out().count().as("c"), __.as("b").in_().count().as("c")) }], 
    g_V_matchXa__a_out_b__notXa_created_bXX: [function({g}) { return g.V().match(__.as("a").out().as("b"), __.not(__.as("a").out("created").as("b"))) }], 
    g_V_matchXa_created_lop_b__b_0created_29_cX_whereXc_repeatXoutX_timesX2XX_selectXa_b_cX: [function({g}) { return g.V().match(__.as("a").out("created").has("name", "lop").as("b"), __.as("b").in_("created").has("age", 29).as("c")).where(__.as("c").repeat(__.out()).times(2)).select("a", "b", "c") }], 
    g_V_out_out_matchXa_0created_b__b_0knows_cX_selectXcX_outXcreatedX_name: [function({g}) { return g.V().out().out().match(__.as("a").in_("created").as("b"), __.as("b").in_("knows").as("c")).select("c").out("created").values("name") }], 
    g_V_matchXa_knows_b__b_created_c__a_created_cX_dedupXa_b_cX_selectXaX_byXnameX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"), __.as("b").out("created").as("c"), __.as("a").out("created").as("c")).dedup("a", "b", "c").select("a").by("name") }], 
    g_V_matchXa_created_b__a_repeatXoutX_timesX2XX_selectXa_bX: [function({g}) { return g.V().match(__.as("a").out("created").as("b"), __.as("a").repeat(__.out()).times(2).as("b")).select("a", "b") }], 
    g_V_notXmatchXa_age_b__a_name_cX_whereXb_eqXcXX_selectXaXX_name: [function({g}) { return g.V().not(__.match(__.as("a").values("age").as("b"), __.as("a").values("name").as("c")).where("b", P.eq("c")).select("a")).values("name") }], 
    g_V_matchXa_knows_b__andXa_created_c__b_created_c__andXb_created_count_d__a_knows_count_dXXX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"), __.and(__.as("a").out("created").as("c"), __.as("b").out("created").as("c"), __.and(__.as("b").out("created").count().as("d"), __.as("a").out("knows").count().as("d")))) }], 
    g_V_matchXa_whereXa_neqXcXX__a_created_b__orXa_knows_vadas__a_0knows_and_a_hasXlabel_personXX__b_0created_c__b_0created_count_isXgtX1XXX_selectXa_b_cX_byXidX: [function({g}) { return g.V().match(__.where("a", P.neq("c")), __.as("a").out("created").as("b"), __.or(__.as("a").out("knows").has("name", "vadas"), __.as("a").in_("knows").and().as("a").has(T.label, "person")), __.as("b").in_("created").as("c"), __.as("b").in_("created").count().is(P.gt(1))).select("a", "b", "c").by(T.id) }], 
    g_V_matchXa__a_both_b__b_both_cX_dedupXa_bX: [function({g}) { return g.V().match(__.as("a").both().as("b"), __.as("b").both().as("c")).dedup("a", "b") }], 
    g_V_matchXa_knows_b__b_created_lop__b_matchXb_created_d__d_0created_cX_selectXcX_cX_selectXa_b_cX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"), __.as("b").out("created").has("name", "lop"), __.as("b").match(__.as("b").out("created").as("d"), __.as("d").in_("created").as("c")).select("c").as("c")).select("a", "b", "c") }], 
    g_V_matchXa_knows_b__a_created_cX: [function({g}) { return g.V().match(__.as("a").out("knows").as("b"), __.as("a").out("created").as("c")) }], 
    g_V_matchXwhereXandXa_created_b__b_0created_count_isXeqX3XXXX__a_both_b__whereXb_inXX: [function({g}) { return g.V().match(__.where(__.and(__.as("a").out("created").as("b"), __.as("b").in_("created").count().is(P.eq(3)))), __.as("a").both().as("b"), __.where(__.as("b").in_())) }], 
    g_V_matchXa_outEXcreatedX_order_byXweight_descX_limitX1X_inV_b__b_hasXlang_javaXX_selectXa_bX_byXnameX: [function({g}) { return g.V().match(__.as("a").outE("created").order().by("weight", Order.desc).limit(1).inV().as("b"), __.as("b").has("lang", "java")).select("a", "b").by("name") }], 
    g_V_matchXa_both_b__b_both_cX_dedupXa_bX_byXlabelX: [function({g}) { return g.V().match(__.as("a").both().as("b"), __.as("b").both().as("c")).dedup("a", "b").by(T.label) }], 
    g_V_matchXa_created_b__b_0created_aX: [function({g}) { return g.V().match(__.as("a").out("created").as("b"), __.as("b").in_("created").as("a")) }], 
    g_V_asXaX_out_asXbX_matchXa_out_count_c__orXa_knows_b__b_in_count_c__and__c_isXgtX2XXXX: [function({g}) { return g.V().as("a").out().as("b").match(__.as("a").out().count().as("c"), __.or(__.as("a").out("knows").as("b"), __.as("b").in_().count().as("c").and().as("c").is(P.gt(2)))) }], 
    g_V_matchXa_knows_count_bX_selectXbX: [function({g}) { return g.V().match(__.as("a").out("knows").count().as("b")).select("b") }], 
    g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_d__c_sungBy_d__d_hasXname_GarciaXX: [function({g}) { return g.V().match(__.as("a").in_("sungBy").as("b"), __.as("a").in_("writtenBy").as("c"), __.as("b").out("writtenBy").as("d"), __.as("c").out("sungBy").as("d"), __.as("d").has("name", "Garcia")) }], 
    g_V_matchXa_hasXsong_name_sunshineX__a_mapX0followedBy_weight_meanX_b__a_0followedBy_c__c_filterXweight_whereXgteXbXXX_outV_dX_selectXdX_byXnameX: [function({g}) { return g.V().match(__.as("a").has("song", "name", "HERE COMES SUNSHINE"), __.as("a").map(__.inE("followedBy").values("weight").mean()).as("b"), __.as("a").inE("followedBy").as("c"), __.as("c").filter(__.values("weight").where(P.gte("b"))).outV().as("d")).select("d").by("name") }], 
    g_V_matchXa_0sungBy_b__a_0sungBy_c__b_writtenBy_d__c_writtenBy_e__d_hasXname_George_HarisonX__e_hasXname_Bob_MarleyXX: [function({g}) { return g.V().match(__.as("a").in_("sungBy").as("b"), __.as("a").in_("sungBy").as("c"), __.as("b").out("writtenBy").as("d"), __.as("c").out("writtenBy").as("e"), __.as("d").has("name", "George_Harrison"), __.as("e").has("name", "Bob_Marley")) }], 
    g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__a_0sungBy_bX: [function({g}) { return g.V().match(__.as("a").has("name", "Garcia"), __.as("a").in_("writtenBy").as("b"), __.as("a").in_("sungBy").as("b")) }], 
    g_V_hasLabelXsongsX_matchXa_name_b__a_performances_cX_selectXb_cX_count: [function({g}) { return g.V().hasLabel("song").match(__.as("a").values("name").as("b"), __.as("a").values("performances").as("c")).select("b", "c").count() }], 
    g_V_matchXa_followedBy_count_isXgtX10XX_b__a_0followedBy_count_isXgtX10XX_bX_count: [function({g}) { return g.V().match(__.as("a").out("followedBy").count().is(P.gt(10)).as("b"), __.as("a").in_("followedBy").count().is(P.gt(10)).as("b")).count() }], 
    g_V_matchXa_0sungBy_b__a_0writtenBy_c__b_writtenBy_dX_whereXc_sungBy_dX_whereXd_hasXname_GarciaXX: [function({g}) { return g.V().match(__.as("a").in_("sungBy").as("b"), __.as("a").in_("writtenBy").as("c"), __.as("b").out("writtenBy").as("d")).where(__.as("c").out("sungBy").as("d")).where(__.as("d").has("name", "Garcia")) }], 
    g_V_matchXa_hasXname_GarciaX__a_0writtenBy_b__b_followedBy_c__c_writtenBy_d__whereXd_neqXaXXX: [function({g}) { return g.V().match(__.as("a").has("name", "Garcia"), __.as("a").in_("writtenBy").as("b"), __.as("b").out("followedBy").as("c"), __.as("c").out("writtenBy").as("d"), __.where("d", P.neq("a"))) }], 
    g_V_matchXa_outXknowsX_name_bX_identity: [function({g}) { return g.V().match(__.as("a").out("knows").values("name").as("b")).identity() }], 
    g_V_outE_mathX0_minus_itX_byXweightX: [function({g}) { return g.V().outE().math("0-_").by("weight") }], 
    g_V_hasXageX_valueMap_mathXit_plus_itXbyXselectXageX_unfoldXX: [function({g}) { return g.V().has("age").valueMap().math("_+_").by(__.select("age").unfold()) }], 
    g_V_asXaX_outXknowsX_asXbX_mathXa_plus_bX_byXageX: [function({g}) { return g.V().as("a").out("knows").as("b").math("a + b").by("age") }], 
    g_withSideEffectXx_100X_V_age_mathX__plus_xX: [function({g}) { return g.withSideEffect("x", 100).V().values("age").math("_ + x") }], 
    g_V_asXaX_outXcreatedX_asXbX_mathXb_plus_aX_byXinXcreatedX_countX_byXageX: [function({g}) { return g.V().as("a").out("created").as("b").math("b + a").by(__.in_("created").count()).by("age") }], 
    g_withSackX1X_injectX1X_repeatXsackXsumX_byXconstantX1XXX_timesX5X_emit_mathXsin__X_byXsackX: [function({g}) { return g.withSack(1).inject(1).repeat(__.sack(Operator.sum).by(__.constant(1))).times(5).emit().math("sin _").by(__.sack()) }], 
    g_V_projectXa_b_cX_byXbothE_weight_sumX_byXbothE_countX_byXnameX_order_byXmathXa_div_bX_descX_selectXcX: [function({g}) { return g.V().project("a", "b", "c").by(__.bothE().values("weight").sum()).by(__.bothE().count()).by("name").order().by(__.math("a / b"), Order.desc).select("c") }], 
    g_V_mathXit_plus_itXbyXageX: [function({g}) { return g.V().math("_+_").by("age") }], 
    g_V_valueMap_mathXit_plus_itXbyXselectXageX_unfoldXX: [function({g}) { return g.V().valueMap().math("_+_").by(__.select("age").unfold()) }], 
    g_VX1X_outE_asXexpectedWeightX_mathXexpectedWeightPlusOneXbyXweightX: [function({g, vid1}) { return g.V(vid1).outE().as("expectedWeight").math("expectedWeight + 1").by("weight") }], 
    g_V_age_max: [function({g}) { return g.V().values("age").max() }], 
    g_V_foo_max: [function({g}) { return g.V().values("foo").max() }], 
    g_V_name_max: [function({g}) { return g.V().values("name").max() }], 
    g_V_age_fold_maxXlocalX: [function({g}) { return g.V().values("age").fold().max(Scope.local) }], 
    g_V_aggregateXaX_byXageX_capXaX_maxXlocalX: [function({g}) { return g.V().aggregate("a").by("age").cap("a").max(Scope.local) }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_maxXlocalX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("age").cap("a").max(Scope.local) }], 
    g_V_aggregateXaX_byXageX_capXaX_unfold_max: [function({g}) { return g.V().aggregate("a").by("age").cap("a").unfold().max() }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_max: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("age").cap("a").unfold().max() }], 
    g_V_aggregateXaX_byXfooX_capXaX_maxXlocalX: [function({g}) { return g.V().aggregate("a").by("foo").cap("a").max(Scope.local) }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_maxXlocalX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("foo").cap("a").max(Scope.local) }], 
    g_V_aggregateXaX_byXfooX_capXaX_unfold_max: [function({g}) { return g.V().aggregate("a").by("foo").cap("a").unfold().max() }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_max: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("foo").cap("a").unfold().max() }], 
    g_V_foo_fold_maxXlocalX: [function({g}) { return g.V().values("foo").fold().max(Scope.local) }], 
    g_V_name_fold_maxXlocalX: [function({g}) { return g.V().values("name").fold().max(Scope.local) }], 
    g_V_repeatXbothX_timesX5X_age_max: [function({g}) { return g.V().repeat(__.both()).times(5).values("age").max() }], 
    g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_maxX: [function({g}) { return g.V().hasLabel("software").group().by("name").by(__.bothE().values("weight").max()) }], 
    g_VX1X_valuesXageX_maxXlocalX: [function({g, vid1}) { return g.V(vid1).values("age").max(Scope.local) }], 
    g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_maxXlocalX: [function({g}) { return g.V().local(__.union(__.values("age"), __.outE().values("weight")).fold()).max(Scope.local) }], 
    g_V_age_mean: [function({g}) { return g.V().values("age").mean() }], 
    g_V_foo_mean: [function({g}) { return g.V().values("foo").mean() }], 
    g_V_age_fold_meanXlocalX: [function({g}) { return g.V().values("age").fold().mean(Scope.local) }], 
    g_V_foo_fold_meanXlocalX: [function({g}) { return g.V().values("foo").fold().mean(Scope.local) }], 
    g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_meanX: [function({g}) { return g.V().hasLabel("software").group().by("name").by(__.bothE().values("weight").mean()) }], 
    g_V_aggregateXaX_byXageX_meanXlocalX: [function({g}) { return g.V().aggregate("a").by("age").cap("a").mean(Scope.local) }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_meanXlocalX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("age").cap("a").mean(Scope.local) }], 
    g_V_aggregateXaX_byXageX_capXaX_unfold_mean: [function({g}) { return g.V().aggregate("a").by("age").cap("a").unfold().mean() }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_mean: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("age").cap("a").unfold().mean() }], 
    g_V_aggregateXaX_byXfooX_meanXlocalX: [function({g}) { return g.V().aggregate("a").by("foo").cap("a").mean(Scope.local) }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_meanXlocalX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("foo").cap("a").mean(Scope.local) }], 
    g_V_aggregateXaX_byXfooX_capXaX_unfold_mean: [function({g}) { return g.V().aggregate("a").by("foo").cap("a").unfold().mean() }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_mean: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("foo").cap("a").unfold().mean() }], 
    g_injectXnull_10_20_nullX_mean: [function({g}) { return g.inject(null, 10, 20, null).mean() }], 
    g_injectXlistXnull_10_20_nullXX_meanXlocalX: [function({g}) { return g.inject([null, 10, 20, null]).mean(Scope.local) }], 
    g_VX1X_valuesXageX_meanXlocalX: [function({g, vid1}) { return g.V(vid1).values("age").mean(Scope.local) }], 
    g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_meanXlocalX: [function({g}) { return g.V().local(__.union(__.values("age"), __.outE().values("weight")).fold()).mean(Scope.local) }], 
    g_injectXnullX_mergeXinjectX1XX: [function({g}) { return g.inject(null).merge(__.inject(1)) }], 
    g_V_valuesXnameX_mergeXV_foldX: [function({g}) { return g.V().values("name").merge(__.V().fold()) }], 
    g_V_fold_mergeXconstantXnullXX: [function({g}) { return g.V().fold().merge(__.constant(null)) }], 
    g_V_fold_mergeXVX: [function({g}) { return g.V().fold().merge(__.V()) }], 
    g_V_elementMap_mergeXconstantXaXX: [function({g}) { return g.V().elementMap().merge(__.constant("a")) }], 
    g_V_fold_mergeXV_asXaX_projectXaX_byXnameXX: [function({g}) { return g.V().fold().merge(__.V().as("a").project("a").by("name")) }], 
    g_V_fold_mergeXk_vX: [function({g}) { return g.V().fold().merge(new Map([["k", "v"]])) }], 
    g_V_valuesXnameX_fold_mergeX2X: [function({g}) { return g.V().values("name").fold().merge(2) }], 
    g_V_valuesXnameX_fold_mergeXnullX: [function({g}) { return g.V().values("name").fold().merge(null) }], 
    g_V_valuesXnonexistantX_fold_mergeXV_valuesXnameX_foldX: [function({g}) { return g.V().values("nonexistant").fold().merge(__.V().values("name").fold()) }], 
    g_V_valuesXnameX_fold_mergeXV_valuesXnonexistantX_foldX: [function({g}) { return g.V().values("name").fold().merge(__.V().values("nonexistant").fold()) }], 
    g_V_valuesXageX_fold_mergeXV_valuesXageX_foldX: [function({g}) { return g.V().values("age").fold().merge(__.V().values("age").fold()) }], 
    g_V_out_path_byXvaluesXnameX_toUpperX_mergeXMARKOX: [function({g}) { return g.V().out().path().by(__.values("name").toUpper()).merge(["MARKO"]) }], 
    g_injectXmarkoX_mergeXV_valuesXnameX_foldX: [function({g}) { return g.inject(["marko"]).merge(__.V().values("name").fold()) }], 
    g_V_valueMapXlocationX_selectXvaluesX_unfold_mergeXseattle_vancouverX: [function({g}) { return g.V().valueMap("location").select(Column.values).unfold().merge(["seattle", "vancouver"]) }], 
    g_V_out_out_path_byXnameX_mergeXempty_listX: [function({g}) { return g.V().out().out().path().by("name").merge([]) }], 
    g_V_valuesXageX_fold_mergeXconstantX27X_foldX: [function({g}) { return g.V().values("age").fold().merge(__.constant(27).fold()) }], 
    g_V_out_out_path_byXnameX_mergeXdave_kelvinX: [function({g}) { return g.V().out().out().path().by("name").merge(["dave", "kelvin"]) }], 
    g_injectXa_null_bX_mergeXa_cX: [function({g}) { return g.inject(["a", null, "b"]).merge(["a", "c"]) }], 
    g_injectXa_null_bX_mergeXa_null_cX: [function({g}) { return g.inject(["a", null, "b"]).merge(["a", null, "c"]) }], 
    g_injectX3_threeX_mergeXfive_three_7X: [function({g}) { return g.inject([3, "three"]).merge(["five", "three", 7]) }], 
    g_V_asXnameX_projectXnameX_byXnameX_mergeXother_blueprintX: [function({g}) { return g.V().as("name").project("name").by("name").merge(new Map([["other", "blueprint"]])) }], 
    g_V_hasXname_markoX_elementMap_mergeXV_hasXname_lopX_elementMapX: [function({g}) { return g.V().has("name", "marko").elementMap().merge(__.V().has("name", "lop").elementMap()) }], 
    g_V_mergeEXlabel_selfX_optionXonMatch_emptyX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29).addE("self") }, function({g, xx1}) { return g.V().mergeE(xx1).option(Merge.onMatch, new Map([])) }, function({g, xx1}) { return g.E() }, function({g, xx1}) { return g.E().properties() }, function({g, xx1}) { return g.V() }], 
    g_V_mergeEXlabel_selfX_optionXonMatch_nullX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29).addE("self") }, function({g, xx1}) { return g.V().mergeE(xx1).option(Merge.onMatch, null) }, function({g, xx1}) { return g.E() }, function({g, xx1}) { return g.E().properties() }, function({g, xx1}) { return g.V() }], 
    g_V_mergeEXemptyX_optionXonCreate_nullX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.V().as("v").mergeE(xx1).option(Merge.onCreate, null).option(Merge.outV, __.select("v")).option(Merge.inV, __.select("v")) }, function({g, xx1}) { return g.E() }, function({g, xx1}) { return g.V() }], 
    g_V_mergeE_inlineXemptyX_optionXonCreate_nullX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.V().as("v").mergeE(new Map([[T.label, "self"], [Direction.OUT, Merge.outV], [Direction.IN, Merge.inV]])).option(Merge.onCreate, null).option(Merge.outV, __.select("v")).option(Merge.inV, __.select("v")) }, function({g}) { return g.E() }, function({g}) { return g.V() }], 
    g_mergeEXemptyX_exists: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).addE("self") }, function({g}) { return g.mergeE(new Map([])) }, function({g}) { return g.E() }, function({g}) { return g.V() }], 
    g_mergeEXemptyX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.mergeE(new Map([])) }], 
    g_V_mergeEXemptyX_two_exist: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29).addV("person").property("name", "vadas").property("age", 27) }, function({g, xx1}) { return g.V().as("v").mergeE(xx1).option(Merge.outV, __.select("v")).option(Merge.inV, __.select("v")) }, function({g, xx1}) { return g.E() }, function({g, xx1}) { return g.V() }], 
    g_V_mergeE_inlineXemptyX_two_exist: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).addV("person").property("name", "vadas").property("age", 27) }, function({g}) { return g.V().as("v").mergeE(new Map([[T.label, "self"], [Direction.OUT, Merge.outV], [Direction.IN, Merge.inV]])).option(Merge.outV, __.select("v")).option(Merge.inV, __.select("v")) }, function({g}) { return g.E() }, function({g}) { return g.V() }], 
    g_mergeEXnullX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.mergeE(null) }], 
    g_mergeEXnullvarX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.mergeE(xx1) }], 
    g_V_limitX1X_mergeEXnullvarX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.V().limit(1).mergeE(xx1) }], 
    g_V_mergeEXnullX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.V().mergeE(null) }], 
    g_mergeEXlabel_knows_out_marko_in_vadasX: [function({g, xx1}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1}) { return g.mergeE(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "marko").out("knows").has("person", "name", "vadas") }], 
    g_withSideEffectXa_label_knows_out_marko_in_vadasX_mergeEXselectXaXX: [function({g}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g}) { return g.mergeE(__.select("a")) }, function({g}) { return g.V().has("person", "name", "marko").out("knows").has("person", "name", "vadas") }], 
    g_mergeEXlabel_knows_out_marko1_in_vadas1X: [function({g, xx1}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1}) { return g.mergeE(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "marko").out("knows").has("person", "name", "vadas") }], 
    g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X_exists: [function({g, xx1}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b") }, function({g, xx1}) { return g.mergeE(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "marko").outE("knows").has("weight", 0.5).inV().has("person", "name", "vadas") }, function({g, xx1}) { return g.V().has("person", "name", "marko").out("knows").has("person", "name", "vadas") }], 
    g_mergeEXlabel_knows_out_marko_in_vadas_weight_05X: [function({g, xx1}) { return g.mergeE(xx1) }], 
    g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX: [function({g, xx1, xx3, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2).option(Merge.onMatch, xx3) }], 
    g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists: [function({g, xx1, xx3, xx2}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b") }, function({g, xx1, xx3, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2).option(Merge.onMatch, xx3) }, function({g, xx1, xx3, xx2}) { return g.V() }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "N") }], 
    g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated: [function({g, xx1, xx3, xx2}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b").property("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2).option(Merge.onMatch, xx3) }, function({g, xx1, xx3, xx2}) { return g.V() }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "N") }], 
    g_V_hasXperson_name_marko_X_mergeEXlabel_knowsX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated: [function({g, xx1, xx3, xx2}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b").property("created", "Y").addE("knows").from_("a").to("b") }, function({g, xx1, xx3, xx2}) { return g.V().has("person", "name", "marko").mergeE(xx1).option(Merge.onCreate, xx2).option(Merge.onMatch, xx3) }, function({g, xx1, xx3, xx2}) { return g.V() }, function({g, xx1, xx3, xx2}) { return g.E() }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "N") }], 
    g_withSideEffectXlabel_knows_out_marko_in_vadasX_injectX1X_selectXmX_mergeE: [function({g}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g}) { return g.inject(1).select("m").mergeE() }, function({g}) { return g.V().has("person", "name", "marko").out("knows").has("person", "name", "vadas") }], 
    g_mergeEXlabel_knows_in_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated: [function({g, xx1, xx3, xx2}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b").property("created", "Y").addE("knows").from_("b").to("a").property("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2).option(Merge.onMatch, xx3) }, function({g, xx1, xx3, xx2}) { return g.V() }, function({g, xx1, xx3, xx2}) { return g.E() }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "N").inV().has("name", "vadas") }], 
    g_mergeEXlabel_knows_out_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated: [function({g, xx1, xx3, xx2}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b").property("created", "Y").addE("knows").from_("b").to("a").property("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2).option(Merge.onMatch, xx3) }, function({g, xx1, xx3, xx2}) { return g.V() }, function({g, xx1, xx3, xx2}) { return g.E() }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "N").outV().has("name", "vadas") }], 
    g_mergeEXout_vadasX_optionXonCreate_created_YX_optionXonMatch_created_NX_exists_updated: [function({g, xx1, xx3, xx2}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b").property("created", "Y").addE("knows").from_("b").to("a").property("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2).option(Merge.onMatch, xx3) }, function({g, xx1, xx3, xx2}) { return g.V() }, function({g, xx1, xx3, xx2}) { return g.E() }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1, xx3, xx2}) { return g.E().hasLabel("knows").has("created", "N").outV().has("name", "vadas") }], 
    g_V_hasXperson_name_marko_X_mergeEXlabel_self_out_vadas1_in_vadas1X: [function({g, xx1}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1}) { return g.V().has("person", "name", "marko").mergeE(xx1) }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.E() }, function({g, xx1}) { return g.E().hasLabel("self").bothV().has("name", "vadas") }], 
    g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX_exists: [function({g, xx1}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b") }, function({g, xx1}) { return g.mergeE(xx1).option(Merge.onCreate, __.select("c")).option(Merge.onMatch, __.select("m")) }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1}) { return g.E().hasLabel("knows").has("created", "N") }], 
    g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX: [function({g, xx1}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b") }, function({g, xx1}) { return g.mergeE(xx1).option(Merge.onCreate, __.select("c")).option(Merge.onMatch, __.select("m")) }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.E() }, function({g, xx1}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1}) { return g.E().hasLabel("knows").has("created", "N") }], 
    g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko1_in_vadas1X_optionXonCreate_selectXcXX_optionXonMatch_selectXmXX: [function({g, xx1}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b") }, function({g, xx1}) { return g.mergeE(xx1).option(Merge.onCreate, __.select("c")).option(Merge.onMatch, __.select("m")) }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.E() }, function({g, xx1}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1}) { return g.E().hasLabel("knows").has("created", "N") }], 
    g_mergeEXlabel_knows_out_marko_in_vadasX_aliased_direction: [function({g, xx1}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1}) { return g.mergeE(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "marko").out("knows").has("person", "name", "vadas") }], 
    g_withSideEffectXm1_label_knows_out_marko_in_vadas_m2_label_self_out_vadas_in_vadasX_unionXselectXm1X_selectXm2XX_mergeE: [function({g}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g}) { return g.union(__.select("m1"), __.select("m2")).mergeE() }, function({g}) { return g.V() }, function({g}) { return g.E() }, function({g}) { return g.V().has("person", "name", "marko").out("knows").has("person", "name", "vadas") }, function({g}) { return g.V().has("person", "name", "vadas").out("self").has("person", "name", "vadas") }], 
    g_withSideEffectXc_created_YX_withSideEffectXm_matchedX_mergeEXlabel_knows_out_marko_in_vadasX_optionXonCreate_selectXcXX_optionXonMatch_sideEffectXpropertiesXweightX_dropX_selectXmXX_exists: [function({g, xx1}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").property("weight", 1.0).from_("a").to("b") }, function({g, xx1}) { return g.mergeE(xx1).option(Merge.onCreate, __.select("c")).option(Merge.onMatch, __.sideEffect(__.properties("weight").drop()).select("m")) }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.E().hasLabel("knows").has("created", "Y") }, function({g, xx1}) { return g.E().hasLabel("knows").has("created", "N") }, function({g, xx1}) { return g.E().hasLabel("knows").has("weight") }], 
    g_mergeE_with_outVinV_options_map: [function({g, xx1, xx3, xx2}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, xx3, xx2}) { return g.mergeE(xx1).option(Merge.outV, xx2).option(Merge.inV, xx3) }, function({g, xx1, xx3, xx2}) { return g.V() }, function({g, xx1, xx3, xx2}) { return g.V().has("name", "marko").out("knows").has("name", "vadas") }], 
    g_mergeE_inline_with_outVinV_options_map: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, xx2}) { return g.mergeE(new Map([[Direction.OUT, Merge.outV], [Direction.IN, Merge.inV], [T.label, "knows"]])).option(Merge.outV, xx1).option(Merge.inV, xx2) }, function({g, xx1, xx2}) { return g.V() }, function({g, xx1, xx2}) { return g.V().has("name", "marko").out("knows").has("name", "vadas") }], 
    g_mergeE_with_outVinV_options_select: [function({g, xx1, vid2, vid1}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, vid2, vid1}) { return g.V(vid1).as("x").V(vid2).as("y").mergeE(xx1).option(Merge.outV, __.select("x")).option(Merge.inV, __.select("y")) }, function({g, xx1, vid2, vid1}) { return g.V() }, function({g, xx1, vid2, vid1}) { return g.V().has("name", "marko").out("knows").has("name", "vadas") }], 
    g_mergeE_inline_with_outVinV_options_select: [function({g, vid2, vid1}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, vid2, vid1}) { return g.V(vid1).as("x").V(vid2).as("y").mergeE(new Map([[Direction.OUT, Merge.outV], [Direction.IN, Merge.inV], [T.label, "knows"]])).option(Merge.outV, __.select("x")).option(Merge.inV, __.select("y")) }, function({g, vid2, vid1}) { return g.V() }, function({g, vid2, vid1}) { return g.V().has("name", "marko").out("knows").has("name", "vadas") }], 
    g_mergeE_with_eid_specified_and_inheritance_1: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2) }, function({g, xx1, xx2}) { return g.V() }, function({g, xx1, xx2}) { return g.E() }, function({g, xx1, xx2}) { return g.E("201") }, function({g, xx1, xx2}) { return g.V().has("name", "marko").out("knows").has("name", "vadas") }], 
    g_mergeE_with_eid_specified_and_inheritance_2: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2) }, function({g, xx1, xx2}) { return g.V() }, function({g, xx1, xx2}) { return g.E() }, function({g, xx1, xx2}) { return g.E("201") }, function({g, xx1, xx2}) { return g.V().has("name", "marko").out("knows").has("name", "vadas") }], 
    g_mergeE_outV_override_prohibited: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2) }], 
    g_mergeE_inV_override_prohibited: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2) }], 
    g_mergeE_label_override_prohibited: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2) }], 
    g_mergeE_id_override_prohibited: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, xx2}) { return g.mergeE(xx1).option(Merge.onCreate, xx2) }], 
    g_mergeV_mergeE_combination_new_vertices: [function({g, xx1, xx3, xx2}) { return g.mergeV(xx1).as("outV").mergeV(xx2).as("inV").mergeE(xx3).option(Merge.outV, __.select("outV")).option(Merge.inV, __.select("inV")) }, function({g, xx1, xx3, xx2}) { return g.V() }, function({g, xx1, xx3, xx2}) { return g.E() }, function({g, xx1, xx3, xx2}) { return g.V().has("name", "marko").out("knows").has("name", "vadas") }], 
    g_mergeV_mergeE_combination_existing_vertices: [function({g, xx1, xx3, xx2}) { return g.addV("person").property("name", "marko").addV("person").property("name", "vadas") }, function({g, xx1, xx3, xx2}) { return g.mergeV(xx1).as("outV").mergeV(xx2).as("inV").mergeE(xx3).option(Merge.outV, __.select("outV")).option(Merge.inV, __.select("inV")) }, function({g, xx1, xx3, xx2}) { return g.V() }, function({g, xx1, xx3, xx2}) { return g.E() }, function({g, xx1, xx3, xx2}) { return g.V().has("name", "marko").out("knows").has("name", "vadas") }], 
    g_V_asXvX_mergeEXxx1X_optionXMerge_onMatch_xx2X_optionXMerge_outV_selectXvXX_optionXMerge_inV_selectXvXX: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1, xx2}) { return g.V().as("v").mergeE(xx1).option(Merge.onMatch, xx2).option(Merge.outV, __.select("v")).option(Merge.inV, __.select("v")) }], 
    g_V_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_sideEffectXpropertyXweight_0XX_constantXemptyXX: [function({g, xx1}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").property("weight", 1).from_("a").to("b") }, function({g, xx1}) { return g.V().mergeE(xx1).option(Merge.onMatch, __.sideEffect(__.property("weight", 0)).constant(new Map([]))) }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.E() }, function({g, xx1}) { return g.E().hasLabel("knows").has("weight", 0) }], 
    g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_sideEffectXpropertyXweight_0XX_constantXemptyXX: [function({g, xx1}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").property("weight", 1).from_("a").to("b") }, function({g, xx1}) { return g.mergeE(xx1).option(Merge.onMatch, __.sideEffect(__.property("weight", 0)).constant(new Map([]))) }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.E().hasLabel("knows").has("weight", 1) }, function({g, xx1}) { return g.E().hasLabel("knows").has("weight", 0) }, function({g, xx1}) { return g.V().has("weight") }], 
    g_unionXselectXmapX_selectXmapX_constantXcreated_NXX_fold_asXmX_mergeEXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_match: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.union(__.select("map"), __.select("map"), __.constant(new Map([["created", "N"]]))).fold().as("m").mergeE(__.select("m").limit(Scope.local, 1).unfold()).option(Merge.onCreate, __.select("m").range(Scope.local, 1, 2).unfold()).option(Merge.onMatch, __.select("m").tail(Scope.local).unfold()) }, function({g}) { return g.V() }, function({g}) { return g.E() }, function({g}) { return g.E().has("created", "N") }, function({g}) { return g.V().has("person", "name", "marko").outE("knows").has("created", "N").inV().has("person", "name", "vadas") }], 
    g_unionXselectXmapX_selectXmapX_constantXcreated_NXX_fold_asXmX_mergeEXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_create: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.union(__.select("map"), __.select("map"), __.constant(new Map([["created", "N"]]))).fold().as("m").mergeE(__.select("m").limit(Scope.local, 1).unfold()).option(Merge.onCreate, __.select("m").range(Scope.local, 1, 2).unfold()).option(Merge.onMatch, __.select("m").tail(Scope.local).unfold()) }, function({g}) { return g.V() }, function({g}) { return g.E() }, function({g}) { return g.E().hasNot("created") }, function({g}) { return g.V().has("person", "name", "marko").outE("knows").hasNot("created").inV().has("person", "name", "vadas") }, function({g}) { return g.V().has("person", "name", "vadas").outE("self").hasNot("weight").inV().has("person", "name", "vadas") }], 
    g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_weight_nullX_allowed: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b").property("weight", 1.0) }, function({g, xx1, xx2}) { return g.mergeE(xx1).option(Merge.onMatch, xx2) }, function({g, xx1, xx2}) { return g.V() }, function({g, xx1, xx2}) { return g.E().hasLabel("knows") }, function({g, xx1, xx2}) { return g.E().hasLabel("knows").has("weight", null) }], 
    g_mergeEXlabel_knows_out_marko_in_vadasX_optionXonMatch_weight_nullX: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").as("a").addV("person").property("name", "vadas").as("b").addE("knows").from_("a").to("b").property("weight", 1.0) }, function({g, xx1, xx2}) { return g.mergeE(xx1).option(Merge.onMatch, xx2) }, function({g, xx1, xx2}) { return g.V() }, function({g, xx1, xx2}) { return g.E().hasLabel("knows") }, function({g, xx1, xx2}) { return g.E().hasLabel("knows").has("weight") }], 
    g_mergeVXemptyX_optionXonMatch_nullX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.mergeV(new Map([])).option(Merge.onMatch, null) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 29) }], 
    g_V_mergeVXemptyX_optionXonMatch_nullX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.V().mergeV(new Map([])).option(Merge.onMatch, null) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 29) }], 
    g_mergeVXnullX_optionXonCreate_label_null_name_markoX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.mergeV(xx1) }], 
    g_V_mergeVXnullX_optionXonCreate_label_null_name_markoX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.V().mergeV(xx1) }], 
    g_mergeVXlabel_person_name_stephenX_optionXonCreate_nullX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.mergeV(xx1).option(Merge.onCreate, null) }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.V().has("person", "name", "marko") }, function({g, xx1}) { return g.V().has("person", "name", "stephen") }], 
    g_V_mergeVXlabel_person_name_stephenX_optionXonCreate_nullX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.V().mergeV(xx1).option(Merge.onCreate, null) }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.V().has("person", "name", "marko") }, function({g, xx1}) { return g.V().has("person", "name", "stephen") }], 
    g_mergeVXnullX_optionXonCreate_emptyX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.mergeV(null).option(Merge.onCreate, new Map([])) }, function({g}) { return g.V() }], 
    g_V_mergeVXnullX_optionXonCreate_emptyX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.V().mergeV(null).option(Merge.onCreate, new Map([])) }, function({g}) { return g.V() }], 
    g_mergeVXemptyX_no_existing: [function({g}) { return g.mergeV(new Map([])) }, function({g}) { return g.V() }], 
    g_injectX0X_mergeVXemptyX_no_existing: [function({g}) { return g.inject(0).mergeV(new Map([])) }, function({g}) { return g.V() }], 
    g_mergeVXemptyX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.mergeV(new Map([])) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 29) }], 
    g_V_mergeVXemptyX_two_exist: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29).addV("person").property("name", "vadas").property("age", 27) }, function({g}) { return g.V().mergeV(new Map([])) }, function({g}) { return g.V() }, function({g}) { return g.V().has("person", "name", "marko").has("age", 29) }, function({g}) { return g.V().has("person", "name", "vadas").has("age", 27) }], 
    g_mergeVXnullX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.mergeV(null) }, function({g}) { return g.V() }], 
    g_mergeVXnullvarX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.mergeV(xx1) }, function({g, xx1}) { return g.V() }], 
    g_V_mergeVXnullX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.V().mergeV(null) }, function({g}) { return g.V() }], 
    g_mergeVXlabel_person_name_stephenX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.mergeV(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "stephen") }], 
    g_mergeVXlabel_person_name_markoX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.mergeV(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "marko") }], 
    g_mergeVXlabel_person_name_stephenX_optionXonCreate_label_person_name_stephen_age_19X_option: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1, xx2}) { return g.mergeV(xx1).option(Merge.onCreate, xx2) }, function({g, xx1, xx2}) { return g.V().has("person", "name", "stephen").has("age", 19) }], 
    g_mergeVXlabel_person_name_markoX_optionXonMatch_age_19X_option: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1, xx2}) { return g.mergeV(xx1).option(Merge.onMatch, xx2) }, function({g, xx1, xx2}) { return g.V().has("person", "name", "marko").has("age", 19) }], 
    g_withSideEffectXc_label_person_name_stephenX_withSideEffectXm_label_person_name_stephen_age_19X_mergeVXselectXcXX_optionXonCreate_selectXmXX_option: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.mergeV(__.select("c")).option(Merge.onCreate, __.select("m")) }, function({g}) { return g.V().has("person", "name", "stephen").has("age", 19) }], 
    g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_mergeVXselectXcXX_optionXonMatch_selectXmXX_option: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.mergeV(__.select("c")).option(Merge.onMatch, __.select("m")) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 19) }], 
    g_mergeVXlabel_person_name_markoX_propertyXname_vadas_acl_publicX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.mergeV(xx1).property("name", "vadas", "acl", "public") }, function({g, xx1}) { return g.V().properties("name").hasValue("vadas").has("acl", "public") }], 
    g_injectX0X_mergeVXlabel_person_name_stephenX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.inject(0).mergeV(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "stephen") }], 
    g_injectX0X_mergeVXlabel_person_name_markoX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.inject(0).mergeV(xx1) }, function({g, xx1}) { return g.V().has("person", "name", "marko") }], 
    g_injectX0X_mergeVXlabel_person_name_stephenX_optionXonCreate_label_person_name_stephen_age_19X_option: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1, xx2}) { return g.inject(0).mergeV(xx1).option(Merge.onCreate, xx2) }, function({g, xx1, xx2}) { return g.V().has("person", "name", "stephen").has("age", 19) }], 
    g_injectX0X_mergeVXlabel_person_name_markoX_optionXonMatch_age_19X_option: [function({g, xx1, xx2}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1, xx2}) { return g.inject(0).mergeV(xx1).option(Merge.onMatch, xx2) }, function({g, xx1, xx2}) { return g.V().has("person", "name", "marko").has("age", 19) }], 
    g_withSideEffectXc_label_person_name_stephenX_withSideEffectXm_label_person_name_stephen_age_19X_injectX0X_mergeVXselectXcXX_optionXonCreate_selectXmXX_option: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.inject(0).mergeV(__.select("c")).option(Merge.onCreate, __.select("m")) }, function({g}) { return g.V().has("person", "name", "stephen").has("age", 19) }], 
    g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_injectX0X_mergeVXselectXcXX_optionXonMatch_selectXmXX_option: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.inject(0).mergeV(__.select("c")).option(Merge.onMatch, __.select("m")) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 19) }], 
    g_injectX0X_mergeVXlabel_person_name_markoX_propertyXname_vadas_acl_publicX: [function({g, xx1}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g, xx1}) { return g.inject(0).mergeV(xx1).property("name", "vadas", "acl", "public") }, function({g, xx1}) { return g.V().properties("name").hasValue("vadas").has("acl", "public") }], 
    g_injectXlabel_person_name_marko_label_person_name_stephenX_mergeVXidentityX: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.inject(new Map([[T.label, "person"], ["name", "marko"]]), new Map([[T.label, "person"], ["name", "stephen"]])).mergeV(__.identity()) }, function({g}) { return g.V().has("person", "name", "stephen") }, function({g}) { return g.V().has("person", "name", "marko") }, function({g}) { return g.V() }], 
    g_injectXlabel_person_name_marko_label_person_name_stephenX_mergeV: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.inject(new Map([[T.label, "person"], ["name", "marko"]]), new Map([[T.label, "person"], ["name", "stephen"]])).mergeV() }, function({g}) { return g.V().has("person", "name", "stephen") }, function({g}) { return g.V().has("person", "name", "marko") }, function({g}) { return g.V() }], 
    g_mergeVXlabel_person_name_stephenX_propertyXlist_name_steveX: [function({g, xx1}) { return g.addV("person").property(Cardinality.list, "name", "stephen") }, function({g, xx1}) { return g.mergeV(xx1).property(Cardinality.list, "name", "steve") }, function({g, xx1}) { return g.V() }, function({g, xx1}) { return g.V().properties("name").hasValue("steve") }, function({g, xx1}) { return g.V().properties("name").hasValue("stephen") }, function({g, xx1}) { return g.V().properties("name") }], 
    g_mergeXlabel_person_name_vadasX_optionXonMatch_age_35X: [function({g, xx1, xx2}) { return g.addV("person").property("name", "vadas").property("age", 29).addV("person").property("name", "vadas").property("age", 27) }, function({g, xx1, xx2}) { return g.mergeV(xx1).option(Merge.onMatch, xx2) }, function({g, xx1, xx2}) { return g.V().has("age", 35) }, function({g, xx1, xx2}) { return g.V() }], 
    g_V_mapXmergeXlabel_person_name_joshXX: [function({g, xx1}) { return g.addV("person").property("name", "vadas").property("age", 29).addV("person").property("name", "stephen").property("age", 27) }, function({g, xx1}) { return g.V().map(__.mergeV(xx1)) }, function({g, xx1}) { return g.V().has("person", "name", "josh") }, function({g, xx1}) { return g.V() }], 
    g_withSideEffectXc_label_person_name_markoX_withSideEffectXm_age_19X_mergeVXselectXcXX_optionXonMatch_sideEffectXpropertiesXageX_dropX_selectXmXX_option: [function({g}) { return g.addV("person").property("name", "marko").property(Cardinality.list, "age", 29).property(Cardinality.list, "age", 31).property(Cardinality.list, "age", 32) }, function({g}) { return g.mergeV(__.select("c")).option(Merge.onMatch, __.sideEffect(__.properties("age").drop()).select("m")) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 19) }, function({g}) { return g.V().has("person", "name", "marko").has("age") }], 
    g_withSideEffectXm_age_19X_V_hasXperson_name_markoX_mergeVXselectXcXX_optionXonMatch_sideEffectXpropertiesXageX_dropX_selectXmXX_option: [function({g}) { return g.addV("person").property("name", "marko").property(Cardinality.list, "age", 29).property(Cardinality.list, "age", 31).property(Cardinality.list, "age", 32) }, function({g}) { return g.V().has("person", "name", "marko").mergeV(new Map([])).option(Merge.onMatch, __.sideEffect(__.properties("age").drop()).select("m")) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 19) }, function({g}) { return g.V().has("person", "name", "marko").properties("age") }], 
    g_mergeV_onCreate_inheritance_existing: [function({g, xx1, xx2}) { return g.addV("person").property("name", "mike").property(T.id, "1") }, function({g, xx1, xx2}) { return g.mergeV(xx1).option(Merge.onCreate, xx2) }, function({g, xx1, xx2}) { return g.V() }, function({g, xx1, xx2}) { return g.V("1").has("person", "name", "mike") }], 
    g_mergeV_onCreate_inheritance_new_1: [function({g, xx1, xx2}) { return g.mergeV(xx1).option(Merge.onCreate, xx2) }, function({g, xx1, xx2}) { return g.V() }, function({g, xx1, xx2}) { return g.V("1").has("person", "name", "mike") }], 
    g_mergeV_onCreate_inheritance_new_2: [function({g, xx1, xx2}) { return g.mergeV(xx1).option(Merge.onCreate, xx2) }, function({g, xx1, xx2}) { return g.V() }, function({g, xx1, xx2}) { return g.V("1").has("person", "name", "mike") }], 
    g_mergeV_label_override_prohibited: [function({g, xx1, xx2}) { return g.mergeV(xx1).option(Merge.onCreate, xx2) }], 
    g_mergeV_id_override_prohibited: [function({g, xx1, xx2}) { return g.mergeV(xx1).option(Merge.onCreate, xx2) }], 
    g_mergeV_hidden_id_key_prohibited: [function({g, xx1}) { return g.mergeV(xx1) }], 
    g_mergeV_hidden_label_key_prohibited: [function({g, xx1}) { return g.mergeV(xx1) }], 
    g_mergeV_hidden_label_value_prohibited: [function({g, xx1}) { return g.mergeV(xx1) }], 
    g_mergeV_hidden_id_key_onCreate_prohibited: [function({g, xx1}) { return g.mergeV(new Map([])).option(Merge.onCreate, xx1) }], 
    g_mergeV_hidden_label_key_onCreate_prohibited: [function({g, xx1}) { return g.mergeV(new Map([])).option(Merge.onCreate, xx1) }], 
    g_mergeV_hidden_label_value_onCreate_prohibited: [function({g, xx1}) { return g.mergeV(new Map([])).option(Merge.onCreate, xx1) }], 
    g_mergeV_hidden_id_key_onMatch_matched_prohibited: [function({g, xx1}) { return g.addV("vertex") }, function({g, xx1}) { return g.mergeV(new Map([])).option(Merge.onMatch, xx1) }], 
    g_mergeV_hidden_label_key_matched_onMatch_matched_prohibited: [function({g, xx1}) { return g.addV("vertex") }, function({g, xx1}) { return g.mergeV(new Map([])).option(Merge.onMatch, xx1) }], 
    g_mergeVXname_markoX_optionXonMatch_age_listX33XX: [function({g}) { return g.addV("person").property("name", "marko").property(Cardinality.list, "age", 29).property(Cardinality.list, "age", 31).property(Cardinality.list, "age", 32) }, function({g}) { return g.mergeV(new Map([["name", "marko"]])).option(Merge.onMatch, new Map([["age", CardinalityValue.list(33)]])) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 33) }, function({g}) { return g.V().has("person", "name", "marko").has("age") }, function({g}) { return g.V().has("person", "name", "marko").properties("age") }], 
    g_mergeVXname_markoX_optionXonMatch_age_setX33XX: [function({g}) { return g.addV("person").property("name", "marko").property(Cardinality.list, "age", 29).property(Cardinality.list, "age", 31).property(Cardinality.list, "age", 32) }, function({g}) { return g.mergeV(new Map([["name", "marko"]])).option(Merge.onMatch, new Map([["age", CardinalityValue.set(33)]])) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 33) }, function({g}) { return g.V().has("person", "name", "marko").has("age") }, function({g}) { return g.V().has("person", "name", "marko").properties("age") }], 
    g_mergeVXname_markoX_optionXonMatch_age_setX31XX: [function({g}) { return g.addV("person").property("name", "marko").property(Cardinality.list, "age", 29).property(Cardinality.list, "age", 31).property(Cardinality.list, "age", 32) }, function({g}) { return g.mergeV(new Map([["name", "marko"]])).option(Merge.onMatch, new Map([["age", CardinalityValue.set(31)]])) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 31) }, function({g}) { return g.V().has("person", "name", "marko").has("age") }, function({g}) { return g.V().has("person", "name", "marko").properties("age") }], 
    g_mergeVXname_markoX_optionXonMatch_age_singleX33XX: [function({g}) { return g.addV("person").property("name", "marko").property(Cardinality.list, "age", 29).property(Cardinality.list, "age", 31).property(Cardinality.list, "age", 32) }, function({g}) { return g.mergeV(new Map([["name", "marko"]])).option(Merge.onMatch, new Map([["age", CardinalityValue.single(33)]])) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 33) }, function({g}) { return g.V().has("person", "name", "marko").has("age") }, function({g}) { return g.V().has("person", "name", "marko").properties("age") }], 
    g_mergeVXname_markoX_optionXonMatch_age_33_singleX: [function({g}) { return g.addV("person").property("name", "marko").property(Cardinality.list, "age", 29).property(Cardinality.list, "age", 31).property(Cardinality.list, "age", 32) }, function({g}) { return g.mergeV(new Map([["name", "marko"]])).option(Merge.onMatch, new Map([["age", 33]]), Cardinality.single) }, function({g}) { return g.V().has("person", "name", "marko").has("age", 33) }, function({g}) { return g.V().has("person", "name", "marko").has("age") }, function({g}) { return g.V().has("person", "name", "marko").properties("age") }], 
    g_mergeVXname_markoX_optionXonMatch_name_allen_age_setX31X_singleX: [function({g}) { return g.addV("person").property("name", "marko").property(Cardinality.list, "age", 29).property(Cardinality.list, "age", 31).property(Cardinality.list, "age", 32) }, function({g}) { return g.mergeV(new Map([["name", "marko"]])).option(Merge.onMatch, new Map([["name", "allen"], ["age", CardinalityValue.set(31)]]), Cardinality.single) }, function({g}) { return g.V().has("person", "name", "marko") }, function({g}) { return g.V().has("person", "name", "allen").has("age", 31) }, function({g}) { return g.V().has("person", "name", "allen").has("age") }, function({g}) { return g.V().has("person", "name", "allen").properties("age") }], 
    g_mergeVXname_markoX_optionXonMatch_name_allen_age_singleX31X_singleX: [function({g}) { return g.addV("person").property("name", "marko").property(Cardinality.list, "age", 29).property(Cardinality.list, "age", 31).property(Cardinality.list, "age", 32) }, function({g}) { return g.mergeV(new Map([["name", "marko"]])).option(Merge.onMatch, new Map([["name", "allen"], ["age", CardinalityValue.single(31)]]), Cardinality.single) }, function({g}) { return g.V().has("person", "name", "marko") }, function({g}) { return g.V().has("person", "name", "allen").has("age", 33) }, function({g}) { return g.V().has("person", "name", "allen").has("age", 31) }, function({g}) { return g.V().has("person", "name", "allen").has("age") }, function({g}) { return g.V().has("person", "name", "allen").properties("age") }], 
    g_mergeVXname_aliceX_optionXonCreate_age_singleX81XX: [function({g}) { return g.mergeV(new Map([["name", "alice"], [T.label, "person"]])).option(Merge.onCreate, new Map([["age", CardinalityValue.single(81)]])) }, function({g}) { return g.V().has("person", "name", "alice").has("age", 81) }, function({g}) { return g.V().has("person", "name", "alice").has("age") }, function({g}) { return g.V().has("person", "name", "alice").properties("age") }], 
    g_mergeVXname_aliceX_optionXonCreate_age_setX81XX: [function({g}) { return g.mergeV(new Map([["name", "alice"], [T.label, "person"]])).option(Merge.onCreate, new Map([["age", CardinalityValue.set(81)]])) }, function({g}) { return g.V().has("person", "name", "alice").has("age", 81) }, function({g}) { return g.V().has("person", "name", "alice").has("age") }, function({g}) { return g.V().has("person", "name", "alice").properties("age") }], 
    g_mergeVXname_aliceX_optionXonCreate_age_81_setX: [function({g}) { return g.mergeV(new Map([["name", "alice"], [T.label, "person"]])).option(Merge.onCreate, new Map([["age", 81]]), Cardinality.set) }, function({g}) { return g.V().has("person", "name", "alice").has("age", 81) }, function({g}) { return g.V().has("person", "name", "alice").has("age") }, function({g}) { return g.V().has("person", "name", "alice").properties("age") }], 
    g_mergeVXname_aliceX_optionXonCreate_age_81_label_person_setX: [function({g}) { return g.mergeV(new Map([["name", "alice"]])).option(Merge.onCreate, new Map([["age", 81], [T.label, "person"]]), Cardinality.set) }, function({g}) { return g.V().has("person", "name", "alice").has("age", 81) }, function({g}) { return g.V().has("person", "name", "alice").has("age") }, function({g}) { return g.V().has("person", "name", "alice").properties("age") }], 
    g_mergeV_hidden_label_key_onMatch_matched_prohibited: [function({g, xx1}) { return g.mergeV(new Map([])).option(Merge.onMatch, xx1) }], 
    g_injectXlist1_list2_list3X_fold_asXmX_mergeVXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_match: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.inject(new Map([[T.label, "person"], ["name", "marko"]]), new Map([[T.label, "person"], ["name", "marko"]]), new Map([["created", "N"]])).fold().as("m").mergeV(__.select("m").limit(Scope.local, 1).unfold()).option(Merge.onCreate, __.select("m").range(Scope.local, 1, 2).unfold()).option(Merge.onMatch, __.select("m").tail(Scope.local).unfold()) }, function({g}) { return g.V().has("person", "name", "marko").has("created", "N") }, function({g}) { return g.V() }], 
    g_injectXlist1_list2_list3X_fold_asXmX_mergeVXselectXmX_limitXlocal_1X_unfoldX_optionXonCreate_selectXmX_rangeXlocal_1_2X_unfoldX_optionXonMatch_selectXmX_tailXlocalX_unfoldX_to_create: [function({g}) { return g.addV("person").property("name", "marko").property("age", 29) }, function({g}) { return g.inject(new Map([[T.label, "person"], ["name", "stephen"]]), new Map([[T.label, "person"], ["name", "stephen"]]), new Map([["created", "N"]])).fold().as("m").mergeV(__.select("m").limit(Scope.local, 1).unfold()).option(Merge.onCreate, __.select("m").range(Scope.local, 1, 2).unfold()).option(Merge.onMatch, __.select("m").tail(Scope.local).unfold()) }, function({g}) { return g.V().has("person", "name", "stephen").hasNot("created") }, function({g}) { return g.V() }], 
    g_V_age_min: [function({g}) { return g.V().values("age").min() }], 
    g_V_foo_min: [function({g}) { return g.V().values("foo").min() }], 
    g_V_name_min: [function({g}) { return g.V().values("name").min() }], 
    g_V_age_fold_minXlocalX: [function({g}) { return g.V().values("age").fold().min(Scope.local) }], 
    g_V_aggregateXaX_byXageX_capXaX_minXlocalX: [function({g}) { return g.V().aggregate("a").by("age").cap("a").min(Scope.local) }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_minXlocalX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("age").cap("a").min(Scope.local) }], 
    g_V_aggregateXaX_byXageX_capXaX_unfold_min: [function({g}) { return g.V().aggregate("a").by("age").cap("a").unfold().min() }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_min: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("age").cap("a").unfold().min() }], 
    g_V_aggregateXaX_byXfooX_capXaX_minXlocalX: [function({g}) { return g.V().aggregate("a").by("foo").cap("a").min(Scope.local) }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_minXlocalX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("foo").cap("a").min(Scope.local) }], 
    g_V_aggregateXaX_byXfooX_capXaX_unfold_min: [function({g}) { return g.V().aggregate("a").by("foo").cap("a").unfold().min() }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_min: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("foo").cap("a").unfold().min() }], 
    g_V_foo_fold_minXlocalX: [function({g}) { return g.V().values("foo").fold().min(Scope.local) }], 
    g_V_name_fold_minXlocalX: [function({g}) { return g.V().values("name").fold().min(Scope.local) }], 
    g_V_repeatXbothX_timesX5X_age_min: [function({g}) { return g.V().repeat(__.both()).times(5).values("age").min() }], 
    g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_minX: [function({g}) { return g.V().hasLabel("software").group().by("name").by(__.bothE().values("weight").min()) }], 
    g_V_foo_injectX9999999999X_min: [function({g}) { return g.V().values("foo").inject(9999999999).min() }], 
    g_VX1X_valuesXageX_minXlocalX: [function({g, vid1}) { return g.V(vid1).values("age").min(Scope.local) }], 
    g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_minXlocalX: [function({g}) { return g.V().local(__.union(__.values("age"), __.outE().values("weight")).fold()).min(Scope.local) }], 
    g_V_name_order: [function({g}) { return g.V().values("name").order() }], 
    g_V_order_byXname_ascX_name: [function({g}) { return g.V().order().by("name", Order.asc).values("name") }], 
    g_V_order_byXnameX_name: [function({g}) { return g.V().order().by("name").values("name") }], 
    g_V_outE_order_byXweight_descX_weight: [function({g}) { return g.V().outE().order().by("weight", Order.desc).values("weight") }], 
    g_V_asXaX_outXcreatedX_asXbX_order_byXshuffleX_selectXa_bX: [function({g}) { return g.V().as("a").out("created").as("b").order().by(Order.shuffle).select("a", "b") }], 
    g_V_both_hasLabelXpersonX_order_byXage_descX_limitX5X_name: [function({g}) { return g.V().both().hasLabel("person").order().by("age", Order.desc).limit(5).values("name") }], 
    g_V_properties_order_byXkey_descX_key: [function({g}) { return g.V().properties().order().by(T.key, Order.desc).key() }], 
    g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_orderXlocalX_byXvaluesX: [function({g}) { return g.V().hasLabel("person").group().by("name").by(__.outE().values("weight").sum()).order(Scope.local).by(Column.values) }], 
    g_V_mapXbothE_weight_foldX_order_byXsumXlocalX_descX_byXcountXlocalX_descX: [function({g}) { return g.V().map(__.bothE().values("weight").order().by(Order.asc).fold()).order().by(__.sum(Scope.local), Order.desc).by(__.count(Scope.local), Order.desc) }], 
    g_V_group_byXlabelX_byXname_order_byXdescX_foldX: [function({g}) { return g.V().group().by(T.label).by(__.values("name").order().by(Order.desc).fold()) }], 
    g_V_hasLabelXpersonX_group_byXnameX_byXoutE_weight_sumX_unfold_order_byXvalues_descX: [function({g}) { return g.V().hasLabel("person").group().by("name").by(__.outE().values("weight").sum()).unfold().order().by(Column.values, Order.desc) }], 
    g_V_asXvX_mapXbothE_weight_foldX_sumXlocalX_asXsX_selectXv_sX_order_byXselectXsX_descX_byXselectXvX_nameX: [function({g}) { return g.V().as("v").map(__.bothE().values("weight").fold()).sum(Scope.local).as("s").select("v", "s").order().by(__.select("s"), Order.desc).by(__.select("v").values("name")) }], 
    g_V_hasLabelXpersonX_fold_orderXlocalX_byXageX: [function({g}) { return g.V().hasLabel("person").fold().order(Scope.local).by("age") }], 
    g_V_both_hasLabelXpersonX_order_byXage_descX_name: [function({g}) { return g.V().both().hasLabel("person").order().by("age", Order.desc).values("name") }], 
    g_V_order_byXoutE_count_descX_byXnameX: [function({g}) { return g.V().order().by(__.outE().count(), Order.desc).by("name") }], 
    g_V_hasLabelXpersonX_order_byXageX: [function({g}) { return g.V().hasLabel("person").order().by("age") }], 
    g_V_order_byXageX: [function({g}) { return g.V().order().by("age") }], 
    g_V_fold_orderXlocalX_byXageX: [function({g}) { return g.V().fold().order(Scope.local).by("age") }], 
    g_V_fold_orderXlocalX_byXage_descX: [function({g}) { return g.V().fold().order(Scope.local).by("age", Order.desc) }], 
    g_V_orXhasLabelXpersonX_hasXsoftware_name_lopXX_order_byXageX: [function({g}) { return g.V().or(__.hasLabel("person"), __.has("software", "name", "lop")).order().by("age") }], 
    g_withStrategiesXProductiveByStrategyX_V_orXhasLabelXpersonX_hasXsoftware_name_lopXX_order_byXageX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().or(__.hasLabel("person"), __.has("software", "name", "lop")).order().by("age") }], 
    g_V_hasXsong_name_OHBOYX_outXfollowedByX_outXfollowedByX_order_byXperformancesX_byXsongType_descX: [function({g}) { return g.V().has("song", "name", "OH BOY").out("followedBy").out("followedBy").order().by("performances").by("songType", Order.desc).by("name") }], 
    g_V_hasLabelXsongX_order_byXperformances_descX_byXnameX_rangeX110_120X_name: [function({g}) { return g.V().hasLabel("song").order().by("performances", Order.desc).by("name").range(110, 120).values("name") }], 
    g_VX1X_elementMap_orderXlocalX_byXkeys_descXunfold: [function({g, vid1}) { return g.V(vid1).elementMap().order(Scope.local).by(Column.keys, Order.desc).unfold() }], 
    g_VX1X_elementMap_orderXlocalX_byXkeys_ascXunfold: [function({g, vid1}) { return g.V(vid1).elementMap().order(Scope.local).by(Column.keys, Order.asc).unfold() }], 
    g_VX1X_valuesXageX_orderXlocalX: [function({g, vid1}) { return g.V(vid1).values("age").order(Scope.local) }], 
    g_V_pageRank_hasXpageRankX: [function({g}) { return g.V().pageRank().has("gremlin.pageRankVertexProgram.pageRank") }], 
    g_V_outXcreatedX_pageRank_withXedges_bothEX_withXpropertyName_projectRankX_withXtimes_0X_valueMapXname_projectRankX: [function({g}) { return g.V().out("created").pageRank().with_("~tinkerpop.pageRank.edges", __.bothE()).with_("~tinkerpop.pageRank.propertyName", "projectRank").with_("~tinkerpop.pageRank.times", 0).valueMap("name", "projectRank") }], 
    g_V_pageRank_order_byXpageRank_descX_byXnameX_name: [function({g}) { return g.V().pageRank().order().by("gremlin.pageRankVertexProgram.pageRank", Order.desc).by("name").values("name") }], 
    g_V_pageRank_order_byXpageRank_descX_name_limitX2X: [function({g}) { return g.V().pageRank().order().by("gremlin.pageRankVertexProgram.pageRank", Order.desc).values("name").limit(2) }], 
    g_V_pageRank_withXedges_outEXknowsXX_withXpropertyName_friendRankX_project_byXnameX_byXvaluesXfriendRankX_mathX: [function({g}) { return g.V().pageRank().with_("~tinkerpop.pageRank.edges", __.outE("knows")).with_("~tinkerpop.pageRank.propertyName", "friendRank").project("name", "friendRank").by("name").by(__.values("friendRank").math("ceil(_ * 100)")) }], 
    g_V_hasLabelXpersonX_pageRank_withXpropertyName_kpageRankX_project_byXnameX_byXvaluesXpageRankX_mathX: [function({g}) { return g.V().hasLabel("person").pageRank().with_("~tinkerpop.pageRank.propertyName", "pageRank").project("name", "pageRank").by("name").by(__.values("pageRank").math("ceil(_ * 100)")) }], 
    g_V_pageRank_withXpropertyName_pageRankX_asXaX_outXknowsX_pageRank_asXbX_selectXa_bX_by_byXmathX: [function({g}) { return g.V().pageRank().with_("~tinkerpop.pageRank.propertyName", "pageRank").as("a").out("knows").values("pageRank").as("b").select("a", "b").by().by(__.math("ceil(_ * 100)")) }], 
    g_V_hasLabelXsoftwareX_hasXname_rippleX_pageRankX1X_withXedges_inEXcreatedX_withXtimes_1X_withXpropertyName_priorsX_inXcreatedX_unionXboth__identityX_valueMapXname_priorsX: [function({g}) { return g.V().hasLabel("software").has("name", "ripple").pageRank(1.0).with_("~tinkerpop.pageRank.edges", __.inE("created")).with_("~tinkerpop.pageRank.times", 1).with_("~tinkerpop.pageRank.propertyName", "priors").in_("created").union(__.both(), __.identity()).valueMap("name", "priors") }], 
    g_V_outXcreatedX_groupXmX_byXlabelX_pageRankX1X_withXpropertyName_pageRankX_withXedges_inEX_withXtimes_1X_inXcreatedX_groupXmX_byXpageRankX_capXmX: [function({g}) { return g.V().out("created").group("m").by(T.label).pageRank(1.0).with_("~tinkerpop.pageRank.propertyName", "pageRank").with_("~tinkerpop.pageRank.edges", __.inE()).with_("~tinkerpop.pageRank.times", 1).in_("created").group("m").by("pageRank").cap("m") }], 
    g_VX1X_name_path: [function({g, vid1}) { return g.V(vid1).values("name").path() }], 
    g_VX1X_out_path_byXageX_byXnameX: [function({g, vid1}) { return g.V(vid1).out().path().by("age").by("name") }], 
    g_V_repeatXoutX_timesX2X_path_byXitX_byXnameX_byXlangX: [function({g}) { return g.V().repeat(__.out()).times(2).path().by().by("name").by("lang") }], 
    g_V_out_out_path_byXnameX_byXageX: [function({g}) { return g.V().out().out().path().by("name").by("age") }], 
    g_V_asXaX_hasXname_markoX_asXbX_hasXage_29X_asXcX_path: [function({g}) { return g.V().as("a").has("name", "marko").as("b").has("age", 29).as("c").path() }], 
    g_VX1X_outEXcreatedX_inV_inE_outV_path: [function({g, vid1}) { return g.V(vid1).outE("created").inV().inE().outV().path() }], 
    g_V_asXaX_out_asXbX_out_asXcX_path_fromXbX_toXcX_byXnameX: [function({g}) { return g.V().as("a").out().as("b").out().as("c").path().from_("b").to("c").by("name") }], 
    g_VX1X_out_path_byXageX: [function({g, vid1}) { return g.V(vid1).out().path().by("age") }], 
    g_withStrategiesXProductiveByStrategyX_VX1X_out_path_byXageX: [function({g, vid1}) { return g.withStrategies(new ProductiveByStrategy()).V(vid1).out().path().by("age") }], 
    g_injectX1_null_nullX_path: [function({g}) { return g.inject(1, null, null).path() }], 
    g_injectX1_null_nullX_path_dedup: [function({g}) { return g.inject(1, null, null).path().dedup() }], 
    g_V_peerPressure_hasXclusterX: [function({g}) { return g.V().peerPressure().has("gremlin.peerPressureVertexProgram.cluster") }], 
    g_V_peerPressure_withXpropertyName_clusterX_withXedges_outEXknowsXX_pageRankX1X_byXrankX_withXedges_outEXknowsX_withXtimes_2X_group_byXclusterX_byXrank_sumX_limitX100X: [function({g}) { return g.V().peerPressure().with_("~tinkerpop.peerPressure.propertyName", "cluster").with_("~tinkerpop.peerPressure.edges", __.outE("knows")).pageRank(1.0).with_("~tinkerpop.pageRank.propertyName", "rank").with_("~tinkerpop.pageRank.edges", __.outE("knows")).with_("~tinkerpop.pageRank.times", 1).group().by("cluster").by(__.values("rank").sum()).limit(100) }], 
    g_V_hasXname_rippleX_inXcreatedX_peerPressure_withXedges_outEX_withyXpropertyName_clusterX_repeatXunionXidentity__bothX_timesX2X_dedup_valueMapXname_clusterX: [function({g}) { return g.V().has("name", "ripple").in_("created").peerPressure().with_("~tinkerpop.peerPressure.edges", __.outE()).with_("~tinkerpop.peerPressure.propertyName", "cluster").repeat(__.union(__.identity(), __.both())).times(2).dedup().valueMap("name", "cluster") }], 
    g_injectXnullX_productXinjectX1XX: [function({g}) { return g.inject(null).product(__.inject(1)) }], 
    g_V_valuesXnameX_productXV_foldX: [function({g}) { return g.V().values("name").product(__.V().fold()) }], 
    g_V_fold_productXconstantXnullXX: [function({g}) { return g.V().fold().product(__.constant(null)) }], 
    g_V_fold_productXVX: [function({g}) { return g.V().fold().product(__.V()) }], 
    g_V_valuesXnameX_fold_productX2X: [function({g}) { return g.V().values("name").fold().product(2) }], 
    g_V_valuesXnameX_fold_productXnullX: [function({g}) { return g.V().values("name").fold().product(null) }], 
    g_V_valuesXnonexistantX_fold_productXV_valuesXnameX_foldX: [function({g}) { return g.V().values("nonexistant").fold().product(__.V().values("name").fold()) }], 
    g_V_valuesXnameX_fold_productXV_valuesXnonexistantX_foldX: [function({g}) { return g.V().values("name").fold().product(__.V().values("nonexistant").fold()) }], 
    g_V_valuesXageX_order_byXdescX_limitX3X_fold_productXV_valuesXageX_order_byXascX_limitX2X_foldX_unfold: [function({g}) { return g.V().values("age").order().by(Order.desc).limit(3).fold().product(__.V().values("age").order().by(Order.asc).limit(2).fold()).unfold() }], 
    g_V_out_path_byXvaluesXnameX_toUpperX_productXMARKOX_unfold: [function({g}) { return g.V().out().path().by(__.values("name").toUpper()).product(["MARKO"]).unfold() }], 
    g_injectXmarkoX_productXV_valuesXnameX_order_foldX_unfold: [function({g}) { return g.inject(["marko"]).product(__.V().values("name").order().fold()).unfold() }], 
    g_V_valueMapXlocationX_selectXvaluesX_unfold_productXdulles_seattle_vancouverX_unfold: [function({g}) { return g.V().valueMap("location").select(Column.values).unfold().product(["dulles", "seattle", "vancouver"]).unfold() }], 
    g_V_valuesXageX_order_byXascX_fold_productXconstantX27X_foldX_unfold: [function({g}) { return g.V().values("age").order().by(Order.asc).fold().product(__.constant(27).fold()).unfold() }], 
    g_V_out_out_path_byXnameX_productXdave_kelvinX_unfold: [function({g}) { return g.V().out().out().path().by("name").product(["dave", "kelvin"]).unfold() }], 
    g_injectXa_null_bX_productXa_cX_unfold: [function({g}) { return g.inject(["a", null, "b"]).product(["a", "c"]).unfold() }], 
    g_injectXa_null_bX_productXa_null_cX_unfold: [function({g}) { return g.inject(["a", null, "b"]).product(["a", null, "c"]).unfold() }], 
    g_injectX3_threeX_productXfive_three_7X_unfold: [function({g}) { return g.inject([3, "three"]).product(["five", "three", 7]).unfold() }], 
    g_V_hasLabelXpersonX_projectXa_bX_byXoutE_countX_byXageX: [function({g}) { return g.V().hasLabel("person").project("a", "b").by(__.outE().count()).by("age") }], 
    g_V_outXcreatedX_projectXa_bX_byXnameX_byXinXcreatedX_countX_order_byXselectXbX__descX_selectXaX: [function({g}) { return g.V().out("created").project("a", "b").by("name").by(__.in_("created").count()).order().by(__.select("b"), Order.desc).select("a") }], 
    g_V_valueMap_projectXxX_byXselectXnameXX: [function({g}) { return g.V().valueMap().project("x").by(__.select("name")) }], 
    g_V_projectXa_bX_byXinE_countX_byXageX: [function({g}) { return g.V().project("a", "b").by(__.inE().count()).by("age") }], 
    g_withStrategiesXProductiveByStrategyX_V_projectXa_bX_byXinE_countX_byXageX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().project("a", "b").by(__.inE().count()).by("age") }], 
    g_V_hasXageX_propertiesXnameX: [function({g}) { return g.V().has("age").properties("name").value() }], 
    g_V_hasXageX_propertiesXname_ageX_value: [function({g}) { return g.V().has("age").properties("name", "age").value() }], 
    g_V_hasXageX_propertiesXage_nameX_value: [function({g}) { return g.V().has("age").properties("age", "name").value() }], 
    g_V_propertiesXname_age_nullX_value: [function({g}) { return g.V().properties("name", "age", null).value() }], 
    g_V_valuesXname_age_nullX: [function({g}) { return g.V().values("name", "age", null) }], 
    g_injectX__feature___test__nullX_rTrim: [function({g}) { return g.inject("feature  ", "one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　").rTrim() }], 
    g_injectX__feature___test__nullX_rTrimXlocalX: [function({g}) { return g.inject(["  feature  ", " one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　"]).rTrim(Scope.local) }], 
    g_injectX__feature__X_rTrim: [function({g}) { return g.inject("  feature  ").rTrim() }], 
    g_injectXListXa_bXX_rTrim: [function({g}) { return g.inject(["a", "b"]).rTrim() }], 
    g_injectXListX1_2XX_rTrimXlocalX: [function({g}) { return g.inject([1, 2]).rTrim(Scope.local) }], 
    g_V_valuesXnameX_rTrim: [function({g}) { return g.addV("person").property("name", " marko ").property("age", 29).as("marko").addV("person").property("name", "  vadas  ").property("age", 27).as("vadas").addV("software").property("name", "  lop").property("lang", "java").as("lop").addV("person").property("name", "josh  ").property("age", 32).as("josh").addV("software").property("name", "   ripple   ").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().values("name").rTrim() }], 
    g_V_valuesXnameX_order_fold_rTrimXlocalX: [function({g}) { return g.addV("person").property("name", " marko ").property("age", 29).as("marko").addV("person").property("name", "  vadas  ").property("age", 27).as("vadas").addV("software").property("name", "  lop").property("lang", "java").as("lop").addV("person").property("name", "josh  ").property("age", 32).as("josh").addV("software").property("name", "   ripple   ").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().values("name").order().fold().rTrim(Scope.local) }], 
    g_injectXthat_this_test_nullX_replaceXh_jX: [function({g}) { return g.inject("that", "this", "test", null).replace("h", "j") }], 
    g_injectXthat_this_test_nullX_fold_replaceXlocal_h_jX: [function({g}) { return g.inject("that", "this", "test", null).fold().replace(Scope.local, "h", "j") }], 
    g_injectXListXa_bXcX_replaceXa_bX: [function({g}) { return g.inject(["a", "b"]).replace("a", "b") }], 
    g_V_hasLabelXsoftwareX_valueXnameX_replaceXnull_iX: [function({g}) { return g.V().hasLabel("software").values("name").replace(null, "g") }], 
    g_V_hasLabelXsoftwareX_valueXnameX_replaceXa_iX: [function({g}) { return g.V().hasLabel("software").values("name").replace("p", "g") }], 
    g_V_hasLabelXsoftwareX_valueXnameX_order_fold_replaceXloacl_a_iX: [function({g}) { return g.V().hasLabel("software").values("name").order().fold().replace(Scope.local, "p", "g") }], 
    g_injectXfeature_test_nullX_reverse: [function({g}) { return g.inject("feature", "test one", null).reverse() }], 
    g_V_valuesXnameX_reverse: [function({g}) { return g.V().values("name").reverse() }], 
    g_V_valuesXageX_reverse: [function({g}) { return g.V().values("age").reverse() }], 
    g_V_out_path_byXnameX_reverse: [function({g}) { return g.V().out().path().by("name").reverse() }], 
    g_V_out_out_path_byXnameX_reverse: [function({g}) { return g.V().out().out().path().by("name").reverse() }], 
    g_V_valuesXageX_fold_orderXlocalX_byXdescX_reverse: [function({g}) { return g.V().values("age").fold().order(Scope.local).by(Order.desc).reverse() }], 
    g_V_valuesXnameX_fold_orderXlocalX_by_reverse: [function({g}) { return g.V().values("name").fold().order(Scope.local).by().reverse() }], 
    g_injectXnullX_reverse: [function({g}) { return g.inject(null).reverse() }], 
    g_injectXbX_reverse: [function({g}) { return g.inject("b").reverse() }], 
    g_injectX3_threeX_reverse: [function({g}) { return g.inject([3, "three"]).reverse() }], 
    g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX: [function({g, vid1}) { return g.V(vid1).as("a").out("knows").as("b").select("a", "b") }], 
    g_VX1X_asXaX_outXknowsX_asXbX_selectXa_bX_byXnameX: [function({g, vid1}) { return g.V(vid1).as("a").out("knows").as("b").select("a", "b").by("name") }], 
    g_VX1X_asXaX_outXknowsX_asXbX_selectXaX: [function({g, vid1}) { return g.V(vid1).as("a").out("knows").as("b").select("a") }], 
    g_VX1X_asXaX_outXknowsX_asXbX_selectXaX_byXnameX: [function({g, vid1}) { return g.V(vid1).as("a").out("knows").as("b").select("a").by("name") }], 
    g_V_asXaX_out_asXbX_selectXa_bX_byXnameX: [function({g}) { return g.V().as("a").out().as("b").select("a", "b").by("name") }], 
    g_V_asXaX_out_aggregateXxX_asXbX_selectXa_bX_byXnameX: [function({g}) { return g.V().as("a").out().aggregate("x").as("b").select("a", "b").by("name") }], 
    g_V_asXaX_name_order_asXbX_selectXa_bX_byXnameX_by_XitX: [function({g}) { return g.V().as("a").values("name").order().as("b").select("a", "b").by("name").by() }], 
    g_V_hasXname_gremlinX_inEXusesX_order_byXskill_ascX_asXaX_outV_asXbX_selectXa_bX_byXskillX_byXnameX: [function({g}) { return g.V().has("name", "gremlin").inE("uses").order().by("skill", Order.asc).as("a").outV().as("b").select("a", "b").by("skill").by("name") }], 
    g_V_whereX_valueXnameX_isXmarkoXX_asXaX_selectXaX: [function({g}) { return g.V().where(__.values("name").is("marko")).as("a").select("a") }], 
    g_V_label_groupCount_asXxX_selectXxX: [function({g}) { return g.V().label().groupCount().as("x").select("x") }], 
    g_V_hasLabelXpersonX_asXpX_mapXbothE_label_groupCountX_asXrX_selectXp_rX: [function({g}) { return g.V().hasLabel("person").as("p").map(__.bothE().label().groupCount()).as("r").select("p", "r") }], 
    g_V_chooseXoutE_count_isX0X__asXaX__asXbXX_chooseXselectXaX__selectXaX__selectXbXX: [function({g, xx1}) { return g.V().choose(__.outE().count().is(xx1), __.as("a"), __.as("b")).choose(__.select("a"), __.select("a"), __.select("b")) }], 
    g_VX1X_groupXaX_byXconstantXaXX_byXnameX_selectXaX_selectXaX: [function({g, vid1}) { return g.V(vid1).group("a").by(__.constant("a")).by(__.values("name")).barrier().select("a").select("a") }], 
    g_VX1X_asXhereX_out_selectXhereX: [function({g, vid1}) { return g.V(vid1).as("here").out().select("here") }], 
    g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX: [function({g, vid4}) { return g.V(vid4).as("here").out().select("here") }], 
    g_VX4X_out_asXhereX_hasXlang_javaX_selectXhereX_name: [function({g, vid4}) { return g.V(vid4).out().as("here").has("lang", "java").select("here").values("name") }], 
    g_VX1X_outE_asXhereX_inV_hasXname_vadasX_selectXhereX: [function({g, vid1}) { return g.V(vid1).outE().as("here").inV().has("name", "vadas").select("here") }], 
    g_VX1X_outEXknowsX_hasXweight_1X_asXhereX_inV_hasXname_joshX_selectXhereX: [function({g, vid1}) { return g.V(vid1).outE("knows").has("weight", 1.0).as("here").inV().has("name", "josh").select("here") }], 
    g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_asXfakeX_inV_hasXname_joshX_selectXhereX: [function({g, vid1}) { return g.V(vid1).outE("knows").as("here").has("weight", 1.0).as("fake").inV().has("name", "josh").select("here") }], 
    g_V_asXhereXout_name_selectXhereX: [function({g}) { return g.V().as("here").out().values("name").select("here") }], 
    g_V_outXcreatedX_unionXasXprojectX_inXcreatedX_hasXname_markoX_selectXprojectX__asXprojectX_inXcreatedX_inXknowsX_hasXname_markoX_selectXprojectXX_groupCount_byXnameX: [function({g}) { return g.V().out("created").union(__.as("project").in_("created").has("name", "marko").select("project"), __.as("project").in_("created").in_("knows").has("name", "marko").select("project")).groupCount().by("name") }], 
    g_V_untilXout_outX_repeatXin_asXaXX_selectXaX_byXtailXlocalX_nameX: [function({g}) { return g.V().until(__.out().out()).repeat(__.in_().as("a")).select("a").by(__.tail(Scope.local).values("name")) }], 
    g_V_outE_weight_groupCount_selectXkeysX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().select(Column.keys).unfold() }], 
    g_V_hasLabelXsoftwareX_asXnameX_asXlanguageX_asXcreatorsX_selectXname_language_creatorsX_byXnameX_byXlangX_byXinXcreatedX_name_fold_orderXlocalXX: [function({g}) { return g.V().hasLabel("software").as("name").as("language").as("creators").select("name", "language", "creators").by("name").by("lang").by(__.in_("created").values("name").fold().order(Scope.local)) }], 
    g_V_outE_weight_groupCount_unfold_selectXkeysX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().unfold().select(Column.keys).unfold() }], 
    g_V_outE_weight_groupCount_unfold_selectXvaluesX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().unfold().select(Column.values).unfold() }], 
    g_V_untilXout_outX_repeatXin_asXaX_in_asXbXX_selectXa_bX_byXnameX: [function({g}) { return g.V().until(__.out().out()).repeat(__.in_().as("a").in_().as("b")).select("a", "b").by("name") }], 
    g_V_outE_weight_groupCount_selectXvaluesX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().select(Column.values).unfold() }], 
    g_V_asXaX_whereXoutXknowsXX_selectXaX: [function({g}) { return g.V().as("a").where(__.out("knows")).select("a") }], 
    g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXfirst_aX: [function({g, vid1}) { return g.V(vid1).as("a").repeat(__.out().as("a")).times(2).select(Pop.first, "a") }], 
    g_V_asXaX_outXknowsX_asXbX_localXselectXa_bX_byXnameXX: [function({g}) { return g.V().as("a").out("knows").as("b").local(__.select("a", "b").by("name")) }], 
    g_VX1X_asXaX_repeatXout_asXaXX_timesX2X_selectXlast_aX: [function({g, vid1}) { return g.V(vid1).as("a").repeat(__.out().as("a")).times(2).select(Pop.last, "a") }], 
    g_VX1X_outEXknowsX_asXhereX_hasXweight_1X_inV_hasXname_joshX_selectXhereX: [function({g, vid1}) { return g.V(vid1).outE("knows").as("here").has("weight", 1.0).inV().has("name", "josh").select("here") }], 
    g_V_asXaX_hasXname_markoX_asXbX_asXcX_selectXa_b_cX_by_byXnameX_byXageX: [function({g}) { return g.V().as("a").has("name", "marko").as("b").as("c").select("a", "b", "c").by().by("name").by("age") }], 
    g_V_outE_weight_groupCount_selectXvaluesX_unfold_groupCount_selectXvaluesX_unfold: [function({g}) { return g.V().outE().values("weight").groupCount().select(Column.values).unfold().groupCount().select(Column.values).unfold() }], 
    g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX: [function({g}) { return g.V().as("a").group("m").by().by(__.bothE().count()).barrier().select("m").select(__.select("a")) }], 
    g_V_asXaX_groupXmX_by_byXbothE_countX_barrier_selectXmX_selectXselectXaXX_byXmathX_plus_XX: [function({g}) { return g.V().as("a").group("m").by().by(__.bothE().count()).barrier().select("m").select(__.select("a")).by(__.math("_+_")) }], 
    g_V_asXaX_outXknowsX_asXaX_selectXall_constantXaXX: [function({g}) { return g.V().as("a").out("knows").as("a").select(Pop.all, __.constant("a")) }], 
    g_V_selectXaX: [function({g}) { return g.V().select("a") }], 
    g_V_selectXaX_count: [function({g}) { return g.V().select("a").count() }], 
    g_V_selectXa_bX: [function({g}) { return g.V().select("a", "b") }], 
    g_V_valueMap_selectXaX: [function({g}) { return g.V().valueMap().select("a") }], 
    g_V_valueMap_selectXa_bX: [function({g}) { return g.V().valueMap().select("a", "b") }], 
    g_V_selectXfirst_aX: [function({g}) { return g.V().select(Pop.first, "a") }], 
    g_V_selectXfirst_a_bX: [function({g}) { return g.V().select(Pop.first, "a", "b") }], 
    g_V_valueMap_selectXfirst_aX: [function({g}) { return g.V().valueMap().select(Pop.first, "a") }], 
    g_V_valueMap_selectXfirst_a_bX: [function({g}) { return g.V().valueMap().select(Pop.first, "a", "b") }], 
    g_V_selectXlast_aX: [function({g}) { return g.V().select(Pop.last, "a") }], 
    g_V_selectXlast_a_bX: [function({g}) { return g.V().select(Pop.last, "a", "b") }], 
    g_V_valueMap_selectXlast_aX: [function({g}) { return g.V().valueMap().select(Pop.last, "a") }], 
    g_V_valueMap_selectXlast_a_bX: [function({g}) { return g.V().valueMap().select(Pop.last, "a", "b") }], 
    g_V_selectXall_aX: [function({g}) { return g.V().select(Pop.all, "a") }], 
    g_V_selectXall_a_bX: [function({g}) { return g.V().select(Pop.all, "a", "b") }], 
    g_V_valueMap_selectXall_aX: [function({g}) { return g.V().valueMap().select(Pop.all, "a") }], 
    g_V_valueMap_selectXall_a_bX: [function({g}) { return g.V().valueMap().select(Pop.all, "a", "b") }], 
    g_V_asXa_bX_out_asXcX_path_selectXkeysX: [function({g}) { return g.V().as("a", "b").out().as("c").path().select(Column.keys) }, function({g}) { return g.V().as("a", "b").out().as("c").path().select(Column.keys) }], 
    g_V_hasXperson_name_markoX_barrier_asXaX_outXknows_selectXaX: [function({g}) { return g.V().has("person", "name", "marko").barrier().as("a").out("knows").select("a") }], 
    g_V_hasXperson_name_markoX_elementMapXnameX_asXaX_unionXidentity_identityX_selectXaX_selectXnameX: [function({g}) { return g.V().has("person", "name", "marko").elementMap("name").as("a").union(__.identity(), __.identity()).select("a").select("name") }], 
    g_V_hasXperson_name_markoX_count_asXaX_unionXidentity_identityX_selectXaX: [function({g}) { return g.V().has("person", "name", "marko").count().as("a").union(__.identity(), __.identity()).select("a") }], 
    g_V_hasXperson_name_markoX_path_asXaX_unionXidentity_identityX_selectXaX_unfold: [function({g}) { return g.V().has("person", "name", "marko").path().as("a").union(__.identity(), __.identity()).select("a").unfold() }], 
    g_EX11X_propertiesXweightX_asXaX_selectXaX_byXkeyX: [function({g, eid11}) { return g.E(eid11).properties("weight").as("a").select("a").by(T.key) }], 
    g_EX11X_propertiesXweightX_asXaX_selectXaX_byXvalueX: [function({g, eid11}) { return g.E(eid11).properties("weight").as("a").select("a").by(T.value) }], 
    g_V_asXaX_selectXaX_byXageX: [function({g}) { return g.V().as("a").select("a").by("age") }], 
    g_V_asXa_nX_selectXa_nX_byXageX_byXnameX: [function({g}) { return g.V().as("a", "n").select("a", "n").by("age").by("name") }], 
    g_withStrategiesXProductiveByStrategyX_V_asXaX_selectXaX_byXageX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().as("a").select("a").by("age") }], 
    g_withSideEffectXk_nullX_injectXxX_selectXkX: [function({g}) { return g.withSideEffect("k", null).inject("x").select("k") }], 
    g_V_out_in_selectXall_a_a_aX_byXunfold_name_foldX: [function({g}) { return g.addV("A").property("name", "a1").as("a1").addV("B").property("name", "b1").as("b1").addE("ab").from_("a1").to("b1") }, function({g}) { return g.V().as("a").out().as("a").in_().as("a").select(Pop.all, "a", "a", "a").by(__.unfold().values("name").fold()) }], 
    g_V_asXlabelX_localXaggregateXxX_selectXxX_selectXlabelX: [function({g}) { return g.V().as("label").local(__.aggregate("x")).barrier().select("x").select("label") }], 
    g_V_name_asXaX_selectXfirst_aX: [function({g}) { return g.V().values("name").as("a").select(Pop.first, "a") }], 
    g_V_name_asXaX_selectXlast_aX: [function({g}) { return g.V().values("name").as("a").select(Pop.last, "a") }], 
    g_V_name_asXaX_selectXmixed_aX: [function({g}) { return g.V().values("name").as("a").select(Pop.mixed, "a") }], 
    g_V_name_asXaX_selectXall_aX: [function({g}) { return g.V().values("name").as("a").select(Pop.all, "a") }], 
    g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_length_asXaX_selectXaX: [function({g}) { return g.V().hasLabel("person").values("name").as("a").concat("X").as("a").length().as("a").select("a") }], 
    g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_length_asXaX_selectXfirst_aX: [function({g}) { return g.V().hasLabel("person").values("name").as("a").concat("X").as("a").length().as("a").select(Pop.first, "a") }], 
    g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_length_asXaX_selectXlast_aX: [function({g}) { return g.V().hasLabel("person").values("name").as("a").concat("X").as("a").length().as("a").select(Pop.last, "a") }], 
    g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_concatXYZX_asXaX_selectXmixed_aX: [function({g}) { return g.V().hasLabel("person").values("name").as("a").concat("X").as("a").concat("YZ").as("a").select(Pop.mixed, "a") }], 
    g_V_hasLabelXpersonX_name_asXaX_concatXXX_asXaX_concatXYZX_asXaX_selectXall_aX: [function({g}) { return g.V().hasLabel("person").values("name").as("a").concat("X").as("a").concat("YZ").as("a").select(Pop.all, "a") }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXmixed_aX_byXunfold_valuesXnameX_foldX: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.mixed, "a").by(__.unfold().values("name").fold()) }], 
    g_V_asXaX_out_asXaX_out_asXaX_selectXall_aX_byXunfold_valuesXnameX_foldX: [function({g}) { return g.V().as("a").out().as("a").out().as("a").select(Pop.all, "a").by(__.unfold().values("name").fold()) }], 
    g_V_shortestPath: [function({g}) { return g.V().shortestPath() }], 
    g_V_both_dedup_shortestPath: [function({g}) { return g.V().both().dedup().shortestPath() }], 
    g_V_shortestPath_edgesIncluded: [function({g}) { return g.V().shortestPath().with_("~tinkerpop.shortestPath.includeEdges") }], 
    g_V_shortestPath_directionXINX: [function({g}) { return g.V().shortestPath().with_("~tinkerpop.shortestPath.edges", Direction.IN) }], 
    g_V_shortestPath_edgesXoutEX: [function({g}) { return g.V().shortestPath().with_("~tinkerpop.shortestPath.edges", __.outE()) }], 
    g_V_shortestPath_edgesIncluded_edgesXoutEX: [function({g}) { return g.V().shortestPath().with_("~tinkerpop.shortestPath.includeEdges").with_("~tinkerpop.shortestPath.edges", __.outE()) }], 
    g_V_hasXname_markoX_shortestPath: [function({g}) { return g.V().has("name", "marko").shortestPath() }], 
    g_V_shortestPath_targetXhasXname_markoXX: [function({g}) { return g.V().shortestPath().with_("~tinkerpop.shortestPath.target", __.has("name", "marko")) }], 
    g_V_shortestPath_targetXvaluesXnameX_isXmarkoXX: [function({g}) { return g.V().shortestPath().with_("~tinkerpop.shortestPath.target", __.values("name").is("marko")) }], 
    g_V_hasXname_markoX_shortestPath_targetXhasLabelXsoftwareXX: [function({g}) { return g.V().has("name", "marko").shortestPath().with_("~tinkerpop.shortestPath.target", __.hasLabel("software")) }], 
    g_V_hasXname_markoX_shortestPath_targetXhasXname_joshXX_distanceXweightX: [function({g}) { return g.V().has("name", "marko").shortestPath().with_("~tinkerpop.shortestPath.target", __.has("name", "josh")).with_("~tinkerpop.shortestPath.distance", "weight") }], 
    g_V_hasXname_danielX_shortestPath_targetXhasXname_stephenXX_edgesXbothEXusesXX: [function({g}) { return g.V().has("name", "daniel").shortestPath().with_("~tinkerpop.shortestPath.target", __.has("name", "stephen")).with_("~tinkerpop.shortestPath.edges", __.bothE("uses")) }], 
    g_V_hasXsong_name_MIGHT_AS_WELLX_shortestPath_targetXhasXsong_name_MAYBE_YOU_KNOW_HOW_I_FEELXX_edgesXoutEXfollowedByXX_distanceXweightX: [function({g}) { return g.V().has("song", "name", "MIGHT AS WELL").shortestPath().with_("~tinkerpop.shortestPath.target", __.has("song", "name", "MAYBE YOU KNOW HOW I FEEL")).with_("~tinkerpop.shortestPath.edges", __.outE("followedBy")).with_("~tinkerpop.shortestPath.distance", "weight") }], 
    g_V_hasXname_markoX_shortestPath_maxDistanceX1X: [function({g}) { return g.V().has("name", "marko").shortestPath().with_("~tinkerpop.shortestPath.maxDistance", 1) }], 
    g_V_hasXname_vadasX_shortestPath_distanceXweightX_maxDistanceX1_3X: [function({g}) { return g.V().has("name", "vadas").shortestPath().with_("~tinkerpop.shortestPath.distance", "weight").with_("~tinkerpop.shortestPath.maxDistance", 1.3) }], 
    g_injectXthat_this_testX_spiltXhX: [function({g}) { return g.inject("that", "this", "test", null).split("h") }], 
    g_injectXhello_worldX_spiltXnullX: [function({g}) { return g.inject("hello world").split(null) }], 
    g_injectXthat_this_test_nullX_splitXemptyX: [function({g}) { return g.inject("that", "this", "test", null).split("") }], 
    g_injectXListXa_bXcX_splitXa_bX: [function({g}) { return g.inject(["a", "b"]).split("a") }], 
    g_V_hasLabelXpersonX_valueXnameX_splitXnullX: [function({g}) { return g.V().hasLabel("person").values("name").split(null) }], 
    g_V_hasLabelXpersonX_valueXnameX_order_fold_splitXlocal_aX_unfold: [function({g}) { return g.V().hasLabel("person").values("name").order().fold().split(Scope.local, "a").unfold() }], 
    g_V_hasLabelXpersonX_valueXnameX_order_fold_splitXlocal_emptyX_unfold: [function({g}) { return g.V().hasLabel("person").values("name").order().fold().split(Scope.local, "").unfold() }], 
    g_injectXthat_this_testX_substringX1_8X: [function({g}) { return g.inject("test", "hello world", null).substring(1, 8) }], 
    g_injectXListXa_bXcX_substringX1_2X: [function({g}) { return g.inject(["aa", "bb"]).substring(1, 2) }], 
    g_V_hasLabelXpersonX_valueXnameX_substringX2X: [function({g}) { return g.V().hasLabel("software").values("name").substring(2) }], 
    g_V_hasLabelXsoftwareX_valueXnameX_substringX1_4X: [function({g}) { return g.V().hasLabel("software").values("name").substring(1, 4) }], 
    g_V_hasLabelXpersonX_valueXnameX_order_fold_substringXlocal_2X: [function({g}) { return g.V().hasLabel("software").values("name").order().fold().substring(Scope.local, 2) }], 
    g_V_hasLabelXsoftwareX_valueXnameX_order_fold_substringXlocal_1_4X: [function({g}) { return g.V().hasLabel("software").values("name").order().fold().substring(Scope.local, 1, 4) }], 
    g_V_hasLabelXsoftwareX_valueXnameX_substringX1_0X: [function({g}) { return g.V().hasLabel("software").values("name").substring(1, 0) }], 
    g_V_hasLabelXpersonX_valueXnameX_substringXneg3X: [function({g}) { return g.V().hasLabel("person").values("name").substring(-3) }], 
    g_V_hasLabelXsoftwareX_valueXnameX_substringX1_neg1X: [function({g}) { return g.V().hasLabel("software").values("name").substring(1, -1) }], 
    g_V_hasLabelXsoftwareX_valueXnameX_substringXneg4_2X: [function({g}) { return g.V().hasLabel("software").values("name").substring(-4, 2) }], 
    g_V_hasLabelXsoftwareX_valueXnameX_substringXneg3_neg1X: [function({g}) { return g.V().hasLabel("software").values("name").substring(-3, -1) }], 
    g_V_injectX127b_1bX_sumXX: [function({g}) { return g.inject(127, 1).sum() }], 
    g_V_injectX_128b__1bX_sumXX: [function({g}) { return g.inject(-128, -1).sum() }], 
    g_V_injectX32767s_1sX_sumXX: [function({g}) { return g.inject(32767, 1).sum() }], 
    g_V_injectX_32768s__1sX_sumXX: [function({g}) { return g.inject(-32768, -1).sum() }], 
    g_V_injectX2147483647i_1iX_sumXX: [function({g}) { return g.inject(2147483647, 1).sum() }], 
    g_V_injectX_2147483648i__1iX_sumXX: [function({g}) { return g.inject(-2147483648, -1).sum() }], 
    g_V_age_sum: [function({g}) { return g.V().values("age").sum() }], 
    g_V_foo_sum: [function({g}) { return g.V().values("foo").sum() }], 
    g_V_age_fold_sumXlocalX: [function({g}) { return g.V().values("age").fold().sum(Scope.local) }], 
    g_V_foo_fold_sumXlocalX: [function({g}) { return g.V().values("foo").fold().sum(Scope.local) }], 
    g_V_hasLabelXsoftwareX_group_byXnameX_byXbothE_weight_sumX: [function({g}) { return g.V().hasLabel("software").group().by("name").by(__.bothE().values("weight").sum()) }], 
    g_V_aggregateXaX_byXageX_sumXlocalX: [function({g}) { return g.V().aggregate("a").by("age").cap("a").sum(Scope.local) }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_sumXlocalX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("age").cap("a").sum(Scope.local) }], 
    g_V_aggregateXaX_byXageX_capXaX_unfold_sum: [function({g}) { return g.V().aggregate("a").by("age").cap("a").unfold().sum() }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXageX_capXaX_unfold_sum: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("age").cap("a").unfold().sum() }], 
    g_V_aggregateXaX_byXfooX_sumXlocalX: [function({g}) { return g.V().aggregate("a").by("foo").cap("a").sum(Scope.local) }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_sumXlocalX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("foo").cap("a").sum(Scope.local) }], 
    g_V_aggregateXaX_byXfooX_capXaX_unfold_sum: [function({g}) { return g.V().aggregate("a").by("foo").cap("a").unfold().sum() }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXaX_byXfooX_capXaX_unfold_sum: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("a").by("foo").cap("a").unfold().sum() }], 
    g_injectXnull_10_5_nullX_sum: [function({g}) { return g.inject(null, 10, 5, null).sum() }], 
    g_injectXlistXnull_10_5_nullXX_sumXlocalX: [function({g}) { return g.inject([null, 10, 5, null]).sum(Scope.local) }], 
    g_VX1X_valuesXageX_sumXlocalX: [function({g, vid1}) { return g.V(vid1).values("age").sum(Scope.local) }], 
    g_V_localXunionXvaluesXageX_outE_valuesXweightXX_foldX_sumXlocalX: [function({g}) { return g.V().local(__.union(__.values("age"), __.outE().values("weight")).fold()).sum(Scope.local) }], 
    g_V_age_injectX1000nX_sum: [function({g}) { return g.V().values("age").inject(1000).sum() }], 
    g_injectX1b_2b_3bX_sum: [function({g}) { return g.inject(1, 2, 3).sum() }], 
    g_injectX1b_2b_3sX_sum: [function({g}) { return g.inject(1, 2, 3).sum() }], 
    g_injectX1b_26b_3iX_sum: [function({g}) { return g.inject(1, 2, 3).sum() }], 
    g_injectX1f_26f_3fX_sum: [function({g}) { return g.inject(1, 2, 3).sum() }], 
    g_V_age_injectX1000nX_fold_sumXlocalX: [function({g}) { return g.V().values("age").inject(1000).fold().sum(Scope.local) }], 
    g_injectX1b_2b_3bX_fold_sumXlocalX: [function({g}) { return g.inject(1, 2, 3).fold().sum(Scope.local) }], 
    g_injectX1b_2b_3sX_fold_sumXlocalX: [function({g}) { return g.inject(1, 2, 3).fold().sum(Scope.local) }], 
    g_injectX1b_26b_3iX_fold_sumXlocalX: [function({g}) { return g.inject(1, 2, 3).fold().sum(Scope.local) }], 
    g_injectX1f_26f_3fX_fold_sumXlocalX: [function({g}) { return g.inject(1, 2, 3).fold().sum(Scope.local) }], 
    g_injectXfeature_test_nullX_toLower: [function({g}) { return g.inject("FEATURE", "tESt", null).toLower() }], 
    g_injectXfeature_test_nullX_toLowerXlocalX: [function({g}) { return g.inject(["FEATURE", "tESt", null]).toLower(Scope.local) }], 
    g_injectXListXa_bXX_toLower: [function({g}) { return g.inject(["a", "b"]).toLower() }], 
    g_V_valuesXnameX_toLower: [function({g}) { return g.addV("person").property("name", "MARKO").property("age", 29).as("marko").addV("person").property("name", "VADAS").property("age", 27).as("vadas").addV("software").property("name", "LOP").property("lang", "java").as("lop").addV("person").property("name", "JOSH").property("age", 32).as("josh").addV("software").property("name", "RIPPLE").property("lang", "java").as("ripple").addV("person").property("name", "PETER").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().values("name").toLower() }], 
    g_V_valuesXnameX_toLowerXlocalX: [function({g}) { return g.addV("person").property("name", "MARKO").property("age", 29).as("marko").addV("person").property("name", "VADAS").property("age", 27).as("vadas").addV("software").property("name", "LOP").property("lang", "java").as("lop").addV("person").property("name", "JOSH").property("age", 32).as("josh").addV("software").property("name", "RIPPLE").property("lang", "java").as("ripple").addV("person").property("name", "PETER").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().values("name").toLower(Scope.local) }], 
    g_V_valuesXnameX_order_fold_toLowerXlocalX: [function({g}) { return g.addV("person").property("name", "MARKO").property("age", 29).as("marko").addV("person").property("name", "VADAS").property("age", 27).as("vadas").addV("software").property("name", "LOP").property("lang", "java").as("lop").addV("person").property("name", "JOSH").property("age", 32).as("josh").addV("software").property("name", "RIPPLE").property("lang", "java").as("ripple").addV("person").property("name", "PETER").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().values("name").order().fold().toLower(Scope.local) }], 
    g_injectXfeature_test_nullX_toUpper: [function({g}) { return g.inject("feature", "tESt", null).toUpper() }], 
    g_injectXfeature_test_nullX_toUpperXlocalX: [function({g}) { return g.inject(["feature", "tESt", null]).toUpper(Scope.local) }], 
    g_injectXListXa_bXX_toUpper: [function({g}) { return g.inject(["a", "b"]).toUpper() }], 
    g_V_valuesXnameX_toUpper: [function({g}) { return g.V().values("name").toUpper() }], 
    g_V_valuesXnameX_toUpperXlocalX: [function({g}) { return g.V().values("name").toUpper(Scope.local) }], 
    g_V_valuesXnameX_order_fold_toUpperXlocalX: [function({g}) { return g.V().values("name").order().fold().toUpper(Scope.local) }], 
    g_injectX__feature___test__nullX_trim: [function({g}) { return g.inject("  feature  ", " one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　").trim() }], 
    g_injectX__feature___test__nullX_trimXlocalX: [function({g}) { return g.inject(["  feature  ", " one test ", null, "", " ", "　abc", "abc　", "　abc　", "　　"]).trim(Scope.local) }], 
    g_injectXListXa_bXX_trim: [function({g}) { return g.inject(["a", "b"]).trim() }], 
    g_injectXListX1_2XX_trimXlocalX: [function({g}) { return g.inject([1, 2]).trim(Scope.local) }], 
    g_V_valuesXnameX_trim: [function({g}) { return g.addV("person").property("name", " marko ").property("age", 29).as("marko").addV("person").property("name", "  vadas  ").property("age", 27).as("vadas").addV("software").property("name", "  lop").property("lang", "java").as("lop").addV("person").property("name", "josh  ").property("age", 32).as("josh").addV("software").property("name", "   ripple   ").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().values("name").trim() }], 
    g_V_valuesXnameX_order_fold_trimXlocalX: [function({g}) { return g.addV("person").property("name", " marko ").property("age", 29).as("marko").addV("person").property("name", "  vadas  ").property("age", 27).as("vadas").addV("software").property("name", "  lop").property("lang", "java").as("lop").addV("person").property("name", "josh  ").property("age", 32).as("josh").addV("software").property("name", "   ripple   ").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g}) { return g.V().values("name").order().fold().trim(Scope.local) }], 
    g_V_localXoutE_foldX_unfold: [function({g}) { return g.V().local(__.outE().fold()).unfold() }], 
    g_V_valueMap_unfold_mapXselectXkeysXX: [function({g}) { return g.V().valueMap().unfold().map(__.select(Column.keys)) }], 
    g_VX1X_repeatXboth_simplePathX_untilXhasIdX6XX_path_byXnameX_unfold: [function({g, vid6, vid1}) { return g.V(vid1).repeat(__.both().simplePath()).until(__.hasId(vid6)).path().by("name").unfold() }], 
    g_V_valueMap: [function({g}) { return g.V().valueMap() }], 
    g_V_valueMapXtrueX: [function({g}) { return g.V().valueMap(true) }], 
    g_V_valueMap_withXtokensX: [function({g}) { return g.V().valueMap().with_(WithOptions.tokens) }], 
    g_V_valueMapXname_ageX: [function({g}) { return g.V().valueMap("name", "age") }], 
    g_V_valueMapXtrue_name_ageX: [function({g}) { return g.V().valueMap(true, "name", "age") }], 
    g_V_valueMapXname_ageX_withXtokensX: [function({g}) { return g.V().valueMap("name", "age").with_(WithOptions.tokens) }], 
    g_V_valueMapXname_ageX_withXtokens_labelsX_byXunfoldX: [function({g}) { return g.V().valueMap("name", "age").with_(WithOptions.tokens, WithOptions.labels).by(__.unfold()) }], 
    g_V_valueMapXname_ageX_withXtokens_idsX_byXunfoldX: [function({g}) { return g.V().valueMap("name", "age").with_(WithOptions.tokens, WithOptions.ids).by(__.unfold()) }], 
    g_VX1X_outXcreatedX_valueMap: [function({g, vid1}) { return g.V(vid1).out("created").valueMap() }], 
    g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMapXtrueX: [function({g}) { return g.V().hasLabel("person").filter(__.outE("created")).valueMap(true) }], 
    g_V_hasLabelXpersonX_filterXoutEXcreatedXX_valueMap_withXtokensX: [function({g}) { return g.V().hasLabel("person").filter(__.outE("created")).valueMap().with_(WithOptions.tokens) }], 
    g_VX1X_valueMapXname_locationX_byXunfoldX_by: [function({g, vid1}) { return g.V(vid1).valueMap("name", "location").by(__.unfold()).by() }], 
    g_V_valueMapXname_age_nullX: [function({g}) { return g.V().valueMap("name", "age", null) }], 
    g_V_valueMapXname_ageX_byXisXxXXbyXunfoldX: [function({g}) { return g.V().valueMap("name", "age").by(__.is("x")).by(__.unfold()) }], 
    g_VXnullX: [function({g}) { return g.V(null) }], 
    g_VXlistXnullXX: [function({g, xx1}) { return g.V(xx1) }], 
    g_VX1_nullX: [function({g, vid1}) { return g.V(vid1, null) }], 
    g_VXlistX1_2_3XX_name: [function({g, xx1}) { return g.V(xx1).values("name") }], 
    g_VXlistXv1_v2_v3XX_name: [function({g, xx1}) { return g.V(xx1).values("name") }], 
    g_V: [function({g}) { return g.V() }], 
    g_VXv1X_out: [function({g, vid1}) { return g.V(vid1).out() }], 
    g_VX1X_out: [function({g, vid1}) { return g.V(vid1).out() }], 
    g_VX2X_in: [function({g, vid2}) { return g.V(vid2).in_() }], 
    g_VX4X_both: [function({g, vid4}) { return g.V(vid4).both() }], 
    g_VX1X_outE: [function({g, vid1}) { return g.V(vid1).outE() }], 
    g_VX2X_outE: [function({g, vid2}) { return g.V(vid2).inE() }], 
    g_VX4X_bothEXcreatedX: [function({g, vid4}) { return g.V(vid4).bothE("created") }], 
    g_VX4X_bothEXcreatedvarX: [function({g, xx1, vid4}) { return g.V(vid4).bothE(xx1) }], 
    g_VX4X_bothE: [function({g, vid4}) { return g.V(vid4).bothE() }], 
    g_V_out_outE_inV_inE_inV_both_name: [function({g}) { return g.V().out().outE().inV().inE().inV().both().values("name") }], 
    g_VX2X_inE: [function({g, vid2}) { return g.V(vid2).bothE() }], 
    g_VX1X_outXknowsX: [function({g, vid1}) { return g.V(vid1).out("knows") }], 
    g_VX1AsStringX_outXknowsX: [function({g, vid1}) { return g.V(vid1).out("knows") }], 
    g_VX1X_outXknows_createdX: [function({g, vid1}) { return g.V(vid1).out("knows", "created") }], 
    g_VX1X_outXknowsvar_createdvarX: [function({g, xx3, xx2, vid1}) { return g.V(vid1).out(xx2, xx3) }], 
    g_V_out_out: [function({g}) { return g.V().out().out() }], 
    g_VX1X_out_out_out: [function({g, vid1}) { return g.V(vid1).out().out().out() }], 
    g_VX1X_out_name: [function({g, vid1}) { return g.V(vid1).out().values("name") }], 
    g_VX1X_to_XOUT_knowsX: [function({g, vid1}) { return g.V(vid1).to(Direction.OUT, "knows") }], 
    g_VX1_2_3_4X_name: [function({g, vid4, vid3, vid2, vid1}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, vid4, vid3, vid2, vid1}) { return g.V().has("software", "name", "lop").drop() }, function({g, vid4, vid3, vid2, vid1}) { return g.V(vid1, vid2, vid3, vid4) }], 
    g_V_hasLabelXpersonX_V_hasLabelXsoftwareX_name: [function({g}) { return g.V().hasLabel("person").V().hasLabel("software").values("name") }], 
    g_V_hasLabelXloopsX_bothEXselfX: [function({g}) { return g.V().hasLabel("loops").bothE("self") }], 
    g_V_hasLabelXloopsX_bothXselfX: [function({g}) { return g.V().hasLabel("loops").both("self") }], 
    g_injectX1X_VXnullX: [function({g}) { return g.inject(1).V(null) }], 
    g_injectX1X_VX1_nullX: [function({g, vid1}) { return g.inject(1).V(vid1, null) }], 
    g_VX1X_V_valuesXnameX: [function({g, vid1}) { return g.V(vid1).V().values("name") }], 
    g_V_outXknowsX_V_name: [function({g}) { return g.V().out("knows").V().values("name") }], 
    g_V_hasXname_GarciaX_inXsungByX_asXsongX_V_hasXname_Willie_DixonX_inXwrittenByX_whereXeqXsongXX_name: [function({g}) { return g.V().has("artist", "name", "Garcia").in_("sungBy").as("song").V().has("artist", "name", "Willie_Dixon").in_("writtenBy").where(P.eq("song")).values("name") }], 
    g_V_hasLabelXpersonX_asXpX_VXsoftwareX_addInEXuses_pX: [function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.addV("person").property("name", "marko").property("age", 29).as("marko").addV("person").property("name", "vadas").property("age", 27).as("vadas").addV("software").property("name", "lop").property("lang", "java").as("lop").addV("person").property("name", "josh").property("age", 32).as("josh").addV("software").property("name", "ripple").property("lang", "java").as("ripple").addV("person").property("name", "peter").property("age", 35).as("peter").addE("knows").from_("marko").to("vadas").property("weight", 0.5).addE("knows").from_("marko").to("josh").property("weight", 1.0).addE("created").from_("marko").to("lop").property("weight", 0.4).addE("created").from_("josh").to("ripple").property("weight", 1.0).addE("created").from_("josh").to("lop").property("weight", 0.4).addE("created").from_("peter").to("lop").property("weight", 0.2) }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V().hasLabel("person").as("p").V(xx1).addE("uses").from_("p") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.E().hasLabel("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid1).outE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid2).outE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid3).inE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid4).outE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid5).inE("uses") }, function({g, xx1, vid1, vid2, vid3, vid4, vid5, vid6}) { return g.V(vid6).outE("uses") }], 
    InjectXnullX_eqXnullX: [function({g}) { return g.inject(null).is(P.eq(null)) }], 
    InjectXnullX_neqXnullX: [function({g}) { return g.inject(null).is(P.neq(null)) }], 
    InjectXnullX_ltXnullX: [function({g}) { return g.inject(null).is(P.lt(null)) }], 
    InjectXnullX_lteXnullX: [function({g}) { return g.inject(null).is(P.lte(null)) }], 
    InjectXnullX_gtXnullX: [function({g}) { return g.inject(null).is(P.gt(null)) }], 
    InjectXnullX_gteXnullX: [function({g}) { return g.inject(null).is(P.gte(null)) }], 
    InjectXNaNX_eqXNaNX: [function({g}) { return g.inject(Number.NaN).is(P.eq(Number.NaN)) }], 
    InjectXNaNX_neqXNaNX: [function({g}) { return g.inject(Number.NaN).is(P.neq(Number.NaN)) }], 
    InjectXNaNX_ltXNaNX: [function({g}) { return g.inject(Number.NaN).is(P.lt(Number.NaN)) }], 
    InjectXNaNX_lteXNaNX: [function({g}) { return g.inject(Number.NaN).is(P.lte(Number.NaN)) }], 
    InjectXNaNX_gtXNaNX: [function({g}) { return g.inject(Number.NaN).is(P.gt(Number.NaN)) }], 
    InjectXNaNX_gteXNaNX: [function({g}) { return g.inject(Number.NaN).is(P.gte(Number.NaN)) }], 
    InjectX1dX_eqXNaNX: [function({g}) { return g.inject(1.0).is(P.eq(Number.NaN)) }], 
    InjectX1dX_neqXNaNX: [function({g}) { return g.inject(1.0).is(P.neq(Number.NaN)) }], 
    InjectX1dX_ltXNaNX: [function({g}) { return g.inject(1.0).is(P.lt(Number.NaN)) }], 
    InjectX1dX_lteXNaNX: [function({g}) { return g.inject(1.0).is(P.lte(Number.NaN)) }], 
    InjectX1dX_gtXNaNX: [function({g}) { return g.inject(1.0).is(P.gt(Number.NaN)) }], 
    InjectX1dX_gteXNaNX: [function({g}) { return g.inject(1.0).is(P.gte(Number.NaN)) }], 
    InjectXNaNX_eqXnullX: [function({g}) { return g.inject(Number.NaN).is(P.eq(null)) }], 
    InjectXNaNX_neqXnullX: [function({g}) { return g.inject(Number.NaN).is(P.neq(null)) }], 
    InjectXNaNX_ltXnullX: [function({g}) { return g.inject(Number.NaN).is(P.lt(null)) }], 
    InjectXNaNX_lteXnullX: [function({g}) { return g.inject(Number.NaN).is(P.lte(null)) }], 
    InjectXNaNX_gtXnullX: [function({g}) { return g.inject(Number.NaN).is(P.gt(null)) }], 
    InjectXNaNX_gteXnullX: [function({g}) { return g.inject(Number.NaN).is(P.gte(null)) }], 
    InjectXfooX_eqX1dX: [function({g}) { return g.inject("foo").is(P.eq(1.0)) }], 
    InjectXfooX_neqX1dX: [function({g}) { return g.inject("foo").is(P.neq(1.0)) }], 
    InjectXfooX_ltX1dX: [function({g}) { return g.inject("foo").is(P.lt(1.0)) }], 
    InjectXfooX_lteX1dX: [function({g}) { return g.inject("foo").is(P.lte(1.0)) }], 
    InjectXfooX_gtX1dX: [function({g}) { return g.inject("foo").is(P.gt(1.0)) }], 
    InjectXfooX_gteX1dX: [function({g}) { return g.inject("foo").is(P.gte(1.0)) }], 
    InjectX1dX_eqXfooX: [function({g}) { return g.inject(1.0).is(P.eq("foo")) }], 
    InjectX1dX_neqXfooX: [function({g}) { return g.inject(1.0).is(P.neq("foo")) }], 
    InjectX1dX_ltXfooX: [function({g}) { return g.inject(1.0).is(P.lt("foo")) }], 
    InjectX1dX_lteXfooX: [function({g}) { return g.inject(1.0).is(P.lte("foo")) }], 
    InjectX1dX_gtXfooX: [function({g}) { return g.inject(1.0).is(P.gt("foo")) }], 
    InjectX1dX_gteXfooX: [function({g}) { return g.inject(1.0).is(P.gte("foo")) }], 
    InjectX1dX_andXtrue_trueX: [function({g}) { return g.inject(1).and(__.is(P.eq(1)), __.is(P.gt(0))) }], 
    InjectX1dX_isXtrue_trueX: [function({g}) { return g.inject(1).is(P.eq(1).and(P.gt(0))) }], 
    InjectX1dX_andXtrue_falseX: [function({g}) { return g.inject(1).and(__.is(P.eq(1)), __.is(P.lt(0))) }], 
    InjectX1dX_isXtrue_falseX: [function({g}) { return g.inject(1).is(P.eq(1).and(P.lt(0))) }], 
    InjectX1dX_andXtrue_errorX: [function({g}) { return g.inject(1).and(__.is(P.eq(1)), __.is(P.lt(Number.NaN))) }], 
    InjectX1dX_isXtrue_errorX: [function({g}) { return g.inject(1).is(P.eq(1).and(P.lt(Number.NaN))) }], 
    InjectX1dX_andXfalse_trueX: [function({g}) { return g.inject(1).and(__.is(P.neq(1)), __.is(P.gt(0))) }], 
    InjectX1dX_isXfalse_trueX: [function({g}) { return g.inject(1).is(P.neq(1).and(P.gt(0))) }], 
    InjectX1dX_andXfalse_falseX: [function({g}) { return g.inject(1).and(__.is(P.neq(1)), __.is(P.lt(0))) }], 
    InjectX1dX_isXfalse_falseX: [function({g}) { return g.inject(1).is(P.neq(1).and(P.lt(0))) }], 
    InjectX1dX_andXfalse_errorX: [function({g}) { return g.inject(1).and(__.is(P.neq(1)), __.is(P.lt(Number.NaN))) }], 
    InjectX1dX_isXfalse_errorX: [function({g}) { return g.inject(1).is(P.neq(1).and(P.lt(Number.NaN))) }], 
    InjectX1dX_andXerror_trueX: [function({g}) { return g.inject(1).and(__.is(P.lt(Number.NaN)), __.is(P.gt(0))) }], 
    InjectX1dX_isXerror_trueX: [function({g}) { return g.inject(1).is(P.lt(Number.NaN).and(P.gt(0))) }], 
    InjectX1dX_andXerror_falseX: [function({g}) { return g.inject(1).and(__.is(P.lt(Number.NaN)), __.is(P.gt(2))) }], 
    InjectX1dX_isXerror_falseX: [function({g}) { return g.inject(1).is(P.lt(Number.NaN).and(P.gt(2))) }], 
    InjectX1dX_andXerror_errorX: [function({g}) { return g.inject(1).and(__.is(P.lt(Number.NaN)), __.is(P.gt(Number.NaN))) }], 
    InjectX1dX_isXerror_errorX: [function({g}) { return g.inject(1).is(P.lt(Number.NaN).and(P.gt(Number.NaN))) }], 
    InjectX1dX_orXtrue_trueX: [function({g}) { return g.inject(1).or(__.is(P.eq(1)), __.is(P.gt(0))) }], 
    InjectX1dX_isXtrue_or_trueX: [function({g}) { return g.inject(1).is(P.eq(1).or(P.gt(0))) }], 
    InjectX1dX_orXtrue_falseX: [function({g}) { return g.inject(1).or(__.is(P.eq(1)), __.is(P.lt(0))) }], 
    InjectX1dX_isXtrue_or_falseX: [function({g}) { return g.inject(1).is(P.eq(1).or(P.lt(0))) }], 
    InjectX1dX_orXtrue_errorX: [function({g}) { return g.inject(1).or(__.is(P.eq(1)), __.is(P.lt(Number.NaN))) }], 
    InjectX1dX_isXtrue_or_errorX: [function({g}) { return g.inject(1).is(P.eq(1).or(P.lt(Number.NaN))) }], 
    InjectX1dX_orXfalse_trueX: [function({g}) { return g.inject(1).or(__.is(P.neq(1)), __.is(P.gt(0))) }], 
    InjectX1dX_isXfalse_or_trueX: [function({g}) { return g.inject(1).is(P.neq(1).or(P.gt(0))) }], 
    InjectX1dX_orXfalse_falseX: [function({g}) { return g.inject(1).or(__.is(P.neq(1)), __.is(P.lt(0))) }], 
    InjectX1dX_isXfalse_or_falseX: [function({g}) { return g.inject(1).is(P.neq(1).or(P.lt(0))) }], 
    InjectX1dX_orXfalse_errorX: [function({g}) { return g.inject(1).or(__.is(P.neq(1)), __.is(P.lt(Number.NaN))) }], 
    InjectX1dX_isXfalse_or_errorX: [function({g}) { return g.inject(1).is(P.neq(1).or(P.lt(Number.NaN))) }], 
    InjectX1dX_orXerror_trueX: [function({g}) { return g.inject(1).or(__.is(P.lt(Number.NaN)), __.is(P.gt(0))) }], 
    InjectX1dX_isXerror_or_trueX: [function({g}) { return g.inject(1).is(P.lt(Number.NaN).or(P.gt(0))) }], 
    InjectX1dX_orXerror_falseX: [function({g}) { return g.inject(1).or(__.is(P.lt(Number.NaN)), __.is(P.gt(2))) }], 
    InjectX1dX_isXerror_or_falseX: [function({g}) { return g.inject(1).is(P.lt(Number.NaN).or(P.gt(2))) }], 
    InjectX1dX_orXerror_errorX: [function({g}) { return g.inject(1).or(__.is(P.lt(Number.NaN)), __.is(P.gt(Number.NaN))) }], 
    InjectX1dX_isXerror_or_errorX: [function({g}) { return g.inject(1).is(P.lt(Number.NaN).or(P.gt(Number.NaN))) }], 
    InjectX1dX_notXtrueX: [function({g}) { return g.inject(1).not(__.is(P.gt(0))) }], 
    InjectX1dX_notXfalseX: [function({g}) { return g.inject(1).not(__.is(P.lt(0))) }], 
    InjectX1dX_notXNaNX: [function({g}) { return g.inject(1).not(__.is(P.gt(Number.NaN))) }], 
    InjectX1dX_notXisXeqXNaNXXX: [function({g}) { return g.inject(1).not(__.is(P.eq(Number.NaN))) }], 
    InjectXInfX_eqXInfX: [function({g}) { return g.inject(Number.POSITIVE_INFINITY).is(P.eq(Number.POSITIVE_INFINITY)) }], 
    InjectXInfX_neqXInfX: [function({g}) { return g.inject(Number.POSITIVE_INFINITY).is(P.neq(Number.POSITIVE_INFINITY)) }], 
    InjectXNegInfX_eqXNegInfX: [function({g}) { return g.inject(Number.NEGATIVE_INFINITY).is(P.eq(Number.NEGATIVE_INFINITY)) }], 
    InjectXNegInfX_neqXNegInfX: [function({g}) { return g.inject(Number.NEGATIVE_INFINITY).is(P.neq(Number.NEGATIVE_INFINITY)) }], 
    InjectXInfX_gtXNegInfX: [function({g}) { return g.inject(Number.POSITIVE_INFINITY).is(P.gt(Number.NEGATIVE_INFINITY)) }], 
    InjectXInfX_ltXNegInfX: [function({g}) { return g.inject(Number.POSITIVE_INFINITY).is(P.lt(Number.NEGATIVE_INFINITY)) }], 
    InjectXNegInfX_ltXInfX: [function({g}) { return g.inject(Number.NEGATIVE_INFINITY).is(P.lt(Number.POSITIVE_INFINITY)) }], 
    InjectXNegInfX_gtXInfX: [function({g}) { return g.inject(Number.NEGATIVE_INFINITY).is(P.gt(Number.POSITIVE_INFINITY)) }], 
    Primitives_Number_eqXbyteX: [function({g, xx1}) { return g.inject([1, 1, 1, 1, 1, 1, 1000, 1, 1]).unfold().where(__.is(xx1)) }], 
    Primitives_Number_eqXshortX: [function({g, xx1}) { return g.inject([1, 1, 1, 1, 1, 1, 1000, 1, 1]).unfold().where(__.is(xx1)) }], 
    Primitives_Number_eqXintX: [function({g, xx1}) { return g.inject([1, 1, 1, 1, 1, 1, 1000, 1, 1]).unfold().where(__.is(xx1)) }], 
    Primitives_Number_eqXlongX: [function({g, xx1}) { return g.inject([1, 1, 1, 1, 1, 1, 1000, 1, 1]).unfold().where(__.is(xx1)) }], 
    Primitives_Number_eqXbigintX: [function({g, xx1}) { return g.inject([1, 1, 1, 1, 1, 1, 1000, 1, 1]).unfold().where(__.is(xx1)) }], 
    Primitives_Number_eqXfloatX: [function({g, xx1}) { return g.inject([1, 1, 1, 1, 1, 1, 1000, 1, 1]).unfold().where(__.is(xx1)) }], 
    Primitives_Number_eqXdoubleX: [function({g, xx1}) { return g.inject([1, 1, 1, 1, 1, 1, 1000, 1, 1]).unfold().where(__.is(xx1)) }], 
    Primitives_Number_eqXbigdecimalX: [function({g, xx1}) { return g.inject([1, 1, 1, 1, 1, 1, 1000, 1, 1]).unfold().where(__.is(xx1)) }], 
    g_V_values_order: [function({g}) { return g.V().values().order() }], 
    g_V_properties_order: [function({g}) { return g.V().properties().order() }], 
    g_V_properties_order_id: [function({g}) { return g.V().properties().order().id() }], 
    g_E_properties_order_value: [function({g}) { return g.addV("person").property("name", "alice").as("a").addE("self").from_("a").to("a").property("weight", 0.5).property("a", 10).addE("self").from_("a").to("a").property("weight", 1.0).property("a", 11).addE("self").from_("a").to("a").property("weight", 0.4).property("a", 12).addE("self").from_("a").to("a").property("weight", 1.0).property("a", 13).addE("self").from_("a").to("a").property("weight", 0.4).property("a", 14).addE("self").from_("a").to("a").property("weight", 0.2).property("a", 15) }, function({g}) { return g.E().properties().order().value() }], 
    g_E_properties_order_byXdescX_value: [function({g}) { return g.addV("person").property("name", "alice").as("a").addE("self").from_("a").to("a").property("weight", 0.5).property("a", 10).addE("self").from_("a").to("a").property("weight", 1.0).property("a", 11).addE("self").from_("a").to("a").property("weight", 0.4).property("a", 12).addE("self").from_("a").to("a").property("weight", 1.0).property("a", 13).addE("self").from_("a").to("a").property("weight", 0.4).property("a", 14).addE("self").from_("a").to("a").property("weight", 0.2).property("a", 15) }, function({g}) { return g.E().properties().order().by(Order.desc).value() }], 
    g_inject_order: [function({g}) { return g.inject("zzz", "foo", ["a", "b", "c", "d"], 1, ["a", "b", "c"], new Map([["a", "a"], ["b", "b"]]), null, 2.0, new Map([["a", "a"], ["b", false], ["c", "c"]]), "bar", true, false, Number.POSITIVE_INFINITY, Number.NaN, Number.NEGATIVE_INFINITY).order() }], 
    g_inject_order_byXdescX: [function({g}) { return g.inject("zzz", "foo", ["a", "b", "c", "d"], 1, ["a", "b", "c"], new Map([["a", "a"], ["b", "b"]]), null, 2.0, new Map([["a", "a"], ["b", false], ["c", "c"]]), "bar", true, false, Number.POSITIVE_INFINITY, Number.NaN, Number.NEGATIVE_INFINITY).order().by(Order.desc) }], 
    g_V_out_out_order_byXascX: [function({g}) { return g.V().out().out().order().by(Order.asc) }], 
    g_V_out_out_order_byXdescX: [function({g}) { return g.V().out().out().order().by(Order.desc) }], 
    g_V_out_out_asXheadX_path_order_byXascX_selectXheadX: [function({g}) { return g.V().out().out().as("head").path().order().by(Order.asc).select("head") }], 
    g_V_out_out_asXheadX_path_order_byXdescX_selectXheadX: [function({g}) { return g.V().out().out().as("head").path().order().by(Order.desc).select("head") }], 
    g_V_out_outE_order_byXascX: [function({g}) { return g.V().out().outE().order().by(Order.asc) }], 
    g_V_out_outE_order_byXdescX: [function({g}) { return g.V().out().outE().order().by(Order.desc) }], 
    g_V_out_outE_asXheadX_path_order_byXascX_selectXheadX: [function({g}) { return g.V().out().outE().as("head").path().order().by(Order.asc).select("head") }], 
    g_V_out_outE_asXheadX_path_order_byXdescX_selectXheadX: [function({g}) { return g.V().out().outE().as("head").path().order().by(Order.desc).select("head") }], 
    g_V_out_out_properties_asXheadX_path_order_byXascX_selectXheadX_value: [function({g}) { return g.V().out().out().properties().as("head").path().order().by(Order.asc).select("head").value() }], 
    g_V_out_out_properties_asXheadX_path_order_byXdescX_selectXheadX_value: [function({g}) { return g.V().out().out().properties().as("head").path().order().by(Order.desc).select("head").value() }], 
    g_V_out_out_values_asXheadX_path_order_byXascX_selectXheadX: [function({g}) { return g.V().out().out().values().as("head").path().order().by(Order.asc).select("head") }], 
    g_V_out_out_values_asXheadX_path_order_byXdescX_selectXheadX: [function({g}) { return g.V().out().out().values().as("head").path().order().by(Order.desc).select("head") }], 
    g_V_valueXnameX_aggregateXxX_capXxX: [function({g}) { return g.V().values("name").aggregate("x").cap("x") }], 
    g_V_aggregateXxX_byXnameX_capXxX: [function({g}) { return g.V().aggregate("x").by("name").cap("x") }], 
    g_V_out_aggregateXaX_path: [function({g}) { return g.V().out().aggregate("a").path() }], 
    g_V_hasLabelXpersonX_aggregateXxX_byXageX_capXxX_asXyX_selectXyX: [function({g}) { return g.V().hasLabel("person").aggregate("x").by("age").cap("x").as("y").select("y") }], 
    g_V_aggregateXxX_byXageX_capXxX: [function({g}) { return g.V().aggregate("x").by("age").cap("x") }], 
    g_V_localXaggregateXxX_byXageXX_capXxX: [function({g}) { return g.V().local(__.aggregate("x").by("age")).cap("x") }], 
    g_withStrategiesXProductiveByStrategyX_V_localXaggregateXxX_byXageXX_capXxX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().local(__.aggregate("x").by("age")).cap("x") }], 
    g_V_localX_aggregateXa_byXnameXX_out_capXaX: [function({g}) { return g.V().local(__.aggregate("a").by("name")).out().cap("a") }], 
    g_VX1X_localXaggregateXaX_byXnameXX_out_localXaggregateXaX_byXnameXX_name_capXaX: [function({g, vid1}) { return g.V(vid1).local(__.aggregate("a").by("name")).out().local(__.aggregate("a").by("name")).values("name").cap("a") }], 
    g_withSideEffectXa_setX_V_both_name_localXaggregateX_aXX_capXaX: [function({g}) { return g.V().both().values("name").local(__.aggregate("a")).cap("a") }], 
    g_withSideEffectXa_set_inlineX_V_both_name_localXaggregateXaXX_capXaX: [function({g}) { return g.withSideEffect("a", new Set(["alice"])).V().both().values("name").local(__.aggregate("a")).cap("a") }], 
    g_V_localXaggregateXaX_byXoutEXcreatedX_countXX_out_out_localXaggregateXaX_byXinEXcreatedX_weight_sumXX_capXaX: [function({g}) { return g.V().local(__.aggregate("a").by(__.outE("created").count())).out().out().local(__.aggregate("a").by(__.inE("created").values("weight").sum())).cap("a") }], 
    g_V_aggregateXxX_byXvaluesXageX_isXgtX29XXX_capXxX: [function({g}) { return g.V().aggregate("x").by(__.values("age").is(P.gt(29))).cap("x") }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXxX_byXvaluesXageX_isXgtX29XXX_capXxX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("x").by(__.values("age").is(P.gt(29))).cap("x") }], 
    g_V_aggregateXxX_byXout_order_byXnameXX_capXxX: [function({g}) { return g.V().aggregate("x").by(__.out().order().by("name")).cap("x") }], 
    g_withStrategiesXProductiveByStrategyX_V_aggregateXxX_byXout_order_byXnameXX_capXxX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().aggregate("x").by(__.out().order().by("name")).cap("x") }], 
    g_V_aggregateXaX_hasXperson_age_gteX30XXX_capXaX_unfold_valuesXnameX: [function({g}) { return g.V().aggregate("a").has("person", "age", P.gte(30)).cap("a").unfold().values("name") }], 
    g_withSideEffectXa_1_sumX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", 1, Operator.sum).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_1_sumX_V_localXaggregateX_aX_byXageXX_capXaX: [function({g}) { return g.withSideEffect("a", 1, Operator.sum).V().local(__.aggregate("a").by("age")).cap("a") }], 
    g_withSideEffectXa_123_minusX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", 123, Operator.minus).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_123_minusX_V_localXaggregateX_aX_byXageXX_capXaX: [function({g}) { return g.withSideEffect("a", 123, Operator.minus).V().local(__.aggregate("a").by("age")).cap("a") }], 
    g_withSideEffectXa_2_multX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", 2, Operator.mult).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_2_multX_V_localXaggregateX_aX_byXageXX_capXaX: [function({g}) { return g.withSideEffect("a", 2, Operator.mult).V().local(__.aggregate("a").by("age")).cap("a") }], 
    g_withSideEffectXa_876960_divX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", 876960, Operator.div).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_876960_divX_V_localXaggregateX_aX_byXageXX_capXaX: [function({g}) { return g.withSideEffect("a", 876960, Operator.div).V().local(__.aggregate("a").by("age")).cap("a") }], 
    g_withSideEffectXa_1_minX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", 1, Operator.min).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_1_minX_V_localXaggregateX_aX_byXageXX_capXaX: [function({g}) { return g.withSideEffect("a", 1, Operator.min).V().local(__.aggregate("a").by("age")).cap("a") }], 
    g_withSideEffectXa_100_minX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", 100, Operator.min).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_100_minX_V_localXaggregateX_aX_byXageXX_capXaX: [function({g}) { return g.withSideEffect("a", 100, Operator.min).V().local(__.aggregate("a").by("age")).cap("a") }], 
    g_withSideEffectXa_1_maxX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", 1, Operator.max).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_1_maxX_V_localXaggregateX_aX_byXageXX_capXaX: [function({g}) { return g.withSideEffect("a", 1, Operator.max).V().local(__.aggregate("a").by("age")).cap("a") }], 
    g_withSideEffectXa_100_maxX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", 100, Operator.max).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_100_maxX_V_localXaggregateX_aX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", 100, Operator.max).V().local(__.aggregate("a").by("age")).cap("a") }], 
    g_withSideEffectXa_true_andX_V_constantXfalseX_aggregateXaX_capXaX: [function({g}) { return g.withSideEffect("a", true, Operator.and).V().constant(false).aggregate("a").cap("a") }], 
    g_withSideEffectXa_true_andX_V_constantXfalseX_localXaggregateX_aXX_capXaX: [function({g}) { return g.withSideEffect("a", true, Operator.and).V().constant(false).local(__.aggregate("a")).cap("a") }], 
    g_withSideEffectXa_true_orX_V_constantXfalseX_aggregateXaX_capXaX: [function({g}) { return g.withSideEffect("a", true, Operator.or).V().constant(false).aggregate("a").cap("a") }], 
    g_withSideEffectXa_true_orX_V_constantXfalseX_localXaggregateX_aXX_capXaX: [function({g}) { return g.withSideEffect("a", true, Operator.or).V().constant(false).local(__.aggregate("a")).cap("a") }], 
    g_withSideEffectXa_1_2_3_addAllX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", [1, 2, 3], Operator.addAll).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_1_2_3_addAllX_V_localXaggregateX_aX_byXageXX_capXaX: [function({g}) { return g.withSideEffect("a", [1, 2, 3], Operator.addAll).V().local(__.aggregate("a").by("age")).cap("a") }], 
    g_withSideEffectXa_1_2_3_assignX_V_aggregateXaX_byXageX_capXaX: [function({g}) { return g.withSideEffect("a", [1, 2, 3], Operator.assign).V().aggregate("a").by("age").cap("a") }], 
    g_withSideEffectXa_1_2_3_assignX_V_order_byXageX_localXaggregateX_aX_byXageXX_capXaX: [function({g}) { return g.withSideEffect("a", [1, 2, 3], Operator.assign).V().order().by("age").local(__.aggregate("a").by("age")).cap("a") }], 
    g_V_localXaggregateXa_nameXX_out_capXaX: [function({g}) { return g.V().local(__.aggregate("a").by("name")).out().cap("a") }], 
    g_withSideEffectXa_setX_V_both_name_localXaggregateXaXX_capXaX: [function({g}) { return g.V().both().values("name").local(__.aggregate("a")).cap("a") }], 
    g_V_localXaggregateXaXX_outE_inV_localXaggregateXaXX_capXaX_unfold_dedup: [function({g}) { return g.V().local(__.aggregate("a")).outE().inV().local(__.aggregate("a")).cap("a").unfold().dedup() }], 
    g_V_hasLabelXpersonX_localXaggregateXaXX_outXcreatedX_localXaggregateXaXX_capXaX: [function({g}) { return g.V().hasLabel("person").local(__.aggregate("a")).out("created").local(__.aggregate("a")).cap("a") }], 
    g_V_localXaggregateXaXX_repeatXout_localXaggregateXaXXX_timesX2X_capXaX_unfold_groupCount: [function({g}) { return g.V().local(__.aggregate("a")).repeat(__.out().local(__.aggregate("a"))).times(2).cap("a").unfold().values("name").groupCount() }], 
    g_V_hasXname_markoX_localXaggregateXaXX_outXknowsX_localXaggregateXaXX_outXcreatedX_localXaggregateXaXX_capXaX: [function({g}) { return g.V().has("name", "marko").local(__.aggregate("a")).out("knows").local(__.aggregate("a")).out("created").local(__.aggregate("a")).cap("a") }], 
    g_V_hasLabelXsoftwareX_localXaggregateXaXX_inXcreatedX_localXaggregateXaXX_outXknowsX_localXaggregateXaXX_capXaX: [function({g}) { return g.V().hasLabel("software").local(__.aggregate("a")).in_("created").local(__.aggregate("a")).out("knows").local(__.aggregate("a")).cap("a") }], 
    g_V_localXaggregateXaXX_outE_hasXweight_lgtX0_5XX_inV_localXaggregateXaXX_capXaX_unfold_path: [function({g}) { return g.V().local(__.aggregate("a")).outE().has("weight", P.gt(0.5)).inV().local(__.aggregate("a")).cap("a").unfold().path() }], 
    g_V_localXaggregateXaXX_bothE_sampleX1X_otherV_localXaggregateXaXX_capXaX_unfold_groupCount_byXlabelX: [function({g}) { return g.V().local(__.aggregate("a")).bothE().sample(1).otherV().local(__.aggregate("a")).cap("a").unfold().groupCount().by(T.label) }], 
    g_V_hasLabelXpersonX_localXaggregateXaXX_outE_inV_simplePath_localXaggregateXaXX_capXaX_unfold_hasLabelXsoftwareX_count: [function({g}) { return g.V().hasLabel("person").local(__.aggregate("a")).outE().inV().simplePath().local(__.aggregate("a")).cap("a").unfold().hasLabel("software").count() }], 
    g_V_localXaggregateXaXX_unionXout_inX_localXaggregateXaXX_capXaX_unfold_dedup_valuesXnameX: [function({g}) { return g.V().local(__.aggregate("a")).union(__.out(), __.in_()).local(__.aggregate("a")).cap("a").unfold().dedup().values("name") }], 
    g_V_hasXname_joshX_localXaggregateXaXX_outE_hasXweight_ltX1_0XX_inV_localXaggregateXaXX_outE_inV_localXaggregateXaXX_capXaX: [function({g}) { return g.V().has("name", "josh").local(__.aggregate("a")).outE().has("weight", P.lt(1.0)).inV().local(__.aggregate("a")).outE().inV().local(__.aggregate("a")).cap("a") }], 
    g_V_hasLabelXpersonX_localXaggregateXaXX_outE_order_byXweightX_limitX1X_inV_localXaggregateXaXX_capXaX: [function({g}) { return g.V().hasLabel("person").local(__.aggregate("a")).outE().order().by("weight").limit(1).inV().local(__.aggregate("a")).cap("a") }], 
    g_V_fail: [function({g}) { return g.V().fail() }], 
    g_V_failXmsgX: [function({g}) { return g.V().fail("msg") }], 
    g_V_unionXout_failX: [function({g}) { return g.V().union(__.out(), __.fail()) }], 
    g_V_group_byXnameX: [function({g}) { return g.V().group().by("name") }], 
    g_V_group_byXageX: [function({g}) { return g.V().group().by("age") }], 
    g_withStrategiesXProductiveByStrategyX_V_group_byXageX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().group().by("age") }], 
    g_V_group_byXnameX_byXageX: [function({g}) { return g.V().group().by("name").by("age") }], 
    g_V_group_byXnameX_by: [function({g}) { return g.V().group().by("name").by() }], 
    g_V_hasXlangX_group_byXlangX_byXcountX: [function({g}) { return g.V().has("lang").group().by("lang").by(__.count()) }], 
    g_V_group_byXoutE_countX_byXnameX: [function({g}) { return g.V().order().by("name").group().by(__.outE().count()).by("name") }], 
    g_V_repeatXbothXfollowedByXX_timesX2X_group_byXsongTypeX_byXcountX: [function({g}) { return g.V().repeat(__.both("followedBy")).times(2).group().by("songType").by(__.count()) }], 
    g_V_group_byXvaluesXnameX_substringX1XX_byXconstantX1XX: [function({g}) { return g.V().group().by(__.values("name").substring(0, 1)).by(__.constant(1)) }], 
    g_V_out_group_byXlabelX_selectXpersonX_unfold_outXcreatedX_name_limitX2X: [function({g}) { return g.V().out().group().by(T.label).select("person").unfold().out("created").values("name").limit(2) }], 
    g_V_hasLabelXsongX_group_byXnameX_byXproperties_groupCount_byXlabelXX: [function({g}) { return g.V().hasLabel("song").group().by("name").by(__.properties().groupCount().by(T.label)) }], 
    g_V_outXfollowedByX_group_byXsongTypeX_byXbothE_group_byXlabelX_byXweight_sumXX: [function({g}) { return g.V().out("followedBy").group().by("songType").by(__.bothE().group().by(T.label).by(__.values("weight").sum())) }], 
    g_V_group_byXlabelX_byXbothE_groupXaX_byXlabelX_byXweight_sumX_weight_sumX: [function({g}) { return g.V().group().by(T.label).by(__.bothE().group("a").by(T.label).by(__.values("weight").sum()).values("weight").sum()) }], 
    g_V_hasLabelXpersonX_asXpX_outXcreatedX_group_byXnameX_byXselectXpX_valuesXageX_sumX: [function({g}) { return g.V().hasLabel("person").as("p").out("created").group().by("name").by(__.select("p").values("age").sum()) }], 
    g_V_group_byXlabelX_byXlabel_countX: [function({g}) { return g.V().group().by(__.label()).by(__.label().count()) }], 
    g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_order_foldX: [function({g}) { return g.V().has("person", "name", P.within("vadas", "peter")).group().by().by(__.out().order().fold()) }], 
    g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_foldX: [function({g}) { return g.V().has("person", "name", P.within("vadas", "peter")).group().by().by(__.out().fold()) }], 
    g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_orderX: [function({g}) { return g.V().has("person", "name", P.within("vadas", "peter")).group().by().by(__.out().order()) }], 
    g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_order_countX: [function({g}) { return g.V().has("person", "name", P.within("vadas", "peter")).group().by().by(__.out().order().count()) }], 
    g_V_hasXperson_name_withinXvadas_peterXX_group_by_byXout_order_fold_countXlocalXX: [function({g}) { return g.V().has("person", "name", P.within("vadas", "peter")).group().by().by(__.out().order().fold().count(Scope.local)) }], 
    g_V_group_by_byXout_label_foldX_selectXvaluesX_unfold_orderXlocalX: [function({g}) { return g.V().group().by().by(__.out().label().fold()).select(Column.values).unfold().order(Scope.local) }], 
    g_V_group_by_byXout_label_dedup_foldX_selectXvaluesX_unfold_orderXlocalX: [function({g}) { return g.V().group().by().by(__.out().label().dedup().fold()).select(Column.values).unfold().order(Scope.local) }], 
    g_V_group_by_byXout_label_limitX0X_foldX_selectXvaluesX_unfold: [function({g}) { return g.V().group().by().by(__.out().label().limit(0).fold()).select(Column.values).unfold() }], 
    g_V_group_by_byXout_label_limitX10X_foldX_selectXvaluesX_unfold_orderXlocalX: [function({g}) { return g.V().group().by().by(__.out().label().limit(10).fold()).select(Column.values).unfold().order(Scope.local) }], 
    g_V_group_by_byXout_label_tailX10X_foldX_selectXvaluesX_unfold_orderXlocalX: [function({g}) { return g.V().group().by().by(__.out().label().tail(10).fold()).select(Column.values).unfold().order(Scope.local) }], 
    g_V_groupXaX_byXnameX_by_selectXaX_countXlocalX: [function({g}) { return g.V().group("a").by("name").by().select("a").count(Scope.local) }], 
    g_V_localXgroupXaX_byXnameX_by_selectXaX_countXlocalXX: [function({g}) { return g.V().local(__.group("a").by("name").by().select("a").count(Scope.local)) }], 
    g_V_group_byXvaluesXnameXX_byXboth_countX: [function({g}) { return g.V().group().by(__.values("name")).by(__.both().count()) }], 
    g_V_outXcreatedX_groupCount_byXnameX: [function({g}) { return g.V().out("created").groupCount().by("name") }], 
    g_V_groupCount_byXageX: [function({g}) { return g.V().groupCount().by("age") }], 
    g_withStrategiesXProductiveByStrategyX_V_groupCount_byXageX: [function({g}) { return g.withStrategies(new ProductiveByStrategy()).V().groupCount().by("age") }], 
    g_V_outXcreatedX_name_groupCount: [function({g}) { return g.V().out("created").values("name").groupCount() }], 
    g_V_outXcreatedX_groupCountXaX_byXnameX_capXaX: [function({g}) { return g.V().out("created").groupCount("a").by("name").cap("a") }], 
    g_V_outXcreatedX_name_groupCountXaX_capXaX: [function({g}) { return g.V().out("created").values("name").groupCount("a").cap("a") }], 
    g_V_repeatXout_groupCountXaX_byXnameXX_timesX2X_capXaX: [function({g}) { return g.V().repeat(__.out().groupCount("a").by("name")).times(2).cap("a") }], 
    g_V_both_groupCountXaX_byXlabelX_asXbX_barrier_whereXselectXaX_selectXsoftwareX_isXgtX2XXX_selectXbX_name: [function({g}) { return g.V().both().groupCount("a").by(T.label).as("b").barrier().where(__.select("a").select("software").is(P.gt(2))).select("b").values("name") }], 
    g_V_unionXoutXknowsX__outXcreatedX_inXcreatedXX_groupCount_selectXvaluesX_unfold_sum: [function({g}) { return g.V().union(__.out("knows"), __.out("created").in_("created")).groupCount().select(Column.values).unfold().sum() }], 
    g_V_hasXnoX_groupCount: [function({g}) { return g.V().has("no").groupCount() }], 
    g_V_hasXnoX_groupCountXaX_capXaX: [function({g}) { return g.V().has("no").groupCount("a").cap("a") }], 
    g_V_unionXrepeatXoutX_timesX2X_groupCountXmX_byXlangXX__repeatXinX_timesX2X_groupCountXmX_byXnameXX_capXmX: [function({g}) { return g.V().union(__.repeat(__.out()).times(2).groupCount("m").by("lang"), __.repeat(__.in_()).times(2).groupCount("m").by("name")).cap("m") }], 
    g_V_outXcreatedX_groupCountXxX_capXxX: [function({g}) { return g.V().out("created").groupCount("x").cap("x") }], 
    g_V_groupCount_byXbothE_countX: [function({g}) { return g.V().groupCount().by(__.bothE().count()) }], 
    g_V_both_localXgroupCountXaXX_out_capXaX_selectXkeysX_unfold_both_localXgroupCountXaXX_capXaX: [function({g}) { return g.V().both().local(__.groupCount("a")).out().cap("a").select(Column.keys).unfold().both().local(__.groupCount("a")).cap("a") }], 
    g_V_hasXperson_name_markoX_bothXknowsX_groupCount_byXvaluesXnameX_foldX: [function({g}) { return g.V().has("person", "name", "marko").both("knows").groupCount().by(__.values("name").fold()) }], 
    g_V_outXcreatedX_groupCount_byXnameX_byXageX: [function({g}) { return g.V().out("created").groupCount().by("name").by("age") }], 
    g_V_outXcreatedX_groupCountXxX_byXnameX_byXageX: [function({g}) { return g.V().out("created").groupCount("x").by("name").by("age") }], 
    g_V_groupCountXaX_selectXaX_countXlocalX: [function({g}) { return g.V().groupCount("a").select("a").count(Scope.local) }], 
    g_V_localXgroupCountXaX_selectXaX_countXlocalXX: [function({g}) { return g.V().local(__.groupCount("a").select("a").count(Scope.local)) }], 
    g_VX1X_out_name_injectXdanielX_asXaX_mapXlengthX_path: [function({g, vid1}) { return g.V(vid1).out().values("name").inject("daniel").as("a").map(__.length()).path() }], 
    g_injectXnull_1_3_nullX: [function({g}) { return g.inject(null, 1, 3, null) }], 
    g_injectX10_20_null_20_10_10X_groupCountXxX_dedup_asXyX_projectXa_bX_by_byXselectXxX_selectXselectXyXXX: [function({g}) { return g.inject(10, 20, null, 20, 10, 10).groupCount("x").dedup().as("y").project("a", "b").by().by(__.select("x").select(__.select("y"))) }], 
    g_injectXname_marko_age_nullX_selectXname_ageX: [function({g}) { return g.inject(new Map([["name", "marko"], ["age", null]])).select("name", "age") }], 
    g_injectXnull_nullX: [function({g}) { return g.inject(null, null) }], 
    g_injectXnullX: [function({g}) { return g.inject(null) }], 
    g_inject: [function({g}) { return g.inject() }], 
    g_VX1X_valuesXageX_injectXnull_nullX: [function({g, xx1}) { return g.V(xx1).values("age").inject(null, null) }], 
    g_VX1X_valuesXageX_injectXnullX: [function({g, xx1}) { return g.V(xx1).values("age").inject(null) }], 
    g_VX1X_valuesXageX_inject: [function({g, xx1}) { return g.V(xx1).values("age").inject() }], 
    g_injectXnull_1_3_nullX_asXaX_selectXaX: [function({g}) { return g.inject(null, 1, 3, null).as("a").select("a") }], 
    g_injectX1_3X_injectX100_300X: [function({g}) { return g.inject(1, 3).inject(100, 300) }], 
    g_injectX1_3_100_300X_list: [function({g}) { return g.inject([1, 3, 100, 300]) }], 
    g_injectX1_3_100_300X_set: [function({g}) { return g.inject(new Set([1, 3, 100, 300])) }], 
    g_injectX1_1X_set: [function({g}) { return g.inject(new Set([1, 1])) }], 
    g_io_readXkryoX: [function({g}) { return g.io("data/tinkerpop-modern.kryo").read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_read_withXreader_gryoX: [function({g}) { return g.io("data/tinkerpop-modern.kryo").with_(IO.reader, IO.gryo).read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_readXgraphsonX: [function({g}) { return g.io("data/tinkerpop-modern.json").read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_read_withXreader_graphsonX: [function({g}) { return g.io("data/tinkerpop-modern.json").with_(IO.reader, IO.graphson).read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_readXgraphmlX: [function({g}) { return g.io("data/tinkerpop-modern.xml").read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_io_read_withXreader_graphmlX: [function({g}) { return g.io("data/tinkerpop-modern.xml").with_(IO.reader, IO.graphml).read() }, function({g}) { return g.V() }, function({g}) { return g.E() }], 
    g_withSackX127bX_injectX1bX_sackXsumX_sack: [function({g}) { return g.withSack(127).inject(1).sack(Operator.sum).sack() }], 
    g_withSackX32767sX_injectX1sX_sackXsumX_sack: [function({g}) { return g.withSack(32767).inject(1).sack(Operator.sum).sack() }], 
    g_withSackX2147483647iX_injectX1iX_sackXsumX_sack: [function({g}) { return g.withSack(2147483647).inject(1).sack(Operator.sum).sack() }], 
    g_withSackX1_7976931348623157E_308dX_injectX1_7976931348623157E_308dX_sackXsumX_sack: [function({g}) { return g.withSack(1.7976931348623157e+308).inject(1.7976931348623157e+308).sack(Operator.sum).sack() }], 
    g_withSackX_128bX_injectX1bX_sackXminusX_sack: [function({g}) { return g.withSack(-128).inject(1).sack(Operator.minus).sack() }], 
    g_withSackX_32768sX_injectX1sX_sackXminusX_sack: [function({g}) { return g.withSack(-32768).inject(1).sack(Operator.minus).sack() }], 
    g_withSackX_2147483648iX_injectX1iX_sackXminusX_sack: [function({g}) { return g.withSack(-2147483648).inject(1).sack(Operator.minus).sack() }], 
    g_withSackX_1_7976931348623157E_308dX_injectX1_7976931348623157E_308dX_sackXminusX_sack: [function({g}) { return g.withSack(-1.7976931348623157e+308).inject(1.7976931348623157e+308).sack(Operator.minus).sack() }], 
    g_withSackX127bX_injectX2bX_sackXmultX_sack: [function({g}) { return g.withSack(127).inject(2).sack(Operator.mult).sack() }], 
    g_withSackX32767sX_injectX2sX_sackXmultX_sack: [function({g}) { return g.withSack(32767).inject(2).sack(Operator.mult).sack() }], 
    g_withSackX2147483647iX_injectX2iX_sackXmultX_sack: [function({g}) { return g.withSack(2147483647).inject(2).sack(Operator.mult).sack() }], 
    g_withSackX1_7976931348623157E_308dX_injectX2dX_sackXmultX_sack: [function({g}) { return g.withSack(1.7976931348623157e+308).inject(2).sack(Operator.mult).sack() }], 
    g_withSackX127bX_injectX0_5fX_sackXdivX_sack: [function({g}) { return g.withSack(127).inject(0.5).sack(Operator.div).sack() }], 
    g_withSackX32767sX_injectX0_5fX_sackXdivX_sack: [function({g}) { return g.withSack(32767).inject(0.5).sack(Operator.div).sack() }], 
    g_withSackX2147483647iX_injectX0_5fX_sackXdivX_sack: [function({g}) { return g.withSack(2147483647).inject(0.5).sack(Operator.div).sack() }], 
    g_withSackX1_7976931348623157E_308dX_injectX0_5dX_sackXdivX_sack: [function({g}) { return g.withSack(1.7976931348623157e+308).inject(0.5).sack(Operator.div).sack() }], 
    g_withSackX_128bX_injectX_1bX_sackXdivX_sack: [function({g}) { return g.withSack(-128).inject(-1).sack(Operator.div).sack() }], 
    g_withSackX_32768sX_injectX_1sX_sackXdivX_sack: [function({g}) { return g.withSack(-32768).inject(-1).sack(Operator.div).sack() }], 
    g_withSackX_2147483648iX_injectX_1iX_sackXdivX_sack: [function({g}) { return g.withSack(-2147483648).inject(-1).sack(Operator.div).sack() }], 
    g_withSackXhelloX_V_outE_sackXassignX_byXlabelX_inV_sack: [function({g}) { return g.withSack("hello").V().outE().sack(Operator.assign).by(T.label).inV().sack() }], 
    g_withSackX0X_V_outE_sackXsumX_byXweightX_inV_sack_sum: [function({g}) { return g.withSack(0.0).V().outE().sack(Operator.sum).by("weight").inV().sack().sum() }], 
    g_withSackX0X_V_repeatXoutE_sackXsumX_byXweightX_inVX_timesX2X_sack: [function({g}) { return g.withSack(0.0).V().repeat(__.outE().sack(Operator.sum).by("weight").inV()).times(2).sack() }], 
    g_withBulkXfalseX_withSackX1_sumX_VX1X_localXoutEXknowsX_barrierXnormSackX_inVX_inXknowsX_barrier_sack: [function({g, vid1}) { return g.withBulk(false).withSack(1.0, Operator.sum).V(vid1).local(__.outE("knows").barrier(Barrier.normSack).inV()).in_("knows").barrier().sack() }], 
    g_withBulkXfalseX_withSackX1_sumX_V_out_barrier_sack: [function({g}) { return g.withBulk(false).withSack(1, Operator.sum).V().out().barrier().sack() }], 
    g_withSackX1_sumX_VX1X_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack: [function({g, vid1}) { return g.withSack(1.0, Operator.sum).V(vid1).local(__.out("knows").barrier(Barrier.normSack)).in_("knows").barrier().sack() }], 
    g_V_sackXassignX_byXageX_sack: [function({g}) { return g.V().sack(Operator.assign).by("age").sack() }], 
    g_withSackXBigInteger_TEN_powX1000X_assignX_V_localXoutXknowsX_barrierXnormSackXX_inXknowsX_barrier_sack: [function({g}) { return g.withSack(10000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000, Operator.assign).V().local(__.out("knows").barrier(Barrier.normSack)).in_("knows").barrier().sack() }], 
    g_withSackX2X_V_sackXdivX_byXconstantX4_0XX_sack: [function({g}) { return g.withSack(2).V().sack(Operator.div).by(__.constant(4.0)).sack() }], 
    g_V_sackXassignX_byXageX_byXnameX_sack: [function({g}) { return g.V().sack(Operator.assign).by("age").by("name").sack() }], 
    g_V_sideEffectXidentityX: [function({g}) { return g.V().sideEffect(__.identity()) }], 
    g_V_sideEffectXidentity_valuesXnameXX: [function({g}) { return g.V().sideEffect(__.identity().values("name")) }], 
    g_V_sideEffectXpropertyXage_22X: [function({g}) { return g.addV("person").property("age", 21) }, function({g}) { return g.V().sideEffect(__.property("age", 22)) }, function({g}) { return g.V().has("age", 21) }, function({g}) { return g.V().has("age", 22) }], 
    g_V_group_byXvaluesXnameX_sideEffectXconstantXzyxXX_substringX1XX_byXconstantX1X_sideEffectXconstantXxyzXXX: [function({g}) { return g.V().group().by(__.values("name").sideEffect(__.constant("zyx")).substring(0, 1)).by(__.constant(1).sideEffect(__.constant("xyz"))) }], 
    g_withSideEffectXx_setX_V_both_both_sideEffectXlocalXaggregateXxX_byXnameXX_capXxX_unfold: [function({g}) { return g.withSideEffect("x", new Set([])).V().both().both().sideEffect(__.local(__.aggregate("x").by("name"))).cap("x").unfold() }], 
    g_V_hasXageX_groupCountXaX_byXnameX_out_capXaX: [function({g}) { return g.V().has("age").groupCount("a").by("name").out().cap("a") }], 
    g_V_groupXaX_byXageX_capXaX: [function({g}) { return g.V().group("a").by("age").cap("a") }], 
    g_V_groupXaX_byXnameX_capXaX: [function({g}) { return g.V().group("a").by("name").cap("a") }], 
    g_V_hasXlangX_groupXaX_byXlangX_byXnameX_out_capXaX: [function({g}) { return g.V().has("lang").group("a").by("lang").by("name").out().cap("a") }], 
    g_V_repeatXout_groupXaX_byXnameX_byXcountX_timesX2X_capXaX: [function({g}) { return g.V().repeat(__.out().group("a").by("name").by(__.count())).times(2).cap("a") }], 
    g_V_groupXaX_byXlabelX_byXoutE_weight_sumX_capXaX: [function({g}) { return g.V().group("a").by(T.label).by(__.outE().values("weight").sum()).cap("a") }], 
    g_V_repeatXbothXfollowedByXX_timesX2X_groupXaX_byXsongTypeX_byXcountX_capXaX: [function({g}) { return g.V().repeat(__.both("followedBy")).times(2).group("a").by("songType").by(__.count()).cap("a") }], 
    g_V_groupXaX_byXvaluesXnameX_substringX1XX_byXconstantX1XX_capXaX: [function({g}) { return g.V().group("a").by(__.values("name").substring(0, 1)).by(__.constant(1)).cap("a") }], 
    g_V_hasLabelXsongX_groupXaX_byXnameX_byXproperties_groupCount_byXlabelXX_out_capXaX: [function({g}) { return g.V().hasLabel("song").group("a").by("name").by(__.properties().groupCount().by(T.label)).out().cap("a") }], 
    g_V_hasLabelXpersonX_asXpX_outXcreatedX_groupXaX_byXnameX_byXselectXpX_valuesXageX_sumX_capXaX: [function({g}) { return g.V().hasLabel("person").as("p").out("created").group("a").by("name").by(__.select("p").values("age").sum()).cap("a") }], 
    g_V_groupXmX_byXnameX_byXinXknowsX_nameX_capXmX: [function({g}) { return g.V().group("m").by("name").by(__.in_("knows").values("name")).cap("m") }], 
    g_V_groupXmX_byXlabelX_byXlabel_countX_capXmX: [function({g}) { return g.V().group("m").by(__.label()).by(__.label().count()).cap("m") }], 
    g_V_chooseXlabel_person__age_groupCountXaX__name_groupCountXbXX_capXa_bX_unfold: [function({g}) { return g.V().choose(__.has(T.label, "person"), __.values("age").groupCount("a"), __.values("name").groupCount("b")).cap("a", "b").unfold() }], 
    g_V_hasXperson_name_withinXvadas_peterXX_groupXaX_by_byXout_orderX_capXaX: [function({g}) { return g.V().has("person", "name", P.within("vadas", "peter")).group("a").by().by(__.out().order()).cap("a") }], 
    g_V_hasXperson_name_withinXvadas_peterXX_groupXaX_by_byXout_order_countX_capXaX: [function({g}) { return g.V().has("person", "name", P.within("vadas", "peter")).group("a").by().by(__.out().order().count()).cap("a") }], 
    g_V_hasXperson_name_withinXvadas_peterXX_groupXaX_by_byXout_order_fold_countXlocalXX_capXaX: [function({g}) { return g.V().has("person", "name", P.within("vadas", "peter")).group("a").by().by(__.out().order().fold().count(Scope.local)).cap("a") }], 
    g_V_groupXaX_by_byXout_label_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX: [function({g}) { return g.V().group("a").by().by(__.out().label().fold()).cap("a").select(Column.values).unfold().order(Scope.local) }], 
    g_V_groupXaX_by_byXout_label_dedup_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX: [function({g}) { return g.V().group("a").by().by(__.out().label().dedup().fold()).cap("a").select(Column.values).unfold().order(Scope.local) }], 
    g_V_groupXaX_by_byXout_label_limitX0X_foldX_capXaX_selectXvaluesX_unfold: [function({g}) { return g.V().group("a").by().by(__.out().label().limit(0).fold()).cap("a").select(Column.values).unfold() }], 
    g_V_groupXaX_by_byXout_label_limitX10X_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX: [function({g}) { return g.V().group("a").by().by(__.out().label().limit(10).fold()).cap("a").select(Column.values).unfold().order(Scope.local) }], 
    g_V_groupXaX_by_byXout_label_tailX10X_foldX_capXaX_selectXvaluesX_unfold_orderXlocalX: [function({g}) { return g.V().group("a").by().by(__.out().label().tail(10).fold()).cap("a").select(Column.values).unfold().order(Scope.local) }], 
    g_VX1X_outEXknowsX_subgraphXsgX_name_capXsgX: [function({g, vid1}) { return g.V(vid1).outE("knows").subgraph("sg").values("name").cap("sg") }], 
    g_V_repeatXbothEXcreatedX_subgraphXsgX_outVX_timesX5X_name_dedup_capXsgX: [function({g}) { return g.V().repeat(__.bothE("created").subgraph("sg").outV()).times(5).values("name").dedup().cap("sg") }], 
    g_V_outEXnoexistX_subgraphXsgXcapXsgX: [function({g}) { return g.V().outE("noexist").subgraph("sg").cap("sg") }], 
    g_E_hasXweight_0_5X_subgraphXaX_selectXaX: [function({g}) { return g.E().has("weight", 0.4).subgraph("a").select("a") }], 
    g_VX1X_out_out_tree_byXnameX: [function({g, vid1}) { return g.V(vid1).out().out().tree().by("name") }], 
    g_VX1X_out_out_tree: [function({g, vid1}) { return g.V(vid1).out().out().tree() }], 
    g_V_out_tree_byXageX: [function({g}) { return g.V().out().tree().by("age") }], 
    g_VX1X_out_out_treeXaX_byXnameX_both_both_capXaX: [function({g, vid1}) { return g.V(vid1).out().out().tree("a").by("name").both().both().cap("a") }], 
    g_VX1X_out_out_treeXaX_both_both_capXaX: [function({g, vid1}) { return g.V(vid1).out().out().tree("a").both().both().cap("a") }], 
    g_VX1X_out_out_tree_byXlabelX: [function({g, vid1}) { return g.V(vid1).out().out().tree().by(T.label) }], 
    g_VX1X_out_out_treeXaX_byXlabelX_both_both_capXaX: [function({g, vid1}) { return g.V(vid1).out().out().tree("a").by(T.label).both().both().cap("a") }], 
    g_VX1X_out_out_out_tree: [function({g}) { return g.V().out().out().out().tree() }], 
    g_VX1X_outE_inV_bothE_otherV_tree: [function({g, vid1}) { return g.V(vid1).outE().inV().bothE().otherV().tree() }], 
    g_VX1X_outE_inV_bothE_otherV_tree_byXnameX_byXlabelX: [function({g, vid1}) { return g.V(vid1).outE().inV().bothE().otherV().tree().by("name").by(T.label) }], 
    g_V_out_treeXaX_selectXaX_countXlocalX: [function({g}) { return g.V().out().tree("a").select("a").count(Scope.local) }], 
    g_V_out_order_byXnameX_localXtreeXaX_selectXaX_countXlocalXX: [function({g}) { return g.V().out().local(__.tree("a").select("a").count(Scope.local)) }], 
}

exports.gremlin = gremlins
