/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyAdaptablesExtender {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyAdaptablesExtender.class);

    public static Class<?>[] getAdaptables(Model modelAnnotation) {
        Class[] adaptables;
        boolean hasJakartaServletRequest = false;
        boolean hasJavaxServletRequest = false;
        for (Class adaptable : adaptables = modelAnnotation.adaptables()) {
            if (adaptable == SlingJakartaHttpServletRequest.class) {
                hasJakartaServletRequest = true;
                continue;
            }
            if (adaptable != SlingHttpServletRequest.class) continue;
            hasJavaxServletRequest = true;
        }
        if (hasJavaxServletRequest && !hasJakartaServletRequest) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Model {} adapts from {} but not from {}. Adjusting list to compensate.", new Object[]{modelAnnotation, SlingJakartaHttpServletRequest.class.getName(), SlingHttpServletRequest.class.getName()});
            }
            Class[] newAdaptables = new Class[adaptables.length + 1];
            System.arraycopy(adaptables, 0, newAdaptables, 0, adaptables.length);
            newAdaptables[adaptables.length] = SlingJakartaHttpServletRequest.class;
            return newAdaptables;
        }
        return adaptables;
    }

    private LegacyAdaptablesExtender() {
    }
}

