/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.models.it.testbundle.models.SelfModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DecoratedIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private ModelFactory modelFactory;
    private ResourceResolver resolver;
    private Resource resourceWithDefaultWrapperBehavior;
    private Resource resourceWithCustomAdaptToWrapper;

    @Before
    public void setUp() throws Exception {
        ResourceResolverFactory rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        this.modelFactory = (ModelFactory)this.teleporter.getService(ModelFactory.class);
        this.resolver = rrFactory.getServiceResourceResolver(null);
        Session session = (Session)this.resolver.adaptTo(Session.class);
        Node rootNode = session.getRootNode();
        Node createdNode = rootNode.addNode("test_" + RandomStringUtils.secure().nextAlphanumeric(10));
        createdNode.setProperty("decorate", true);
        session.save();
        this.resourceWithDefaultWrapperBehavior = this.resolver.getResource(createdNode.getPath());
        createdNode = rootNode.addNode("test_" + RandomStringUtils.secure().nextAlphanumeric(10));
        createdNode.setProperty("decorate", "customAdaptTo");
        session.save();
        this.resourceWithCustomAdaptToWrapper = this.resolver.getResource(createdNode.getPath());
    }

    @After
    public void tearDown() throws Exception {
        this.resolver.delete(this.resourceWithDefaultWrapperBehavior);
        this.resolver.delete(this.resourceWithCustomAdaptToWrapper);
        this.resolver.close();
    }

    @Test
    public void testInjectDecoratedResourceUsingCreateModel() {
        Assert.assertTrue((String)"Resource is not wrapped", (boolean)(this.resourceWithDefaultWrapperBehavior instanceof ResourceWrapper));
        SelfModel model = (SelfModel)this.modelFactory.createModel((Object)this.resourceWithDefaultWrapperBehavior, SelfModel.class);
        Assert.assertNotNull((String)"Model is null", (Object)model);
        Assert.assertTrue((String)"Model is not wrapped", (boolean)(model.getResource() instanceof ResourceWrapper));
    }

    @Test
    public void testInjectDecoratedResourceUsingAdaptTo() {
        Assert.assertTrue((String)"Resource is not wrapped", (boolean)(this.resourceWithCustomAdaptToWrapper instanceof ResourceWrapper));
        SelfModel model = (SelfModel)this.resourceWithCustomAdaptToWrapper.adaptTo(SelfModel.class);
        Assert.assertNotNull((String)"Model is null", (Object)model);
        Assert.assertTrue((String)"Model is not wrapped", (boolean)(model.getResource() instanceof ResourceWrapper));
    }
}

