/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.ServicePropertiesMap;
import org.apache.sling.models.impl.injectors.BindingsInjector;
import org.apache.sling.models.impl.injectors.ChildResourceInjector;
import org.apache.sling.models.impl.injectors.OSGiServiceInjector;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.impl.via.BeanPropertyViaProvider;
import org.apache.sling.models.spi.ViaProvider;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.apache.sling.models.testmodels.classes.OptionalObjectsModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;

@ExtendWith(value={MockitoExtension.class})
class OptionalObjectsTest {
    private ModelAdapterFactory factory;
    private OSGiServiceInjector osgiInjector;
    @Mock
    private BundleContext bundleContext;
    @Mock
    private SlingJakartaHttpServletRequest request;
    @Mock
    private Logger log;

    OptionalObjectsTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.osgiInjector = new OSGiServiceInjector();
        this.osgiInjector.activate(this.bundleContext);
        BindingsInjector bindingsInjector = new BindingsInjector();
        ValueMapInjector valueMapInjector = new ValueMapInjector();
        ChildResourceInjector childResourceInjector = new ChildResourceInjector();
        RequestAttributeInjector requestAttributeInjector = new RequestAttributeInjector();
        this.factory.injectors = Arrays.asList(bindingsInjector, valueMapInjector, childResourceInjector, requestAttributeInjector, this.osgiInjector);
        this.factory.bindStaticInjectAnnotationProcessorFactory((StaticInjectAnnotationProcessorFactory)bindingsInjector, (Map)new ServicePropertiesMap(1L, 0));
        this.factory.injectAnnotationProcessorFactories = Collections.singletonList(valueMapInjector);
        this.factory.injectAnnotationProcessorFactories2 = Collections.singletonList(childResourceInjector);
        this.factory.bindStaticInjectAnnotationProcessorFactory((StaticInjectAnnotationProcessorFactory)requestAttributeInjector, (Map)new ServicePropertiesMap(4L, 0));
        this.factory.bindStaticInjectAnnotationProcessorFactory((StaticInjectAnnotationProcessorFactory)this.osgiInjector, (Map)new ServicePropertiesMap(5L, 0));
        this.factory.bindViaProvider((ViaProvider)new BeanPropertyViaProvider(), null);
        SlingBindings bindings = new SlingBindings();
        bindings.setLog(this.log);
        Mockito.lenient().when(this.request.getAttribute(SlingBindings.class.getName())).thenReturn((Object)bindings);
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{OptionalObjectsModel.class});
    }

    @Test
    void testFieldInjectionClass() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("optionalString", "foo bar baz");
        map.put("optionalByte", Byte.valueOf("1"));
        map.put("optionalInteger", Integer.valueOf("1"));
        map.put("optionalShort", Short.valueOf("1"));
        map.put("optionalLong", Long.valueOf("1"));
        map.put("optionalShort", Short.valueOf("1"));
        map.put("optionalDouble", Double.valueOf("1"));
        map.put("optionalFloat", Float.valueOf("1"));
        map.put("optionalChar", Character.valueOf('1'));
        map.put("optionalBoolean", Boolean.valueOf("true"));
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)new ValueMapDecorator(map));
        OptionalObjectsModel model = (OptionalObjectsModel)this.factory.getAdapter((Object)res, OptionalObjectsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals(Optional.of("foo bar baz"), model.getOptionalString());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullString());
        Assertions.assertEquals(Optional.of(1), model.getOptionalInteger());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullInteger());
        Assertions.assertEquals(Optional.of(Byte.valueOf("1")), model.getOptionalByte());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullByte());
        Assertions.assertEquals(Optional.of(Long.valueOf("1")), model.getOptionalLong());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullLong());
        Assertions.assertEquals(Optional.of(Short.valueOf("1")), model.getOptionalShort());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullShort());
        Assertions.assertEquals(Optional.of(Double.valueOf("1")), model.getOptionalDouble());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullDouble());
        Assertions.assertEquals(Optional.of(Float.valueOf("1")), model.getOptionalFloat());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullFloat());
        Assertions.assertEquals(Optional.of(1L), model.getOptionalLong());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullLong());
        Assertions.assertEquals(Optional.of(Character.valueOf('1')), model.getOptionalChar());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullChar());
        Assertions.assertEquals(Optional.of(Boolean.valueOf("true")), model.getOptionalBoolean());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullBoolean());
    }

    @Test
    void testFieldInjectionListsAndArrays() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("intList", new Integer[]{1, 2, 9, 8});
        map.put("stringList", new String[]{"hello", "world"});
        map.put("optionalList", Arrays.asList("foo", "bar", "baz"));
        map.put("optionalArray", new String[]{"qux", "quux"});
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        OptionalObjectsModel model = (OptionalObjectsModel)this.factory.getAdapter((Object)res, OptionalObjectsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((int)4, (int)model.getIntList().get().size());
        Assertions.assertEquals((Integer)2, (Integer)model.getIntList().get().get(1));
        Assertions.assertEquals((int)2, (int)model.getStringList().get().size());
        Assertions.assertEquals((Object)"hello", (Object)model.getStringList().get().get(0));
        Assertions.assertEquals(Optional.of(Arrays.asList("foo", "bar", "baz")), model.getOptionalList());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullList());
        Assertions.assertTrue((boolean)model.getOptionalArray().isPresent());
        Assertions.assertTrue((boolean)"qux".equalsIgnoreCase(model.getOptionalArray().get()[0]));
        Assertions.assertTrue((boolean)"quux".equalsIgnoreCase(model.getOptionalArray().get()[1]));
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullArray());
    }

    @Test
    void testFieldInjectionsChildResource() {
        Resource res = (Resource)Mockito.mock(Resource.class);
        Resource child = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)child.getName()).thenReturn((Object)"child");
        Mockito.lenient().when((Object)res.getChild("child")).thenReturn((Object)child);
        OptionalObjectsModel model = (OptionalObjectsModel)this.factory.getAdapter((Object)res, OptionalObjectsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)child.getName(), (Object)model.getOptionalChild().get().getName());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullChild());
    }

    @Test
    void testFieldInjectionsScriptVariable() {
        SlingBindings bindings = new SlingBindings();
        SlingScriptHelper helper = (SlingScriptHelper)Mockito.mock(SlingScriptHelper.class);
        bindings.setSling(helper);
        Mockito.when((Object)this.request.getAttribute(SlingBindings.class.getName())).thenReturn((Object)bindings);
        OptionalObjectsModel model = (OptionalObjectsModel)this.factory.getAdapter((Object)this.request, OptionalObjectsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)helper, (Object)model.getOptionalHelper().get());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullHelper());
    }

    @Test
    void testFieldInjectionsOSGiService() throws InvalidSyntaxException {
        ServiceReference ref = (ServiceReference)Mockito.mock(ServiceReference.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.lenient().when((Object)this.bundleContext.getServiceReferences(Logger.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref});
        ((BundleContext)Mockito.doReturn((Object)logger).when((Object)this.bundleContext)).getService(ref);
        OptionalObjectsModel model = (OptionalObjectsModel)this.factory.getAdapter((Object)this.request, OptionalObjectsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)logger, (Object)model.getLog().get());
    }

    @Test
    void testFieldInjectionsRequestAttribute() {
        Object attribute = new Object();
        Mockito.lenient().when(this.request.getAttribute("attribute")).thenReturn(attribute);
        OptionalObjectsModel model = (OptionalObjectsModel)this.factory.getAdapter((Object)this.request, OptionalObjectsModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)attribute, (Object)model.getOptionalRequestAttribute().get());
        Assertions.assertEquals(Optional.empty(), model.getOptionalNullRequestAttribute());
    }
}

