/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.MissingElementException;
import org.apache.sling.models.factory.MissingElementsException;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AnnotationConflictsTest {
    private ModelAdapterFactory factory;
    @Mock
    private Resource resource;

    AnnotationConflictsTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        ValueMapInjector injector = new ValueMapInjector();
        this.factory.injectors = Arrays.asList(injector);
        this.factory.injectAnnotationProcessorFactories = Collections.singletonList(new ValueMapInjector());
        for (Class<?> clazz : this.getClass().getDeclaredClasses()) {
            if (clazz.isInterface()) continue;
            this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{clazz});
        }
    }

    @Test
    void testSucessfulAdaptations() {
        for (Class<?> clazz : this.getClass().getDeclaredClasses()) {
            if (clazz.isInterface() || !clazz.getSimpleName().startsWith("Successful")) continue;
            this.successful(clazz);
        }
    }

    @Test
    void testFailingAdaptations() {
        for (Class<?> clazz : this.getClass().getDeclaredClasses()) {
            if (clazz.isInterface() || !clazz.getSimpleName().startsWith("Failing")) continue;
            this.failing(clazz);
        }
    }

    private <T extends Methods> void successful(Class<T> modelClass) {
        ValueMapDecorator map = new ValueMapDecorator(Collections.singletonMap("otherText", "hello"));
        Mockito.when((Object)((ValueMap)this.resource.adaptTo(ValueMap.class))).thenReturn((Object)map);
        Methods model = (Methods)this.factory.createModel((Object)this.resource, modelClass);
        Assertions.assertNotNull((Object)model, (String)("Adaptation to " + modelClass.getSimpleName() + " was not null."));
        Assertions.assertNull((Object)model.getEmptyText(), (String)("Adaptation to " + modelClass.getSimpleName() + " had a non-null emptyText value."));
        Assertions.assertEquals((Object)"hello", (Object)model.getOtherText(), (String)("Adaptation to " + modelClass.getSimpleName() + " had an unexpected value in the otherText value."));
    }

    private <T extends Methods> void failing(Class<T> modelClass) {
        ValueMapDecorator map = new ValueMapDecorator(Collections.singletonMap("otherText", "hello"));
        Mockito.when((Object)((ValueMap)this.resource.adaptTo(ValueMap.class))).thenReturn((Object)map);
        boolean thrown = false;
        try {
            this.factory.createModel((Object)this.resource, modelClass);
        }
        catch (MissingElementsException e) {
            Assertions.assertEquals((int)1, (int)e.getMissingElements().size(), (String)("Adaptation to " + modelClass.getSimpleName() + " failed, but with the wrong number of exceptions."));
            MissingElementException me = (MissingElementException)e.getMissingElements().iterator().next();
            Assertions.assertTrue((boolean)me.getElement().toString().endsWith("emptyText"), (String)("Adaptation to " + modelClass.getSimpleName() + " didn't fail due to emptyText."));
            thrown = true;
        }
        Assertions.assertTrue((boolean)thrown, (String)("Adaptation to " + modelClass.getSimpleName() + " was successful."));
    }

    private static interface Methods {
        public String getOtherText();

        public String getEmptyText();
    }

    @Model(adaptables={Resource.class})
    public static class SuccessfulSingleOptionalBySeparateAnnotationOverridingStrategyFieldModel
    implements Methods {
        @ValueMapValue
        private String otherText;
        @ValueMapValue(injectionStrategy=InjectionStrategy.REQUIRED)
        @Optional
        private String emptyText;

        @Override
        public String getOtherText() {
            return this.otherText;
        }

        @Override
        public String getEmptyText() {
            return this.emptyText;
        }
    }

    @Model(adaptables={Resource.class})
    public static class FailingSingleRequiredBySeparateAnnotationOverridingStrategyFieldModel
    implements Methods {
        @ValueMapValue
        private String otherText;
        @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
        @Required
        private String emptyText;

        @Override
        public String getOtherText() {
            return this.otherText;
        }

        @Override
        public String getEmptyText() {
            return this.emptyText;
        }
    }

    @Model(adaptables={Resource.class})
    public static class SuccessfulSingleRequiredBySeparateAnnotationOverridingAttributeFieldModel
    implements Methods {
        @ValueMapValue
        private String otherText;
        @ValueMapValue(optional=true)
        @Required
        private String emptyText;

        @Override
        public String getOtherText() {
            return this.otherText;
        }

        @Override
        public String getEmptyText() {
            return this.emptyText;
        }
    }

    @Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
    public static class FailingSingleRequiredByStrategyFieldModel
    implements Methods {
        @ValueMapValue
        private String otherText;
        @ValueMapValue(injectionStrategy=InjectionStrategy.REQUIRED)
        private String emptyText;

        @Override
        public String getOtherText() {
            return this.otherText;
        }

        @Override
        public String getEmptyText() {
            return this.emptyText;
        }
    }

    @Model(adaptables={Resource.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
    public static class FailingSingleRequiredByAnnotationFieldModel
    implements Methods {
        @ValueMapValue
        private String otherText;
        @ValueMapValue
        @Required
        private String emptyText;

        @Override
        public String getOtherText() {
            return this.otherText;
        }

        @Override
        public String getEmptyText() {
            return this.emptyText;
        }
    }

    @Model(adaptables={Resource.class})
    public static class SuccessfulSingleOptionalByStrategyFieldModel
    implements Methods {
        @ValueMapValue
        private String otherText;
        @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
        private String emptyText;

        @Override
        public String getOtherText() {
            return this.otherText;
        }

        @Override
        public String getEmptyText() {
            return this.emptyText;
        }
    }

    @Model(adaptables={Resource.class})
    public static class SuccessfulSingleOptionalViaAttributeFieldModel
    implements Methods {
        @ValueMapValue
        private String otherText;
        @ValueMapValue(optional=true)
        private String emptyText;

        @Override
        public String getOtherText() {
            return this.otherText;
        }

        @Override
        public String getEmptyText() {
            return this.emptyText;
        }
    }

    @Model(adaptables={Resource.class})
    public static class SuccessfulSingleOptionalBySeparateAnnotationFieldModel
    implements Methods {
        @ValueMapValue
        private String otherText;
        @ValueMapValue
        @Optional
        private String emptyText;

        @Override
        public String getOtherText() {
            return this.otherText;
        }

        @Override
        public String getEmptyText() {
            return this.emptyText;
        }
    }
}

