/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.models.impl;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Collections;

import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.injector.CustomAnnotation;
import org.apache.sling.models.impl.injector.CustomAnnotationInjector;
import org.apache.sling.models.impl.injector.SimpleInjector;
import org.apache.sling.models.spi.injectorspecific.InjectAnnotationProcessorFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;

@SuppressWarnings("deprecation")
@ExtendWith(MockitoExtension.class)
class CustomInjectorTest {

    private ModelAdapterFactory factory;

    @BeforeEach
    void setup() {
        factory = AdapterFactoryTest.createModelAdapterFactory();
        factory.adapterImplementations.addClassesAsAdapterAndImplementation(
                TestModel.class, CustomAnnotationModel.class);
    }

    @Test
    void testInjectorWhichDoesNotImplementAnnotationProcessor() {
        factory.injectors = Arrays.asList(new SimpleInjector());

        TestModel model = factory.getAdapter(new Object(), TestModel.class);
        assertNotNull(model);
        assertEquals("test string", model.getTestString());
    }

    @Test
    void testInjectorWithCustomAnnotation() {
        CustomAnnotationInjector injector = new CustomAnnotationInjector();

        factory.injectors = Arrays.asList(new SimpleInjector(), injector);
        factory.injectAnnotationProcessorFactories = factory.injectAnnotationProcessorFactories =
                Collections.<InjectAnnotationProcessorFactory>singletonList(injector);

        CustomAnnotationModel model = factory.getAdapter(new Object(), CustomAnnotationModel.class);
        assertNotNull(model);
        assertEquals("default value", model.getDefaultString());
        assertEquals("custom value", model.getCustomString());
    }

    @Model(adaptables = Object.class)
    public interface TestModel {
        @Inject
        String getTestString();
    }

    @Model(adaptables = Object.class)
    public interface CustomAnnotationModel {
        @CustomAnnotation
        String getDefaultString();

        @Inject
        String getCustomString();
    }
}
