/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.AbstractName;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

@XmlTransient
public class DefaultScopedName
extends AbstractName
implements ScopedName {
    private static final long serialVersionUID = 1363103337249930577L;
    private final List<? extends LocalName> parsedNames;
    private transient GenericName tail;
    private transient GenericName path;

    static AbstractName create(List<? extends DefaultLocalName> names) {
        ArgumentChecks.ensureNonEmpty((String)"names", names);
        if (names.size() == 1) {
            return names.get(0);
        }
        return new DefaultScopedName(names);
    }

    private DefaultScopedName(List<? extends LocalName> names) {
        this.parsedNames = names;
    }

    protected DefaultScopedName(NameSpace scope, List<? extends CharSequence> names) {
        int size = names.size();
        ArgumentChecks.ensureCountBetween((String)"names", (boolean)true, (int)2, (int)Integer.MAX_VALUE, (int)size);
        DefaultNameSpace ns = DefaultNameSpace.castOrCopy(scope);
        boolean global = ns.isGlobal();
        int i = 0;
        Object[] locals = new LocalName[size];
        Iterator<? extends CharSequence> it = names.iterator();
        CharSequence name = it.next();
        do {
            ArgumentChecks.ensureNonNullElement((String)"names", (int)i, (Object)name);
            locals[i++] = new DefaultLocalName(ns, name);
            ns = ns.child(name, ns.separator);
            name = it.next();
        } while (it.hasNext());
        DefaultLocalName tip = ns.local(name, null);
        if (global) {
            tip.fullyQualified = this.fullyQualified = this;
        }
        locals[i++] = tip;
        if (i != size) {
            throw new ConcurrentModificationException(Errors.format((short)165, (Object)"names"));
        }
        this.parsedNames = Containers.viewAsUnmodifiableList((Object[])locals);
    }

    protected DefaultScopedName(GenericName path, GenericName tail) {
        ArgumentChecks.ensureNonNull((String)"path", (Object)path);
        ArgumentChecks.ensureNonNull((String)"tail", (Object)tail);
        List parsedPath = path.getParsedNames();
        List parsedTail = tail.getParsedNames();
        int index = parsedPath.size();
        Object[] locals = parsedPath.toArray(new LocalName[index + parsedTail.size()]);
        Iterator it = parsedTail.iterator();
        LocalName name = (LocalName)it.next();
        LocalName lastName = locals[index - 1];
        NameSpace lastScope = lastName.scope();
        NameSpace tailScope = name.scope();
        if (tailScope instanceof DefaultNameSpace && ((DefaultNameSpace)tailScope).parent() == lastScope) {
            if (path instanceof LocalName) {
                this.tail = tail;
            }
            while (true) {
                locals[index++] = name;
                if (it.hasNext()) {
                    name = (LocalName)it.next();
                    continue;
                }
                break;
            }
        } else {
            DefaultNameSpace scope = DefaultNameSpace.castOrCopy(lastScope);
            CharSequence label = DefaultScopedName.name((GenericName)lastName);
            while (true) {
                scope = scope.child(label, scope.separator);
                label = DefaultScopedName.name((GenericName)name);
                name = new DefaultLocalName(scope, label);
                locals[index++] = name;
                if (!it.hasNext()) break;
                name = (LocalName)it.next();
            }
        }
        if (index != locals.length) {
            throw new ConcurrentModificationException(Errors.format((short)165, (Object)"tail"));
        }
        this.parsedNames = Containers.viewAsUnmodifiableList((Object[])locals);
        if (tail instanceof LocalName) {
            this.path = path;
        }
    }

    protected DefaultScopedName(GenericName path, String separator, CharSequence tail) {
        ArgumentChecks.ensureNonNull((String)"path", (Object)path);
        ArgumentChecks.ensureNonNull((String)"tail", (Object)tail);
        List parsedPath = path.getParsedNames();
        int index = parsedPath.size();
        Object[] locals = parsedPath.toArray(new LocalName[index + 1]);
        LocalName lastName = locals[index - 1];
        DefaultNameSpace scope = DefaultNameSpace.castOrCopy(lastName.scope());
        scope = scope.child(DefaultScopedName.name((GenericName)lastName), separator != null ? separator : scope.separator);
        locals[index] = new DefaultLocalName(scope, tail);
        this.parsedNames = Containers.viewAsUnmodifiableList((Object[])locals);
        this.path = path;
    }

    private static CharSequence name(GenericName name) {
        if (name instanceof DefaultLocalName) {
            return ((DefaultLocalName)name).name;
        }
        InternationalString label = name.toInternationalString();
        return label != null ? label : name.toString();
    }

    @Override
    public NameSpace scope() {
        return this.head().scope();
    }

    public synchronized GenericName tail() {
        if (this.tail == null) {
            int size = this.parsedNames.size();
            switch (size) {
                default: {
                    this.tail = new DefaultScopedName(this.parsedNames.subList(1, size));
                    break;
                }
                case 2: {
                    this.tail = (GenericName)this.parsedNames.get(1);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(size);
                }
            }
        }
        return this.tail;
    }

    public synchronized GenericName path() {
        if (this.path == null) {
            int size = this.parsedNames.size();
            switch (size) {
                default: {
                    this.path = new DefaultScopedName(this.parsedNames.subList(0, size - 1));
                    break;
                }
                case 2: {
                    this.path = (GenericName)this.parsedNames.get(0);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AssertionError(size);
                }
            }
        }
        return this.path;
    }

    @Override
    public List<? extends LocalName> getParsedNames() {
        return this.parsedNames;
    }
}

