/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.fxg.logging.FXGLog;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.internal.fxg.dom.GradientEntryNode;
import org.apache.royale.compiler.internal.fxg.dom.filters.AbstractFilterNode;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class GradientGlowFilterNode
extends AbstractFilterNode {
    public double angle = 45.0;
    public double distance = 4.0;
    public double blurX = 4.0;
    public double blurY = 4.0;
    public boolean inner = false;
    public boolean knockout = false;
    public int quality = 1;
    public double strength = 1.0;
    public List<GradientEntryNode> entries;

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(super.getChildren());
        if (this.entries != null) {
            children.addAll(this.entries);
        }
        return children;
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof GradientEntryNode) {
            if (this.entries == null) {
                this.entries = new ArrayList<GradientEntryNode>(4);
            } else if (this.entries.size() >= 15) {
                FXGLog.getLogger().log(30000, "InvalidGradientGlowFilterNumElements", null, this.getDocumentPath(), this.startLine, this.startColumn);
                return;
            }
            this.entries.add((GradientEntryNode)child);
        } else {
            super.addChild(child, problems);
        }
    }

    @Override
    public String getNodeName() {
        return "GradientGlowFilter";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("angle".equals(name)) {
            this.angle = DOMParserHelper.parseDouble(this, value, name, this.angle, problems);
        } else if ("blurX".equals(name)) {
            this.blurX = DOMParserHelper.parseDouble(this, value, name, this.blurX, problems);
        } else if ("blurY".equals(name)) {
            this.blurY = DOMParserHelper.parseDouble(this, value, name, this.blurY, problems);
        } else if ("distance".equals(name)) {
            this.distance = DOMParserHelper.parseDouble(this, value, name, this.distance, problems);
        } else if ("inner".equals(name)) {
            this.inner = DOMParserHelper.parseBoolean(this, value, name, this.inner, problems);
        } else if ("knockout".equals(name)) {
            this.knockout = DOMParserHelper.parseBoolean(this, value, name, this.knockout, problems);
        } else if ("quality".equals(name)) {
            this.quality = DOMParserHelper.parseInt(this, value, name, 1, 3, this.quality, problems);
        } else if ("strength".equals(name)) {
            this.strength = DOMParserHelper.parseDouble(this, value, name, this.strength, problems);
        } else {
            super.setAttribute(name, value, problems);
        }
    }
}

