/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.databinding;

import java.util.LinkedList;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.as.codegen.Binding;
import org.apache.royale.compiler.internal.as.codegen.InstructionListNode;
import org.apache.royale.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.NumericLiteralNode;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLArrayNode;
import org.apache.royale.compiler.tree.mxml.IMXMLConcatenatedDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelPropertyNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelRootNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLSingleDataBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStringNode;

public class BindingDestinationMaker {
    public static IExpressionNode makeDestinationFunctionInstructionList(IMXMLDataBindingNode dbnode, MXMLClassDirectiveProcessor host) {
        InstructionListNode ret = null;
        IASNode parent = dbnode.getParent();
        if (parent instanceof IMXMLModelPropertyNode) {
            LinkedList<IASNode> nodes = new LinkedList<IASNode>();
            IASNode tempNode = parent;
            boolean done = false;
            while (!done) {
                if (tempNode instanceof IMXMLModelNode) {
                    done = true;
                }
                if (!(tempNode instanceof IMXMLModelRootNode)) {
                    nodes.addFirst(tempNode);
                }
                if ((tempNode = tempNode.getParent()) != null) continue;
                assert (false);
                return null;
            }
            InstructionList insns = new InstructionList();
            insns.addInstruction(208);
            int nodeIndex = 0;
            for (IASNode n : nodes) {
                boolean last = nodeIndex == nodes.size() - 1;
                BindingDestinationMaker.generateOne(insns, n, last);
                ++nodeIndex;
            }
            ret = new InstructionListNode(insns);
        } else if (parent instanceof IMXMLPropertySpecifierNode && dbnode instanceof IMXMLSingleDataBindingNode) {
            IMXMLPropertySpecifierNode psn = (IMXMLPropertySpecifierNode)parent;
            IDefinition d = psn.getDefinition();
            if (d != null) {
                Binding b = host.getInstanceScope().getBinding(d);
                INamespaceReference ns = d.getNamespaceReference();
                if (ns != NamespaceDefinition.getPublicNamespaceDefinition()) {
                    InstructionList insns = new InstructionList();
                    insns.addInstruction(208);
                    insns.addInstruction(209);
                    insns.addInstruction(97, b.getName());
                    ret = new InstructionListNode(insns);
                }
            }
        } else if (parent instanceof IMXMLStringNode && dbnode instanceof IMXMLConcatenatedDataBindingNode && parent.getParent() instanceof IMXMLArrayNode) {
            int index = -1;
            int n = parent.getParent().getChildCount();
            for (int i = 0; i < n; ++i) {
                IASNode child = parent.getParent().getChild(i);
                if (child != parent) continue;
                index = i;
                break;
            }
            IdentifierNode arrayNode = new IdentifierNode(((IMXMLArrayNode)parent.getParent()).getEffectiveID());
            arrayNode.setSourcePath(parent.getSourcePath());
            arrayNode.setColumn(parent.getColumn());
            arrayNode.setLine(parent.getLine());
            NumericLiteralNode indexNode = new NumericLiteralNode(Integer.valueOf(index).toString());
            indexNode.setSourcePath(parent.getSourcePath());
            indexNode.setColumn(parent.getColumn());
            indexNode.setLine(parent.getLine());
            DynamicAccessNode mae = new DynamicAccessNode(arrayNode);
            mae.setRightOperandNode(indexNode);
            mae.setParent((NodeBase)dbnode.getParent());
            arrayNode.setParent(mae);
            indexNode.setParent(mae);
            return mae;
        }
        return ret;
    }

    private static void generateOne(InstructionList insns, IASNode node, boolean lastOne) {
        if (node instanceof IMXMLModelPropertyNode) {
            BindingDestinationMaker.generateOneLevel(insns, (IMXMLModelPropertyNode)node, lastOne);
        } else if (node instanceof IMXMLModelNode) {
            BindingDestinationMaker.generateModel(insns, (IMXMLModelNode)node, lastOne);
        } else assert (false);
    }

    private static void generateOneLevel(InstructionList insns, IMXMLModelPropertyNode node, boolean lastOne) {
        if (!lastOne) {
            insns.addInstruction(102, new Name(node.getName()));
            if (node.getIndex() >= 0) {
                String nodeIndexName = Integer.toString(node.getIndex());
                insns.addInstruction(102, new Name(nodeIndexName));
            }
        } else if (node.getIndex() < 0) {
            insns.addInstruction(209);
            insns.addInstruction(97, new Name(node.getName()));
        } else {
            insns.addInstruction(102, new Name(node.getName()));
            insns.addInstruction(209);
            String nodeIndexName = Integer.toString(node.getIndex());
            insns.addInstruction(97, new Name(nodeIndexName));
        }
    }

    private static void generateModel(InstructionList insns, IMXMLModelNode model, boolean lastOne) {
        if (!lastOne) {
            String id = model.getEffectiveID();
            assert (id != null);
            insns.addInstruction(102, new Name(id));
        } else assert (false);
    }

    public static class Destination {
        public IExpressionNode destinationASTNode;
        boolean transformationRequired;

        public Destination(IExpressionNode destinationASTNode, boolean transformationRequired) {
            this.destinationASTNode = destinationASTNode;
            this.transformationRequired = transformationRequired;
        }
    }
}

