/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ClassResolver {
    public static Class resolveClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        ClassNotFoundException firstException;
        block10: {
            ClassLoader threadLoader;
            block9: {
                firstException = null;
                if (classLoader != null) {
                    try {
                        return Class.forName(className, true, classLoader);
                    }
                    catch (ClassNotFoundException e) {
                        if (firstException != null) break block9;
                        firstException = e;
                    }
                }
            }
            if ((threadLoader = Thread.currentThread().getContextClassLoader()) != null) {
                try {
                    return Class.forName(className, true, threadLoader);
                }
                catch (ClassNotFoundException e) {
                    if (firstException != null) break block10;
                    firstException = e;
                }
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (firstException == null) {
                firstException = e;
            }
            throw firstException;
        }
    }

    public static class Stream
    extends ObjectInputStream {
        private final ClassLoader classLoader;

        public Stream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            ClassNotFoundException firstException;
            block10: {
                ClassLoader threadLoader;
                block9: {
                    firstException = null;
                    if (this.classLoader != null) {
                        try {
                            return Class.forName(desc.getName(), false, this.classLoader);
                        }
                        catch (ClassNotFoundException e) {
                            if (firstException != null) break block9;
                            firstException = e;
                        }
                    }
                }
                if ((threadLoader = Thread.currentThread().getContextClassLoader()) != null) {
                    try {
                        return Class.forName(desc.getName(), false, threadLoader);
                    }
                    catch (ClassNotFoundException e) {
                        if (firstException != null) break block10;
                        firstException = e;
                    }
                }
            }
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException e) {
                if (firstException == null) {
                    firstException = e;
                }
                throw firstException;
            }
        }
    }
}

