/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.internal.JsonRpcHandlerManager;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.client.ClientSession;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.message.Message;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.kurento.jsonrpc.message.ResponseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClientLocal
extends JsonRpcClient {
    private static Logger log = LoggerFactory.getLogger(JsonRpcClientLocal.class);
    private JsonRpcHandler<? extends Object> remoteHandler;
    private final JsonRpcHandlerManager remoteHandlerManager = new JsonRpcHandlerManager();

    public <F> JsonRpcClientLocal(JsonRpcHandler<? extends Object> handler) {
        this.remoteHandler = handler;
        this.remoteHandlerManager.setJsonRpcHandler(this.remoteHandler);
        this.session = new ClientSession("XXX", null, this);
        this.rsHelper = new JsonRpcRequestSenderHelper(){

            @Override
            public <P, R> Response<R> internalSendRequest(Request<P> request, Class<R> resultClass) throws IOException {
                return JsonRpcClientLocal.this.localSendRequest(request, resultClass);
            }

            @Override
            protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> resultClass, Continuation<Response<JsonElement>> continuation) {
                Response<JsonElement> result = JsonRpcClientLocal.this.localSendRequest(request, resultClass);
                if (result != null) {
                    continuation.onSuccess(result);
                }
            }
        };
    }

    private <R, P> Response<R> localSendRequest(Request<P> request, Class<R> resultClass) {
        String jsonRequest = request.toString();
        log.debug("--> {}", (Object)jsonRequest);
        Request<JsonObject> newRequest = JsonUtils.fromJsonRequest(jsonRequest, JsonObject.class);
        final Response[] response = new Response[1];
        ClientSession clientSession = new ClientSession(this.session.getSessionId(), null, new JsonRpcRequestSenderHelper(){

            @Override
            protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> clazz, final Continuation<Response<JsonElement>> continuation) {
                JsonRpcClientLocal.this.handlerManager.handleRequest(JsonRpcClientLocal.this.session, request, new TransactionImpl.ResponseSender(){

                    @Override
                    public void sendResponse(Message message) throws IOException {
                        continuation.onSuccess((Response)message);
                    }

                    @Override
                    public void sendPingResponse(Message message) throws IOException {
                        this.sendResponse(message);
                    }
                });
            }

            protected <P2, R2> Response<R2> internalSendRequest(Request<P2> request, Class<R2> resultClass) throws IOException {
                final Object[] response = new Object[1];
                final CountDownLatch responseLatch = new CountDownLatch(1);
                JsonRpcClientLocal.this.handlerManager.handleRequest(JsonRpcClientLocal.this.session, request, new TransactionImpl.ResponseSender(){

                    @Override
                    public void sendResponse(Message message) throws IOException {
                        response[0] = message;
                        responseLatch.countDown();
                    }

                    @Override
                    public void sendPingResponse(Message message) throws IOException {
                        this.sendResponse(message);
                    }
                });
                Response response2 = (Response)response[0];
                try {
                    responseLatch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                log.debug("<-- {}", (Object)response2);
                Object result = response2.getResult();
                if (result == null || resultClass.isAssignableFrom(result.getClass())) {
                    return response2;
                }
                if (resultClass == JsonElement.class) {
                    response2.setResult(JsonUtils.toJsonElement(result));
                    return response2;
                }
                throw new ClassCastException("Class " + String.valueOf(result) + " cannot be converted to " + String.valueOf(resultClass));
            }
        });
        TransactionImpl t = new TransactionImpl(clientSession, newRequest, new TransactionImpl.ResponseSender(){

            @Override
            public void sendResponse(Message message) throws IOException {
                response[0] = (Response)message;
            }

            @Override
            public void sendPingResponse(Message message) throws IOException {
                this.sendResponse(message);
            }
        });
        try {
            this.remoteHandler.handleRequest(t, request);
        }
        catch (Exception e) {
            ResponseError error = ResponseError.newFromException(e);
            return new Response(request.getId(), error);
        }
        if (response[0] != null) {
            Response responseObj = response[0];
            if (responseObj.getId() == null) {
                responseObj.setId(request.getId());
            }
            String jsonResponse = responseObj.toString();
            Response<R> newResponse = JsonUtils.fromJsonResponse(jsonResponse, resultClass);
            newResponse.setId(request.getId());
            return newResponse;
        }
        return new Response(request.getId());
    }

    @Override
    public void close() throws IOException {
        this.handlerManager.afterConnectionClosed(this.session, "Client close");
        super.close();
    }

    @Override
    public void setServerRequestHandler(JsonRpcHandler<?> handler) {
        super.setServerRequestHandler(handler);
        this.handlerManager.afterConnectionEstablished(this.session);
        this.remoteHandlerManager.afterConnectionEstablished(this.session);
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public void setRequestTimeout(long requesTimeout) {
        log.warn("setRequestTimeout(...) method will be ignored");
    }
}

