/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.util;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.ClientEndpointManager;
import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.ClientMessageReader;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.nio.InboundHandlerWithCounters;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.function.Consumer;

public class ClientMessageDecoder
extends InboundHandlerWithCounters<ByteBuffer, Consumer<ClientMessage>> {
    final Long2ObjectHashMap<ClientMessage> builderBySessionIdMap = new Long2ObjectHashMap();
    private final Connection connection;
    private ClientMessageReader activeReader;
    private boolean clientIsTrusted;
    private final int maxMessageLength;
    private final ClientEndpointManager clientEndpointManager;

    public ClientMessageDecoder(Connection connection, Consumer<ClientMessage> dst, HazelcastProperties properties) {
        ClientEndpointManager clientEndpointManager;
        this.dst(dst);
        if (properties == null) {
            properties = new HazelcastProperties((Properties)null);
        }
        if (dst instanceof ClientEngine) {
            ClientEngine clientEngine = (ClientEngine)dst;
            clientEndpointManager = clientEngine.getEndpointManager();
        } else {
            clientEndpointManager = null;
        }
        this.clientEndpointManager = clientEndpointManager;
        this.maxMessageLength = properties.getInteger(ClusterProperty.CLIENT_PROTOCOL_UNVERIFIED_MESSAGE_BYTES);
        this.activeReader = new ClientMessageReader(this.maxMessageLength);
        this.connection = connection;
    }

    @Override
    public void handlerAdded() {
        this.initSrcBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandlerStatus onRead() {
        ((ByteBuffer)this.src).flip();
        try {
            boolean trusted;
            boolean complete;
            while (((ByteBuffer)this.src).hasRemaining() && (complete = this.activeReader.readFrom((ByteBuffer)this.src, trusted = this.isEndpointTrusted()))) {
                ClientMessage.Frame firstFrame = this.activeReader.getClientMessage().getStartFrame();
                int flags = firstFrame.flags;
                if (ClientMessage.isFlagSet(flags, 49152)) {
                    this.handleMessage(this.activeReader.getClientMessage());
                } else {
                    if (!trusted) {
                        throw new IllegalStateException("Fragmented client messages are not allowed before the client is authenticated.");
                    }
                    ClientMessage message = this.activeReader.getClientMessage();
                    message.dropFragmentationFrame();
                    long fragmentationId = Bits.readLongL(firstFrame.content, 0);
                    if (ClientMessage.isFlagSet(flags, 32768)) {
                        this.builderBySessionIdMap.put(fragmentationId, message);
                    } else if (ClientMessage.isFlagSet(flags, 16384)) {
                        ClientMessage clientMessage = this.mergeIntoExistingClientMessage(fragmentationId);
                        this.builderBySessionIdMap.remove(fragmentationId);
                        this.handleMessage(clientMessage);
                    } else {
                        this.mergeIntoExistingClientMessage(fragmentationId);
                    }
                }
                this.activeReader = new ClientMessageReader(this.maxMessageLength);
            }
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)this.src);
        }
    }

    private boolean isEndpointTrusted() {
        if (this.clientEndpointManager == null || this.clientIsTrusted) {
            return true;
        }
        ClientEndpoint endpoint = this.clientEndpointManager.getEndpoint(this.connection);
        this.clientIsTrusted = endpoint != null && endpoint.isAuthenticated();
        return this.clientIsTrusted;
    }

    private ClientMessage mergeIntoExistingClientMessage(long fragmentationId) {
        ClientMessage existingMessage = this.builderBySessionIdMap.get(fragmentationId);
        existingMessage.merge(this.activeReader.getClientMessage());
        return existingMessage;
    }

    private void handleMessage(ClientMessage clientMessage) {
        clientMessage.setConnection(this.connection);
        this.normalPacketsRead.inc();
        ((Consumer)this.dst).accept(clientMessage);
    }
}

