/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractPartitionMessageTask<P>
extends AbstractAsyncMessageTask<P, Object>
implements PartitionSpecificRunnable {
    private boolean namespaceAware;

    protected AbstractPartitionMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected final void setNamespaceAware() {
        this.namespaceAware = true;
    }

    @Override
    protected void processMessage() {
        if (this.namespaceAware) {
            NamespaceUtil.runWithNamespace(this.nodeEngine, this.getUserCodeNamespace(), () -> super.processMessage());
        } else {
            super.processMessage();
        }
    }

    @Override
    public int getPartitionId() {
        return this.clientMessage.getPartitionId();
    }

    @Override
    protected CompletableFuture<Object> processInternal() {
        Operation op = this.prepareOperation();
        if (ClientMessage.isFlagSet(this.clientMessage.getHeaderFlags(), 256)) {
            op.setClientCallId(this.clientMessage.getCorrelationId());
        }
        op.setCallerUuid(this.endpoint.getUuid());
        return this.nodeEngine.getOperationService().createInvocationBuilder(this.getServiceName(), op, this.getPartitionId()).setResultDeserialized(false).invoke();
    }

    @Override
    public final Permission getUserCodeNamespacePermission() {
        if (this.namespaceAware) {
            String namespace = this.getUserCodeNamespace();
            return namespace != null ? new UserCodeNamespacePermission(namespace, "use") : null;
        }
        return null;
    }

    protected abstract Operation prepareOperation();

    protected abstract String getUserCodeNamespace();
}

