/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.string.Strings;

public class AutoLabelTagHandler
extends AbstractMarkupFilter {
    public AutoLabelTagHandler(MarkupResourceStream resourceStream) {
        super(resourceStream);
    }

    @Override
    protected MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (tag == null || tag.isClose() || tag instanceof WicketTag) {
            return tag;
        }
        String related = tag.getAttribute(this.getWicketNamespace() + ":for");
        if (related == null) {
            return tag;
        }
        if (Strings.isEmpty((String)(related = related.trim()))) {
            throw new ParseException("Tag contains an empty wicket:for attribute", tag.getPos());
        }
        if (!"label".equalsIgnoreCase(tag.getName())) {
            throw new ParseException("Attribute wicket:for can only be attached to <label> tag", tag.getPos());
        }
        if (tag.getId() != null) {
            throw new ParseException("Attribute wicket:for cannot be used in conjunction with wicket:id", tag.getPos());
        }
        tag.setId("label_attr" + this.getRequestUniqueId());
        tag.setModified(true);
        tag.setAutoComponentTag(true);
        return tag;
    }
}

