/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room;

import com.github.openjson.JSONObject;
import org.apache.openmeetings.web.common.BasePanel;
import org.apache.openmeetings.web.common.OmAjaxClientInfoBehavior;
import org.apache.openmeetings.web.room.VideoSettings;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class NetTestPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference NETTEST_JS_REFERENCE = new JavaScriptResourceReference(VideoSettings.class, "nettest.js");

    public NetTestPanel(String id) {
        super(id);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)NETTEST_JS_REFERENCE));
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{new OmAjaxClientInfoBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onClientInfo(AjaxRequestTarget target, WebClientInfo info) {
                super.onClientInfo(target, info);
                target.appendJavaScript((CharSequence)String.format("NetTest.init(%s);", NetTestPanel.this.getStringLabels()));
            }
        }});
    }

    private JSONObject getStringLabels() {
        JSONObject o = new JSONObject();
        for (String id : new String[]{"network.test.ms", "network.test.mb", "network.test.sec", "network.test.click.play", "network.test.copy.log", "network.test.report.start", "network.test.ping", "network.test.ping.avg", "network.test.ping.rcv", "network.test.ping.lost", "network.test.ping.load", "network.test.port", "network.test.port.avail", "network.test.port.stopped", "network.test.jitter", "network.test.jitter.avg", "network.test.jitter.min", "network.test.jitter.max", "network.test.jitter.avgAbbr", "network.test.dwn", "network.test.dwn.bytes", "network.test.dwn.time", "network.test.dwn.speed", "network.test.upl", "network.test.upl.bytes", "network.test.upl.time", "network.test.upl.speed"}) {
            o.put(id.substring("network.test.".length()), (Object)this.getString(id));
        }
        return o;
    }
}

