/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.retry;

import java.util.List;

public interface RetryState {
    public int getRetryCount();

    public List<Throwable> getExceptions();

    default public Throwable getLastException() {
        List<Throwable> exceptions = this.getExceptions();
        if (exceptions.isEmpty()) {
            throw new IllegalStateException("No exception recorded");
        }
        return exceptions.get(exceptions.size() - 1);
    }

    default public boolean isSuccessful() {
        return this.getRetryCount() >= this.getExceptions().size();
    }
}

