/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;

public class StandardFlowDifference
implements FlowDifference {
    private final DifferenceType type;
    private final VersionedComponent componentA;
    private final VersionedComponent componentB;
    private final Optional<String> fieldName;
    private final Object valueA;
    private final Object valueB;
    private final String description;

    public StandardFlowDifference(DifferenceType type, VersionedComponent componentA, VersionedComponent componentB, Object valueA, Object valueB, String description) {
        this(type, componentA, componentB, null, valueA, valueB, description);
    }

    public StandardFlowDifference(DifferenceType type, VersionedComponent componentA, VersionedComponent componentB, String fieldName, Object valueA, Object valueB, String description) {
        this.type = type;
        this.componentA = componentA;
        this.componentB = componentB;
        this.fieldName = Optional.ofNullable(fieldName);
        this.valueA = valueA;
        this.valueB = valueB;
        this.description = description;
    }

    @Override
    public DifferenceType getDifferenceType() {
        return this.type;
    }

    @Override
    public VersionedComponent getComponentA() {
        return this.componentA;
    }

    @Override
    public VersionedComponent getComponentB() {
        return this.componentB;
    }

    @Override
    public Optional<String> getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object getValueA() {
        return this.valueA;
    }

    @Override
    public Object getValueB() {
        return this.valueB;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.componentA == null ? null : this.componentA.getIdentifier(), this.componentA == null ? null : this.componentA.getInstanceIdentifier(), this.componentB == null ? null : this.componentB.getIdentifier(), this.componentB == null ? null : this.componentB.getInstanceIdentifier(), this.fieldName.orElse(null), this.valueA, this.valueB, this.description});
    }

    public boolean equals(Object obj) {
        String otherComponentBId;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardFlowDifference)) {
            return false;
        }
        StandardFlowDifference other = (StandardFlowDifference)obj;
        String componentAId = this.componentA == null ? null : this.componentA.getIdentifier();
        String otherComponentAId = other.componentA == null ? null : other.componentA.getIdentifier();
        String componentBId = this.componentB == null ? null : this.componentB.getIdentifier();
        String string = otherComponentBId = other.componentB == null ? null : other.componentB.getIdentifier();
        if (this.componentA != null && this.componentA.getInstanceIdentifier() != null && other.componentA != null && other.componentA.getInstanceIdentifier() != null && !this.componentA.getInstanceIdentifier().equals(other.componentA.getInstanceIdentifier())) {
            return false;
        }
        if (this.componentB != null && this.componentB.getInstanceIdentifier() != null && other.componentB != null && other.componentB.getInstanceIdentifier() != null && !this.componentB.getInstanceIdentifier().equals(other.componentB.getInstanceIdentifier())) {
            return false;
        }
        return Objects.equals(componentAId, otherComponentAId) && Objects.equals(componentBId, otherComponentBId) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.valueA, other.valueA) && Objects.equals(this.valueB, other.valueB) && this.fieldName.orElse("").equals(other.fieldName.orElse(""));
    }
}

