/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core.support;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Objects;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.jspecify.annotations.NonNull;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DirContextProxy;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.support.AbstractContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;

public final class ObservationContextSource
implements BaseLdapPathContextSource {
    private final BaseLdapPathContextSource contextSource;
    private final DirContextOperationObservationContext.Builder builder;
    private final ObservationRegistry registry;

    public ObservationContextSource(BaseLdapPathContextSource contextSource, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)contextSource, (String)"contextSource cannot be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
        Assert.isTrue((!(contextSource instanceof ObservationContextSource) ? 1 : 0) != 0, (String)"contextSource is already wrapped in an ObservationContextSource");
        this.contextSource = contextSource;
        this.registry = observationRegistry;
        this.builder = DirContextOperationObservationContext.withContextSource(this.contextSource);
    }

    @Override
    public DirContext getReadOnlyContext() throws NamingException {
        return this.wrapDirContext(this.contextSource.getReadOnlyContext());
    }

    @Override
    public DirContext getReadWriteContext() throws NamingException {
        return this.wrapDirContext(this.contextSource.getReadWriteContext());
    }

    @Override
    public DirContext getContext(String principal, String credentials) throws NamingException {
        return this.wrapDirContext(this.contextSource.getContext(principal, credentials));
    }

    private DirContext wrapDirContext(DirContext delegate) {
        if (delegate instanceof DirContextOperations) {
            return delegate;
        }
        if (delegate instanceof LdapContext) {
            LdapContext ldap = (LdapContext)delegate;
            return new ObservationLdapContext(this.builder, ldap, this.registry);
        }
        return new ObservationDirContext(this.builder, delegate, this.registry);
    }

    @Override
    @Deprecated
    public DistinguishedName getBaseLdapPath() {
        return this.contextSource.getBaseLdapPath();
    }

    @Override
    public LdapName getBaseLdapName() {
        return this.contextSource.getBaseLdapName();
    }

    @Override
    public String getBaseLdapPathAsString() {
        return this.contextSource.getBaseLdapPathAsString();
    }

    private static class DirContextOperationObservationContext
    extends Observation.Context {
        private final String urls;
        private final String base;
        private final String operation;

        DirContextOperationObservationContext(String urls, String base, String operation) {
            this.urls = urls;
            this.base = base;
            this.operation = operation;
        }

        static Builder withContextSource(BaseLdapPathContextSource contextSource) {
            return new Builder(contextSource);
        }

        String getUrls() {
            return this.urls;
        }

        String getBase() {
            return this.base;
        }

        String getOperation() {
            return this.operation;
        }

        private static class Builder {
            private final String urls;
            private final String base;

            Builder(BaseLdapPathContextSource contextSource) {
                this.base = contextSource.getBaseLdapPathAsString();
                if (contextSource instanceof AbstractContextSource) {
                    AbstractContextSource acs = (AbstractContextSource)contextSource;
                    this.urls = Arrays.toString(acs.getUrls());
                } else {
                    this.urls = "unknown";
                }
            }

            DirContextOperationObservationContext operation(String operation) {
                return new DirContextOperationObservationContext(this.urls, this.base, operation);
            }
        }
    }

    private static class ObservationLdapContext
    extends ObservationDirContext
    implements DelegatingLdapContext {
        private final LdapContext delegate;

        ObservationLdapContext(DirContextOperationObservationContext.Builder builder, LdapContext delegate, ObservationRegistry registry) {
            super(builder, delegate, registry);
            this.delegate = delegate;
        }

        @Override
        public ExtendedResponse extendedOperation(ExtendedRequest request) throws javax.naming.NamingException {
            Observation observation = this.observation("extendedOperation");
            observation.highCardinalityKeyValue("request.id", request.getID());
            return (ExtendedResponse)observation.observeChecked(() -> this.delegate.extendedOperation(request));
        }

        @Override
        public void reconnect(Control[] controls) throws javax.naming.NamingException {
            Observation observation = this.observation("reconnect");
            ArrayList<String> ids = new ArrayList<String>();
            for (Control control : controls) {
                ids.add(control.getID());
            }
            observation.highCardinalityKeyValue("control.ids", ((Object)ids).toString());
            observation.observeChecked(() -> this.delegate.reconnect(controls));
        }
    }

    private static class ObservationDirContext
    extends AbstractDirContextProxy
    implements DelegatingDirContext {
        private final ObservationRegistry registry;
        private final DirContextOperationObservationConvention convention = new DirContextOperationObservationConvention();
        private final DirContextOperationObservationContext.Builder builder;

        ObservationDirContext(DirContextOperationObservationContext.Builder builder, DirContext delegate, ObservationRegistry registry) {
            super(delegate);
            this.builder = builder;
            this.registry = registry;
        }

        @Override
        public Attributes getAttributes(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("getAttributes").highCardinalityKeyValue("name", name.toString());
            return (Attributes)observation.observeChecked(() -> this.getTargetContext().getAttributes(name));
        }

        @Override
        public Attributes getAttributes(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("getAttributes").highCardinalityKeyValue("name", name);
            return (Attributes)observation.observeChecked(() -> this.getTargetContext().getAttributes(name));
        }

        @Override
        public Attributes getAttributes(Name name, String[] attrIds) throws javax.naming.NamingException {
            Observation observation = this.observation("getAttributes").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(attrIds));
            return (Attributes)observation.observeChecked(() -> this.getTargetContext().getAttributes(name, attrIds));
        }

        @Override
        public Attributes getAttributes(String name, String[] attrIds) throws javax.naming.NamingException {
            Observation observation = this.observation("getAttributes").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(attrIds));
            return (Attributes)observation.observeChecked(() -> this.getTargetContext().getAttributes(name, attrIds));
        }

        @Override
        public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws javax.naming.NamingException {
            Observation observation = this.observation("modifyAttributes").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(mod_op, attrs));
            observation.observeChecked(() -> this.getTargetContext().modifyAttributes(name, mod_op, attrs));
        }

        @Override
        public void modifyAttributes(String name, int mod_op, Attributes attrs) throws javax.naming.NamingException {
            Observation observation = this.observation("modifyAttributes").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(mod_op, attrs));
            observation.observeChecked(() -> this.getTargetContext().modifyAttributes(name, mod_op, attrs));
        }

        @Override
        public void modifyAttributes(Name name, ModificationItem[] mods) throws javax.naming.NamingException {
            Observation observation = this.observation("modifyAttributes").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(mods));
            observation.observeChecked(() -> this.getTargetContext().modifyAttributes(name, mods));
        }

        @Override
        public void modifyAttributes(String name, ModificationItem[] mods) throws javax.naming.NamingException {
            Observation observation = this.observation("modifyAttributes").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(mods));
            observation.observeChecked(() -> this.getTargetContext().modifyAttributes(name, mods));
        }

        @Override
        public void bind(Name name, Object obj, Attributes attrs) throws javax.naming.NamingException {
            Observation observation = this.observation("bind").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(attrs));
            observation.observeChecked(() -> this.getTargetContext().bind(name, obj, attrs));
        }

        @Override
        public void bind(String name, Object obj, Attributes attrs) throws javax.naming.NamingException {
            Observation observation = this.observation("bind").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(attrs));
            observation.observeChecked(() -> this.getTargetContext().bind(name, obj, attrs));
        }

        @Override
        public void rebind(Name name, Object obj, Attributes attrs) throws javax.naming.NamingException {
            Observation observation = this.observation("rebind").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(attrs));
            observation.observeChecked(() -> this.getTargetContext().rebind(name, obj, attrs));
        }

        @Override
        public void rebind(String name, Object obj, Attributes attrs) throws javax.naming.NamingException {
            Observation observation = this.observation("rebind").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(attrs));
            observation.observeChecked(() -> this.getTargetContext().rebind(name, obj, attrs));
        }

        @Override
        public DirContext createSubcontext(Name name, Attributes attrs) throws javax.naming.NamingException {
            Observation observation = this.observation("createSubcontext").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(attrs));
            return (DirContext)observation.observeChecked(() -> this.getTargetContext().createSubcontext(name, attrs));
        }

        @Override
        public DirContext createSubcontext(String name, Attributes attrs) throws javax.naming.NamingException {
            Observation observation = this.observation("createSubcontext").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(attrs));
            return (DirContext)observation.observeChecked(() -> this.getTargetContext().createSubcontext(name, attrs));
        }

        @Override
        public DirContext getSchema(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("getSchema").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (DirContext)observation.observeChecked(() -> this.getTargetContext().getSchema(name));
        }

        @Override
        public DirContext getSchema(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("getSchema").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (DirContext)observation.observeChecked(() -> this.getTargetContext().getSchema(name));
        }

        @Override
        public DirContext getSchemaClassDefinition(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("getSchemaClassDefinition").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (DirContext)observation.observeChecked(() -> this.getTargetContext().getSchemaClassDefinition(name));
        }

        @Override
        public DirContext getSchemaClassDefinition(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("getSchemaClassDefinition").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (DirContext)observation.observeChecked(() -> this.getTargetContext().getSchemaClassDefinition(name));
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws javax.naming.NamingException {
            Observation observation = this.observation("search").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIdsReturn(attributesToReturn));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().search(name, matchingAttributes, attributesToReturn));
        }

        @Override
        public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws javax.naming.NamingException {
            Observation observation = this.observation("search").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(matchingAttributes)).highCardinalityKeyValue(ObservationDirContext.attributeIdsReturn(attributesToReturn));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().search(name, matchingAttributes, attributesToReturn));
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws javax.naming.NamingException {
            Observation observation = this.observation("search").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(matchingAttributes));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().search(name, matchingAttributes));
        }

        @Override
        public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws javax.naming.NamingException {
            Observation observation = this.observation("search").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIds(matchingAttributes));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().search(name, matchingAttributes));
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws javax.naming.NamingException {
            Observation observation = this.observation("search").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIdsReturn(cons)).highCardinalityKeyValue(ObservationDirContext.searchControls(cons));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().search(name, filter, cons));
        }

        @Override
        public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws javax.naming.NamingException {
            Observation observation = this.observation("search").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIdsReturn(cons)).highCardinalityKeyValue(ObservationDirContext.searchControls(cons));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().search(name, filter, cons));
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws javax.naming.NamingException {
            Observation observation = this.observation("search").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIdsReturn(cons)).highCardinalityKeyValue(ObservationDirContext.searchControls(cons));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().search(name, filterExpr, filterArgs, cons));
        }

        @Override
        public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws javax.naming.NamingException {
            Observation observation = this.observation("search").highCardinalityKeyValue(ObservationDirContext.name(name)).highCardinalityKeyValue(ObservationDirContext.attributeIdsReturn(cons)).highCardinalityKeyValue(ObservationDirContext.searchControls(cons));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().search(name, filterExpr, filterArgs, cons));
        }

        @Override
        public Object lookup(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("lookup").highCardinalityKeyValue(ObservationDirContext.name(name));
            return observation.observeChecked(() -> this.getTargetContext().lookup(name));
        }

        @Override
        public Object lookup(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("lookup").highCardinalityKeyValue(ObservationDirContext.name(name));
            return observation.observeChecked(() -> this.getTargetContext().lookup(name));
        }

        @Override
        public void bind(Name name, Object obj) throws javax.naming.NamingException {
            Observation observation = this.observation("bind").highCardinalityKeyValue(ObservationDirContext.name(name));
            observation.observeChecked(() -> this.getTargetContext().bind(name, obj));
        }

        @Override
        public void bind(String name, Object obj) throws javax.naming.NamingException {
            Observation observation = this.observation("bind").highCardinalityKeyValue(ObservationDirContext.name(name));
            observation.observeChecked(() -> this.getTargetContext().bind(name, obj));
        }

        @Override
        public void rebind(Name name, Object obj) throws javax.naming.NamingException {
            Observation observation = this.observation("rebind").highCardinalityKeyValue(ObservationDirContext.name(name));
            observation.observeChecked(() -> this.getTargetContext().rebind(name, obj));
        }

        @Override
        public void rebind(String name, Object obj) throws javax.naming.NamingException {
            Observation observation = this.observation("rebind").highCardinalityKeyValue(ObservationDirContext.name(name));
            observation.observeChecked(() -> this.getTargetContext().rebind(name, obj));
        }

        @Override
        public void unbind(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("unbind").highCardinalityKeyValue(ObservationDirContext.name(name));
            observation.observeChecked(() -> this.getTargetContext().unbind(name));
        }

        @Override
        public void unbind(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("unbind").highCardinalityKeyValue(ObservationDirContext.name(name));
            observation.observeChecked(() -> this.getTargetContext().unbind(name));
        }

        @Override
        public void rename(Name oldName, Name newName) throws javax.naming.NamingException {
            Observation observation = this.observation("rename").highCardinalityKeyValue(ObservationDirContext.name("old.name", oldName)).highCardinalityKeyValue(ObservationDirContext.name("newName", newName));
            observation.observeChecked(() -> this.getTargetContext().rename(oldName, newName));
        }

        @Override
        public void rename(String oldName, String newName) throws javax.naming.NamingException {
            Observation observation = this.observation("rename").highCardinalityKeyValue(ObservationDirContext.name("old.name", oldName)).highCardinalityKeyValue(ObservationDirContext.name("newName", newName));
            observation.observeChecked(() -> this.getTargetContext().rename(oldName, newName));
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("list").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().list(name));
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("list").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().list(name));
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("listBindings").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().listBindings(name));
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("listBindings").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (NamingEnumeration)observation.observeChecked(() -> this.getTargetContext().listBindings(name));
        }

        @Override
        public void destroySubcontext(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("destroySubcontext").highCardinalityKeyValue(ObservationDirContext.name(name));
            observation.observeChecked(() -> this.getTargetContext().destroySubcontext(name));
        }

        @Override
        public void destroySubcontext(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("destroySubcontext").highCardinalityKeyValue(ObservationDirContext.name(name));
            observation.observeChecked(() -> this.getTargetContext().destroySubcontext(name));
        }

        @Override
        public Context createSubcontext(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("createSubcontext").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (Context)observation.observeChecked(() -> this.getTargetContext().createSubcontext(name));
        }

        @Override
        public Context createSubcontext(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("createSubcontext").highCardinalityKeyValue(ObservationDirContext.name(name));
            return (Context)observation.observeChecked(() -> this.getTargetContext().createSubcontext(name));
        }

        @Override
        public Object lookupLink(Name name) throws javax.naming.NamingException {
            Observation observation = this.observation("lookupLink").highCardinalityKeyValue(ObservationDirContext.name(name));
            return observation.observeChecked(() -> this.getTargetContext().lookupLink(name));
        }

        @Override
        public Object lookupLink(String name) throws javax.naming.NamingException {
            Observation observation = this.observation("lookupLink").highCardinalityKeyValue(ObservationDirContext.name(name));
            return observation.observeChecked(() -> this.getTargetContext().lookupLink(name));
        }

        @Override
        public String getNameInNamespace() throws javax.naming.NamingException {
            Observation observation = this.observation("getNameInNamespace");
            return (String)observation.observeChecked(this.getTargetContext()::getNameInNamespace);
        }

        private static KeyValue name(String tagName, Name name) {
            return KeyValue.of((String)tagName, (String)String.valueOf(name));
        }

        private static KeyValue name(String tagName, String name) {
            return KeyValue.of((String)tagName, (String)name);
        }

        private static KeyValue name(Name name) {
            return ObservationDirContext.name("name", name);
        }

        private static KeyValue name(String name) {
            return ObservationDirContext.name("name", name);
        }

        private static KeyValue attributeIds(String[] attributes) {
            return KeyValue.of((String)"attribute.ids", (String)Arrays.toString(attributes));
        }

        private static KeyValue attributeIds(Attributes attributes) {
            return KeyValue.of((String)"attribute.ids", (String)Collections.list(attributes.getIDs()).toString());
        }

        private static KeyValue attributeIds(int mod_op, Attributes attrs) {
            ArrayList<String> attributes = Collections.list(attrs.getIDs());
            String value = Collections.singletonMap(ObservationDirContext.modify(mod_op), attributes).toString();
            return KeyValue.of((String)"attribute.ids", (String)value);
        }

        private static KeyValue attributeIds(ModificationItem[] items) {
            LinkedMultiValueMap ids = new LinkedMultiValueMap();
            for (ModificationItem item : items) {
                ids.add((Object)ObservationDirContext.modify(item.getModificationOp()), (Object)item.getAttribute().getID());
            }
            String value = ids.toString();
            return KeyValue.of((String)"attribute.ids", (String)value);
        }

        private static KeyValue attributeIdsReturn(String[] attrs) {
            if (attrs == null) {
                return KeyValue.of((String)"attribute.ids", (String)"all");
            }
            return KeyValue.of((String)"attribute.ids", (String)Arrays.toString(attrs));
        }

        private static KeyValue attributeIdsReturn(SearchControls searchControls) {
            if (searchControls == null) {
                return ObservationDirContext.attributeIdsReturn((String[])null);
            }
            return ObservationDirContext.attributeIdsReturn(searchControls.getReturningAttributes());
        }

        private static KeyValue searchControls(SearchControls searchControls) {
            if (searchControls == null) {
                return KeyValue.of((String)"search.controls", (String)"default");
            }
            return KeyValue.of((String)"search.controls", (String)Objects.toString(searchControls));
        }

        private static String modify(int mod_op) {
            return switch (mod_op) {
                case 1 -> "add";
                case 2 -> "replace";
                case 3 -> "remove";
                default -> throw new IllegalArgumentException("Unsupported operation: " + mod_op);
            };
        }

        Observation observation(String operation) {
            DirContextOperationObservationContext context = this.builder.operation(operation);
            return Observation.createNotStarted((ObservationConvention)this.convention, () -> context, (ObservationRegistry)this.registry);
        }
    }

    private static abstract class AbstractDirContextProxy
    implements DirContextProxy {
        private final DirContext delegate;

        AbstractDirContextProxy(DirContext delegate) {
            this.delegate = delegate;
        }

        @Override
        public DirContext getTargetContext() {
            return this.delegate;
        }
    }

    private static interface DelegatingDirContext
    extends DirContext,
    DirContextProxy {
        @Override
        default public NameParser getNameParser(Name name) throws javax.naming.NamingException {
            return this.getTargetContext().getNameParser(name);
        }

        @Override
        default public NameParser getNameParser(String name) throws javax.naming.NamingException {
            return this.getTargetContext().getNameParser(name);
        }

        @Override
        default public Name composeName(Name name, Name prefix) throws javax.naming.NamingException {
            return this.getTargetContext().composeName(name, prefix);
        }

        @Override
        default public String composeName(String name, String prefix) throws javax.naming.NamingException {
            return this.getTargetContext().composeName(name, prefix);
        }

        @Override
        default public Object addToEnvironment(String propName, Object propVal) throws javax.naming.NamingException {
            return this.getTargetContext().addToEnvironment(propName, propVal);
        }

        @Override
        default public Object removeFromEnvironment(String propName) throws javax.naming.NamingException {
            return this.getTargetContext().removeFromEnvironment(propName);
        }

        @Override
        default public Hashtable<?, ?> getEnvironment() throws javax.naming.NamingException {
            return this.getTargetContext().getEnvironment();
        }

        @Override
        default public void close() throws javax.naming.NamingException {
            this.getTargetContext().close();
        }
    }

    private static interface DelegatingLdapContext
    extends LdapContext,
    DirContextProxy {
        @Override
        default public LdapContext newInstance(Control[] requestControls) throws javax.naming.NamingException {
            return ((LdapContext)this.getTargetContext()).newInstance(requestControls);
        }

        @Override
        default public Control[] getConnectControls() throws javax.naming.NamingException {
            return ((LdapContext)this.getTargetContext()).getConnectControls();
        }

        @Override
        default public void setRequestControls(Control[] requestControls) throws javax.naming.NamingException {
            ((LdapContext)this.getTargetContext()).setRequestControls(requestControls);
        }

        @Override
        default public Control[] getRequestControls() throws javax.naming.NamingException {
            return ((LdapContext)this.getTargetContext()).getRequestControls();
        }

        @Override
        default public Control[] getResponseControls() throws javax.naming.NamingException {
            return ((LdapContext)this.getTargetContext()).getResponseControls();
        }
    }

    private static class DirContextOperationObservationConvention
    implements ObservationConvention<DirContextOperationObservationContext> {
        static final String OBSERVATION_NAME = "spring.ldap.dir.context.operations";

        private DirContextOperationObservationConvention() {
        }

        public @NonNull KeyValues getLowCardinalityKeyValues(DirContextOperationObservationContext context) {
            return KeyValues.of((String)"urls", (String)context.getUrls()).and("base", context.getBase()).and("operation", context.getOperation());
        }

        public boolean supportsContext(Observation.Context context) {
            return context instanceof DirContextOperationObservationContext;
        }

        public String getName() {
            return OBSERVATION_NAME;
        }

        public String getContextualName(DirContextOperationObservationContext context) {
            return "perform " + context.getOperation();
        }
    }
}

