/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.security.KeyStore;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.StandardTrustManagerFactoryBuilder;
import org.apache.nifi.security.ssl.TrustManagerBuilder;

public class StandardTrustManagerBuilder
implements TrustManagerBuilder {
    private KeyStore trustStore;

    @Override
    public X509ExtendedTrustManager build() {
        TrustManager[] trustManagers = this.getTrustManagers();
        if (trustManagers == null) {
            throw new BuilderConfigurationException("Trust Managers not found: Trust Store required");
        }
        Optional<X509ExtendedTrustManager> configuredTrustManager = Arrays.stream(trustManagers).filter(trustManager -> trustManager instanceof X509ExtendedTrustManager).map(trustManager -> (X509ExtendedTrustManager)trustManager).findFirst();
        return configuredTrustManager.orElseThrow(() -> new BuilderConfigurationException("X.509 Trust Manager not found"));
    }

    public StandardTrustManagerBuilder trustStore(KeyStore trustStore) {
        this.trustStore = Objects.requireNonNull(trustStore, "Trust Store required");
        return this;
    }

    private TrustManager[] getTrustManagers() {
        TrustManager[] trustManagers;
        if (this.trustStore == null) {
            trustManagers = null;
        } else {
            TrustManagerFactory trustManagerFactory = new StandardTrustManagerFactoryBuilder().trustStore(this.trustStore).build();
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        return trustManagers;
    }
}

