/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.OkResult;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class TransferFlowVersion
extends AbstractNiFiRegistryCommand<StringResult> {
    public TransferFlowVersion() {
        super("transfer-flow-version", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Transfers a version of a flow directly from one flow to another, without needing to export/import. If --" + CommandOption.SRC_PROPS.getLongName() + " is not specified, the source flow is assumed to be in the same registry as the destination flow. If --" + CommandOption.SRC_FLOW_VERSION.getLongName() + " is not specified, then the latest version will be transferred.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.SRC_PROPS.createOption());
        this.addOption(CommandOption.SRC_FLOW_ID.createOption());
        this.addOption(CommandOption.SRC_FLOW_VERSION.createOption());
        this.addOption(CommandOption.FLOW_ID.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        VersionedFlow destFlow;
        String srcPropsValue = this.getArg(properties, CommandOption.SRC_PROPS);
        String srcFlowId = this.getRequiredArg(properties, CommandOption.SRC_FLOW_ID);
        Integer srcFlowVersion = this.getIntArg(properties, CommandOption.SRC_FLOW_VERSION);
        String destFlowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        NiFiRegistryClient srcClient = this.getSourceClient(client, srcPropsValue);
        VersionedFlowSnapshot srcSnapshot = srcFlowVersion == null ? srcClient.getFlowSnapshotClient().getLatest(srcFlowId) : srcClient.getFlowSnapshotClient().get(srcFlowId, srcFlowVersion.intValue());
        Integer srcSnapshotFlowVersion = srcSnapshot.getSnapshotMetadata().getVersion();
        try {
            destFlow = client.getFlowClient().get(destFlowId);
        }
        catch (Exception e) {
            throw new NiFiRegistryException("Error retrieving destination flow : " + e.getMessage(), (Throwable)e);
        }
        List<Integer> destVersions = this.getVersions(client, destFlow.getIdentifier());
        Integer destFlowVersion = destVersions.isEmpty() ? 1 : destVersions.get(0) + 1;
        VersionedFlowSnapshotMetadata destMetadata = new VersionedFlowSnapshotMetadata();
        destMetadata.setBucketIdentifier(destFlow.getBucketIdentifier());
        destMetadata.setFlowIdentifier(destFlowId);
        destMetadata.setVersion(destFlowVersion.intValue());
        destMetadata.setComments(srcSnapshot.getSnapshotMetadata().getComments());
        srcSnapshot.setFlow(null);
        srcSnapshot.setBucket(null);
        srcSnapshot.setSnapshotMetadata(destMetadata);
        client.getFlowSnapshotClient().create(srcSnapshot);
        if (this.getContext().isInteractive()) {
            this.println();
            this.println("Transferred version " + srcSnapshotFlowVersion + " of source flow to version " + destFlowVersion + " of destination flow");
        }
        return new OkResult(this.getContext().isInteractive());
    }
}

